/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.xianlin.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.authority.dto.RoleFormAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.sync.xianlin.util.AppFromSyncProperties;
import com.jxdinfo.hussar.formdesign.application.sync.xianlin.util.HttpUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"hussar.app-sync.type"}, havingValue="XianLin")
@Service(value="com.jxdinfo.hussar.example.sync.appFormSyncService")
public class CustomAppSyncServiceImpl
implements AppSyncService {
    @Resource
    private AppFromSyncProperties props;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysFormGroupService formGroupService;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomAppSyncServiceImpl.class);

    public void syncApp(String type, SysApplication app) {
        HashMap<String, Object> bodyData = new HashMap<String, Object>();
        switch (type) {
            case "add": {
                bodyData.put("menuId", app.getId());
                bodyData.put("menuText", app.getAppName());
                bodyData.put("menuAlias", app.getAppName());
                bodyData.put("parentId", "");
                bodyData.put("seq", app.getAppSeq());
                bodyData.put("isLeaf", "0");
                bodyData.put("menuType", "0");
                HttpUtil.sendPost(this.props.getAddUrl(), bodyData);
                break;
            }
            case "edit": {
                bodyData.put("menuId", app.getId());
                bodyData.put("menuText", app.getAppName());
                bodyData.put("menuAlias", app.getAppName());
                bodyData.put("parentId", "");
                bodyData.put("seq", app.getAppSeq());
                bodyData.put("isLeaf", "0");
                bodyData.put("menuType", "0");
                HttpUtil.sendPost(this.props.getEditUrl(), bodyData);
                break;
            }
            case "del": {
                bodyData.put("menuId", app.getId());
                HttpUtil.sendPost(this.props.getDelUrl(), bodyData);
            }
        }
    }

    public void syncFormGroup(String type, SysFormGroup formGroup) {
        HashMap<String, Object> bodyData = new HashMap<String, Object>();
        switch (type) {
            case "add": {
                bodyData.put("menuId", formGroup.getId());
                bodyData.put("menuText", formGroup.getGroupName());
                bodyData.put("menuAlias", formGroup.getGroupName());
                bodyData.put("parentId", formGroup.getAppId());
                bodyData.put("seq", formGroup.getSeq());
                bodyData.put("isLeaf", "0");
                bodyData.put("menuType", "1");
                HttpUtil.sendPost(this.props.getAddUrl(), bodyData);
                break;
            }
            case "edit": {
                bodyData.put("menuId", formGroup.getId());
                bodyData.put("menuText", formGroup.getGroupName());
                bodyData.put("menuAlias", formGroup.getGroupName());
                bodyData.put("parentId", formGroup.getAppId());
                bodyData.put("seq", formGroup.getSeq());
                bodyData.put("isLeaf", "0");
                bodyData.put("menuType", "1");
                HttpUtil.sendPost(this.props.getEditUrl(), bodyData);
                break;
            }
            case "del": {
                bodyData.put("menuId", formGroup.getId());
                HttpUtil.sendPost(this.props.getDelUrl(), bodyData);
            }
        }
    }

    public void syncForm(String type, SysForm form) {
        HashMap<String, Object> bodyData = new HashMap<String, Object>();
        switch (type) {
            case "add": {
                bodyData.put("menuId", form.getId());
                bodyData.put("menuText", form.getFormName());
                bodyData.put("menuAlias", form.getFormName());
                bodyData.put("parentId", HussarUtils.isEmpty((Object)form.getFormGroupId()) ? form.getAppId() : form.getFormGroupId());
                bodyData.put("seq", form.getSeq());
                bodyData.put("isLeaf", "1");
                bodyData.put("menuType", "2");
                bodyData.put("path", form.getAppId());
                HttpUtil.sendPost(this.props.getAddUrl(), bodyData);
                break;
            }
            case "edit": {
                bodyData.put("menuId", form.getId());
                bodyData.put("menuText", form.getFormName());
                bodyData.put("menuAlias", form.getFormName());
                bodyData.put("parentId", HussarUtils.isEmpty((Object)form.getFormGroupId()) ? form.getAppId() : form.getFormGroupId());
                bodyData.put("seq", form.getSeq());
                bodyData.put("isLeaf", "1");
                bodyData.put("menuType", "2");
                bodyData.put("path", form.getAppId());
                HttpUtil.sendPost(this.props.getEditUrl(), bodyData);
                break;
            }
            case "del": {
                bodyData.put("menuId", form.getId());
                HttpUtil.sendPost(this.props.getDelUrl(), bodyData);
            }
        }
    }

    public void syncCustomButton(String type, SysCustomButton sysCustomButton) {
    }

    public void syncAuthority(List<RoleFormAuthorityDto> roleFormAuthorityDtoList) {
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void recycleApp(Long appId) {
        List sysForms;
        List sysFormGroups;
        SysApplication sysApplication = this.sysApplicationBoService.selectById(appId);
        if (HussarUtils.isNotEmpty((Object)sysApplication)) {
            this.syncApp("add", sysApplication);
        }
        if (HussarUtils.isNotEmpty((Object)(sysFormGroups = this.formGroupService.list((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId))))) {
            for (SysFormGroup sysFormGroup : sysFormGroups) {
                this.syncFormGroup("add", sysFormGroup);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(sysForms = this.formService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId))))) {
            for (SysForm sysForm : sysForms) {
                this.syncForm("add", sysForm);
            }
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importApp(Long appId) {
        List sysForms;
        List sysFormGroups = this.formGroupService.list((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysFormGroups)) {
            for (SysFormGroup sysFormGroup : sysFormGroups) {
                this.syncFormGroup("add", sysFormGroup);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(sysForms = this.formService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId))))) {
            for (SysForm sysForm : sysForms) {
                this.syncForm("add", sysForm);
            }
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importAppFail(Long appId) {
        SysApplication sysApplication = this.sysApplicationBoService.selectById(appId);
        if (HussarUtils.isNotEmpty((Object)sysApplication)) {
            this.syncApp("del", sysApplication);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        this.syncForm("add", form);
    }

    public void upgradeForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        this.syncForm("edit", form);
    }

    public void copyForm(Long formId) {
        try {
            SysForm form = (SysForm)this.formService.getById((Serializable)formId);
            this.syncForm("add", form);
        }
        catch (Exception e) {
            LOGGER.error("\u8868\u5355\u590d\u5236\u83dc\u5355\u540c\u6b65\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public void convertForm(Long formId) {
    }

    public Long getAppRoleGroupId(Long appId) {
        return null;
    }

    public void syncHistory(Long appId) {
    }
}

