/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.rule.service.Impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.rule.dao.SysRuleExcActionMapper;
import com.jxdinfo.hussar.formdesign.application.rule.dto.ShortAction;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleExecActionDto;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleExecAction;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleExcActionService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.SysRuleExecActionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.rule.service.impl.SysRuleExcActionServiceImpl")
public class SysRuleExcActionServiceImpl
extends HussarServiceImpl<SysRuleExcActionMapper, SysRuleExecAction>
implements ISysRuleExcActionService {
    @Resource
    private SysRuleExcActionMapper sysRuleExcActionMapper;

    public ApiResponse<String> addRuleExcAction(SysRuleExecActionVo sysRuleExcActionVo) {
        this.save((BaseEntity)sysRuleExcActionVo);
        return ApiResponse.success((Object)sysRuleExcActionVo.getActionId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    public ApiResponse<Boolean> editRuleExcAction(SysRuleExecActionDto sysRuleExcActionDto) {
        boolean flag = this.updateById((BaseEntity)sysRuleExcActionDto);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public ApiResponse<Boolean> deleteRuleExcAction(Long actionId) {
        boolean flag = this.removeById(actionId);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public List<SysRuleExecActionVo> getRuleExcActionList(SysRuleExecActionDto sysRuleExcActionDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List RuleExcActionList = this.sysRuleExcActionMapper.selectList((Wrapper)queryWrapper.like(SysRuleExecAction::getExecAction, (Object)sysRuleExcActionDto.getExecAction()));
        ArrayList<SysRuleExecActionVo> RuleExcActionVos = new ArrayList<SysRuleExecActionVo>();
        for (SysRuleExecAction sysRuleExecAction : RuleExcActionList) {
            SysRuleExecActionVo sysRuleExcActionVo = new SysRuleExecActionVo();
            if (!HussarUtils.isNotEmpty((Object)sysRuleExecAction)) continue;
            BeanUtils.copyProperties((Object)sysRuleExecAction, (Object)sysRuleExcActionVo);
            RuleExcActionVos.add(sysRuleExcActionVo);
        }
        return RuleExcActionVos;
    }

    public SysRuleExecActionVo getRuleExcActionDetail(String actionId) {
        SysRuleExecActionVo sysRuleExcActionVo = new SysRuleExecActionVo();
        SysRuleExecAction sysRuleExecAction = (SysRuleExecAction)this.getById((Serializable)((Object)actionId));
        if (HussarUtils.isNotEmpty((Object)sysRuleExecAction)) {
            BeanUtils.copyProperties((Object)sysRuleExecAction, (Object)sysRuleExcActionVo);
        }
        return sysRuleExcActionVo;
    }

    public List<SysRuleExecAction> getActionByShortAction(ShortAction shortAction) {
        LambdaQueryWrapper excQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)excQueryWrapper.eq(SysRuleExecAction::getFormId, (Object)shortAction.getFormId())).eq(SysRuleExecAction::getExecAction, (Object)shortAction.getActionType());
        return this.list((Wrapper)excQueryWrapper);
    }

    public List<SysRuleExecAction> getActionsByRuleId(String ruleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        return this.sysRuleExcActionMapper.selectList((Wrapper)queryWrapper.eq(SysRuleExecAction::getRuleId, (Object)ruleId));
    }

    public List<SysRuleExecAction> getActionsByRuleIds(List<String> ruleIds) {
        LambdaQueryWrapper ruleExcActionWrapper = new LambdaQueryWrapper();
        return this.sysRuleExcActionMapper.selectList((Wrapper)ruleExcActionWrapper.in(SysRuleExecAction::getRuleId, ruleIds));
    }

    public List<SysRuleExecAction> getActionsByFormId(String formId) {
        LambdaQueryWrapper ruleExcActionWrapper = new LambdaQueryWrapper();
        return this.sysRuleExcActionMapper.selectList((Wrapper)ruleExcActionWrapper.eq(SysRuleExecAction::getFormId, (Object)formId));
    }

    public Boolean deleteByRuleId(String ruleId) {
        LambdaQueryWrapper ruleExcActionWrapper = new LambdaQueryWrapper();
        List execActions = this.sysRuleExcActionMapper.selectList((Wrapper)ruleExcActionWrapper.eq(SysRuleExecAction::getRuleId, (Object)ruleId));
        ArrayList<String> ids = new ArrayList<String>();
        for (SysRuleExecAction ruleExecAction : execActions) {
            ids.add(ruleExecAction.getActionId());
        }
        return this.removeByIds(ids);
    }
}

