/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.FieldAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.FormRoleFieldAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.enums.FiledSettingStatus;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.AppFieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthWithStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormRoleAuthVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysUpAppVisitRoleFieldServiceImpl")
public class SysUpAppVisitRoleFieldServiceImpl
extends HussarServiceImpl<SysUpAppVisitRoleFieldMapper, SysUpAppVisitRoleField>
implements ISysUpAppVisitRoleFieldService {
    @Resource
    private IPermissionService permissionService;
    @Resource
    private SysUpAppVisitRoleFieldMapper sysUpAppVisitRoleFieldMapper;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysApplicationBoService applicationBoService;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @HussarTransactional
    public ApiResponse<Boolean> saveFieldAuthority(FormRoleFieldAuthoritiesDto formRoleFieldAuthoritiesDto) {
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)formRoleFieldAuthoritiesDto.getAppId())).eq(SysUpAppVisitRoleField::getFormId, (Object)formRoleFieldAuthoritiesDto.getFormId())).eq(SysUpAppVisitRoleField::getRoleId, (Object)formRoleFieldAuthoritiesDto.getRoleId()));
        ArrayList<SysUpAppVisitRoleField> sysUpAppVisitRoleFields = new ArrayList<SysUpAppVisitRoleField>();
        List fieldDtos = formRoleFieldAuthoritiesDto.getFieldDtos();
        for (FieldAuthorityDto fieldAuthorityDto : fieldDtos) {
            SysUpAppVisitRoleField sysUpAppVisitRoleField = new SysUpAppVisitRoleField();
            sysUpAppVisitRoleField.setAppId(formRoleFieldAuthoritiesDto.getAppId());
            sysUpAppVisitRoleField.setFormId(formRoleFieldAuthoritiesDto.getFormId());
            sysUpAppVisitRoleField.setRoleId(formRoleFieldAuthoritiesDto.getRoleId());
            sysUpAppVisitRoleField.setFieldId(fieldAuthorityDto.getFieldId());
            sysUpAppVisitRoleField.setFieldName(fieldAuthorityDto.getFieldName());
            sysUpAppVisitRoleField.setCanRead(fieldAuthorityDto.getCanRead());
            sysUpAppVisitRoleField.setCanWrite(fieldAuthorityDto.getCanWrite());
            sysUpAppVisitRoleField.setParentId(fieldAuthorityDto.getParentId());
            sysUpAppVisitRoleFields.add(sysUpAppVisitRoleField);
            List children = fieldAuthorityDto.getChildren();
            if (HussarUtils.isEmpty((Object)children)) continue;
            for (FieldAuthorityDto authorityDto : children) {
                SysUpAppVisitRoleField appVisitRoleField = new SysUpAppVisitRoleField();
                appVisitRoleField.setAppId(formRoleFieldAuthoritiesDto.getAppId());
                appVisitRoleField.setFormId(formRoleFieldAuthoritiesDto.getFormId());
                appVisitRoleField.setRoleId(formRoleFieldAuthoritiesDto.getRoleId());
                appVisitRoleField.setFieldId(authorityDto.getFieldId());
                appVisitRoleField.setFieldName(authorityDto.getFieldName());
                appVisitRoleField.setCanRead(authorityDto.getCanRead());
                appVisitRoleField.setCanWrite(authorityDto.getCanWrite());
                appVisitRoleField.setParentId(authorityDto.getParentId());
                sysUpAppVisitRoleFields.add(appVisitRoleField);
            }
        }
        return ApiResponse.success((Object)this.saveBatch(sysUpAppVisitRoleFields, sysUpAppVisitRoleFields.size()));
    }

    public void saveBatchFieldAuthority(List<FormRoleFieldAuthoritiesDto> formRoleFieldAuthoritiesDtoList, boolean isForm) {
        if (HussarUtils.isEmpty(formRoleFieldAuthoritiesDtoList)) {
            return;
        }
        Long appId = formRoleFieldAuthoritiesDtoList.get(0).getAppId();
        Long roleId = formRoleFieldAuthoritiesDtoList.get(0).getRoleId();
        Long formId = formRoleFieldAuthoritiesDtoList.get(0).getFormId();
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)appId)).eq(!isForm, SysUpAppVisitRoleField::getRoleId, (Object)roleId)).eq(isForm, SysUpAppVisitRoleField::getFormId, (Object)formId));
        ArrayList<SysUpAppVisitRoleField> sysUpAppVisitRoleFields = new ArrayList<SysUpAppVisitRoleField>();
        for (FormRoleFieldAuthoritiesDto formRoleFieldAuthoritiesDto : formRoleFieldAuthoritiesDtoList) {
            this.tran2RoleField(sysUpAppVisitRoleFields, formRoleFieldAuthoritiesDto.getAppId(), formRoleFieldAuthoritiesDto.getRoleId(), formRoleFieldAuthoritiesDto.getFormId(), formRoleFieldAuthoritiesDto.getFieldDtos());
        }
        if (HussarUtils.isNotEmpty(sysUpAppVisitRoleFields)) {
            this.saveBatch(sysUpAppVisitRoleFields);
        }
    }

    public ApiResponse<List<AppFieldAuthorityVo>> getFieldAuthorityList(Long formId, Long roleId, String appId) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysUpAppVisitRoleField::getFormId, (Object)formId);
        ew.eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId);
        List roleFieldList = this.list((Wrapper)ew);
        ArrayList<AppFieldAuthorityVo> fieldAuthorityVos = new ArrayList<AppFieldAuthorityVo>();
        Map<String, SysUpAppVisitRoleField> fieldVoMap = roleFieldList.stream().collect(Collectors.toMap(item -> item.getFieldId() + item.getParentId(), item -> item));
        List widgetFields = (List)this.formOperateExposedService.widgets(formId.toString(), appId).getData();
        if (HussarUtils.isEmpty((Object)widgetFields)) {
            return ApiResponse.success(fieldAuthorityVos);
        }
        this.dealWidget(fieldAuthorityVos, fieldVoMap, widgetFields);
        return ApiResponse.success(fieldAuthorityVos);
    }

    public Map<Long, FieldAuthWithStatusVo> listFieldAuthorityByAppId(Long appId, Long roleId, Long formId) {
        HashMap<Long, FieldAuthWithStatusVo> fieldAuthorityVoMap = new HashMap<Long, FieldAuthWithStatusVo>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            wrapper.eq(SysUpAppVisitRoleField::getAppId, (Object)appId);
        }
        if (HussarUtils.isNotEmpty((Object)roleId)) {
            wrapper.eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            wrapper.eq(SysUpAppVisitRoleField::getFormId, (Object)formId);
        }
        List roleFieldList = this.list((Wrapper)wrapper);
        Map<Long, List<SysUpAppVisitRoleField>> fieldGroupMap = roleFieldList.stream().collect(Collectors.groupingBy(SysUpAppVisitRoleField::getFormId));
        LambdaQueryWrapper wrapperForm = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            wrapperForm.eq(SysForm::getAppId, (Object)appId);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            wrapperForm.eq(SysForm::getId, (Object)formId);
        }
        List sysFormList = this.sysFormService.list((Wrapper)wrapperForm);
        for (SysForm sysForm : sysFormList) {
            ArrayList<Widget> widgetListAll;
            Long formIdEach = sysForm.getId();
            ArrayList<AppFieldAuthorityVo> fieldAuthorityList = new ArrayList<AppFieldAuthorityVo>();
            FieldAuthWithStatusVo fieldAuthWithStatusVo = new FieldAuthWithStatusVo();
            fieldAuthorityVoMap.put(formIdEach, fieldAuthWithStatusVo);
            if ("3".equals(sysForm.getFormType()) || "2".equals(sysForm.getFormType())) continue;
            fieldAuthWithStatusVo.setAuthorities(fieldAuthorityList);
            List sysUpAppVisitRoleFields = Optional.ofNullable(fieldGroupMap.get(formIdEach)).orElse(new ArrayList());
            fieldAuthWithStatusVo.setStatus(Integer.valueOf(HussarUtils.isEmpty((Object)sysUpAppVisitRoleFields) ? FiledSettingStatus.DEFAULT.getStatus() : FiledSettingStatus.CONFIGURED.getStatus()));
            Map<String, SysUpAppVisitRoleField> fieldMap = sysUpAppVisitRoleFields.stream().collect(Collectors.toMap(item -> item.getFieldId() + item.getParentId(), item -> item));
            List widgetFields = Optional.ofNullable(this.formOperateExposedService.widgets(formIdEach.toString(), appId.toString())).map(ApiResponse::getData).orElseThrow(() -> new BaseException("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25!"));
            this.dealWidget(fieldAuthorityList, fieldMap, widgetFields);
            FormDesignResponse formCanvasSchema = this.canvasSchemaService.get(String.valueOf(formIdEach));
            FormCanvasSchema canvas = (FormCanvasSchema)formCanvasSchema.getData();
            List widgetList = canvas.widgetsContainChildren();
            if (!HussarUtils.isNotEmpty((Object)widgetList) || !HussarUtils.isNotEmpty(widgetListAll = new ArrayList<Widget>(widgetList))) continue;
            this.sortField(fieldAuthorityList, widgetListAll);
        }
        return fieldAuthorityVoMap;
    }

    public void prepareFieldAuthorityByFormId(List<SysFormRoleAuthVo> result, Long appId, Long formId) {
        List roleFieldList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)appId)).eq(SysUpAppVisitRoleField::getFormId, (Object)formId));
        Map<Long, List<SysUpAppVisitRoleField>> fieldGroupMap = roleFieldList.stream().collect(Collectors.groupingBy(SysUpAppVisitRoleField::getRoleId));
        List widgetFields = Optional.ofNullable(this.formOperateExposedService.widgets(formId.toString(), appId.toString())).map(ApiResponse::getData).orElseThrow(() -> new BaseException("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u65f6\uff0c\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25!"));
        FormDesignResponse formCanvasSchema = this.canvasSchemaService.get(String.valueOf(formId));
        FormCanvasSchema canvas = (FormCanvasSchema)formCanvasSchema.getData();
        for (SysFormRoleAuthVo formRoleAuthVo : result) {
            ArrayList<AppFieldAuthorityVo> fieldAuthorityList = new ArrayList<AppFieldAuthorityVo>();
            FieldAuthWithStatusVo fieldAuthWithStatusVo = new FieldAuthWithStatusVo();
            formRoleAuthVo.setFieldAuthority(fieldAuthWithStatusVo);
            fieldAuthWithStatusVo.setAuthorities(fieldAuthorityList);
            List sysUpAppVisitRoleFields = Optional.ofNullable(fieldGroupMap.get(formRoleAuthVo.getRoleId())).orElse(new ArrayList());
            fieldAuthWithStatusVo.setStatus(Integer.valueOf(HussarUtils.isEmpty((Object)sysUpAppVisitRoleFields) ? FiledSettingStatus.DEFAULT.getStatus() : FiledSettingStatus.CONFIGURED.getStatus()));
            Map<String, SysUpAppVisitRoleField> fieldMap = sysUpAppVisitRoleFields.stream().collect(Collectors.toMap(item -> item.getFieldId() + item.getParentId(), item -> item));
            this.dealWidget(fieldAuthorityList, fieldMap, widgetFields);
            List widgetList = canvas.widgets();
            if (!HussarUtils.isNotEmpty((Object)widgetList)) continue;
            ArrayList<Widget> widgetListAll = new ArrayList<Widget>(widgetList);
            if (HussarUtils.isNotEmpty((Object)canvas.childTables())) {
                widgetListAll.addAll(canvas.childTables());
            }
            if (!HussarUtils.isNotEmpty(widgetListAll)) continue;
            this.sortField(fieldAuthorityList, widgetListAll);
        }
    }

    private void tran2RoleField(List<SysUpAppVisitRoleField> roleFields, Long appId, Long roleId, Long formId, List<FieldAuthorityDto> fieldAuthorityDtos) {
        for (FieldAuthorityDto fieldAuthorityDto : fieldAuthorityDtos) {
            SysUpAppVisitRoleField sysUpAppVisitRoleField = new SysUpAppVisitRoleField();
            sysUpAppVisitRoleField.setAppId(appId);
            sysUpAppVisitRoleField.setFormId(formId);
            sysUpAppVisitRoleField.setRoleId(roleId);
            sysUpAppVisitRoleField.setFieldId(fieldAuthorityDto.getFieldId());
            sysUpAppVisitRoleField.setFieldName(fieldAuthorityDto.getFieldName());
            sysUpAppVisitRoleField.setCanRead(fieldAuthorityDto.getCanRead());
            sysUpAppVisitRoleField.setCanWrite(fieldAuthorityDto.getCanWrite());
            sysUpAppVisitRoleField.setParentId(fieldAuthorityDto.getParentId());
            roleFields.add(sysUpAppVisitRoleField);
            List children = fieldAuthorityDto.getChildren();
            if (HussarUtils.isEmpty((Object)children)) continue;
            this.tran2RoleField(roleFields, appId, roleId, formId, children);
        }
    }

    private void sortField(List<AppFieldAuthorityVo> fieldControls, List<Widget> widgetsOrdered) {
        for (AppFieldAuthorityVo fieldControl : fieldControls) {
            if (!HussarUtils.isNotEmpty((Object)fieldControl.getChildren()) || !WidgetTool.anyMatch((String)fieldControl.getType(), (String[])new String[]{WidgetType.CHILDREN_TABLE.getType(), WidgetType.JXDNChildrenTableAgg.getType()})) continue;
            List widgetChild = widgetsOrdered.stream().filter(widget -> fieldControl.getFieldId().equals(widget.getName())).findFirst().get().getChildren();
            this.sortField(fieldControl.getChildren(), widgetChild);
        }
        List orders = widgetsOrdered.stream().sorted(Comparator.comparingInt(Widget::getSeq)).map(Widget::getName).collect(Collectors.toList());
        fieldControls.sort((o1, o2) -> {
            int io1 = orders.indexOf(o1.getFieldId());
            int io2 = orders.indexOf(o2.getFieldId());
            if (io1 == -1 && io2 == -1) {
                return 0;
            }
            if (io1 == -1 || io2 == -1) {
                return io1 == -1 ? 1 : -1;
            }
            return Integer.compare(io1, io2);
        });
    }

    private void dealWidget(List<AppFieldAuthorityVo> fieldAuthorityVos, Map<String, SysUpAppVisitRoleField> fieldMap, List<WidgetField> widgetFields) {
        for (WidgetField widgetField : widgetFields) {
            AppFieldAuthorityVo fieldVo = new AppFieldAuthorityVo();
            String fieldId = widgetField.getName();
            String parentId = widgetField.getParentKey();
            fieldVo.setFieldId(fieldId);
            fieldVo.setFieldName(widgetField.getTitle());
            fieldVo.setType(widgetField.getType());
            fieldVo.setUsage(widgetField.getUsage());
            fieldVo.setDataType(widgetField.getDataType());
            fieldVo.setRealField(widgetField.getIsRealField());
            fieldVo.setReadOnly(widgetField.isReadOnly());
            fieldVo.setParentId(widgetField.getParentKey());
            SysUpAppVisitRoleField appVisitRolefield = fieldMap.get(fieldId + parentId);
            if (HussarUtils.isNotEmpty((Object)appVisitRolefield)) {
                fieldVo.setCanRead(appVisitRolefield.getCanRead());
                fieldVo.setCanWrite(appVisitRolefield.getCanWrite());
            } else {
                fieldVo.setCanRead("1");
                fieldVo.setCanWrite("1");
            }
            if (HussarUtils.isNotEmpty((Object)widgetField.getChildren())) {
                ArrayList fieldVosChildren = Lists.newArrayListWithCapacity((int)10);
                widgetField.getChildren().forEach(c -> {
                    AppFieldAuthorityVo cT = new AppFieldAuthorityVo();
                    String childFieldId = c.getName();
                    String childParentId = c.getParentKey();
                    cT.setFieldId(c.getName());
                    cT.setFieldName(widgetField.getTitle() + "." + c.getTitle());
                    cT.setType(c.getType());
                    cT.setUsage(c.getUsage());
                    cT.setDataType(c.getDataType());
                    cT.setRealField(c.getIsRealField());
                    cT.setReadOnly(c.isReadOnly());
                    cT.setParentId(c.getParentKey());
                    SysUpAppVisitRoleField visitRolefield = (SysUpAppVisitRoleField)fieldMap.get(childFieldId + childParentId);
                    if (HussarUtils.isNotEmpty((Object)visitRolefield)) {
                        cT.setCanRead(visitRolefield.getCanRead());
                        cT.setCanWrite(visitRolefield.getCanWrite());
                    } else {
                        cT.setCanRead("1");
                        cT.setCanWrite("1");
                    }
                    ArrayList fieldVosChildChildren = Lists.newArrayListWithCapacity((int)10);
                    if (HussarUtils.isNotEmpty((Object)c.getChildren())) {
                        c.getChildren().forEach(cc -> {
                            AppFieldAuthorityVo ccT = new AppFieldAuthorityVo();
                            String childChildFieldId = cc.getName();
                            String childChildParentId = cc.getParentKey();
                            ccT.setFieldId(cc.getName());
                            ccT.setFieldName(widgetField.getTitle() + "." + c.getTitle() + "." + cc.getTitle());
                            ccT.setType(cc.getType());
                            ccT.setUsage(cc.getUsage());
                            ccT.setDataType(cc.getDataType());
                            ccT.setRealField(cc.getIsRealField());
                            ccT.setReadOnly(cc.isReadOnly());
                            ccT.setParentId(cc.getParentKey());
                            SysUpAppVisitRoleField visitRolefieldChild = (SysUpAppVisitRoleField)fieldMap.get(childChildFieldId + childChildParentId);
                            if (HussarUtils.isNotEmpty((Object)visitRolefieldChild)) {
                                ccT.setCanRead(visitRolefieldChild.getCanRead());
                                ccT.setCanWrite(visitRolefieldChild.getCanWrite());
                            } else {
                                ccT.setCanRead("1");
                                ccT.setCanWrite("1");
                            }
                            fieldVosChildChildren.add(ccT);
                        });
                        cT.setChildren((List)fieldVosChildChildren);
                    }
                    fieldVosChildren.add(cT);
                });
                fieldVo.setChildren((List)fieldVosChildren);
            }
            fieldAuthorityVos.add(fieldVo);
        }
    }

    public ApiResponse<List<FieldAuthorityVo>> formAuthorityField(Long formId) {
        if (HussarUtils.isEmpty((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)shiroUser) && HussarUtils.isEmpty((Object)(shiroUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")))) {
            return ApiResponse.success();
        }
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        Long appId = sysForm.getAppId();
        SysApplication appDetail = this.applicationBoService.selectById(appId);
        List rolesList = shiroUser.getRolesList();
        if (HussarUtils.isNotEmpty((Object)appDetail)) {
            Long developRoleId = appDetail.getDevelopRoleId();
            if (HussarUtils.isNotEmpty((Object)rolesList) && rolesList.contains(developRoleId)) {
                return ApiResponse.success(new ArrayList());
            }
        }
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            ArrayList fieldNoAuthority = Lists.newArrayListWithCapacity((int)10);
            List allField = this.permissionService.getFormFieldAuthority(formId, rolesList);
            if (HussarUtils.isEmpty((Object)allField)) {
                return ApiResponse.success();
            }
            Map<String, List<FieldAuthorityVo>> nameFieldMap = allField.stream().filter(e -> HussarUtils.isNotEmpty((Object)e.getFieldId())).collect(Collectors.groupingBy(FieldAuthorityVo::getFieldId));
            if (HussarUtils.isEmpty(nameFieldMap)) {
                return ApiResponse.success();
            }
            nameFieldMap.forEach((k, v) -> {
                FieldAuthorityVo fT = (FieldAuthorityVo)v.get(0);
                Set canRead = v.stream().map(FieldAuthorityVo::getCanRead).collect(Collectors.toSet());
                if (!canRead.contains("1")) {
                    fT.setCanRead("0");
                } else {
                    fT.setCanRead("1");
                }
                Set canWrite = v.stream().map(FieldAuthorityVo::getCanWrite).collect(Collectors.toSet());
                if (canWrite.contains("")) {
                    fT.setCanWrite("");
                } else if (!canWrite.contains("1")) {
                    fT.setCanWrite("0");
                } else {
                    fT.setCanWrite("1");
                }
                if ("0".equals(fT.getCanRead()) || "0".equals(fT.getCanWrite())) {
                    fieldNoAuthority.add(fT);
                }
            });
            return ApiResponse.success((Object)fieldNoAuthority);
        }
        return ApiResponse.success();
    }
}

