/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.impl;

import com.jxdinfo.hussar.authorization.menu.model.MenuInfo;
import com.jxdinfo.hussar.authorization.menu.service.IExtendSelectUserMenu;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class NoCodeExtendSelectUserMenu
implements IExtendSelectUserMenu {
    private final ISysFunctionsBoService functionsBoService;
    private final ISysApplicationService applicationService;
    private final ISysFormService formService;
    private static final String LEAF_MENU = "1";
    private static final String NO_CODE_SYNC = "noCode";

    public NoCodeExtendSelectUserMenu(@Lazy ISysFunctionsBoService functionsBoService, @Lazy ISysApplicationService applicationService, @Lazy ISysFormService formService) {
        this.functionsBoService = functionsBoService;
        this.applicationService = applicationService;
        this.formService = formService;
    }

    public List<MenuInfo> selectQueryUserMenu(List<MenuInfo> menuInfoList) {
        this.filterMenusWithoutAccess(menuInfoList);
        return menuInfoList;
    }

    public void filterMenusWithoutAccess(List<MenuInfo> menuInfoList) {
        Iterator<MenuInfo> menuInfoIterator = menuInfoList.iterator();
        while (menuInfoIterator.hasNext()) {
            MenuInfo menuInfo = menuInfoIterator.next();
            if (LEAF_MENU.equals(menuInfo.getIsLeaf())) {
                boolean filterFlag = this.filterNoAppAuthMenu(menuInfo);
                if (!filterFlag) continue;
                menuInfoIterator.remove();
                continue;
            }
            List childMenus = menuInfo.getChildMenus();
            this.filterMenusWithoutAccess(childMenus);
            if (!HussarUtils.isEmpty((Object)childMenus)) continue;
            menuInfoIterator.remove();
        }
    }

    private boolean filterNoAppAuthMenu(MenuInfo leafMenu) {
        Long formId;
        SysForm form;
        boolean filterNoAppAuthMenuFlag = false;
        Long functionId = Long.valueOf(leafMenu.getFunctionId());
        SysFunctions menuFunction = this.functionsBoService.getOneById(functionId);
        if (HussarUtils.isNotEmpty((Object)menuFunction) && NO_CODE_SYNC.equals(menuFunction.getFunSource()) && HussarUtils.isNotEmpty((Object)(form = (SysForm)this.formService.getById((Serializable)(formId = menuFunction.getFunctionModuleId()))))) {
            Long appId = form.getAppId();
            filterNoAppAuthMenuFlag = this.applicationService.validateAuthorityByAppId(appId) == false;
        }
        return filterNoAppAuthMenuFlag;
    }
}

