/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.controller;

import com.jxdinfo.hussar.formdesign.application.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormExportService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OpControllerAnno;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8868\u5355\u5bfc\u51fa\u5bfc\u5165\u7c7b"})
@RequestMapping(value={"/hussarNoCode/form/migrate"})
@RestController(value="com.jxdinfo.hussar.formdesign.application.form.controller.FormExportImportController")
public class FormExportImportController {
    @Resource
    private IFormExportService formExportService;
    @Resource
    private IFormImportService formImportService;
    private final Logger log = LoggerFactory.getLogger(FormExportImportController.class);

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355", notes="\u5bfc\u51fa\u8868\u5355")
    public ApiResponse<Map<String, String>> export(@RequestBody FormExportDto formExportDto) {
        String exportCacheKey = "export_progress_" + UUID.randomUUID();
        TransmittableThreadLocalHolder.set((String)"exportCacheKey", (Object)exportCacheKey);
        this.formExportService.export(formExportDto);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("exportCacheKey", exportCacheKey);
        return ApiResponse.success(result);
    }

    @PostMapping(value={"/exportBatch"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355\u6279\u91cf", notes="\u5bfc\u51fa\u8868\u5355\u6279\u91cf")
    public ApiResponse<Long> exportBatch(@RequestBody List<FormExportDto> formExportDtos) {
        return this.formExportService.exportBatch(formExportDtos);
    }

    @GetMapping(value={"/export_progress"})
    public ApiResponse<ExportStatusVo> getExportProgress(@RequestParam String exportCacheKey) {
        return this.formExportService.getExportProgress(exportCacheKey);
    }

    @PostMapping(value={"/export_file_download/{fileId}"})
    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355\u9644\u4ef6\u4e0b\u8f7d", notes="\u5bfc\u51fa\u8868\u5355\u9644\u4ef6\u4e0b\u8f7d")
    public void downloadExportFile(@PathVariable(value="fileId") Long fileId, HttpServletResponse response) {
        this.formExportService.downloadExportFile(fileId, response);
    }

    @PostMapping(value={"/import_attachment_parse"})
    @ApiOperation(value="\u5bfc\u5165\u8868\u5355\u9644\u4ef6\u89e3\u6790", notes="\u5bfc\u5165\u8868\u5355\u9644\u4ef6\u89e3\u6790")
    public ApiResponse<FormAttachmentParseVo> parseAttachment(@RequestBody MultipartFile file) {
        return this.formImportService.parseAttachment(file);
    }

    @PostMapping(value={"/import_password_verify"})
    @ApiOperation(value="\u5bfc\u5165\u8868\u5355\u5bc6\u7801\u9a8c\u8bc1", notes="\u5bfc\u5165\u8868\u5355\u5bc6\u7801\u9a8c\u8bc1")
    public ApiResponse<Boolean> verifyPassword(@RequestBody FormImportDto formImportDto) {
        return this.formImportService.verifyPassword(formImportDto);
    }

    @PostMapping(value={"/import"})
    @OpControllerAnno
    @ApiOperation(value="\u5bfc\u5165\u8868\u5355", notes="\u5bfc\u5165\u8868\u5355")
    public ApiResponse<Map<String, String>> importForm(@RequestBody FormImportDto formImportDto) throws Exception {
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        String importCacheKey = "import_progress_" + UUID.randomUUID();
        TransmittableThreadLocalHolder.set((String)"importCacheKey", (Object)importCacheKey);
        this.formImportService.importForm(formImportDto);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("importCacheKey", importCacheKey);
        return ApiResponse.success(result);
    }

    @PostMapping(value={"/importBatch"})
    @OpControllerAnno
    @ApiOperation(value="\u5bfc\u5165\u8868\u5355\u6279\u91cf", notes="\u5bfc\u5165\u8868\u5355\u6279\u91cf")
    public ApiResponse<Boolean> importFormBatch(@RequestBody MultipartFile file, @RequestParam Long appId, @RequestParam(required=false) String password) {
        return this.formImportService.importFormBatch(file, appId, password);
    }

    @GetMapping(value={"/import_progress"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u5165\u8868\u5355\u8fdb\u5ea6", notes="\u83b7\u53d6\u5bfc\u5165\u8868\u5355\u8fdb\u5ea6")
    public ApiResponse<ImportStatusVo> getImportProgress(@RequestParam String importCacheKey) {
        return this.formImportService.getImportProgress(importCacheKey);
    }
}

