/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppIoUtil {
    public static final String EXPORT_FOLDER_PATH = ".export-store";
    public static final String COMMON_DATA_PATH = "commonData";
    public static final String APP_CONFIG_PATH = "appConfig";
    public static final String BUSINESS_DATA_PATH = "businessData";
    public static final String EXPORT_META_FILE = "hussar.meta";
    public static final String COMMON_DATA_FILE = "commonData.json";
    public static final String ROLE_DATA = "roles";
    public static final String ROLE_GROUP_DATA = "roleGroups";
    public static final String DATA_PUSH_FILE = "dataPush.json";
    public static final String APP_FILE = "app.json";
    public static final String APP_INFO_DATA = "appInfo";
    public static final String APP_AUTH_DATA = "appAuth";
    public static final String FORM_FILE = "form.json";
    public static final String FORM_DATA = "forms";
    public static final String FORM_GROUP_DATA = "formGroups";
    public static final String CANVAS_PATH = "canvas";
    public static final String CANVAS_SUFFIX = ".fd";
    public static final String VIEW_PATH = "view";
    public static final String VIEW_SUFFIX = ".vd";
    public static final String SETTING_PATH = "setting";
    public static final String SETTING_SUFFIX = ".setting";
    public static final String STAFF_SCOPE_PATH = "staff";
    public static final String STAFF_SCOPE_SUFFIX = ".stf";
    public static final String STAFF_SCOPE_HISTORY = "history";
    public static final String FLOW_DATA_FILE = "flow.json";
    public static final String APP_LINK_INNER_FILE = "appLinkInner.json";
    public static final String APP_LINK_INNER = "appLinkInner";
    public static final String PAGE_EXPAND = "pageExpand";
    public static final String WIDGET_EXPAND = "widgetExpand";
    public static final String CUSTOM_BUTTON_DATA_FILE = "customButton.json";
    public static final String CUSTOM_BUTTON_DATA = "customButtonData";
    public static final String SCRIPT_FILE = "script.json";
    public static final String SCRIPT_DATA = "scriptData";
    public static final String FORM_CHECK_CONFIG_FILE = "checkConfig.json";
    public static final String BUSINESS_RULE_FILE = "rule.json";
    public static final String MSG_PUSH_FILE = "msg.json";
    public static final String APP_WATERMARK_FILE = "appWatermark.json";
    public static final String APP_WATERMARK = "appWatermark";
    public static final String FORM_LINK_DATA_FILE = "formLink.json";
    public static final String PRINT_TEMPLATE_PATH = "printTemplate";
    public static final String PRINT_TEMPLATE_FILE_PATH = "templateFile";
    public static final String PRINT_TEMPLATE_DATA_FILE = "printTemplate.json";
    public static final String PRINT_TEMPLATE_DATA = "printTemplateData";
    public static final String FORM_PUBIC_VIEW_FILE = "publicView.json";
    public static final String DATA_PULL_FILE = "dataPull.json";
    public static final String APP_TYPE = "app";
    public static final String FORM_TYPE = "form";
    public static final String CUSTOM_BUTTON_TYPE = "customButton";
    public static final String SCRIPT_TYPE = "script";
    public static final String BUSINESS_RULE_TYPE = "businessRule";
    public static final String MSG_PUSH_TYPE = "msgPush";
    public static final String FORM_LINK_TYPE = "formLink";
    public static final String DATA_PULL_TYPE = "dataPull";
    public static final String DATA_PUSH_TYPE = "dataPush";
    public static final String PRINT_TEMPLATE_TYPE = "printTemplate";
    public static final String CHECK_CONFIG_TYPE = "formCheckConfig";
    public static final String PUBLIC_VIEW_TYPE = "publicView";
    public static final String FLOW_DATA_TYPE = "flowData";
    private static final Logger LOGGER = LoggerFactory.getLogger(AppIoUtil.class);

    private static String constructFilePath(String importResourcePath, String resourceType) {
        switch (resourceType) {
            case "app": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, APP_FILE});
            }
            case "form": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, FORM_FILE});
            }
            case "customButton": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, CUSTOM_BUTTON_DATA_FILE});
            }
            case "script": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, SCRIPT_FILE});
            }
            case "businessRule": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, BUSINESS_RULE_FILE});
            }
            case "msgPush": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, MSG_PUSH_FILE});
            }
            case "formLink": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, FORM_LINK_DATA_FILE});
            }
            case "dataPull": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, DATA_PULL_FILE});
            }
            case "dataPush": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, DATA_PUSH_FILE});
            }
            case "publicView": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, FORM_PUBIC_VIEW_FILE});
            }
            case "formCheckConfig": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, FORM_CHECK_CONFIG_FILE});
            }
            case "printTemplate": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, "printTemplate", PRINT_TEMPLATE_DATA_FILE});
            }
            case "flowData": {
                return FileUtil.posixPath((String[])new String[]{importResourcePath, APP_CONFIG_PATH, FLOW_DATA_FILE});
            }
        }
        LOGGER.warn("\u672a\u77e5\u7684\u8d44\u6e90\u7c7b\u578b: {}", (Object)resourceType);
        return "";
    }

    public static <T> T readData(String importResourcePath, String resourceType, Class<T> clazz) {
        String filePath = AppIoUtil.constructFilePath(importResourcePath, resourceType);
        File file = new File(filePath);
        if (!file.exists()) {
            LOGGER.warn("\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)filePath);
            return null;
        }
        try {
            String text = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            if (HussarUtils.isBlank((CharSequence)text)) {
                LOGGER.warn("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a: {}", (Object)filePath);
                return null;
            }
            return (T)JSONObject.parseObject((String)text, clazz);
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u5bfc\u5165\u6587\u4ef6\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)filePath, (Object)e);
            throw new HussarException("\u8bfb\u53d6\u5bfc\u5165\u6587\u4ef6\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public static <T> List<T> readDataToList(String importResourcePath, String resourceType, Class<T> clazz) {
        JSONArray data = AppIoUtil.readData(importResourcePath, resourceType, JSONArray.class);
        if (HussarUtils.isNotEmpty((Object)data)) {
            return JSON.parseArray((String)JSON.toJSONString((Object)data), clazz);
        }
        return Collections.emptyList();
    }

    public static <T> T readDataByKey(String importResourcePath, String resourceType, String key, Class<T> clazz) {
        JSONObject data = AppIoUtil.readData(importResourcePath, resourceType, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)data) && data.containsKey((Object)key)) {
            return (T)JSONObject.parseObject((String)data.getString(key), clazz);
        }
        return null;
    }

    public static <T> List<T> readDataByKeyToList(String importResourcePath, String resourceType, String key, Class<T> clazz) {
        JSONObject data = AppIoUtil.readData(importResourcePath, resourceType, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)data) && data.containsKey((Object)key)) {
            return JSONArray.parseArray((String)data.getString(key), clazz);
        }
        return null;
    }

    public static List<FormSchema> readMidFiles(String resourcePath, String appId) {
        Object[] formMidFileFolders;
        ArrayList<FormSchema> formSchemas = new ArrayList<FormSchema>();
        String midFileFolderPath = FileUtil.posixPath((String[])new String[]{resourcePath, APP_CONFIG_PATH, appId});
        File midFileFolder = new File(midFileFolderPath);
        if (midFileFolder.exists() && midFileFolder.isDirectory() && HussarUtils.isNotEmpty((Object[])(formMidFileFolders = midFileFolder.listFiles()))) {
            for (Object formMidFileFolder : formMidFileFolders) {
                FormSchema formSchema = new FormSchema();
                String canvasPath = FileUtil.posixPath((String[])new String[]{((File)formMidFileFolder).getAbsolutePath(), CANVAS_PATH, ((File)formMidFileFolder).getName() + CANVAS_SUFFIX});
                FormCanvasSchema canvas = AppMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
                formSchema.setFormCanvas(canvas);
                String viewPath = FileUtil.posixPath((String[])new String[]{((File)formMidFileFolder).getAbsolutePath(), VIEW_PATH, ((File)formMidFileFolder).getName() + VIEW_SUFFIX});
                FormViewSchema view = AppMigrateUtil.readFileToObject(viewPath, FormViewSchema.class);
                formSchema.setView(view);
                String settingPath = FileUtil.posixPath((String[])new String[]{((File)formMidFileFolder).getAbsolutePath(), SETTING_PATH, ((File)formMidFileFolder).getName() + SETTING_SUFFIX});
                FormSettingSchema setting = AppMigrateUtil.readFileToObject(settingPath, FormSettingSchema.class);
                formSchema.setSetting(setting);
                formSchemas.add(formSchema);
            }
        }
        return formSchemas;
    }

    public static <T> T replaceMapping(T obj, Class<T> clazz, Map<Object, Object> replaceMap) {
        String text = JSON.toJSONStringWithDateFormat(obj, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(replaceMap.entrySet());
        sortedEntries.sort((o1, o2) -> o2.getKey().toString().length() - o1.getKey().toString().length());
        for (Map.Entry entry : sortedEntries) {
            text = text.replace(entry.getKey().toString(), entry.getValue().toString());
        }
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static <T> List<T> replaceMappingToList(List<T> obj, Class<T> clazz, Map<Object, Object> replaceMap) {
        String text = JSON.toJSONStringWithDateFormat(obj, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(replaceMap.entrySet());
        sortedEntries.sort((o1, o2) -> o2.getKey().toString().length() - o1.getKey().toString().length());
        for (Map.Entry entry : sortedEntries) {
            text = text.replace(entry.getKey().toString(), entry.getValue().toString());
        }
        return JSONArray.parseArray((String)text, clazz);
    }
}

