/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lefttree.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.lefttree.annotation.CheckPermission;
import com.jxdinfo.hussar.formdesign.application.lefttree.constant.LeftTreeConst;
import com.jxdinfo.hussar.formdesign.application.lefttree.dto.LeftTreeConvertDto;
import com.jxdinfo.hussar.formdesign.application.lefttree.dto.LeftTreeCopyDto;
import com.jxdinfo.hussar.formdesign.application.lefttree.dto.LeftTreeCtx;
import com.jxdinfo.hussar.formdesign.application.lefttree.model.NavLeftTreeOrder;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeOrderService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeService;
import com.jxdinfo.hussar.formdesign.application.lefttree.util.LeftTreeUtil;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.LeftTreeAuthVo;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.LeftTreeFlatVo;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.NavLeftTreeVo;
import com.jxdinfo.hussar.formdesign.application.lefttree.vo.WidgetVo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.NavLeftTreeOption;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.WidgetItem;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class NavLeftTreeServiceImpl
implements INavLeftTreeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavLeftTreeServiceImpl.class);
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private INavLeftTreeOrderService navLeftTreeOrderService;
    private static final Set<WidgetType> supportFilterWidgets = new HashSet<WidgetType>(Collections.singleton(WidgetType.JXDNLinkForm));
    private static final Set<WidgetType> supportSupWidgets = new HashSet<WidgetType>(Collections.singleton(WidgetType.JXDNLinkForm));

    @CheckPermission
    public ApiResponse<List<NavLeftTreeVo>> initLeftTree(Long formId, String viewId) {
        try {
            DataView dataView = this.getDataView(formId, viewId);
            int viewType = dataView.getViewType();
            LeftTreeCtx leftTreeCtx = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), null);
            List<NavLeftTreeVo> leftTreeNodeList = this.buildLeftTree(leftTreeCtx);
            return ApiResponse.success(leftTreeNodeList);
        }
        catch (Exception e) {
            LOGGER.error("\u5de6\u4fa7\u6811\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u5de6\u4fa7\u6811\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public ApiResponse<List<NavLeftTreeVo>> lazyLoadLeftTree(Long formId, String viewId, Long id) {
        try {
            DataView dataView = this.getDataView(formId, viewId);
            int viewType = dataView.getViewType();
            LeftTreeCtx leftTreeCtx = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), id);
            NavLeftTreeVo root = this.formQueryToTreeNode(leftTreeCtx, false);
            List<NavLeftTreeVo> leftTreeNodeList = this.loadChildNodes(root, leftTreeCtx);
            return ApiResponse.success(leftTreeNodeList);
        }
        catch (Exception e) {
            LOGGER.error("\u61d2\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u61d2\u52a0\u8f7d\u5931\u8d25");
        }
    }

    public ApiResponse<List<LeftTreeFlatVo>> getAllSubNode(Long formId, String viewId, Long id) {
        try {
            ArrayList<LeftTreeFlatVo> leftTreeFlatVoList = new ArrayList<LeftTreeFlatVo>();
            DataView dataView = this.getDataView(formId, viewId);
            int viewType = dataView.getViewType();
            LeftTreeCtx leftTreeCtx = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), id);
            NavLeftTreeVo root = this.formQueryToTreeNode(leftTreeCtx, false);
            this.loadSubNodes(root, leftTreeCtx);
            this.flatTreeVo(root, leftTreeFlatVoList);
            return ApiResponse.success(leftTreeFlatVoList);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u7ea7\u8282\u70b9\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u4e0b\u7ea7\u8282\u70b9\u67e5\u8be2\u5931\u8d25");
        }
    }

    public ApiResponse<List<WidgetVo>> listFilterWidget(Long formId) {
        try {
            SysForm targetForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
            new LeftTreeUtil.Validator().isNotNull(targetForm, "\u8868\u5355\u4e0d\u5b58\u5728").validate();
            FormCanvasSchema canvasSchema = this.getCanvasSchema(formId);
            List widgets = Optional.ofNullable(canvasSchema.widgets()).orElse(new ArrayList());
            return ApiResponse.success(widgets.stream().filter(this.isFilterWidget()).map(widget -> (WidgetVo)BeanUtil.copy((Object)widget, WidgetVo.class)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOGGER.error("\u7b5b\u9009\u5b57\u6bb5\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u7b5b\u9009\u5b57\u6bb5\u67e5\u8be2\u5931\u8d25");
        }
    }

    public ApiResponse<LeftTreeAuthVo> getLeftTreeAuth(Long formId, String viewId) {
        try {
            DataView dataView = this.getDataView(formId, viewId);
            int viewType = dataView.getViewType();
            LeftTreeCtx leftTreeCtx = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), null);
            LeftTreeAuthVo leftTreeAuth = this.getLeftTreeAuthByFormId(leftTreeCtx.getFormId());
            return ApiResponse.success((Object)leftTreeAuth);
        }
        catch (Exception e) {
            LOGGER.error("\u5de6\u4fa7\u6811\u6743\u9650\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u5de6\u4fa7\u6811\u6743\u9650\u67e5\u8be2\u5931\u8d25");
        }
    }

    public LeftTreeAuthVo getLeftTreeAuthByFormId(Long formId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        String formType = sysForm.getFormType();
        LeftTreeAuthVo leftTreeAuthVo = new LeftTreeAuthVo();
        List<String> filterBtnCodeList = Arrays.asList(Button.CREATE_OPERATE.getButtonCode(), Button.EDIT_OPERATE.getButtonCode(), Button.DELETE_OPERATE.getButtonCode());
        List buttonVoList = this.applicationService.formAuthorityButton(formId);
        List buttonCodeList = buttonVoList.stream().map(ButtonVo::getButtonCode).filter(filterBtnCodeList::contains).distinct().collect(Collectors.toList());
        LeftTreeUtil.condRun("0".equals(formType) && buttonCodeList.contains(Button.CREATE_OPERATE.getButtonCode()), () -> buttonCodeList.add("copy"));
        LeftTreeUtil.condRun("1".equals(formType), () -> buttonCodeList.remove(Button.EDIT_OPERATE.getButtonCode()));
        leftTreeAuthVo.setButtonList(buttonCodeList);
        return leftTreeAuthVo;
    }

    public ApiResponse<NavLeftTreeVo> copyLeftTreeNode(LeftTreeCopyDto leftTreeCopyDto) {
        try {
            Long formId = leftTreeCopyDto.getFormId();
            String viewId = leftTreeCopyDto.getViewId();
            Long id = leftTreeCopyDto.getId();
            new LeftTreeUtil.Validator().isNotNull(formId, "\u53c2\u6570\u6821\u9a8c\uff1a\u8868\u5355id\u672a\u4f20\u9012").isNotNull(viewId, "\u53c2\u6570\u6821\u9a8c\uff1a\u89c6\u56feid\u672a\u4f20\u9012").isNotNull(id, "\u53c2\u6570\u6821\u9a8c\uff1a\u8282\u70b9id\u672a\u4f20\u9012").validate();
            DataView dataView = this.getDataView(formId, viewId);
            int viewType = dataView.getViewType();
            LeftTreeCtx leftTreeCtx = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), id);
            Long newRecordId = this.copyBusinessData(leftTreeCtx.getTreeAppId(), leftTreeCtx.getTreeFormId(), leftTreeCtx.getId(), leftTreeCtx.getTitleFieldName());
            if (HussarUtils.isNotEmpty((Object)newRecordId)) {
                leftTreeCtx.setId(newRecordId);
                return ApiResponse.success((Object)this.formQueryToTreeNode(leftTreeCtx, false));
            }
            return ApiResponse.fail((String)"\u5de6\u4fa7\u6811\u8282\u70b9\u590d\u5236\u5931\u8d25");
        }
        catch (Exception e) {
            LOGGER.error("\u5de6\u4fa7\u6811\u8282\u70b9\u590d\u5236\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u5de6\u4fa7\u6811\u8282\u70b9\u590d\u5236\u5931\u8d25");
        }
    }

    public Long copyBusinessData(Long appId, Long formId, Long id, String renameFieldName) {
        EngineResultEntity resultEntity = this.formQuery(appId, formId, id);
        String tableName = this.sysFormService.getTableNameById(formId);
        String fieldValue = String.valueOf(resultEntity.get((Object)renameFieldName));
        String newFieldValue = fieldValue + "(\u526f\u672c)";
        resultEntity.put((Object)renameFieldName, (Object)newFieldValue);
        Long newRecordId = IdWorker.getId((Object)resultEntity);
        resultEntity.put((Object)"RECORD_ID", (Object)newRecordId);
        resultEntity.put((Object)tableName, (Object)newRecordId);
        FormCanvasSchema canvasSchema = this.getCanvasSchema(formId);
        List allChildTables = canvasSchema.childTables();
        allChildTables.stream().filter(widget -> resultEntity.containsKey((Object)widget.getName())).forEach(widget -> LeftTreeUtil.castList(resultEntity.get((Object)widget.getName()), EngineResultEntity.class).forEach(childEntity -> {
            Long sonChildRecordId = IdWorker.getId((Object)childEntity);
            childEntity.put((Object)"RECORD_ID", (Object)sonChildRecordId);
            childEntity.put((Object)"F_RECORD_ID", (Object)newRecordId);
            widget.getChildren().stream().filter(grandSonWidget -> childEntity.containsKey((Object)grandSonWidget.getName()) && HussarUtils.equals((Object)grandSonWidget.getType(), (Object)WidgetType.CHILDREN_TABLE.getType())).forEach(grandSonWidget -> LeftTreeUtil.castList(childEntity.get((Object)grandSonWidget.getName()), EngineResultEntity.class).forEach(grandSonEntity -> {
                Long grandsonRecordId = IdWorker.getId((Object)grandSonEntity);
                grandSonEntity.put((Object)"RECORD_ID", (Object)grandsonRecordId);
                grandSonEntity.put((Object)"F_RECORD_ID", (Object)sonChildRecordId);
                grandSonEntity.put((Object)"G_RECORD_ID", (Object)newRecordId);
            }));
        }));
        ResponseEntity apiResponse = this.formOperateExposedService.formSave(String.valueOf(formId), (Map)resultEntity, String.valueOf(appId), Boolean.valueOf(true));
        return Optional.ofNullable(apiResponse).map(HttpEntity::getBody).map(ApiResponse::getData).map(String::valueOf).map(Long::valueOf).orElse(null);
    }

    public DataView getDataView(Long formId, String viewId) {
        Optional<DataView> customViewOptional = this.getCustomViewById(viewId);
        if (customViewOptional.isPresent()) {
            return customViewOptional.get();
        }
        FormDesignResponse sysViewResponse = this.viewSchemaService.get(String.valueOf(formId));
        List systemViews = Optional.ofNullable(sysViewResponse).map(FormDesignResponse::getData).map(FormViewSchema::getViews).orElseThrow(() -> new HussarException("\u8868\u5355\u89c6\u56fe\u67e5\u8be2\u5931\u8d25"));
        return systemViews.stream().filter(view -> viewId.equals(view.getId())).findFirst().orElseThrow(() -> new HussarException("\u8868\u5355\u89c6\u56fe\u67e5\u8be2\u5931\u8d25"));
    }

    private Optional<DataView> getCustomViewById(String viewId) {
        try {
            long viewIdLong = Long.parseLong(viewId);
            return Optional.ofNullable(this.customViewService.getById(Long.valueOf(viewIdLong))).map(FormDesignResponse::getData);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public ApiResponse<List<WidgetVo>> listSupWidget(Long formId, String widgetName) {
        try {
            FormCanvasSchema formCanvasSchema = this.getCanvasSchema(formId);
            List widgets = Optional.ofNullable(formCanvasSchema.widgets()).orElse(new ArrayList());
            List supWidgets = widgets.stream().filter(this.isSupWidget(widgetName)).map(widget -> (WidgetVo)BeanUtil.copy((Object)widget, WidgetVo.class)).collect(Collectors.toList());
            return ApiResponse.success(supWidgets);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u7ea7\u5b57\u6bb5\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u4e0a\u7ea7\u5b57\u6bb5\u67e5\u8be2\u5931\u8d25");
        }
    }

    public ApiResponse<NavLeftTreeVo> convertDataToTreeNode(LeftTreeConvertDto leftTreeConvertDto) {
        LeftTreeCtx leftTreeCtx = new LeftTreeCtx();
        BeanUtil.copyProperties((Object)leftTreeConvertDto, (Object)leftTreeCtx);
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)leftTreeConvertDto.getTreeFormId());
        leftTreeCtx.setTreeFormType(sysForm.getFormType());
        WidgetItem titleField = leftTreeConvertDto.getTitleField();
        leftTreeCtx.setTitleFieldName(this.getLabelFieldName(titleField.getType(), titleField.getName()));
        WidgetItem linkField = leftTreeConvertDto.getLinkField();
        leftTreeCtx.setCurrentFieldName(this.getLabelFieldName(linkField.getType(), linkField.getName()));
        WidgetItem supField = leftTreeConvertDto.getSupField();
        leftTreeCtx.setParentFieldName(this.getParentFieldName(supField.getType(), supField.getName()));
        try {
            return ApiResponse.success((Object)this.formQueryToTreeNode(leftTreeCtx, true));
        }
        catch (Exception e) {
            LOGGER.error("\u4e1a\u52a1\u6570\u636e\u8f6c\u6811\u8282\u70b9\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u4e1a\u52a1\u6570\u636e\u8f6c\u6811\u8282\u70b9\u5931\u8d25");
        }
    }

    public ApiResponse<NavLeftTreeVo> getAllSubNodeBatch(Map<String, Object> map) {
        Long formId = Long.parseLong(map.get("formId").toString());
        String viewId = (String)map.get("viewId");
        List idStrList = (List)map.get("idList");
        List idList = idStrList.stream().map(Long::valueOf).collect(Collectors.toList());
        ArrayList<NavLeftTreeVo> leftTreeNodeList = new ArrayList<NavLeftTreeVo>();
        DataView dataView = this.getDataView(formId, viewId);
        int viewType = dataView.getViewType();
        NavLeftTreeVo rootNode = new NavLeftTreeVo();
        for (Long id : idList) {
            LeftTreeCtx leftTreeCtx = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), id);
            NavLeftTreeVo root = this.formQueryToTreeNode(leftTreeCtx, false);
            List<NavLeftTreeVo> children = this.loadChildNodes(root, leftTreeCtx);
            root.setChildren(children);
            root.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(children)));
            if (HussarUtils.isEmpty((Object)root.getParentId())) {
                rootNode = root;
            }
            leftTreeNodeList.add(root);
        }
        LeftTreeCtx leftTreeCtx = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), (Long)rootNode.getId());
        this.addSubNodes(rootNode, leftTreeCtx, leftTreeNodeList, formId, viewId);
        return ApiResponse.success((Object)rootNode, (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    public EngineResultEntity formQuery(String appId, String formId, String id) {
        return Optional.ofNullable(this.formOperateExposedService.formQuery(formId, id, null, appId, false)).map(HttpEntity::getBody).map(ApiResponse::getData).map(EngineResultEntity.class::cast).orElseThrow(() -> new HussarException("\u4e1a\u52a1\u6570\u636e\u67e5\u8be2\u5931\u8d25"));
    }

    private FormCanvasSchema getCanvasSchema(Long formId) {
        return Optional.ofNullable(this.canvasSchemaService.get(String.valueOf(formId))).map(FormDesignResponse::getData).orElseThrow(() -> new HussarException("\u8868\u5355\u753b\u5e03\u67e5\u8be2\u5931\u8d25"));
    }

    private Predicate<Widget> isSupWidget(String widgetName) {
        return widget -> {
            try {
                String type = widget.getType();
                WidgetType widgetType = WidgetType.getWidgetType((String)type);
                AssertUtil.isNotNull((Object)widgetType, (String)"\u4e0d\u652f\u6301\u7684\u7ec4\u4ef6\u7c7b\u578b");
                if (!supportSupWidgets.contains(widgetType)) {
                    return false;
                }
                JSONObject props = widget.getProps();
                String linkWidgetName = this.getLinkFieldNameBasedOnType(widgetType, props);
                return HussarUtils.isNotEmpty((Object)linkWidgetName) && HussarUtils.equals((Object)linkWidgetName, (Object)widgetName);
            }
            catch (Exception e) {
                LOGGER.error("\u4e0a\u7ea7\u5b57\u6bb5\u67e5\u8be2\u5f02\u5e38!", (Throwable)e);
                return false;
            }
        };
    }

    private Predicate<Widget> isFilterWidget() {
        return widget -> {
            try {
                String type = widget.getType();
                WidgetType widgetType = WidgetType.getWidgetType((String)type);
                if (!supportFilterWidgets.contains(widgetType)) {
                    return false;
                }
                AssertUtil.isNotNull((Object)widgetType, (String)"\u4e0d\u652f\u6301\u7684\u7ec4\u4ef6\u7c7b\u578b");
                JSONObject props = widget.getProps();
                String linkFormId = this.getLinkFormIdBasedOnType(widgetType, props);
                String linkFieldName = this.getLinkFieldNameBasedOnType(widgetType, props);
                if (HussarUtils.isEmpty((Object)linkFormId) || HussarUtils.isEmpty((Object)linkFieldName)) {
                    return false;
                }
                FormCanvasSchema linkCanvas = this.getCanvasSchema(Long.valueOf(linkFormId));
                List linkCanvasWidgets = linkCanvas.widgets();
                return linkCanvasWidgets.stream().anyMatch(this.isSupWidget(linkFieldName));
            }
            catch (Exception e) {
                LOGGER.error("\u8fc7\u6ee4\u5b57\u6bb5\u6761\u4ef6\u5224\u65ad\u5f02\u5e38!", (Throwable)e);
                return false;
            }
        };
    }

    private String getLinkFormIdBasedOnType(WidgetType widgetType, JSONObject props) {
        switch (widgetType) {
            case JXDNLinkForm: {
                if (!props.containsKey((Object)"linkTableInfo")) {
                    return null;
                }
                JSONObject linkTableInfo = props.getJSONObject("linkTableInfo");
                return linkTableInfo.containsKey((Object)"formId") ? (String)linkTableInfo.get((Object)"formId") : null;
            }
            case SELECT: 
            case SELECT_MUL: {
                if (!props.containsKey((Object)"async")) {
                    return null;
                }
                JSONObject asyncInfo = props.getJSONObject("async");
                return asyncInfo.containsKey((Object)"formId") ? (String)asyncInfo.get((Object)"formId") : null;
            }
        }
        return null;
    }

    private String getLinkFieldNameBasedOnType(WidgetType widgetType, JSONObject props) {
        switch (widgetType) {
            case JXDNLinkForm: {
                if (!props.containsKey((Object)"linkTableInfo")) {
                    return null;
                }
                JSONObject linkTableInfo = props.getJSONObject("linkTableInfo");
                return linkTableInfo.containsKey((Object)"linkFieldInfo") && linkTableInfo.getJSONObject("linkFieldInfo").containsKey((Object)"name") ? (String)linkTableInfo.getJSONObject("linkFieldInfo").get((Object)"name") : null;
            }
            case SELECT: 
            case SELECT_MUL: {
                if (!props.containsKey((Object)"async")) {
                    return null;
                }
                JSONObject asyncInfo = props.getJSONObject("async");
                return asyncInfo.containsKey((Object)"fieldName") ? (String)asyncInfo.get((Object)"fieldName") : null;
            }
        }
        return null;
    }

    public List<NavLeftTreeVo> buildLeftTree(LeftTreeCtx leftTreeCtx) {
        NavLeftTreeVo root = this.createRootNode(LeftTreeConst.TreeNodeDefault.ROOT_ID, LeftTreeConst.TreeNodeDefault.ROOT_PARENT_ID, LeftTreeConst.TreeNodeDefault.ROOT_LABEL, null, null);
        LeftTreeUtil.condRun(HussarUtils.equals((Object)leftTreeCtx.getDefaultDisplayNode(), (Object)-1), () -> this.loadSubNodes(root, leftTreeCtx), () -> this.loadSubNodesLimitedHeight(root, leftTreeCtx, 0));
        return new ArrayList<NavLeftTreeVo>(root.getChildren());
    }

    public List<NavLeftTreeVo> loadChildNodes(NavLeftTreeVo root, LeftTreeCtx leftTreeCtx) {
        Long treeAppId = leftTreeCtx.getTreeAppId();
        Long treeFormId = leftTreeCtx.getTreeFormId();
        String treeViewId = leftTreeCtx.getTreeViewId();
        String titleFieldName = leftTreeCtx.getTitleFieldName();
        String currentFieldName = leftTreeCtx.getCurrentFieldName();
        String parentFieldName = leftTreeCtx.getParentFieldName();
        String treeFormType = leftTreeCtx.getTreeFormType();
        Long formId = leftTreeCtx.getFormId();
        String viewId = leftTreeCtx.getViewId();
        List order = LeftTreeUtil.conSupplier("desc".equals(leftTreeCtx.getSortType()), () -> OrderItem.descs((String[])new String[]{titleFieldName}), () -> OrderItem.ascs((String[])new String[]{titleFieldName}));
        List<EngineResultEntity> resultEntityList = this.tableQueryCondOnFiled(treeAppId, treeFormId, treeViewId, parentFieldName, (Long)root.getId(), order);
        if (HussarUtils.isEmpty(resultEntityList)) {
            return Collections.emptyList();
        }
        List<NavLeftTreeVo> childNodes = this.convertToTreeNodes(resultEntityList, treeFormType, titleFieldName, currentFieldName, parentFieldName);
        List<String> nodeIdList = resultEntityList.stream().map(entity -> LeftTreeUtil.convertString(entity.get((Object)"RECORD_ID"))).collect(Collectors.toList());
        Map<Long, Boolean> leafNodeFlagMap = this.getLeafNodeFlagMap(treeAppId, treeFormId, treeViewId, parentFieldName, nodeIdList);
        childNodes.forEach(childNode -> childNode.setHasChildren((Boolean)leafNodeFlagMap.get(childNode.getId())));
        return this.customSort(childNodes, formId, viewId, (Long)root.getId());
    }

    private List<NavLeftTreeVo> customSort(List<NavLeftTreeVo> nodeList, Long formId, String viewId, Long parentId) {
        NavLeftTreeOrder leftTreeOrder = this.navLeftTreeOrderService.getOrderByParentId(formId, viewId, parentId);
        if (HussarUtils.isNotEmpty((Object)leftTreeOrder) && HussarUtils.isNotEmpty((Object)leftTreeOrder.getChildOrder())) {
            String childOrder = leftTreeOrder.getChildOrder();
            List<String> childOrderList = Arrays.asList(childOrder.split(","));
            HashMap<Long, Integer> orderMap = new HashMap<Long, Integer>();
            childOrderList.forEach(id -> orderMap.put(Long.valueOf(id), childOrderList.indexOf(id)));
            return nodeList.stream().sorted(this.nodeComparator(orderMap)).collect(Collectors.toList());
        }
        return nodeList;
    }

    Comparator<NavLeftTreeVo> nodeComparator(Map<Long, Integer> orderMap) {
        return (o1, o2) -> {
            if (orderMap.containsKey(o1.getId()) && orderMap.containsKey(o2.getId())) {
                return (Integer)orderMap.get(o1.getId()) - (Integer)orderMap.get(o2.getId());
            }
            if (orderMap.containsKey(o1.getId())) {
                return -1;
            }
            if (orderMap.containsKey(o2.getId())) {
                return 1;
            }
            return 0;
        };
    }

    public void loadSubNodesLimitedHeight(NavLeftTreeVo root, LeftTreeCtx leftTreeCtx, int height) {
        if (height > leftTreeCtx.getDefaultDisplayNode() + 1) {
            return;
        }
        ++height;
        List<NavLeftTreeVo> children = this.loadChildNodes(root, leftTreeCtx);
        root.setChildren(children);
        root.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(children)));
        if (HussarUtils.isNotEmpty(children)) {
            for (NavLeftTreeVo child : children) {
                this.loadSubNodesLimitedHeight(child, leftTreeCtx, height);
            }
        }
    }

    public void loadSubNodes(NavLeftTreeVo root, LeftTreeCtx leftTreeCtx) {
        List<NavLeftTreeVo> children = this.loadChildNodes(root, leftTreeCtx);
        root.setChildren(children);
        root.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(children)));
        if (HussarUtils.isNotEmpty(children)) {
            for (NavLeftTreeVo child : children) {
                this.loadSubNodes(child, leftTreeCtx);
            }
        }
    }

    public void addSubNodes(NavLeftTreeVo root, LeftTreeCtx leftTreeCtx, List<NavLeftTreeVo> leftTreeVos, Long formId, String viewId) {
        List<NavLeftTreeVo> children = this.loadChildNodes(root, leftTreeCtx);
        for (NavLeftTreeVo child : children) {
            boolean foundMatch = false;
            for (NavLeftTreeVo leftTreeVo : leftTreeVos) {
                if (!((Long)child.getId()).equals(leftTreeVo.getId())) continue;
                child.setChildren(leftTreeVo.getChildren());
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                child.setChildren(null);
                continue;
            }
            DataView dataView = this.getDataView(formId, viewId);
            int viewType = dataView.getViewType();
            LeftTreeCtx leftTreeCtxNew = this.getLeftTreeCtx(formId, viewId, viewType, dataView.getNavLeftTreeOption(), (Long)root.getId());
            this.addSubNodes(child, leftTreeCtxNew, leftTreeVos, formId, viewId);
        }
        root.setChildren(children);
        root.setHasChildren(Boolean.valueOf(HussarUtils.isNotEmpty(children)));
    }

    public EngineResultEntity formQuery(Long appId, Long formId, Long id) {
        return Optional.ofNullable(this.formOperateExposedService.formQuery(String.valueOf(formId), String.valueOf(id), null, String.valueOf(appId), true)).map(HttpEntity::getBody).map(ApiResponse::getData).map(EngineResultEntity.class::cast).orElseThrow(() -> new HussarException("\u4e1a\u52a1\u6570\u636e\u67e5\u8be2\u5931\u8d25"));
    }

    public NavLeftTreeVo formQueryToTreeNode(LeftTreeCtx leftTreeCtx, boolean updateLeafFlag) {
        Long treeAppId = leftTreeCtx.getTreeAppId();
        Long treeFormId = leftTreeCtx.getTreeFormId();
        String treeViewId = leftTreeCtx.getTreeViewId();
        String treeFormType = leftTreeCtx.getTreeFormType();
        String titleFieldName = leftTreeCtx.getTitleFieldName();
        String currentFieldName = leftTreeCtx.getCurrentFieldName();
        String parentFieldName = leftTreeCtx.getParentFieldName();
        Long id = leftTreeCtx.getId();
        EngineResultEntity resultEntity = this.formQuery(treeAppId, treeFormId, id);
        String label = LeftTreeUtil.convertString(resultEntity.get((Object)titleFieldName));
        Long parentId = LeftTreeUtil.convertLong(resultEntity.get((Object)parentFieldName));
        String parentLabel = LeftTreeUtil.convertString(resultEntity.get((Object)currentFieldName));
        Long processInstId = null;
        if (HussarUtils.equals((Object)"1", (Object)treeFormType)) {
            processInstId = LeftTreeUtil.convertLong(resultEntity.get((Object)"PROCESS_INST_ID"));
        }
        NavLeftTreeVo treeNode = this.createRootNode(id, parentId, label, parentLabel, processInstId);
        LeftTreeUtil.condRun(updateLeafFlag, () -> {
            Map<Long, Boolean> leafNodeFlagMap = this.getLeafNodeFlagMap(treeAppId, treeFormId, treeViewId, parentFieldName, Collections.singletonList(String.valueOf(id)));
            treeNode.setHasChildren(leafNodeFlagMap.get(id));
        });
        return treeNode;
    }

    public List<EngineResultEntity> tableQueryCondition(Long appId, Long formId, String viewId, Map<String, Object> params) {
        return Optional.ofNullable(this.appFormService.tableQuery(String.valueOf(formId), viewId, params, String.valueOf(appId))).map(HttpEntity::getBody).map(ApiResponse::getData).map(o -> (PageVo)o).map(PageVo::getData).map(o -> LeftTreeUtil.castList(o, EngineResultEntity.class)).orElseThrow(() -> new BaseException("\u4e1a\u52a1\u6570\u636e\u67e5\u8be2\u5931\u8d25"));
    }

    public List<EngineResultEntity> tableQueryCondOnFiled(Long appId, Long formId, String viewId, String fieldName, Long value, List<OrderItem> sort) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(sort)) {
            params.put("orders", sort);
        }
        SuperQueryConditionDto queryCondition = new SuperQueryConditionDto();
        queryCondition.setField(fieldName);
        queryCondition.setRule(HussarUtils.isEmpty((Object)value) ? "_isNull" : "_eq");
        queryCondition.setVal((Object)value);
        queryCondition.setMatch(MatchTypeEnum.AND.getValue());
        params.put("superQueryConditionDto", Collections.singletonList(queryCondition));
        params.put("current", 1);
        params.put("size", Integer.MAX_VALUE);
        return this.tableQueryCondition(appId, formId, viewId, params);
    }

    public List<EngineResultEntity> tableQueryCondInFiledList(Long appId, Long formId, String viewId, String fieldName, List<String> value) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        SuperQueryConditionDto queryCondition = new SuperQueryConditionDto();
        queryCondition.setField(fieldName);
        queryCondition.setRule(HussarUtils.isEmpty(value) ? "_isNull" : "_in");
        queryCondition.setVal(value);
        queryCondition.setMatch(MatchTypeEnum.AND.getValue());
        params.put("superQueryConditionDto", Collections.singletonList(queryCondition));
        params.put("size", 30);
        params.put("current", 1);
        return this.tableQueryCondition(appId, formId, viewId, params);
    }

    public NavLeftTreeVo createRootNode(Long id, Long parentId, String label, String value, Long processInstId) {
        NavLeftTreeVo navLeftTreeVo = new NavLeftTreeVo();
        navLeftTreeVo.setId((Serializable)id);
        navLeftTreeVo.setParentId((Serializable)parentId);
        navLeftTreeVo.setLabel(label);
        navLeftTreeVo.setValue(value);
        navLeftTreeVo.setProcessInstId(processInstId);
        return navLeftTreeVo;
    }

    public void flatTreeVo(NavLeftTreeVo leftTree, List<LeftTreeFlatVo> leftTreeFlatVoList) {
        if (HussarUtils.isEmpty((Object)leftTree)) {
            return;
        }
        leftTreeFlatVoList.add((LeftTreeFlatVo)BeanUtil.copy((Object)leftTree, LeftTreeFlatVo.class));
        LeftTreeUtil.condRun(HussarUtils.isNotEmpty((Object)leftTree.getChildren()), () -> leftTree.getChildren().forEach(child -> this.flatTreeVo((NavLeftTreeVo)child, leftTreeFlatVoList)));
    }

    public List<NavLeftTreeVo> convertToTreeNodes(List<EngineResultEntity> resultEntityList, String formType, String titleFieldName, String currentFieldName, String parentFieldName) {
        ArrayList<NavLeftTreeVo> nodeList = new ArrayList<NavLeftTreeVo>();
        for (EngineResultEntity entity : resultEntityList) {
            Long id = LeftTreeUtil.convertLong(entity.get((Object)"RECORD_ID"));
            String label = LeftTreeUtil.convertString(entity.get((Object)titleFieldName));
            String value = LeftTreeUtil.convertString(entity.get((Object)currentFieldName));
            Long parentId = LeftTreeUtil.convertLong(entity.get((Object)parentFieldName));
            NavLeftTreeVo treeNode = new NavLeftTreeVo();
            treeNode.setId((Serializable)id);
            treeNode.setLabel(label);
            treeNode.setValue(value);
            treeNode.setParentId((Serializable)parentId);
            LeftTreeUtil.condRun(HussarUtils.equals((Object)"1", (Object)formType), () -> treeNode.setProcessInstId(LeftTreeUtil.convertLong(entity.get((Object)"PROCESS_INST_ID"))));
            nodeList.add(treeNode);
        }
        return nodeList;
    }

    public Map<Long, Boolean> getLeafNodeFlagMap(Long appId, Long formId, String viewId, String parentFieldName, List<String> idList) {
        List<EngineResultEntity> resultEntityList = this.tableQueryCondInFiledList(appId, formId, viewId, parentFieldName, idList);
        return resultEntityList.stream().filter(entity -> HussarUtils.isNotEmpty((Object)entity.get((Object)parentFieldName))).collect(Collectors.groupingBy(entity -> LeftTreeUtil.convertLong(entity.get((Object)parentFieldName)), Collectors.counting())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entity -> (Long)entity.getValue() > 0L));
    }

    public LeftTreeCtx getLeftTreeCtx(Long formId, String viewId, int viewType, NavLeftTreeOption leftTreeOption, Long id) {
        LeftTreeCtx leftTreeCtx = new LeftTreeCtx();
        switch (viewType) {
            case 1: {
                this.processTreeTable(formId, viewId, leftTreeOption, id, leftTreeCtx);
                break;
            }
            case 2: {
                this.processTreeDetail(formId, viewId, leftTreeOption, id, leftTreeCtx);
                break;
            }
            default: {
                throw new HussarException("\u4e0d\u652f\u6301\u6b64\u79cd\u7c7b\u578b\u7684\u5de6\u4fa7\u6811");
            }
        }
        return leftTreeCtx;
    }

    private void processTreeDetail(Long formId, String viewId, NavLeftTreeOption leftTreeOption, Long id, LeftTreeCtx leftTreeCtx) {
        WidgetItem titleWidget = leftTreeOption.getTitleWidget();
        WidgetItem supWidget = leftTreeOption.getSupWidget();
        WidgetItem linkWidget = leftTreeOption.getLinkWidget();
        leftTreeCtx.setId(id);
        leftTreeCtx.setFormId(formId);
        leftTreeCtx.setViewId(viewId);
        leftTreeCtx.setTreeAppId(titleWidget.getAppId());
        leftTreeCtx.setTreeFormId(formId);
        leftTreeCtx.setTreeViewId(viewId);
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)supWidget.getFormId());
        String formType = sysForm.getFormType();
        leftTreeCtx.setTreeFormType(formType);
        leftTreeCtx.setSortType(leftTreeOption.getSortType());
        leftTreeCtx.setDefaultDisplayNode(leftTreeOption.getDefaultDisplayNode());
        leftTreeCtx.setTitleFieldName(this.getLabelFieldName(titleWidget.getType(), titleWidget.getName()));
        leftTreeCtx.setCurrentFieldName(linkWidget.getName());
        leftTreeCtx.setParentFieldName(this.getParentFieldName(supWidget.getType(), supWidget.getName()));
    }

    private void processTreeTable(Long formId, String viewId, NavLeftTreeOption leftTreeOption, Long id, LeftTreeCtx leftTreeCtx) {
        WidgetItem linkWidget = leftTreeOption.getLinkWidget();
        WidgetItem supWidget = leftTreeOption.getSupWidget();
        leftTreeCtx.setId(id);
        leftTreeCtx.setFormId(formId);
        leftTreeCtx.setViewId(viewId);
        leftTreeCtx.setTreeAppId(linkWidget.getAppId());
        leftTreeCtx.setTreeFormId(linkWidget.getFormId());
        leftTreeCtx.setSortType(leftTreeOption.getSortType());
        leftTreeCtx.setDefaultDisplayNode(leftTreeOption.getDefaultDisplayNode());
        leftTreeCtx.setTitleFieldName(this.getLabelFieldName(linkWidget.getType(), linkWidget.getName()));
        leftTreeCtx.setCurrentFieldName(linkWidget.getName());
        leftTreeCtx.setParentFieldName(this.getParentFieldName(supWidget.getType(), supWidget.getName()));
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)linkWidget.getFormId());
        String formType = sysForm.getFormType();
        leftTreeCtx.setTreeFormType(formType);
        switch (formType) {
            case "0": {
                leftTreeCtx.setTreeViewId(ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId());
                break;
            }
            case "1": {
                leftTreeCtx.setTreeViewId(ViewIdEnum.SYS_FLOW_ALL_DATA.getId());
                break;
            }
            default: {
                throw new HussarException("\u4e0d\u652f\u6301\u7684\u8868\u5355\u7c7b\u578b");
            }
        }
    }

    public String getParentFieldName(String widgetType, String widgetName) {
        String referFieldName;
        WidgetType type = WidgetType.getWidgetType((String)widgetType);
        AssertUtil.isNotNull((Object)type, (String)"\u4e0d\u652f\u6301\u7684\u7ec4\u4ef6\u7c7b\u578b");
        switch (type) {
            case JXDNLinkForm: {
                referFieldName = widgetName + "_ref_id";
                break;
            }
            default: {
                throw new HussarException("\u4e0d\u652f\u6301\u7684\u7ec4\u4ef6\u7c7b\u578b");
            }
        }
        return referFieldName;
    }

    private String getLabelFieldName(String widgetType, String widgetName) {
        String labelFieldName;
        WidgetType type = WidgetType.getWidgetType((String)widgetType);
        AssertUtil.isNotNull((Object)type, (String)"\u4e0d\u652f\u6301\u7684\u7ec4\u4ef6\u7c7b\u578b");
        switch (type) {
            case SELECT: 
            case SELECT_MUL: 
            case RADIO_GROUP: 
            case CHECK_BOX_GROUP: 
            case ADDRESS: 
            case JXDNUser: 
            case JXDNUserMulti: 
            case JXDNOrg: 
            case JXDNOrgMulti: {
                labelFieldName = widgetName + "_label";
                break;
            }
            default: {
                labelFieldName = widgetName;
            }
        }
        return labelFieldName;
    }
}

