/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.extapi.model.SysFormExtApi;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormUpgradeTypEnum;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.ImportFormDataDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.UpgradeFormMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormCheckConfig;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.lefttree.model.NavLeftTreeOrder;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.print.model.SysFileInfoDashboard;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.util.FormMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportThreadServiceImpl")
public class FormImportThreadServiceImpl
implements IFormImportThreadService {
    @Resource
    private IFormImportInfoService formImportInfoService;
    @Resource
    private ISysFormService formService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private IFormUpgradeThreadService formUpgradeThreadService;
    @Resource
    private IFormImportThreadService formImportThreadService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormImportThreadServiceImpl.class);

    @HussarDs(value="#dataSourceKey")
    public void startImportThread(FormImportDto formImportDto, String dataSourceKey) throws Exception {
        ImportMappingDto importMappingDto = new ImportMappingDto();
        formImportDto.setUpgradeData(true);
        this.initFormDataByFormPackage(formImportDto, importMappingDto);
        formImportDto.setId(importMappingDto.getFormDataInit().getForm().getId());
        try {
            TransmittableThreadLocalHolder.set((String)"appId", (Object)String.valueOf(importMappingDto.getNewAppId()));
            importMappingDto.setKeepTableName(HussarUtils.isEmpty((Object)this.formService.getById((Serializable)formImportDto.getId())));
            if (importMappingDto.isKeepTableName()) {
                formImportDto.setUpgradeFormLink(true);
                formImportDto.setDataOprLogType(5);
                FormUpgradeDto upgradeDto = (FormUpgradeDto)BeanUtil.copy((Object)formImportDto, FormUpgradeDto.class);
                upgradeDto.setUpgradeType(FormUpgradeTypEnum.COVER.getCode());
                importMappingDto.setKeepTableName(true);
                UpgradeFormMappingDto upgradeFormMappingDto = (UpgradeFormMappingDto)BeanUtil.copy((Object)importMappingDto, UpgradeFormMappingDto.class);
                this.formUpgradeThreadService.upgradeForm(upgradeDto, upgradeFormMappingDto);
            } else {
                this.importForm(formImportDto, importMappingDto);
            }
            String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.success((int)4, (boolean)true, (Object)importMappingDto.getNewAppId()));
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty(importMappingDto.getFormIdMap().values())) {
                this.formService.removeByIds(importMappingDto.getFormIdMap().values());
                importMappingDto.getFormIdMap().values().forEach(formId -> {
                    SysForm sysForm = new SysForm();
                    sysForm.setId(formId);
                    this.appSyncService.syncForm("del", sysForm);
                });
            }
            LOGGER.error("\u8868\u5355\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new HussarException((Throwable)e);
        }
    }

    public void importForm(FormImportDto formImportDto, ImportMappingDto importMappingDto) throws Exception {
        this.formImportInfoService.importFormData(formImportDto, importMappingDto);
        if ("2".equals(formImportDto.getFormType())) {
            this.formImportInfoService.importDashboardData(formImportDto, importMappingDto);
        } else {
            this.formImportInfoService.importMidFile(formImportDto, importMappingDto);
            this.formImportInfoService.importFlowData(formImportDto, importMappingDto);
            if (formImportDto.isUpgradeData()) {
                this.formImportInfoService.importBusinessData(formImportDto, importMappingDto);
            }
            this.formImportInfoService.importBusinessRule(formImportDto, importMappingDto);
        }
        Long importFormId = importMappingDto.getFormIdMap().values().stream().findFirst().orElse(null);
        this.appSyncService.importForm(importFormId);
    }

    public void initFormDataByFormPackage(FormImportDto formImportDto, ImportMappingDto importMappingDto) throws IOException {
        String dataFilePath;
        JSONObject businessData;
        ImportFormDataDto importFormDataDto = new ImportFormDataDto();
        String formFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "form.json"});
        JSONObject jsonObject = FormMigrateUtil.readFileToObject(formFilePath, JSONObject.class);
        SysForm form = (SysForm)jsonObject.getObject("form", SysForm.class);
        importFormDataDto.setForm(form);
        if ("2".equals(form.getFormType())) {
            String dashboardImagePath;
            JSONObject dashboardImageJsonObject;
            String dashboardFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "dashboardConfig", "dashboard.json"});
            JSONObject jsonObjectDashboard = FormMigrateUtil.readFileToObject(dashboardFilePath, JSONObject.class);
            if (HussarUtils.isNotEmpty((Object)jsonObjectDashboard)) {
                JSONArray dashEntryList = (JSONArray)jsonObjectDashboard.get((Object)"dashboard");
                importFormDataDto.setDashEntry(dashEntryList);
            }
            if (HussarUtils.isNotEmpty((Object)(dashboardImageJsonObject = FormMigrateUtil.readFileToObject(dashboardImagePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "dashboardImagePath", "printImage.json"}), JSONObject.class)))) {
                JSONArray printTemplateJsonArray = (JSONArray)dashboardImageJsonObject.getObject("printImageData", JSONArray.class);
                List<SysFileInfoDashboard> dashboardImageInfo = FormMigrateUtil.parseJsonArrayToList(printTemplateJsonArray, SysFileInfoDashboard.class);
                importFormDataDto.setDashboardImageList(dashboardImageInfo);
                String imagePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "dashboardImagePath", "imageFile"});
                importFormDataDto.setDashboardImagePath(imagePath);
            }
        }
        String filePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", form.getTableName()});
        File file = new File(filePath);
        String canvasPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "canvas", file.getName() + ".fd"});
        String settingPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "setting", file.getName() + ".setting"});
        String viewPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "view", file.getName() + ".vd"});
        importFormDataDto.setFile(filePath);
        importFormDataDto.setCanvasPath(canvasPath);
        importFormDataDto.setSettingPath(settingPath);
        importFormDataDto.setViewPath(viewPath);
        String checkConfigFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "checkConfig.json"});
        File fileConfigFilePath = new File(checkConfigFilePath);
        if (fileConfigFilePath.exists()) {
            String text = new String(Files.readAllBytes(Paths.get(fileConfigFilePath.getAbsolutePath(), new String[0])));
            List checkConfigs = JSONArray.parseArray((String)text, SysFormCheckConfig.class);
            importFormDataDto.setCheckConfigs(checkConfigs);
        }
        String msgPushPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "appConfig", "msg.json"});
        List<SysMsgPushConfig> msgPushConfigs = FormMigrateUtil.readFileToObject(msgPushPath, List.class);
        msgPushConfigs = FormMigrateUtil.parseListObjectoList(msgPushConfigs, SysMsgPushConfig.class);
        importFormDataDto.setSysMsgPushConfigs(msgPushConfigs);
        String printTemplatePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "printTemplate", "printTemplate.json"});
        JSONObject printJsonObject = FormMigrateUtil.readFileToObject(printTemplatePath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)printJsonObject)) {
            JSONArray printTemplateJsonArray = (JSONArray)printJsonObject.getObject("printTemplateData", JSONArray.class);
            List<SysPrintTemplate> printTemplates = FormMigrateUtil.parseJsonArrayToList(printTemplateJsonArray, SysPrintTemplate.class);
            importFormDataDto.setPrintTemplates(printTemplates);
        }
        String templateFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "printTemplate", "templateFile"});
        importFormDataDto.setTemplateFilePath(templateFilePath);
        String formLinkFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "formLink.json"});
        JSONObject formLinkJsonObject = FormMigrateUtil.readFileToObject(formLinkFilePath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)formLinkJsonObject)) {
            importFormDataDto.setFormLinkObject(formLinkJsonObject);
        }
        String dataPushPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "appConfig", "dataPush.json"});
        List<SysDataPushConfig> sysDataPushConfigs = FormMigrateUtil.readFileToObject(dataPushPath, List.class);
        sysDataPushConfigs = FormMigrateUtil.parseListObjectoList(sysDataPushConfigs, SysDataPushConfig.class);
        importFormDataDto.setPushConfigs(sysDataPushConfigs);
        String dataPushMapPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "appConfig", "dataPushMap.json"});
        FormMap map = FormMigrateUtil.readFileToObject(dataPushMapPath, FormMap.class);
        if (HussarUtils.isNotEmpty((Object)map)) {
            importFormDataDto.setMap(map);
        }
        String dataPullPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "appConfig", "dataPull.json"});
        List<SysDataPullConfig> sysDataPullConfigs = FormMigrateUtil.readFileToObject(dataPullPath, List.class);
        sysDataPullConfigs = FormMigrateUtil.parseListObjectoList(sysDataPullConfigs, SysDataPullConfig.class);
        importFormDataDto.setPullConfigs(sysDataPullConfigs);
        String publicViewPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "publicView.json"});
        List<DataView> dataViews = FormMigrateUtil.readFileToObject(publicViewPath, List.class);
        dataViews = FormMigrateUtil.parseListObjectoList(dataViews, DataView.class);
        importFormDataDto.setDataViews(dataViews);
        String leftTreePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "appConfig", "leftTree.json"});
        JSONObject leftTreeJsonObject = FormMigrateUtil.readFileToObject(leftTreePath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)leftTreeJsonObject)) {
            List dragOrders = JSONArray.parseArray((String)leftTreeJsonObject.getString("dragOrder"), NavLeftTreeOrder.class);
            importFormDataDto.setDragOrders(dragOrders);
        }
        String extensionApiPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "appConfig", "extensionApi.json"});
        List<SysFormExtApi> sysFormExtApis = FormMigrateUtil.readFileToObject(extensionApiPath, List.class);
        sysFormExtApis = FormMigrateUtil.parseListObjectoList(sysFormExtApis, SysFormExtApi.class);
        importFormDataDto.setSysFormExtApis(sysFormExtApis);
        String ruleFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "rule.json"});
        List<RuleFullVo> ruleFullVos = FormMigrateUtil.readFileToObject(ruleFilePath, List.class);
        ruleFullVos = FormMigrateUtil.parseListObjectoList(ruleFullVos, RuleFullVo.class);
        importFormDataDto.setRules(ruleFullVos);
        String customButtonPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "customButton.json"});
        JSONObject customButtonJsonObject = FormMigrateUtil.readFileToObject(customButtonPath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)customButtonJsonObject)) {
            JSONArray customButtonJsonArray = (JSONArray)customButtonJsonObject.getObject("customButtonData", JSONArray.class);
            List<SysCustomButton> customButtons = FormMigrateUtil.parseJsonArrayToList(customButtonJsonArray, SysCustomButton.class);
            importFormDataDto.setCustomButton(customButtons);
        }
        String scriptBasespath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "script.json"});
        List<ScriptBase> scriptBases = FormMigrateUtil.readFileToObject(scriptBasespath, List.class);
        scriptBases = FormMigrateUtil.parseListObjectoList(scriptBases, ScriptBase.class);
        importFormDataDto.setScriptBases(scriptBases);
        if ("1".equals(form.getFormType())) {
            String flowFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "formConfig", "flow.json"});
            JSONObject flowData = FormMigrateUtil.readFileToObject(flowFilePath, JSONObject.class);
            importFormDataDto.setFlowData(flowData);
        }
        if (formImportDto.isUpgradeData() && HussarUtils.isNotEmpty((Object)(businessData = FormMigrateUtil.readFileToObject(dataFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "businessData", "businessData.json"}), JSONObject.class)))) {
            importFormDataDto.setBusinessData(businessData);
        }
        String widgetExpandPath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "widgetExpand"});
        importFormDataDto.setWidgetExpandPath(widgetExpandPath);
        importMappingDto.setFormDataInit(importFormDataDto);
    }
}

