/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppRecycleBoService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportThreadService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportServiceImpl")
public class AppImportServiceImpl
implements IAppImportService {
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IAppImportThreadService appImportThreadService;
    @Resource
    private ISysApplicationBoService applicationService;
    @Resource
    private ISysAppRecycleBoService appRecycleBoService;
    @Resource
    private SysFormMapper sysFormMapper;
    private static final Logger logger = LoggerFactory.getLogger(AppImportServiceImpl.class);

    public ApiResponse<AppAttachmentParseVo> parseAttachment(MultipartFile file) {
        String path;
        try {
            path = this.appFileExtendService.fileDecrypt(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = path.substring(0, path.length() - 7);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        AppExportMetaDto appExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, AppExportMetaDto.class);
        String formPath = FileUtil.posixPath((String[])new String[]{unZipPath, "appConfig" + File.separator + "app.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(formPath, JSONObject.class);
        if (HussarUtils.isEmpty((Object)jsonObject)) {
            throw new BaseException("\u8bfb\u53d6\u5e94\u7528\u4fe1\u606f\u5931\u8d25");
        }
        Object object = jsonObject.get((Object)"appInfo");
        JSONObject app = (JSONObject)object;
        if (HussarUtils.isEmpty((Object)app)) {
            throw new BaseException("\u8bfb\u53d6\u5e94\u7528\u4fe1\u606f\u5931\u8d25");
        }
        if (appExportMetaDto == null || HussarUtils.isEmpty((Object)appExportMetaDto.getAppName())) {
            return ApiResponse.fail((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u5e94\u7528\u6587\u4ef6");
        }
        AppAttachmentParseVo appAttachmentParseVo = new AppAttachmentParseVo();
        appAttachmentParseVo.setPath(unZipPath);
        appAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)appExportMetaDto.getPassword()));
        BeanUtils.copyProperties((Object)appExportMetaDto, (Object)appAttachmentParseVo);
        appAttachmentParseVo.setI18nKeys(app.getString("i18nKeys"));
        appAttachmentParseVo.setId(app.getString("id"));
        return ApiResponse.success((Object)appAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(AppImportDto appImportDto) {
        String inputPwd = DigestUtil.sha1Hex((String)appImportDto.getPassword());
        String metaFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "hussar.meta"});
        AppExportMetaDto appExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, AppExportMetaDto.class);
        assert (appExportMetaDto != null);
        String password = appExportMetaDto.getPassword();
        return ApiResponse.success((Object)inputPwd.equals(password));
    }

    public Boolean verifyAppName(String appName) {
        SysApplicationVo appByName = this.applicationService.getAppByName(appName);
        SysAppRecycle recycleAppByName = this.appRecycleBoService.getSysAppRecycle(appName);
        return HussarUtils.isEmpty((Object)appByName) && HussarUtils.isEmpty((Object)recycleAppByName);
    }

    public void importApp(AppImportDto appImportDto) {
        logger.info("\u5e94\u7528\u5bfc\u5165 => \u5f00\u59cb\u6267\u884c...");
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> {
            try {
                this.appImportThreadService.startImportThread(appImportDto, dataSourceKey);
                TransmittableThreadLocalHolder.clear((String)"loginUser");
                logger.info("\u5e94\u7528\u5bfc\u5165 => \u6267\u884c\u5b8c\u6bd5\uff01");
            }
            catch (Exception e) {
                logger.error("\u5e94\u7528\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                throw new HussarException((Throwable)e);
            }
        });
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class));
    }

    public void importSuccessCallBack(String appId) {
        SysApplication application = this.applicationService.selectById(Long.valueOf(appId));
        if (ToolUtil.isNotEmpty((Object)application) && HussarUtils.isNotEmpty((Object)application.getDevelopRoleId())) {
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            Map extendUserMap = userDetails.getExtendUserMap();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            Object rolesList = extendUserMap.get("rolesList");
            if (HussarUtils.isNotEmpty(rolesList)) {
                roleIds.addAll((List)rolesList);
            }
            roleIds.add(application.getDevelopRoleId());
            userDetails.addExtendUserMap("rolesList", roleIds);
            SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, userDetails.getTokenValue());
        }
    }

    public ApiResponse<String> checkTableName(AppImportDto appImportDto) {
        String formFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "form.json"});
        JSONObject formData = AppMigrateUtil.readFileToObject(formFilePath, JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)formData)) {
            boolean flag = HussarUtils.equals((Object)appImportDto.getSpliceType(), (Object)"custom");
            List<SysForm> forms = AppMigrateUtil.parseJsonObjectToListByKey(formData, "forms", SysForm.class);
            if (HussarUtils.isNotEmpty(forms)) {
                Object[] files;
                ArrayList<String> duplicateNames = new ArrayList<String>();
                List<String> showTableNames = this.getTableName();
                List allTableNames = showTableNames.stream().map(name -> name.toUpperCase()).collect(Collectors.toList());
                List tableNames = forms.stream().map(SysForm::getTableName).collect(Collectors.toList());
                ArrayList<String> newTableNames = new ArrayList<String>();
                ArrayList<String> overLengthNames = new ArrayList<String>();
                if (flag) {
                    for (String tableName : tableNames) {
                        String newName = tableName + "_" + appImportDto.getSpliceSuffix();
                        if (newName.length() > 63) {
                            overLengthNames.add(tableName);
                        }
                        newTableNames.add(newName);
                    }
                } else {
                    for (String tableName : tableNames) {
                        if (tableName.length() > 63) {
                            overLengthNames.add(tableName);
                        }
                        newTableNames.add(tableName);
                    }
                }
                if (HussarUtils.isNotEmpty(overLengthNames)) {
                    String maxName = overLengthNames.stream().max(Comparator.comparing(String::length)).get();
                    return ApiResponse.success((Object)"3", (String)("\u6570\u636e\u5e93\u4e3b\u8868:" + maxName + " \u8868\u540d\u8d85\u957f"));
                }
                boolean contains = false;
                String oldAppId = String.valueOf(appImportDto.getId());
                String midFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", oldAppId});
                File midFileFolder = new File(midFilePath);
                if (midFileFolder.exists() && midFileFolder.isDirectory() && HussarUtils.isNotEmpty((Object[])(files = midFileFolder.listFiles()))) {
                    ArrayList<String> newChildrenNames = new ArrayList<String>();
                    for (Object file : files) {
                        String canvasPath = FileUtil.posixPath((String[])new String[]{((File)file).getAbsolutePath(), "canvas", ((File)file).getName() + ".fd"});
                        FormCanvasSchema formCanvasSchema = AppMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
                        if (!HussarUtils.isNotEmpty((Object)formCanvasSchema)) continue;
                        ArrayList<String> overLengthChildrenNames = new ArrayList<String>();
                        for (Widget widget : formCanvasSchema.childTables()) {
                            String oldSubTableName = widget.getName();
                            if (flag) {
                                String newSubTableName = oldSubTableName + "_" + appImportDto.getSpliceSuffix();
                                if (newSubTableName.length() > 63) {
                                    overLengthChildrenNames.add(oldSubTableName);
                                }
                                newChildrenNames.add(newSubTableName);
                                continue;
                            }
                            if (oldSubTableName.length() > 63) {
                                overLengthChildrenNames.add(oldSubTableName);
                            }
                            newChildrenNames.add(oldSubTableName);
                        }
                        if (!HussarUtils.isNotEmpty(overLengthChildrenNames)) continue;
                        String maxName = overLengthChildrenNames.stream().max(Comparator.comparing(String::length)).get();
                        return ApiResponse.success((Object)"3", (String)("\u6570\u636e\u5e93\u5b50\u8868:" + maxName + " \u8868\u540d\u8d85\u957f"));
                    }
                    for (String newChildrenName : newChildrenNames) {
                        if (!HussarUtils.contains(allTableNames.iterator(), (Object)newChildrenName.toUpperCase())) continue;
                        contains = true;
                        duplicateNames.add(newChildrenName);
                    }
                    if (contains) {
                        logger.info("\u6570\u636e\u5e93\u4e2d\u5b50\u8868\u5b58\u5728\u91cd\u590d\u8868\u540d:" + duplicateNames);
                        return ApiResponse.success((Object)"2", (String)"\u6570\u636e\u5e93\u4e2d\u5b50\u8868\u5b58\u5728\u91cd\u590d\u8868\u540d");
                    }
                }
                for (String newTableName : newTableNames) {
                    if (!HussarUtils.contains(allTableNames.iterator(), (Object)newTableName.toUpperCase())) continue;
                    contains = true;
                    duplicateNames.add(newTableName);
                }
                if (contains) {
                    logger.info("\u6570\u636e\u5e93\u4e2d\u4e3b\u8868\u5b58\u5728\u91cd\u590d\u8868\u540d:" + duplicateNames);
                    return ApiResponse.success((Object)"2", (String)"\u6570\u636e\u5e93\u4e2d\u4e3b\u8868\u5b58\u5728\u91cd\u590d\u8868\u540d");
                }
                return ApiResponse.success((Object)"1", (String)"\u6570\u636e\u5e93\u4e2d\u65e0\u91cd\u590d\u8868\u540d");
            }
        }
        return ApiResponse.success((Object)"1", (String)"\u65e0\u8868\u5355\u6570\u636e");
    }

    public List<String> getTableName() {
        List<Object> tableNameList = new ArrayList();
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        ItemDataSource currentDatasource = bean.getCurrentDatasource();
        switch (currentDatasource.getDbType()) {
            case MYSQL: {
                tableNameList = this.sysFormMapper.showMysqlTableNames();
                break;
            }
            case DM: 
            case OSCAR: {
                String dbName = HussarUtils.isNotEmpty((Object)currentDatasource.getSchemaName()) ? currentDatasource.getSchemaName() : currentDatasource.getUsername();
                tableNameList = this.sysFormMapper.showDMAndOscarTableNames(dbName.toUpperCase());
                break;
            }
            case KINGBASE_ES: {
                String schemaName = HussarUtils.isEmpty((Object)currentDatasource.getSchemaName()) ? "public" : currentDatasource.getSchemaName();
                tableNameList = this.sysFormMapper.showKingBaseTableNames(schemaName);
                break;
            }
            default: {
                throw new HussarException("\u6682\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b");
            }
        }
        return tableNameList;
    }
}

