/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormSysFieldEnum;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.dto.TableNameQueryDto;
import com.jxdinfo.hussar.formdesign.application.tableinfo.model.SysUserTableName;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.FormTableInfoService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.service.DatasourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl.FormTableInfoServiceImpl")
public class FormTableInfoServiceImpl
implements FormTableInfoService {
    private final Logger LOGGER = LoggerFactory.getLogger(FormTableInfoServiceImpl.class);
    @Autowired
    private DatasourceDataService dataSourceDataService;
    @Autowired
    private ISysFormService formService;
    @Autowired
    private ISysUserTableNameService sysUserTableNameService;

    @Override
    public ApiResponse<Boolean> flushed() throws IOException, LcdpException {
        Boolean flushing = (Boolean)HussarCacheUtil.get((String)"sys_user_table_name_flushed", (Object)"flushed_key");
        if (HussarUtils.isNotEmpty((Object)flushing) && flushing.booleanValue()) {
            return ApiResponse.success((Object)false);
        }
        HussarCacheUtil.put((String)"sys_user_table_name_flushed", (Object)"flushed_key", (Object)true, (long)600L);
        try {
            this.sysUserTableNameService.flushed();
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HussarCacheUtil.evict((String)"sys_user_table_name_flushed", (Object)"flushed_key");
        }
        return ApiResponse.success((Object)true);
    }

    @Override
    public Page<SysUserTableName> getTableInfoList(TableNameQueryDto queryDto) throws IOException, LcdpException {
        this.sysUserTableNameService.clearCreated();
        return this.sysUserTableNameService.selectByPage(queryDto.getPage(), queryDto.getTableNameLike());
    }

    @Override
    public List<TableInfo> getTables(List<String> tableNames) throws IOException, LcdpException {
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasource = sysDataSourceService.getByConnName(NoCodeBusinessDB.getNocodeBusinessDB());
        List tableInfoList = this.dataSourceDataService.filterTables(datasource.getId(), "BASE TABLE", tableNames);
        Set<String> fieldNameUppers = FormSysFieldEnum.getFieldNameUppers();
        for (TableInfo tableInfo : tableInfoList) {
            List fields = tableInfo.getFields();
            if (!HussarUtils.isNotEmpty((Object)fields)) continue;
            fields.removeIf(field -> fieldNameUppers.contains(field.getName().toUpperCase()) || HussarUtils.equals((Object)tableInfo.getName().toUpperCase(), (Object)field.getName().toUpperCase()));
        }
        return tableInfoList;
    }

    @Override
    public ApiResponse<String> checkTableNames(List<String> tableNames) {
        ApiResponse<Boolean> check = this.sysUserTableNameService.check(tableNames);
        if (!check.isSuccess()) {
            return ApiResponse.fail((String)check.getMsg());
        }
        String key = this.sysUserTableNameService.put(tableNames);
        return ApiResponse.success((Object)key, (String)"");
    }
}

