/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.impl;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.RoleFormAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.sync.union.dto.ConversionProduct;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUnionConverter;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUnionHelper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@HussarTokenDs
@ConditionalOnProperty(name={"hussar.app-sync.type"}, havingValue="union")
@Service(value="com.jxdinfo.hussar.example.sync.appSyncUnionServiceImpl")
public class AppSyncUnionServiceImpl
implements AppSyncService {
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysFunctionModulesBoService functionModulesBoService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private ISysResourceMosulesBoService resourceMosulesBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysFunctionResourcesBoService functionResourcesBoService;
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private ISysMenuManageBoService menuBoService;
    @Resource
    private SyncUnionHelper syncHelper;
    @Resource
    private SyncUnionConverter syncUnionConverter;
    private static final String NO_CODE_SOURCE = "noCode";
    private static final Logger LOGGER = LoggerFactory.getLogger(AppSyncUnionServiceImpl.class);

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncApp(String type, SysApplication app) {
        switch (type) {
            case "add": {
                this.addApp(app);
                break;
            }
            case "edit": {
                this.editApp(app);
                break;
            }
            case "del": {
                this.delApp(app);
                break;
            }
            default: {
                throw new HussarException("\u5e94\u7528\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addApp(SysApplication app) {
        this.saveConversionProduct(this.syncUnionConverter.appToModule(app, null));
    }

    private void editApp(SysApplication app) {
        this.functionModulesBoService.updateNameById(app.getId(), app.getAppName());
        this.resourceMosulesBoService.updateNameById(app.getId(), app.getAppName());
    }

    private void delApp(SysApplication app) {
        Long appId = app.getId();
        List<Long> formGroupIds = this.syncHelper.listFormGroupIds(appId);
        List<Long> formIds = this.syncHelper.getAllFormId(appId);
        List<Long> menuFunIdsByApp = this.syncHelper.listMenuFunIdsByApp(appId);
        ArrayList<Long> moduleIds = new ArrayList<Long>();
        moduleIds.add(app.getId());
        moduleIds.addAll(formGroupIds);
        moduleIds.addAll(formIds);
        if (HussarUtils.isNotEmpty(moduleIds)) {
            this.functionModulesBoService.deleteByIds(moduleIds);
            this.resourceMosulesBoService.deleteResourceModulesByIds(moduleIds);
        }
        List<Long> funIds = this.syncHelper.listFunIdsByApp(appId);
        List<Long> resIds = this.syncHelper.listResIdsByApp(appId);
        if (HussarUtils.isNotEmpty(funIds)) {
            this.functionsBoService.deleteByid(funIds);
            this.hussarBaseResourceService.deleteResourcesByIds(resIds);
            this.rolesExternalService.delRoleFunByFunIds(funIds);
            this.rolesExternalService.delRoleResByResIds(resIds);
            this.functionResourcesBoService.deleteByFunAndResId(funIds, resIds);
            this.rolesExternalService.delRoleRightByFunIds(funIds);
        }
        if (HussarUtils.isNotEmpty(menuFunIdsByApp)) {
            this.menuBoService.delByFunId(menuFunIdsByApp);
            HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncFormGroup(String type, SysFormGroup formGroup) {
        switch (type) {
            case "add": {
                this.addFormGroup(formGroup);
                break;
            }
            case "edit": {
                this.editFormGroup(formGroup);
                break;
            }
            case "del": {
                this.delFormGroup(formGroup);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u5206\u7ec4\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addFormGroup(SysFormGroup formGroup) {
        this.saveConversionProduct(this.syncUnionConverter.formGroupToModule(formGroup, null));
    }

    private void editFormGroup(SysFormGroup formGroup) {
        this.functionModulesBoService.updateNameById(formGroup.getId(), formGroup.getGroupName());
        this.resourceMosulesBoService.updateNameById(formGroup.getId(), formGroup.getGroupName());
    }

    private void delFormGroup(SysFormGroup formGroup) {
        this.functionModulesBoService.deleteById(formGroup.getId());
        this.resourceMosulesBoService.deleteOneResourceModulesById(formGroup.getId());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncForm(String type, SysForm form) {
        switch (type) {
            case "add": {
                this.addForm(form);
                break;
            }
            case "edit": {
                this.editForm(form);
                break;
            }
            case "del": {
                this.delForm(form);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addForm(SysForm form) {
        ConversionProduct conversionProduct = new ConversionProduct();
        this.syncUnionConverter.formToModule(form, conversionProduct);
        this.syncUnionConverter.formToMenuRes(form, conversionProduct);
        if (this.ordinaryOrFlow(form)) {
            this.syncUnionConverter.formToElementRes(form, conversionProduct);
            this.syncUnionConverter.formToDataRes(form, conversionProduct);
        }
        this.syncUnionConverter.authFormForAppDevRole(form, conversionProduct);
        this.saveConversionProduct(conversionProduct);
    }

    private void editForm(SysForm form) {
        boolean haveGroup = HussarUtils.isNotEmpty((Object)form.getFormGroupId());
        Long appId = HussarUtils.isNotEmpty((Object)form.getAppId()) ? form.getAppId() : ((SysForm)this.formService.getById((Serializable)form.getId())).getAppId();
        Long moduleId = haveGroup ? form.getFormGroupId() : appId;
        this.functionModulesBoService.updateParentAndNameById(form.getId(), moduleId, form.getFormName());
        this.resourceMosulesBoService.updateParentAndNameById(form.getId(), moduleId, form.getFormName());
        if (HussarUtils.isNotEmpty((Object)form.getFormName())) {
            this.functionsBoService.updateNameByCode(form.getId(), form.getFormName());
            this.hussarBaseResourceService.updateNameAliasByCode("menu_" + form.getId(), form.getFormName(), form.getFormName());
        }
    }

    private void delForm(SysForm form) {
        Long formId = form.getId();
        Long menuFunId = this.syncHelper.getMenuFunId(formId);
        List<Long> allFunIdsByForm = this.syncHelper.listFunIdsByForm(formId);
        List<Long> allResIdsByForm = this.syncHelper.listResIdsByForm(formId);
        this.functionModulesBoService.deleteById(formId);
        this.resourceMosulesBoService.deleteOneResourceModulesById(formId);
        this.functionsBoService.deleteByid(allFunIdsByForm);
        this.hussarBaseResourceService.deleteResourcesByIds(allResIdsByForm);
        if (HussarUtils.isNotEmpty(allFunIdsByForm) && HussarUtils.isNotEmpty(allResIdsByForm)) {
            this.functionResourcesBoService.deleteByFunAndResId(allFunIdsByForm, allResIdsByForm);
        }
        if (HussarUtils.isNotEmpty(allFunIdsByForm)) {
            this.rolesExternalService.delRoleFunByFunIds(allFunIdsByForm);
        }
        if (HussarUtils.isNotEmpty(allResIdsByForm)) {
            this.rolesExternalService.delRoleResByResIds(allResIdsByForm);
        }
        if (HussarUtils.isNotEmpty((Object)menuFunId)) {
            this.menuBoService.delByFunId(Collections.singletonList(menuFunId));
            HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
        }
        HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncCustomButton(String type, SysCustomButton sysCustomButton) {
        switch (type) {
            case "add": {
                this.addCustomButton(sysCustomButton);
                break;
            }
            case "edit": {
                this.editCustomButton(sysCustomButton);
                break;
            }
            case "del": {
                this.delCustomButton(sysCustomButton);
                break;
            }
            default: {
                throw new HussarException("\u8868\u5355\u53d8\u66f4\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
            }
        }
    }

    private void addCustomButton(SysCustomButton sysCustomButton) {
        Long formId = sysCustomButton.getFormId();
        String buttonCode = sysCustomButton.getAction();
        String buttonAlias = sysCustomButton.getAlias();
        SysFunctions fun = new SysFunctions();
        fun.setId(sysCustomButton.getId());
        fun.setFunctionCode("element_" + formId + "_" + buttonCode);
        fun.setFunctionModuleId(formId);
        fun.setFunctionName(buttonAlias + "\u529f\u80fd");
        fun.setFunSource(NO_CODE_SOURCE);
        this.functionsBoService.saveOneFunctions(fun);
        SysResources customButtonRes = new SysResources();
        customButtonRes.setId(sysCustomButton.getId());
        customButtonRes.setResourceName(buttonAlias);
        customButtonRes.setResourceAlias(buttonAlias);
        customButtonRes.setModuleId(formId);
        customButtonRes.setResTypeId("res_element");
        customButtonRes.setPermissions(buttonCode);
        customButtonRes.setResourceCode("element_" + formId + "_" + buttonCode);
        customButtonRes.setParentResourceId(formId);
        customButtonRes.setResSource(NO_CODE_SOURCE);
        this.hussarBaseResourceService.saveOneResource(customButtonRes);
        SysFunctionResources funRes = new SysFunctionResources();
        funRes.setFunctionId(fun.getId());
        funRes.setResourceId(customButtonRes.getId());
        this.functionResourcesBoService.saveOneFunRes(funRes);
        Long appDevRoleId = this.syncHelper.getAppDevRoleId(sysCustomButton.getAppId());
        this.syncHelper.saveRoleFun(appDevRoleId, fun.getId());
        this.syncHelper.saveRoleRes(appDevRoleId, customButtonRes.getId());
    }

    private void editCustomButton(SysCustomButton sysCustomButton) {
        this.functionsBoService.updateNameById(sysCustomButton.getId(), sysCustomButton.getAlias());
        this.hussarBaseResourceService.updateNameAliasById(sysCustomButton.getId(), sysCustomButton.getAlias(), sysCustomButton.getAlias());
    }

    private void delCustomButton(SysCustomButton sysCustomButton) {
        Long buttonId = sysCustomButton.getId();
        this.functionsBoService.deleteOneById(buttonId);
        this.hussarBaseResourceService.deleteOneResourcesById(buttonId);
        if (HussarUtils.isNotEmpty((Object)buttonId)) {
            this.functionsBoService.deleteOneById(buttonId);
            this.hussarBaseResourceService.deleteOneResourcesById(buttonId);
            this.functionResourcesBoService.deleteByFunAndResId(Collections.singletonList(buttonId), Collections.singletonList(buttonId));
            this.rolesExternalService.delRoleFunByFunIds(Collections.singletonList(buttonId));
            this.rolesExternalService.delRoleResByResIds(Collections.singletonList(buttonId));
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void syncAuthority(List<RoleFormAuthorityDto> roleFormAuthorityDtoList) {
        if (HussarUtils.isEmpty(roleFormAuthorityDtoList)) {
            return;
        }
        roleFormAuthorityDtoList.forEach(roleFormAuthorityDto -> {
            this.removeOriginAuth((RoleFormAuthorityDto)roleFormAuthorityDto);
            if (roleFormAuthorityDto.isAuthorized()) {
                this.syncPageAuth((RoleFormAuthorityDto)roleFormAuthorityDto);
                this.syncOperationAuth((RoleFormAuthorityDto)roleFormAuthorityDto);
                this.syncDataAuth((RoleFormAuthorityDto)roleFormAuthorityDto);
            }
        });
        HussarCacheUtil.evictKeysLike((String)"menu_info", (String)"hussar_menus:");
    }

    private void removeOriginAuth(RoleFormAuthorityDto roleFormAuthorityDto) {
        List<Long> allResIdsByForm;
        Long roleId = roleFormAuthorityDto.getRoleId();
        Long formId = roleFormAuthorityDto.getFormId();
        Long menuFunId = this.syncHelper.getMenuFunId(formId);
        List<Long> allFunIdsByForm = this.syncHelper.listFunIdsByForm(formId);
        if (HussarUtils.isNotEmpty(allFunIdsByForm)) {
            this.rolesExternalService.delRoleFunByRoleAndFunIds(roleId, allFunIdsByForm);
        }
        if (HussarUtils.isNotEmpty(allResIdsByForm = this.syncHelper.listResIdsByForm(formId))) {
            this.rolesExternalService.delRoleResByRoleAndResIds(roleId, allResIdsByForm);
        }
        this.rolesExternalService.delRoleRightByRoleAndFunId(roleId, menuFunId);
    }

    private void syncPageAuth(RoleFormAuthorityDto roleFormAuthorityDto) {
        Long roleId = roleFormAuthorityDto.getRoleId();
        Long formId = roleFormAuthorityDto.getFormId();
        Long menuFunId = this.syncHelper.getMenuFunId(formId);
        Long menuResId = this.syncHelper.getMenuResId(formId);
        this.syncHelper.saveRoleFun(roleId, menuFunId);
        this.syncHelper.saveRoleRes(roleId, menuResId);
        List<Long> allDataResIdsByForm = this.syncHelper.listDataResIdByForm(formId);
        if (HussarUtils.isNotEmpty(allDataResIdsByForm)) {
            allDataResIdsByForm.forEach(resId -> this.syncHelper.saveRoleRes(roleId, (Long)resId));
        }
    }

    private void syncOperationAuth(RoleFormAuthorityDto roleFormAuthorityDto) {
        Long roleId = roleFormAuthorityDto.getRoleId();
        Long formId = roleFormAuthorityDto.getFormId();
        List<String> buttonCodes = roleFormAuthorityDto.getButtonAuthoritiesDto().getButtonDtoList().stream().map(ButtonDto::getButtonCode).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(buttonCodes)) {
            buttonCodes.forEach(buttonCode -> {
                String elementCode = "element_" + formId + "_" + buttonCode;
                Long elementFunId = this.functionsBoService.getOneByCode(elementCode).getId();
                Long elementResId = this.hussarBaseResourceService.getResourcesByCode(elementCode).getId();
                this.syncHelper.saveRoleFun(roleId, elementFunId);
                this.syncHelper.saveRoleRes(roleId, elementResId);
            });
        }
    }

    private void syncDataAuth(RoleFormAuthorityDto roleFormAuthorityDto) {
        Long roleId;
        Long formId = roleFormAuthorityDto.getFormId();
        SysRoleDataRight roleDataRight = this.syncUnionConverter.dataAuthToRoleDataRight(formId, roleId = roleFormAuthorityDto.getRoleId());
        if (HussarUtils.isNotEmpty((Object)roleDataRight)) {
            this.rolesExternalService.saveOneRoleRight(roleDataRight);
        }
    }

    private void syncDataRes(SysForm form) {
        Long menuFunId = this.syncHelper.getMenuFunId(form.getId());
        List<SysResources> dataResources = this.syncUnionConverter.dataResToResource(form);
        if (HussarUtils.isNotEmpty(dataResources)) {
            this.hussarBaseResourceService.saveBatchResource(dataResources);
            dataResources.forEach(dataResource -> this.syncHelper.saveFunRes(menuFunId, dataResource.getId()));
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importApp(Long appId) {
        SysApplication application = new SysApplication();
        application.setId(appId);
        this.delApp(application);
        this.syncHistory(appId);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importAppFail(Long appId) {
        SysApplication application = new SysApplication();
        application.setId(application.getId());
        this.syncApp("del", application);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void importForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        if (HussarUtils.isNotEmpty((Object)form)) {
            this.syncForm("add", form);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void copyForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        if (HussarUtils.isNotEmpty((Object)form)) {
            this.syncForm("add", form);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void convertForm(Long formId) {
        SysForm form = (SysForm)this.formService.getById((Serializable)formId);
        Long appDevRole = this.syncHelper.getAppDevRoleId(form.getAppId());
        if (HussarUtils.isNotEmpty((Object)form)) {
            String formType = form.getFormType();
            if ("1".equals(formType)) {
                SysFunctions batchSubmitFunction = this.syncUnionConverter.systemButtonToFunction(Button.SUBMIT_OPERATE, formId);
                SysFunctions batchRejectFunction = this.syncUnionConverter.systemButtonToFunction(Button.REJECT_OPERATE, formId);
                SysResources batchSubmitResource = this.syncUnionConverter.systemButtonToResource(Button.SUBMIT_OPERATE, formId);
                SysResources batchRejectResource = this.syncUnionConverter.systemButtonToResource(Button.REJECT_OPERATE, formId);
                this.functionsBoService.saveOneFunctions(batchSubmitFunction);
                this.functionsBoService.saveOneFunctions(batchRejectFunction);
                this.hussarBaseResourceService.saveOneResource(batchSubmitResource);
                this.hussarBaseResourceService.saveOneResource(batchRejectResource);
                this.syncHelper.saveFunRes(batchSubmitFunction.getId(), batchSubmitResource.getId());
                this.syncHelper.saveFunRes(batchRejectFunction.getId(), batchRejectResource.getId());
                this.syncHelper.saveRoleFun(appDevRole, batchSubmitFunction.getId());
                this.syncHelper.saveRoleFun(appDevRole, batchRejectFunction.getId());
                this.syncHelper.saveRoleRes(appDevRole, batchSubmitResource.getId());
                this.syncHelper.saveRoleRes(appDevRole, batchRejectResource.getId());
                List<SysAppVisitRoleButton> roleButtonAuthList = this.syncHelper.listButtonAuthByFlowSystemButton(formId);
                if (HussarUtils.isNotEmpty(roleButtonAuthList)) {
                    for (SysAppVisitRoleButton roleButtonAuth : roleButtonAuthList) {
                        Long elementFunctionIdByButtonCode = this.syncHelper.getElementFunctionIdByButtonCode(roleButtonAuth.getFormId(), roleButtonAuth.getButtonCode());
                        Long elementResourceIdByButtonCode = this.syncHelper.getElementResourceIdByButtonCode(roleButtonAuth.getFormId(), roleButtonAuth.getButtonCode());
                        this.syncHelper.saveRoleFun(roleButtonAuth.getRoleId(), elementFunctionIdByButtonCode);
                        this.syncHelper.saveRoleRes(roleButtonAuth.getRoleId(), elementResourceIdByButtonCode);
                    }
                }
            } else {
                ArrayList<Long> elementFunctionIdsByFlowSystemButton = new ArrayList<Long>(Arrays.asList(this.syncHelper.getElementFunctionIdByButtonCode(formId, Button.SUBMIT_OPERATE.getButtonCode()), this.syncHelper.getElementFunctionIdByButtonCode(formId, Button.REJECT_OPERATE.getButtonCode())));
                ArrayList<Long> elementResourceIdsByFlowSystemButton = new ArrayList<Long>(Arrays.asList(this.syncHelper.getElementResourceIdByButtonCode(formId, Button.SUBMIT_OPERATE.getButtonCode()), this.syncHelper.getElementResourceIdByButtonCode(formId, Button.REJECT_OPERATE.getButtonCode())));
                this.functionsBoService.deleteByid(elementFunctionIdsByFlowSystemButton);
                this.hussarBaseResourceService.deleteResourcesByIds(elementResourceIdsByFlowSystemButton);
                this.functionResourcesBoService.deleteByFunAndResId(elementFunctionIdsByFlowSystemButton, elementResourceIdsByFlowSystemButton);
                this.rolesExternalService.delRoleFunByFunIds(elementFunctionIdsByFlowSystemButton);
                this.rolesExternalService.delRoleResByResIds(elementResourceIdsByFlowSystemButton);
            }
            List<Long> dataResIdsByForm = this.syncHelper.listDataResIdByForm(formId);
            if (HussarUtils.isNotEmpty(dataResIdsByForm)) {
                this.hussarBaseResourceService.deleteResourcesByIds(dataResIdsByForm);
                this.functionResourcesBoService.deleteByResId(dataResIdsByForm);
                this.rolesExternalService.delRoleResByResIds(dataResIdsByForm);
            }
            this.syncDataRes(form);
            List<Long> newDataResIdsByForm = this.syncHelper.listDataResIdByForm(formId);
            List roleIds = this.rolesExternalService.listRoleResByResId(this.syncHelper.getMenuResId(formId)).stream().map(SysRoleResource::getRoleId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(roleIds) && HussarUtils.isNotEmpty(newDataResIdsByForm)) {
                for (Long roleId : roleIds) {
                    newDataResIdsByForm.forEach(dataResId -> this.syncHelper.saveRoleRes(roleId, (Long)dataResId));
                }
            }
        }
    }

    public void recycleApp(Long appId) {
        SysApplication application = new SysApplication();
        application.setId(appId);
        this.delApp(application);
        this.syncHistory(appId);
    }

    public void syncHistory(Long appId) {
        List<SysAppVisitRoleButton> list;
        List<SysAppVisitFormAuthorizeRoles> list2;
        List<SysForm> allForm;
        SysApplication application = this.sysApplicationBoService.selectById(appId);
        SysFunctionModules appFunctionModule = this.functionModulesBoService.getOneById(appId);
        if (HussarUtils.isEmpty((Object)application) || HussarUtils.isNotEmpty((Object)appFunctionModule)) {
            return;
        }
        Long startTime = System.currentTimeMillis();
        ConversionProduct conversionProduct = new ConversionProduct();
        this.syncUnionConverter.appToModule(application, conversionProduct);
        List<SysFormGroup> formGroups = this.syncHelper.getFormGroups(appId);
        if (HussarUtils.isNotEmpty(formGroups)) {
            for (SysFormGroup sysFormGroup : formGroups) {
                this.syncUnionConverter.formGroupToModule(sysFormGroup, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(allForm = this.syncHelper.getAllForm(appId))) {
            for (SysForm sysForm : allForm) {
                this.syncUnionConverter.formToModule(sysForm, conversionProduct);
                this.syncUnionConverter.formToMenuRes(sysForm, conversionProduct);
                if (!this.ordinaryOrFlow(sysForm)) continue;
                this.syncUnionConverter.formToElementRes(sysForm, conversionProduct);
                this.syncUnionConverter.formToDataRes(sysForm, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(list2 = this.syncHelper.getAllFormAuth(appId))) {
            for (SysAppVisitFormAuthorizeRoles sysAppVisitFormAuthorizeRoles : list2) {
                this.syncUnionConverter.formAuthToRelation(sysAppVisitFormAuthorizeRoles, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(list = this.syncHelper.getAllButtonAuth(appId))) {
            for (SysAppVisitRoleButton buttonAuth : list) {
                this.syncUnionConverter.buttonAuthToRelation(buttonAuth, conversionProduct);
            }
        }
        if (HussarUtils.isNotEmpty(list2)) {
            for (SysAppVisitFormAuthorizeRoles formAuth : list2) {
                this.syncUnionConverter.dataAuthToRoleDataRight(formAuth, conversionProduct);
            }
        }
        this.saveConversionProduct(conversionProduct);
        Long l = System.currentTimeMillis();
        LOGGER.info("\u540c\u6b65\u6240\u9700\u65f6\u95f4\uff1a{}", (Object)(l - startTime));
    }

    public Long getAppRoleGroupId(Long appId) {
        SysRoleGroup appRoleGroup = this.getAppRoleGroup(appId);
        if (!HussarUtils.isNull((Object)appRoleGroup)) {
            return appRoleGroup.getId();
        }
        return null;
    }

    private SysRoleGroup getAppRoleGroup(Long appId) {
        return this.rolesExternalService.getRoleGroupByAppId(appId);
    }

    private void saveConversionProduct(ConversionProduct conversionProduct) {
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionModulesList())) {
            this.functionModulesBoService.saveAll(conversionProduct.getFunctionModulesList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getResourceModulesList())) {
            this.resourceMosulesBoService.saveResourceModules(conversionProduct.getResourceModulesList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionList())) {
            this.functionsBoService.saveAllFunctions(conversionProduct.getFunctionList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getResourceList())) {
            this.hussarBaseResourceService.saveBatchResource(conversionProduct.getResourceList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getFunctionResourceList())) {
            this.functionResourcesBoService.saveAllFunRes(conversionProduct.getFunctionResourceList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleFunctionList())) {
            this.rolesExternalService.saveAllRoleFun(conversionProduct.getRoleFunctionList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleResourceList())) {
            HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
            this.rolesExternalService.saveAllRoleRes(conversionProduct.getRoleResourceList());
        }
        if (HussarUtils.isNotEmpty(conversionProduct.getRoleDataRightList())) {
            this.rolesExternalService.saveAllRoleRight(conversionProduct.getRoleDataRightList());
        }
    }

    private boolean ordinaryOrFlow(SysForm form) {
        String formType = form.getFormType();
        return "0".equals(formType) || "1".equals(formType);
    }
}

