/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.service.INoCodeAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.SysAppVisitFormAuthorizeRolesDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FormRoleVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitFormAuthorizeRolesServiceImpl")
public class SysAppVisitFormAuthorizeRolesServiceImpl
extends HussarServiceImpl<SysAppVisitFormAuthorizeRolesMapper, SysAppVisitFormAuthorizeRoles>
implements ISysAppVisitFormAuthorizeRolesService {
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper appVisitFormAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper sysAppVisitRoleButtonMapper;
    @Autowired
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private SysUpAppVisitRoleFieldMapper sysUpAppVisitRoleFieldMapper;
    @Autowired
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysAppVisitRoleOrganDataAuthorityMapper roleOrganDataAuthorityMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Resource
    private ISysRolesExternalService sysRolesService;
    @Resource
    private IHussarBaseUserBoService userRoleService;
    @Resource
    private INoCodeAppDevelopTeamService noCodeAppDevelopTeamService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IPermissionService permissionService;

    @HussarTransactional
    public ApiResponse<Boolean> addFormAuthorizeRoles(SysAppVisitFormAuthorizeRolesDto sysAppVisitFormAuthorizeRolesDto) {
        ArrayList<SysAppVisitFormAuthorizeRoles> rolesList = new ArrayList<SysAppVisitFormAuthorizeRoles>();
        for (int i = 0; i < sysAppVisitFormAuthorizeRolesDto.getRoleIdList().size(); ++i) {
            this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)sysAppVisitFormAuthorizeRolesDto.getFormId())).eq(SysAppVisitFormAuthorizeRoles::getRoleId, sysAppVisitFormAuthorizeRolesDto.getRoleIdList().get(i)));
            SysAppVisitFormAuthorizeRoles authorizeRoles = new SysAppVisitFormAuthorizeRoles();
            BeanUtils.copyProperties((Object)sysAppVisitFormAuthorizeRolesDto, (Object)authorizeRoles);
            authorizeRoles.setRoleId((Long)sysAppVisitFormAuthorizeRolesDto.getRoleIdList().get(i));
            rolesList.add(authorizeRoles);
        }
        boolean flag = this.saveBatch(rolesList);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteFormAuthorizeRoles(List<Long> formRoleId) {
        this.deleteFormOtherAuthorityInfo(formRoleId);
        return ApiResponse.success((Object)this.removeByIds(formRoleId));
    }

    private void deleteFormOtherAuthorityInfo(List<Long> formRoleId) {
        List sysAppVisitFormAuthorizeRoles = this.appVisitFormAuthorizeRolesMapper.selectBatchIds(formRoleId);
        Long formId = ((SysAppVisitFormAuthorizeRoles)sysAppVisitFormAuthorizeRoles.get(0)).getFormId();
        List roleIds = sysAppVisitFormAuthorizeRoles.stream().map(SysAppVisitFormAuthorizeRoles::getRoleId).collect(Collectors.toList());
        this.roleButtonMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId)).in(SysAppVisitRoleButton::getRoleId, roleIds));
        this.sysUpAppVisitRoleFieldMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId)).in(SysUpAppVisitRoleField::getRoleId, roleIds));
        this.roleOrganDataAuthorityMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).in(SysAppVisitRoleOrganDataAuthority::getRoleId, roleIds));
        List sysAppVisitDataLogics = this.dataLogicMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).in(SysAppVisitDataLogic::getRoleId, roleIds));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogics)) {
            List logicIds = sysAppVisitDataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicMapper.deleteBatchIds(logicIds);
            this.dataLogicFilterMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, logicIds));
        }
    }

    public ApiResponse<List<FormRoleVo>> getFormAuthorizeRolesList(Long appId, Long formId) {
        List<FormRoleVo> formRoleList = this.appVisitFormAuthorizeRolesMapper.getFormAuthorizeRolesList(appId, formId);
        if (HussarUtils.isNotEmpty(formRoleList)) {
            List roleIds = formRoleList.stream().map(FormRoleVo::getRoleId).collect(Collectors.toList());
            List list = this.sysRolesService.getRolesByIds(roleIds);
            Map<Long, SysRoles> map = list.stream().collect(Collectors.toMap(SysRoles::getId, r -> r));
            formRoleList.forEach(r -> {
                SysRoles role = (SysRoles)map.get(r.getRoleId());
                if (HussarUtils.isNotEmpty((Object)role)) {
                    r.setName(role.getRoleName());
                }
            });
        }
        return ApiResponse.success(formRoleList);
    }

    public ApiResponse<List<Long>> getAuthorityFormList(Long appId) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysApplicationVo app = this.applicationService.getAppDetailById(appId);
        boolean isInDevelopTeam = this.noCodeAppDevelopTeamService.checkCurrentUserInTeam(appId);
        if (securityUser.isSuperAdmin() || securityUser.getId().equals(app.getCreator()) || isInDevelopTeam || securityUser.getRolesList().contains(TenantConstant.ADMIN_ROLE)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId);
            List sysForms = this.sysFormService.list((Wrapper)queryWrapper);
            List sysFormIds = sysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            return ApiResponse.success(sysFormIds);
        }
        if (HussarUtils.isNotEmpty((Object)securityUser.getRolesList())) {
            return ApiResponse.success((Object)this.permissionService.getAuthorityFormList(securityUser.getRolesList(), appId));
        }
        return ApiResponse.success(new ArrayList());
    }

    public ApiResponse<List<Long>> getAuthFormListByUserId(Long userId, Long appId) {
        boolean isSuperAdmin;
        List userRoles = this.userRoleService.listUserRolesByUserId(userId);
        List<Long> roleIds = userRoles.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
        boolean bl = isSuperAdmin = HussarUtils.isNotEmpty(roleIds) && roleIds.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue());
        if (HussarUtils.isEmpty(roleIds)) {
            return ApiResponse.success(new ArrayList());
        }
        if (isSuperAdmin) {
            return ApiResponse.success(this.appVisitFormAuthorizeRolesMapper.getAuthorityFormListAll(appId));
        }
        return ApiResponse.success(this.appVisitFormAuthorizeRolesMapper.getAuthorityFormList(roleIds, appId));
    }

    @HussarTransactional
    public ApiResponse<Boolean> roleCancel(SysAppVisitFormAuthorizeRolesDto formAuthorizeRolesDto) {
        if (HussarUtils.isNotEmpty((Object)formAuthorizeRolesDto.getFormId()) && HussarUtils.isNotEmpty((Object)formAuthorizeRolesDto.getRoleId())) {
            Long formId = formAuthorizeRolesDto.getFormId();
            Long roleId = formAuthorizeRolesDto.getRoleId();
            this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId)).eq(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId));
            this.sysAppVisitRoleButtonMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId)).eq(SysAppVisitRoleButton::getRoleId, (Object)roleId));
            this.roleOrganDataAuthorityService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId)).eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
            this.sysUpAppVisitRoleFieldMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId)).eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId));
            this.sysAppVisitDataLogicService.dataLogicAuthorityCancel(formId, roleId);
            return ApiResponse.success((Object)Boolean.TRUE);
        }
        throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
    }

    public ApiResponse<Boolean> checkRolePermissions(Long formId) {
        UserDetails userDetails;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            return ApiResponse.success((Object)true);
        }
        boolean isTenantAdmin = false;
        if (HussarUtils.isNotEmpty((Object)user.getRolesList())) {
            isTenantAdmin = user.getRolesList().contains(TenantConstant.ADMIN_ROLE);
        }
        if (user.isSuperAdmin() || isTenantAdmin) {
            return ApiResponse.success((Object)true);
        }
        SysForm form = this.applicationService.getFormDetailById(formId);
        if (HussarUtils.isEmpty((Object)form)) {
            return ApiResponse.success((Object)false);
        }
        SysApplicationVo app = this.applicationService.getAppDetailById(form.getAppId());
        if (HussarUtils.isEmpty((Object)app)) {
            return ApiResponse.success((Object)false);
        }
        if (user.getId().equals(app.getCreator())) {
            return ApiResponse.success((Object)true);
        }
        LambdaQueryWrapper formWrapper = Wrappers.lambdaQuery();
        formWrapper.eq(HussarUtils.isNotEmpty((Object)formId), SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId);
        List sysAppVisitFormAuthorizeRoles = this.appVisitFormAuthorizeRolesMapper.selectList((Wrapper)formWrapper);
        if (HussarUtils.isEmpty((Object)sysAppVisitFormAuthorizeRoles)) {
            return ApiResponse.success((Object)false);
        }
        HashSet<Long> authorizeRoleIds = new HashSet<Long>();
        if (HussarUtils.isNotEmpty((Object)sysAppVisitFormAuthorizeRoles)) {
            for (SysAppVisitFormAuthorizeRoles sysAppVisitFormAuthorizeRole : sysAppVisitFormAuthorizeRoles) {
                authorizeRoleIds.add(sysAppVisitFormAuthorizeRole.getRoleId());
            }
        }
        if ((userDetails = HussarSecurityUtils.getLoginUserDetails()) == null) {
            userDetails = (UserDetails)TransmittableThreadLocalHolder.get((String)"loginUserDetails");
        }
        Map extendUserMap = userDetails.getExtendUserMap();
        ArrayList roleIds = new ArrayList();
        Object rolesList = extendUserMap.get("rolesList");
        List longs = JSONArray.parseArray((String)JSON.toJSONString(rolesList), Long.class);
        if (HussarUtils.isNotEmpty(rolesList)) {
            roleIds.addAll(longs);
        }
        roleIds.retainAll(authorizeRoleIds);
        return ApiResponse.success((Object)(!roleIds.isEmpty() ? 1 : 0));
    }

    public Map<Long, List<SysAppVisitFormAuthorizeRoles>> listFormAuthorizedByAppId(Long appId, Long roleId) {
        List formAuthorizeRolesList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId)).eq(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId));
        return formAuthorizeRolesList.stream().collect(Collectors.groupingBy(SysAppVisitFormAuthorizeRoles::getFormId));
    }

    public List<SysAppVisitFormAuthorizeRoles> listAppVisitFormAuthorizeRoles(Long appId, Long formId, Long roleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId)).eq(HussarUtils.isNotEmpty((Object)formId), SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId)).eq(HussarUtils.isNotEmpty((Object)roleId), SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId)).orderByAsc(HussarBaseEntity::getCreateTime);
        return this.list((Wrapper)queryWrapper);
    }

    public boolean checkFormAuthority(String formId) {
        SecurityUser user = NoCodeSecurityUtil.getUser();
        boolean isTenantAdmin = false;
        if (HussarUtils.isNotEmpty((Object)user.getRolesList())) {
            isTenantAdmin = user.getRolesList().contains(TenantConstant.ADMIN_ROLE);
        }
        if (user.isSuperAdmin() || isTenantAdmin) {
            return true;
        }
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)((Object)formId));
        Long appId = sysForm.getAppId();
        SysApplicationVo sysApplication = this.applicationService.getAppDetailById(appId);
        Long developRoleId = sysApplication.getDevelopRoleId();
        List rolesList = user.getRolesList();
        if (rolesList.contains(developRoleId)) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            List sysAppVisitFormAuthorizeRoles = this.appVisitFormAuthorizeRolesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId)).in(SysAppVisitFormAuthorizeRoles::getRoleId, (Collection)rolesList));
            return HussarUtils.isNotEmpty((Object)sysAppVisitFormAuthorizeRoles);
        }
        return false;
    }
}

