/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppExportRecordMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.SysAppRecordDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppExportRecord;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppExportRecordService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppExportRecordVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.sysAppExportRecordServiceImpl")
public class SysAppExportRecordServiceImpl
extends HussarServiceImpl<SysAppExportRecordMapper, SysAppExportRecord>
implements ISysAppExportRecordService {
    @Resource
    private SysAppExportRecordMapper sysAppExportRecordMapper;
    @Resource
    private AppFileExtendService appFileExtendService;

    public IPage<SysAppExportRecordVo> selectRecordList(SysAppRecordDto sysAppRecordDto) {
        Page page = new Page(sysAppRecordDto.getCurrent(), sysAppRecordDto.getSize());
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)securityUser)) {
            throw new BaseException("\u83b7\u53d6\u767b\u5f55\u6388\u6743\u7528\u6237\u5931\u8d25");
        }
        boolean superAdmin = securityUser.isSuperAdmin() || securityUser.getRolesList().contains(TenantConstant.ADMIN_ROLE);
        return this.sysAppExportRecordMapper.selectRecordList((Page<SysAppExportRecordVo>)page, sysAppRecordDto.getName(), sysAppRecordDto.getType(), superAdmin ? null : securityUser.getId());
    }

    public void deleteExportRecord(Long recordId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppExportRecord::getRecordId, (Object)recordId);
        Long exportFileId = ((SysAppExportRecord)((SysAppExportRecordMapper)this.baseMapper).selectOne((Wrapper)wrapper)).getExportFileId();
        this.appFileExtendService.fileDelete(exportFileId);
        ((SysAppExportRecordMapper)this.baseMapper).deleteById(recordId);
    }
}

