/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.property.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.formdesign.application.property.dao.ScriptRecordMapper;
import com.jxdinfo.hussar.formdesign.application.property.dto.ScriptBaseAssemble;
import com.jxdinfo.hussar.formdesign.application.property.dto.ScriptManifest;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptGroup;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptMethod;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptMethodRelated;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptParam;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptRecord;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptGroupService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptMethodService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptParamService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRelatedService;
import com.jxdinfo.hussar.formdesign.application.property.util.JsScriptParser;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptGroupPlatVO;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptGroupVO;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptMethodConstruct;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptPreviewVO;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptTreeVO;
import com.jxdinfo.hussar.formdesign.application.tool.SnowflakeID;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class ScriptRecordServiceImpl
extends HussarServiceImpl<ScriptRecordMapper, ScriptRecord>
implements ScriptRecordService {
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ScriptMethodService scriptMethodService;
    @Resource
    private ScriptParamService scriptParamService;
    @Resource
    private ScriptRecordMapper scriptRecordMapper;
    @Resource
    private ScriptGroupService scriptGroupService;
    @Resource
    private ScriptRelatedService scriptRelatedService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private SnowflakeID snowflakeID;
    private static final String SCRIPT_CACHE_NAME = "extend_script";
    private static final String SCRIPT_CARD_KEY = "listGlobalCard";
    private static final String SCRIPT_FORM_KEY = "listInFormPlat";

    public static void evictCache(String formId) {
        if (ObjectUtils.isNotEmpty((Object)formId)) {
            HussarCacheUtil.evict((String)SCRIPT_CACHE_NAME, (Object)String.format("%s_%s_%s", SCRIPT_CACHE_NAME, SCRIPT_FORM_KEY, formId));
        } else {
            HussarCacheUtil.evict((String)SCRIPT_CACHE_NAME, (Object)String.format("%s_%s", SCRIPT_CACHE_NAME, SCRIPT_CARD_KEY));
        }
    }

    private static <T> T getCache() {
        return (T)HussarCacheUtil.get((String)SCRIPT_CACHE_NAME, (Object)String.format("%s_%s", SCRIPT_CACHE_NAME, SCRIPT_CARD_KEY));
    }

    private static <T> T getCache(String formId) {
        return (T)HussarCacheUtil.get((String)SCRIPT_CACHE_NAME, (Object)String.format("%s_%s_%s", SCRIPT_CACHE_NAME, SCRIPT_FORM_KEY, formId));
    }

    private void putCache(Object o) {
        HussarCacheUtil.put((String)SCRIPT_CACHE_NAME, (Object)String.format("%s_%s", SCRIPT_CACHE_NAME, SCRIPT_CARD_KEY), (Object)o);
    }

    private void putCache(String formId, Object o) {
        HussarCacheUtil.put((String)SCRIPT_CACHE_NAME, (Object)String.format("%s_%s_%s", SCRIPT_CACHE_NAME, SCRIPT_FORM_KEY, formId), (Object)o);
    }

    public ApiResponse<Integer> check(long fileId, String groupId, String formId, String scriptType) {
        ScriptZipMeta scriptZp;
        try {
            scriptZp = this.parseScriptZp(fileId);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        if (scriptType != null && !scriptType.isEmpty() && !scriptType.equals(scriptZp.getManifest().getType())) {
            return ApiResponse.success((int)10000, (Object)4, (String)"\u5bfc\u5165\u811a\u672c\u7c7b\u578b\u6709\u8bef");
        }
        if (ObjectUtils.isNotEmpty((Object)groupId)) {
            if (!this.ifOnly(scriptZp.getScriptName(), ScriptRecord::getFormId)) {
                return ApiResponse.success((int)10000, (Object)3, (String)"\u5e94\u7528\u4e0b\u5b58\u5728\u540c\u540d\u811a\u672c\uff0c\u8bf7\u4fee\u6539\u811a\u672c\u540d\u540e\u518d\u5bfc\u5165");
            }
            if (!this.ifOnly(scriptZp.getScriptName(), ScriptRecord::getGroupId)) {
                return ApiResponse.success((int)10000, (Object)2, (String)"\u5f53\u524d\u9875\u9762\u5b58\u5728\u540c\u540d\u811a\u672c\uff0c\u662f\u5426\u8986\u76d6");
            }
        }
        if (ObjectUtils.isNotEmpty((Object)formId)) {
            if (!this.ifOnlyNe(scriptZp.getScriptName(), formId)) {
                return ApiResponse.success((int)10000, (Object)3, (String)"\u5168\u5c40\u5b58\u5728\u540c\u540d\u811a\u672c\uff0c\u8bf7\u4fee\u6539\u811a\u672c\u540d\u540e\u518d\u5bfc\u5165");
            }
            if (!this.ifOnly(scriptZp.getScriptName(), formId)) {
                return ApiResponse.success((int)10000, (Object)2, (String)"\u5f53\u524d\u9875\u9762\u5b58\u5728\u540c\u540d\u811a\u672c\uff0c\u662f\u5426\u8986\u76d6");
            }
        }
        return ApiResponse.success((int)10000, (Object)1, (String)"");
    }

    @HussarTransactional
    public ApiResponse<Boolean> scriptImport(long fileId, String groupId, String formId) throws IOException {
        ApiResponse<Boolean> apiResponse;
        ScriptZipMeta scriptZp;
        if (ObjectUtils.isEmpty((Object)formId) && ObjectUtils.isEmpty((Object)groupId)) {
            return ApiResponse.fail((String)"\u8bf7\u4f20\u5206\u7ec4\u6216\u8005\u8868\u5355id");
        }
        String unzipFilePath = null;
        this.snowflakeID.init();
        try {
            scriptZp = this.parseScriptZp(fileId);
        }
        catch (Exception e) {
            ApiResponse apiResponse2 = ApiResponse.fail((String)e.getMessage());
            if (ObjectUtils.isNotEmpty(unzipFilePath) && new File(unzipFilePath).exists()) {
                FileUtils.forceDelete((File)new File(unzipFilePath));
            }
            return apiResponse2;
        }
        try {
            ScriptBaseAssemble scriptBaseAssemble = this.importScript(scriptZp, groupId, formId, fileId);
            unzipFilePath = scriptZp.getUnzipFilePath();
            ApiResponse<Boolean> imported = this.importMethods(scriptZp.getScriptBase().getMethods(), scriptBaseAssemble, new HashMap<String, String>());
            ScriptRecordServiceImpl.evictCache(formId);
            apiResponse = imported;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (ObjectUtils.isNotEmpty(unzipFilePath) && new File(unzipFilePath).exists()) {
                    FileUtils.forceDelete((File)new File(unzipFilePath));
                }
                throw throwable;
            }
        }
        if (ObjectUtils.isNotEmpty((Object)unzipFilePath) && new File(unzipFilePath).exists()) {
            FileUtils.forceDelete((File)new File(unzipFilePath));
        }
        return apiResponse;
    }

    private boolean ifOnly(String scriptName, SFunction<ScriptRecord, ?> column) {
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)checkWrapper.eq(ScriptRecord::getName, (Object)scriptName)).isNotNull(column);
        long checkRecordCount = this.count((Wrapper)checkWrapper);
        return checkRecordCount <= 0L;
    }

    private boolean ifOnly(String scriptName, String formId) {
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)checkWrapper.eq(ScriptRecord::getName, (Object)scriptName)).eq(ScriptRecord::getFormId, (Object)formId);
        long checkRecordCount = this.count((Wrapper)checkWrapper);
        return checkRecordCount <= 0L;
    }

    private boolean ifOnlyNe(String scriptName, String formId) {
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)checkWrapper.eq(ScriptRecord::getName, (Object)scriptName)).isNotNull(ScriptRecord::getGroupId);
        long checkRecordCount = this.count((Wrapper)checkWrapper);
        return checkRecordCount <= 0L;
    }

    public ApiResponse<List<ScriptGroupVO>> listGlobalCard(String scriptName) {
        ArrayList<ScriptGroupVO> groupVOS = new ArrayList<ScriptGroupVO>();
        LambdaQueryWrapper groupQueryWrapper = new LambdaQueryWrapper();
        groupQueryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List scriptGroups = this.scriptGroupService.list((Wrapper)groupQueryWrapper);
        if (ObjectUtils.isEmpty((Object)scriptGroups)) {
            return ApiResponse.success(new ArrayList());
        }
        List<ScriptBase> scriptBases = this.scriptFilterLike(scriptGroups.stream().map(scriptGroup -> String.valueOf(scriptGroup.getGroupId())).collect(Collectors.toList()), scriptName, true);
        for (ScriptGroup scriptGroup2 : scriptGroups) {
            ScriptGroupVO scriptGroupVO = new ScriptGroupVO();
            scriptGroupVO.setGroupId(scriptGroup2.getGroupId());
            scriptGroupVO.setGroupType(scriptGroup2.getGroupType());
            scriptGroupVO.setGroupName(scriptGroup2.getGroupName());
            groupVOS.add(scriptGroupVO);
        }
        for (ScriptGroupVO scriptGroupVO : groupVOS) {
            ArrayList<ScriptBase> childScript = new ArrayList<ScriptBase>();
            for (ScriptBase scriptBase : scriptBases) {
                if (ObjectUtils.isEmpty((Object)scriptBase.getGroupId()) || !scriptBase.getGroupId().equals(scriptGroupVO.getGroupId())) continue;
                scriptBase.setDesc(scriptBase.getDescription());
                childScript.add(scriptBase);
            }
            scriptGroupVO.setScripts(childScript);
        }
        return ApiResponse.success(groupVOS);
    }

    public ApiResponse<Page<ScriptGroupPlatVO>> listGlobalPage(String scriptName, String groupId, PageInfo pageInfo) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<ScriptGroupPlatVO> scriptGroupPlatVOS = this.scriptRecordMapper.listGlobalPage((Page<ScriptGroupPlatVO>)page, scriptName, ObjectUtils.isNotEmpty((Object)groupId) ? Long.parseLong(groupId) : 0L);
        if (ObjectUtils.isNotEmpty(scriptGroupPlatVOS)) {
            scriptGroupPlatVOS.forEach(scriptGroupPlatVO -> scriptGroupPlatVO.setDesc(scriptGroupPlatVO.getDescription()));
        }
        page.setRecords(scriptGroupPlatVOS);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<ScriptTreeVO> listInForm(String scriptName, String formId) {
        ApiResponse<List<ScriptGroupVO>> globalCard = this.listGlobalCard(scriptName);
        List<ScriptBase> scriptBases = this.scriptFilterLike(Collections.singletonList(formId), scriptName, false);
        if (ObjectUtils.isNotEmpty(scriptBases)) {
            scriptBases.forEach(scriptBase -> scriptBase.setDesc(scriptBase.getDescription()));
        }
        ScriptTreeVO scriptTree = new ScriptTreeVO();
        scriptTree.setForm(scriptBases);
        scriptTree.setGlobal((List)globalCard.getData());
        return ApiResponse.success((Object)scriptTree);
    }

    public ApiResponse<List<ScriptBase>> listInFormPlat(String scriptName, String formId) {
        ApiResponse<List<ScriptGroupVO>> globalCard = this.listGlobalCard(scriptName);
        ArrayList scripts = new ArrayList();
        ((List)globalCard.getData()).forEach(card -> {
            if (ObjectUtils.isNotEmpty((Object)card.getScripts())) {
                card.getScripts().forEach(scriptBase -> scriptBase.setGroupName(card.getGroupName()));
                scripts.addAll(card.getScripts());
            }
        });
        List<ScriptBase> scriptBases = this.scriptFilterLike(Collections.singletonList(formId), scriptName, false);
        if (ObjectUtils.isEmpty(scriptBases)) {
            scriptBases = new ArrayList<ScriptBase>();
        }
        scriptBases.addAll(scripts);
        scriptBases.forEach(scriptBase -> scriptBase.setDesc(scriptBase.getDescription()));
        return ApiResponse.success(scriptBases);
    }

    public void scriptDownload(long fileId, HttpServletResponse response) {
        this.attachmentManagerService.fileDownload(response, Long.valueOf(fileId));
    }

    @HussarTransactional
    public ApiResponse<Boolean> scriptDelete(long scriptId) throws IOException {
        String unzipPath;
        ScriptRecord scriptRecord = (ScriptRecord)this.getById(Long.valueOf(scriptId));
        if (ObjectUtils.isEmpty((Object)scriptRecord)) {
            return ApiResponse.success((Object)true);
        }
        this.removeById(Long.valueOf(scriptId));
        LambdaQueryWrapper methodWrapper = new LambdaQueryWrapper();
        methodWrapper.eq(ScriptMethod::getScriptId, (Object)scriptId);
        List scriptMethods = this.scriptMethodService.list((Wrapper)methodWrapper);
        if (ObjectUtils.isNotEmpty((Object)scriptMethods)) {
            List methodIds = scriptMethods.stream().map(ScriptMethod::getId).collect(Collectors.toList());
            this.scriptMethodService.remove((Wrapper)methodWrapper);
            LambdaQueryWrapper paramWrapper = new LambdaQueryWrapper();
            paramWrapper.in(ScriptParam::getMethodId, methodIds);
            this.scriptParamService.remove((Wrapper)paramWrapper);
            LambdaQueryWrapper relateWrapper = new LambdaQueryWrapper();
            relateWrapper.in(ScriptMethodRelated::getMethodId, methodIds);
            this.scriptRelatedService.remove((Wrapper)relateWrapper);
        }
        if (new File(unzipPath = this.cutSuffix(scriptRecord.getName())).exists()) {
            FileUtils.forceDelete((File)new File(unzipPath));
        }
        ScriptRecordServiceImpl.evictCache(scriptRecord.getFormId());
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> relateAdd(String relatedPath, long methodId) {
        ScriptMethod method = (ScriptMethod)this.scriptMethodService.getById((Serializable)Long.valueOf(methodId));
        ScriptRecord scriptRecord = (ScriptRecord)this.getById(method.getScriptId());
        if (ObjectUtils.isEmpty((Object)scriptRecord)) {
            return ApiResponse.fail((String)("\u811a\u672c\uff1a" + method.getDescription() + "\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        if (ObjectUtils.isEmpty((Object)method)) {
            return ApiResponse.fail((String)("\u65b9\u6cd5\uff1a" + methodId + "\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        boolean save = this.scriptRelatedService.save((Object)new ScriptMethodRelated.Builder().withMethodId(Long.valueOf(methodId)).withRelatedPath(relatedPath).build());
        ScriptRecordServiceImpl.evictCache(scriptRecord.getFormId());
        return ApiResponse.success((Object)save);
    }

    public ApiResponse<ScriptPreviewVO> script(String scriptName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ScriptRecord::getName, (Object)scriptName);
        ScriptRecord scriptRecord = (ScriptRecord)this.getOne((Wrapper)wrapper);
        if (ObjectUtils.isEmpty((Object)scriptRecord)) {
            return ApiResponse.fail((String)String.format("\u811a\u672c\uff1a%s \u8bb0\u5f55\u4e0d\u5b58\u5728", scriptName));
        }
        return ApiResponse.success((Object)new ScriptPreviewVO.Builder().withCode(scriptRecord.getEditorNote()).withName(scriptRecord.getName()).build(), (String)"");
    }

    public void showImage(String scriptName, String fileName, HttpServletResponse response) {
        String logoPath = FileUtil.posixPath((String[])new String[]{this.unzipPath(this.cutSuffix(scriptName)), "assets", fileName});
        this.writeImage(logoPath, response, () -> true);
    }

    public void logoTemp(long fileId, HttpServletResponse response) {
        JSONObject logoJson;
        ScriptZipMeta scriptZipMeta = this.parseScriptZp(fileId);
        String logo = scriptZipMeta.getManifest().getLogo();
        if (ObjectUtils.isEmpty((Object)logo)) {
            throw new BaseException("\u8bfb\u53d6\u56fe\u6807\u5931\u8d25\uff0cmanifest\u6587\u4ef6\u4e2d\u672a\u5b9a\u4e49\u56fe\u6807\u8def\u5f84");
        }
        try {
            logoJson = JSONObject.parseObject((String)logo);
        }
        catch (Exception e) {
            throw new BaseException("\u8bfb\u53d6\u56fe\u6807\u5931\u8d25\uff0cmanifest\u6587\u4ef6\u4e2d\u56fe\u6807\u8def\u5f84\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String logoPath = logoJson.getString("data");
        if (logoPath.startsWith(".")) {
            logoPath = logoPath.substring(1);
        }
        String logoAb = FileUtil.posixPath((String[])new String[]{scriptZipMeta.getUnzipFilePath(), logoPath});
        this.writeImage(logoAb, response, () -> {
            File unzipFile = new File(scriptZipMeta.getUnzipFilePath());
            if (unzipFile.exists()) {
                try {
                    FileUtils.deleteDirectory((File)unzipFile);
                }
                catch (IOException e) {
                    throw new BaseException("\u5220\u9664\u4e34\u65f6\u89e3\u538b\u6587\u4ef6\u5931\u8d25");
                }
            }
            return true;
        });
    }

    public ApiResponse<List<ScriptBase>> debug(List<ScriptManifest> manifests) {
        ArrayList scriptBases = new ArrayList();
        if (ObjectUtils.isEmpty(manifests)) {
            return null;
        }
        manifests.forEach(manifest -> {
            ScriptBase scriptBase = JsScriptParser.parseScript(manifest.getCode());
            scriptBase.setName(manifest.getName());
            scriptBases.add(scriptBase);
        });
        return ApiResponse.success(scriptBases);
    }

    private List<ScriptBase> scriptBases(LambdaQueryWrapper<ScriptRecord> recordWrapper) {
        ArrayList<ScriptBase> scriptBases = new ArrayList<ScriptBase>();
        List scriptRecords = this.list((Wrapper)recordWrapper);
        if (ObjectUtils.isEmpty((Object)scriptRecords)) {
            return new ArrayList<ScriptBase>();
        }
        for (ScriptRecord scriptRecord : scriptRecords) {
            ScriptBase scriptBase = new ScriptBase();
            BeanUtil.copyProperties((Object)scriptRecord, (Object)scriptBase);
            scriptBases.add(scriptBase);
        }
        ArrayList<ScriptMethodConstruct> scriptMethodConstructs = new ArrayList<ScriptMethodConstruct>();
        LambdaQueryWrapper methodWrapper = new LambdaQueryWrapper();
        methodWrapper.in(ScriptMethod::getScriptId, (Collection)scriptRecords.stream().map(ScriptRecord::getId).collect(Collectors.toList()));
        List scriptMethods = this.scriptMethodService.list((Wrapper)methodWrapper);
        if (ObjectUtils.isNotEmpty((Object)scriptMethods)) {
            for (ScriptMethod scriptMethod : scriptMethods) {
                ScriptMethodConstruct methodConstruct = new ScriptMethodConstruct();
                BeanUtil.copyProperties((Object)scriptMethod, (Object)methodConstruct);
                scriptMethodConstructs.add(methodConstruct);
            }
            LambdaQueryWrapper paramWrapper = new LambdaQueryWrapper();
            List methodIds = scriptMethods.stream().map(ScriptMethod::getId).collect(Collectors.toList());
            paramWrapper.in(ScriptParam::getMethodId, methodIds);
            List scriptParams = this.scriptParamService.list((Wrapper)paramWrapper);
            LambdaQueryWrapper relateWrapper = new LambdaQueryWrapper();
            relateWrapper.in(ScriptMethodRelated::getMethodId, methodIds);
            List scriptMethodRelateds = this.scriptRelatedService.list((Wrapper)relateWrapper);
            for (ScriptMethodConstruct scriptMethodConstruct : scriptMethodConstructs) {
                ArrayList<ScriptParam> childParams = new ArrayList<ScriptParam>();
                ArrayList<ScriptMethodRelated> childrelateds = new ArrayList<ScriptMethodRelated>();
                if (ObjectUtils.isNotEmpty((Object)scriptParams)) {
                    for (ScriptParam scriptParam : scriptParams) {
                        if (!scriptParam.getMethodId().equals(scriptMethodConstruct.getId())) continue;
                        if ("1".equals(scriptParam.getParamType())) {
                            scriptMethodConstruct.setReturnValue(scriptParam);
                            continue;
                        }
                        childParams.add(scriptParam);
                    }
                }
                if (ObjectUtils.isNotEmpty((Object)scriptMethodRelateds)) {
                    for (ScriptMethodRelated scriptMethodRelated : scriptMethodRelateds) {
                        if (!scriptMethodRelated.getMethodId().equals(scriptMethodConstruct.getId())) continue;
                        childrelateds.add(scriptMethodRelated);
                    }
                }
                scriptMethodConstruct.setParams(childParams);
                scriptMethodConstruct.setRelated(childrelateds);
            }
            for (ScriptBase scriptBase : scriptBases) {
                ArrayList<ScriptMethodConstruct> methodConstructs = new ArrayList<ScriptMethodConstruct>();
                for (ScriptMethodConstruct scriptMethodConstruct : scriptMethodConstructs) {
                    if (!scriptMethodConstruct.getScriptId().equals(scriptBase.getId())) continue;
                    methodConstructs.add(scriptMethodConstruct);
                }
                scriptBase.setMethods(methodConstructs);
            }
        }
        return scriptBases;
    }

    private List<ScriptBase> scriptFilterEqId(Long scriptId) {
        LambdaQueryWrapper recordWrapper = new LambdaQueryWrapper();
        recordWrapper.eq(ScriptRecord::getId, (Object)scriptId);
        return this.scriptBases((LambdaQueryWrapper<ScriptRecord>)recordWrapper);
    }

    private List<ScriptBase> scriptFilterEq(List<String> conditions, String eq, boolean global) {
        LambdaQueryWrapper recordWrapper = new LambdaQueryWrapper();
        if (global) {
            recordWrapper.in(ScriptRecord::getGroupId, conditions);
        } else {
            recordWrapper.in(ScriptRecord::getFormId, conditions);
        }
        if (ObjectUtils.isNotEmpty((Object)eq)) {
            recordWrapper.eq(ScriptRecord::getName, (Object)eq);
        }
        return this.scriptBases((LambdaQueryWrapper<ScriptRecord>)recordWrapper);
    }

    private List<ScriptBase> scriptFilterLike(List<String> conditions, String like, boolean global) {
        LambdaQueryWrapper recordWrapper = new LambdaQueryWrapper();
        if (global) {
            recordWrapper.in(ScriptRecord::getGroupId, conditions);
        } else {
            recordWrapper.in(ScriptRecord::getFormId, conditions);
        }
        if (ObjectUtils.isNotEmpty((Object)like)) {
            recordWrapper.like(ScriptRecord::getDescription, (Object)like);
        }
        return this.scriptBases((LambdaQueryWrapper<ScriptRecord>)recordWrapper);
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private String unzipPath(String scriptName) {
        String backProjectPath = this.formDesignProperties.getBackProjectPath();
        String noCodeStore = this.formDesignProperties.getNoCodeStore();
        String expWidgetFIleName = SCRIPT_CACHE_NAME;
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), backProjectPath, noCodeStore, expWidgetFIleName, scriptName});
    }

    private String cutSuffix(String scriptName) {
        if (scriptName.endsWith(".js")) {
            scriptName = scriptName.substring(0, scriptName.indexOf(".js"));
        }
        if (scriptName.endsWith(".css")) {
            scriptName = scriptName.substring(0, scriptName.indexOf(".css"));
        }
        return scriptName;
    }

    private ScriptZipMeta parseScriptZp(long fileId) {
        ScriptBase scriptBase;
        String js;
        String tempUnzipFilePath;
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)Long.valueOf(fileId));
        Long attachmentSize = attachmentModel.getAttachmentSize();
        if (attachmentSize > 0x200000L) {
            throw new BaseException("\u4e0a\u4f20\u9644\u4ef6\u4e0d\u80fd\u8d85\u8fc72M\uff01");
        }
        if (ObjectUtils.isEmpty((Object)attachmentModel)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u4e0a\u4f20\u7684\u811a\u672c\u538b\u7f29\u6587\u4ef6");
        }
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String attachmentZipPath = FileUtil.systemPath((String[])new String[]{attachmentModel.getAttachmentDir(), fileId + suffix});
        String attachmentPath = FileUtil.systemPath((String[])new String[]{attachmentModel.getAttachmentDir(), String.valueOf(fileId)});
        try {
            if (new File(attachmentPath).exists()) {
                FileUtils.forceDelete((File)new File(attachmentPath));
            }
            tempUnzipFilePath = ZipUtil.unzip((String)attachmentZipPath).getAbsolutePath();
        }
        catch (Exception e) {
            ToolUtil.getLogger(ScriptRecordServiceImpl.class).error("\u89e3\u538bzip\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BaseException("\u89e3\u538b\u811a\u672c\u538b\u7f29\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String manifestPath = FileUtil.systemPath((String[])new String[]{tempUnzipFilePath, "manifest.json"});
        if (!new File(manifestPath).exists()) {
            throw new BaseException("\u811a\u672c\u6587\u4ef6\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u8bf7\u653e\u7f6e\u6b63\u786e\u7684manifest.json\u6587\u4ef6\uff01");
        }
        ScriptManifest manifest = AppMigrateUtil.readFileToObject(manifestPath, ScriptManifest.class);
        if (ObjectUtils.isEmpty((Object)manifest) || ObjectUtils.isEmpty((Object)manifest.getName())) {
            throw new BaseException("\u811a\u672c\u6587\u4ef6\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u8bf7\u653e\u7f6e\u6b63\u786e\u7684manifest.json\u6587\u4ef6\uff01");
        }
        String scriptName = manifest.getName();
        String jsPath = FileUtil.systemPath((String[])new String[]{tempUnzipFilePath, scriptName});
        try {
            js = FileUtils.readFileToString((File)new File(jsPath), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new BaseException("\u8bfb\u53d6js\u6587\u4ef6\u5185\u5bb9\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            scriptBase = JsScriptParser.parseScript(js);
        }
        catch (Exception e) {
            throw new BaseException("js\u811a\u672c\u7ed3\u6784\u5316\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return new ScriptZipMeta(manifest, scriptBase, scriptName, js, tempUnzipFilePath, attachmentZipPath);
    }

    private ScriptBaseAssemble importScript(ScriptZipMeta scriptZp, String groupId, String formId, long fileId) throws IOException {
        String scriptName = scriptZp.getScriptName();
        String js = scriptZp.getCode();
        ScriptManifest manifest = scriptZp.getManifest();
        String uploadZipPath = scriptZp.getUploadZipPath();
        String unzipPath = this.cutSuffix(scriptName);
        LambdaQueryWrapper recordWrapper = new LambdaQueryWrapper();
        recordWrapper.eq(ScriptRecord::getName, (Object)scriptName);
        String conditions = "";
        if (ObjectUtils.isNotEmpty((Object)groupId)) {
            conditions = groupId;
            recordWrapper.isNotNull(ScriptRecord::getGroupId);
        } else if (ObjectUtils.isNotEmpty((Object)formId)) {
            conditions = formId;
            recordWrapper.eq(ScriptRecord::getFormId, (Object)formId);
        }
        ScriptRecord oldScriptRecord = (ScriptRecord)this.getOne((Wrapper)recordWrapper);
        List methodInDbs = new ArrayList();
        ScriptRecord scriptRecord = new ScriptRecord.Builder(ObjectUtils.isEmpty((Object)oldScriptRecord) ? new ScriptRecord() : oldScriptRecord).withName(scriptName).withDesc(manifest.getTitle()).withNote(manifest.getDescription()).withIcon(manifest.getLogo()).withType(manifest.getType()).withAuthor(manifest.getAuthor()).withVersion(manifest.getVersion()).withEditorNote(js).withFileId(Long.valueOf(fileId)).withGroupId(ObjectUtils.isNotEmpty((Object)groupId) ? Long.valueOf(Long.parseLong(groupId)) : null).withFormId(formId).build();
        if (ObjectUtils.isNotEmpty((Object)oldScriptRecord)) {
            List<ScriptBase> scriptBases = this.scriptFilterEqId(oldScriptRecord.getId());
            if (ObjectUtils.isEmpty(scriptBases) || scriptBases.size() > 1) {
                throw new BaseException("\u67e5\u8be2\u811a\u672c\u8bb0\u5f55\u4e3a\u7a7a\u6216\u8005\u5927\u4e8e1\u6761\uff01");
            }
            methodInDbs = scriptBases.get(0).getMethods();
            File unzipFile = new File(this.unzipPath(unzipPath));
            if (unzipFile.exists()) {
                FileUtils.deleteDirectory((File)unzipFile);
            }
        }
        ZipUtil.unzip((String)uploadZipPath, (String)this.unzipPath(unzipPath));
        this.saveOrUpdate((BaseEntity)scriptRecord);
        return new ScriptBaseAssemble(methodInDbs, scriptRecord);
    }

    public ApiResponse<Boolean> importMethods(List<ScriptMethodConstruct> methodsNew, ScriptBaseAssemble scriptBaseAssemble, Map<String, String> scriptMethodMap) {
        if (ObjectUtils.isEmpty(methodsNew)) {
            return ApiResponse.success((Object)true);
        }
        List methodInDbs = scriptBaseAssemble.getMethodInDbs();
        ScriptRecord scriptRecord = scriptBaseAssemble.getScriptRecord();
        ArrayList<ScriptMethod> addMethods = new ArrayList<ScriptMethod>();
        ArrayList delMethods = new ArrayList();
        ArrayList<Object> addParams = new ArrayList<Object>();
        ArrayList<ScriptParam> delParams = new ArrayList<ScriptParam>();
        ScriptRecordServiceImpl.copyList(delMethods, methodInDbs);
        for (ScriptMethodConstruct method : methodsNew) {
            List<ScriptParam> params;
            boolean isAdd = true;
            for (ScriptMethodConstruct methodInDb : methodInDbs) {
                if (!method.getName().equals(methodInDb.getName())) continue;
                ScriptMethod scriptMethod = new ScriptMethod();
                BeanUtil.copyProperties((Object)method, (Object)scriptMethod);
                scriptMethod.setId(methodInDb.getId());
                scriptMethod.setScriptId(scriptRecord.getId());
                addMethods.add(scriptMethod);
                ArrayList<ScriptParam> paramsInDb = ObjectUtils.isEmpty((Object)methodInDb.getParams()) ? new ArrayList() : methodInDb.getParams();
                ArrayList<ScriptParam> paramsNew = ObjectUtils.isEmpty((Object)method.getParams()) ? new ArrayList() : method.getParams();
                ParamContrast paramContrast = this.paramContrast(paramsInDb, paramsNew);
                paramContrast.getAddParams().forEach(param -> param.setMethodId(methodInDb.getId()));
                addParams.addAll(paramContrast.getAddParams());
                delParams.addAll(paramContrast.getDelParams());
                isAdd = false;
                delMethods.remove(methodInDb);
                break;
            }
            if (!isAdd) continue;
            ScriptMethod scriptMethod = new ScriptMethod();
            long methodId = this.snowflakeID.nextIdLong();
            scriptMethodMap.put(String.valueOf(method.getId()), String.valueOf(methodId));
            BeanUtil.copyProperties((Object)method, (Object)scriptMethod);
            scriptMethod.setId(Long.valueOf(methodId));
            scriptMethod.setScriptId(scriptRecord.getId());
            addMethods.add(scriptMethod);
            List list = params = ObjectUtils.isEmpty((Object)method.getParams()) ? new ArrayList() : method.getParams();
            if (ObjectUtils.isNotEmpty((Object)method.getReturnValue())) {
                params.add(method.getReturnValue());
            }
            params.forEach(param -> {
                param.setMethodId(Long.valueOf(methodId));
                param.setId(Long.valueOf(this.snowflakeID.nextIdLong()));
            });
            addParams.addAll(params);
        }
        delMethods.forEach(delMethod -> delParams.addAll(delMethod.getParams()));
        this.scriptMethodService.saveOrUpdateBatch(addMethods);
        List methodDelIds = delMethods.stream().map(ScriptMethodConstruct::getId).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(methodDelIds)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(ScriptMethodRelated::getMethodId, methodDelIds);
            this.scriptRelatedService.remove((Wrapper)wrapper);
            this.scriptMethodService.removeByIds(methodDelIds);
        }
        this.scriptParamService.saveOrUpdateBatch(addParams);
        List paramIds = delParams.stream().map(ScriptParam::getId).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(paramIds)) {
            this.scriptParamService.removeByIds(paramIds);
        }
        return ApiResponse.success((Object)true, (String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    private ParamContrast paramContrast(List<ScriptParam> paramsInDb, List<ScriptParam> paramsNew) {
        ArrayList<ScriptParam> addParams = new ArrayList<ScriptParam>();
        ArrayList<ScriptParam> delParams = new ArrayList<ScriptParam>();
        ScriptRecordServiceImpl.copyList(delParams, paramsInDb);
        for (ScriptParam paramNew : paramsNew) {
            boolean isAdd = true;
            for (ScriptParam paramInDb : paramsInDb) {
                if (!paramInDb.getName().equals(paramNew.getName())) continue;
                paramNew.setId(paramInDb.getId());
                addParams.add(paramNew);
                delParams.remove(paramInDb);
                isAdd = false;
                break;
            }
            if (!isAdd) continue;
            addParams.add(paramNew);
        }
        return new ParamContrast(addParams, new ArrayList<ScriptParam>(), delParams);
    }

    public static <T> void copyList(List<? super T> dest, List<? extends T> src) {
        CollectionUtils.addAll(dest, (Object[])new Object[src.size()]);
        Collections.copy(dest, src);
    }

    private void writeImage(String image, HttpServletResponse response, Supplier<Boolean> supplier) {
        OutputStream os = null;
        try {
            File file = new File(image);
            byte[] data = FileUtils.readFileToByteArray((File)file);
            os = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
            response.setContentType("image/jpeg;charset=UTF-8");
            IOUtils.write((byte[])data, (OutputStream)os);
        }
        catch (IOException e) {
            ToolUtil.getLogger(ScriptRecordServiceImpl.class).error("\u8bfb\u53d6\u56fe\u6807\u5931\u8d25\uff1a{}\uff01", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u8bfb\u53d6\u56fe\u6807\u5931\u8d25");
        }
        finally {
            if (ObjectUtils.isNotEmpty(os)) {
                try {
                    os.close();
                    supplier.get();
                }
                catch (IOException e) {
                    ToolUtil.getLogger(ScriptRecordServiceImpl.class).error("\u8bfb\u53d6\u56fe\u6807\u54cd\u5e94\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}\uff01", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    static class ScriptZipMeta {
        private ScriptManifest manifest;
        private ScriptBase scriptBase;
        private String scriptName;
        private String code;
        private String unzipFilePath;
        private String uploadZipPath;

        public ScriptZipMeta(ScriptManifest manifest, ScriptBase scriptBase, String scriptName, String code, String unzipFilePath, String uploadZipPath) {
            this.manifest = manifest;
            this.scriptBase = scriptBase;
            this.scriptName = scriptName;
            this.code = code;
            this.unzipFilePath = unzipFilePath;
            this.uploadZipPath = uploadZipPath;
        }

        public ScriptManifest getManifest() {
            return this.manifest;
        }

        public void setManifest(ScriptManifest manifest) {
            this.manifest = manifest;
        }

        public ScriptBase getScriptBase() {
            return this.scriptBase;
        }

        public void setScriptBase(ScriptBase scriptBase) {
            this.scriptBase = scriptBase;
        }

        public String getScriptName() {
            return this.scriptName;
        }

        public void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getUnzipFilePath() {
            return this.unzipFilePath;
        }

        public void setUnzipFilePath(String unzipFilePath) {
            this.unzipFilePath = unzipFilePath;
        }

        public String getUploadZipPath() {
            return this.uploadZipPath;
        }

        public void setUploadZipPath(String uploadZipPath) {
            this.uploadZipPath = uploadZipPath;
        }
    }

    static class ParamContrast {
        List<ScriptParam> addParams;
        List<ScriptParam> editParams;
        List<ScriptParam> delParams;

        public ParamContrast(List<ScriptParam> addParams, List<ScriptParam> editParams, List<ScriptParam> delParams) {
            this.addParams = addParams;
            this.editParams = editParams;
            this.delParams = delParams;
        }

        public List<ScriptParam> getAddParams() {
            return this.addParams;
        }

        public void setAddParams(List<ScriptParam> addParams) {
            this.addParams = addParams;
        }

        public List<ScriptParam> getEditParams() {
            return this.editParams;
        }

        public void setEditParams(List<ScriptParam> editParams) {
            this.editParams = editParams;
        }

        public List<ScriptParam> getDelParams() {
            return this.delParams;
        }

        public void setDelParams(List<ScriptParam> delParams) {
            this.delParams = delParams;
        }
    }
}

