/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.policy.RenderPolicy;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DownLoadCompent;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.I18nUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.WaterMarkComponent;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.print.dto.WordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.enums.FileNameMode;
import com.jxdinfo.hussar.formdesign.application.print.handle.SuggestionTemp;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.model.SysWordPrintTask;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysWordPrintTaskService;
import com.jxdinfo.hussar.formdesign.application.print.util.DocxUtil;
import com.jxdinfo.hussar.formdesign.application.print.util.GenerateCode;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintGeneFileName;
import com.jxdinfo.hussar.formdesign.application.print.vo.WidgetsAndData;
import com.jxdinfo.hussar.formdesign.application.util.DeepCopy;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.jgit.util.StringUtils;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLFactory;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ddr.poi.html.HtmlRenderPolicy;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STEm;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHighlightColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSectionMark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STThemeColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTRImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class WordHandle {
    @Value(value="${hussar-formdesign.workspace:}")
    private String outputPath;
    @Value(value="${hussar.nocode.wordPrint.selectionBoxEnable:false}")
    private boolean selectionBoxEnable;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private ISysWordPrintTaskService sysWordPrintTaskService;
    @Resource
    private OssService ossService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private WaterMarkComponent waterMarkComponent;
    @Resource
    private I18nUtil i18nUtil;
    @Resource
    private DownLoadCompent downLoadCompent;
    private static ConcurrentHashMap<String, Object> hashMap = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger(WordHandle.class);

    private void replaceInPara(XWPFDocument doc, XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets, Map<String, String> richTextMap) throws FileNotFoundException {
        boolean exactFlag = false;
        if (para.getSpacingLineRule() == LineSpacingRule.EXACT && HussarUtils.isNotEmpty((Object)para.getRuns())) {
            exactFlag = true;
        }
        String tempString = "";
        int lastChar = 32;
        if (WordHandle.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            HashSet<XWPFRun> runSet = new HashSet<XWPFRun>();
            for (XWPFRun run : runs) {
                String text = run.getText(0);
                if (text == null) continue;
                boolean isFind = true;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '$') {
                        runSet = new HashSet();
                        runSet.add(run);
                        tempString = text;
                    } else if (ch == '{') {
                        if (lastChar == 36) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else if (ch == '}') {
                        if (tempString != null && tempString.indexOf("${") >= 0) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                        if (runSet.size() > 0) {
                            String replaceText = WordHandle.replaceText(tempString, param);
                            if (!replaceText.equals(tempString) && isFind) {
                                int index = 0;
                                XWPFRun aRun = null;
                                for (XWPFRun tempRun : runSet) {
                                    tempRun.setText("", 0);
                                    if (index == 0) {
                                        aRun = tempRun;
                                    }
                                    ++index;
                                }
                                this.replaceTemp(doc, para, param, tempString, replaceText, aRun, widgets, richTextMap, exactFlag);
                                isFind = false;
                            }
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else {
                        if (runSet.size() <= 0 || runSet.contains(run)) continue;
                        runSet.add(run);
                        tempString = tempString + text;
                    }
                    lastChar = ch;
                }
            }
        }
    }

    private void replaceInPara1(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets, Map<String, String> richTextMap) throws FileNotFoundException {
        String tempString = "";
        int lastChar = 32;
        if (WordHandle.matcher(para.getParagraphText()).find()) {
            List runs = para.getRuns();
            HashSet<XWPFRun> runSet = new HashSet<XWPFRun>();
            for (XWPFRun run : runs) {
                String text = run.getText(0);
                if (text == null) continue;
                boolean isFind = true;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '$') {
                        runSet = new HashSet();
                        runSet.add(run);
                        tempString = text;
                    } else if (ch == '{') {
                        if (lastChar == 36) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else if (ch == '}') {
                        if (tempString != null && tempString.indexOf("${") >= 0) {
                            if (!runSet.contains(run)) {
                                runSet.add(run);
                                tempString = tempString + text;
                            }
                        } else {
                            runSet = new HashSet();
                            tempString = "";
                        }
                        if (runSet.size() > 0) {
                            String replaceText = WordHandle.replaceText(tempString, param);
                            if (!replaceText.equals(tempString) && isFind) {
                                int index = 0;
                                XWPFRun aRun = null;
                                for (XWPFRun tempRun : runSet) {
                                    tempRun.setText("", 0);
                                    if (index == 0) {
                                        aRun = tempRun;
                                    }
                                    ++index;
                                }
                                this.replaceTemp1(param, tempString, replaceText, aRun, widgets, richTextMap);
                                isFind = false;
                            }
                            runSet = new HashSet();
                            tempString = "";
                        }
                    } else {
                        if (runSet.size() <= 0 || runSet.contains(run)) continue;
                        runSet.add(run);
                        tempString = tempString + text;
                    }
                    lastChar = ch;
                }
            }
        }
    }

    private void replaceTemp(XWPFDocument doc, XWPFParagraph para, Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, boolean exactFlag) {
        ArrayList<String> temps = new ArrayList<String>();
        ArrayList<String> replaceTexts = new ArrayList<String>();
        Matcher matcher = WordHandle.matcher(tempString);
        while (matcher.find()) {
            String group = matcher.group();
            temps.add(group);
            if (param.containsKey(group)) {
                if (HussarUtils.isEmpty((Object)param.get(group))) {
                    replaceTexts.add("");
                    continue;
                }
                replaceTexts.add(param.get(group).toString());
                continue;
            }
            replaceTexts.add("");
        }
        int s = 0;
        for (int j = 0; j < temps.size(); ++j) {
            int i;
            int k = j - s;
            String string = (String)temps.get(j);
            String text = (String)replaceTexts.get(j);
            if (WordHandle.judgeImage(string, widgets)) {
                if (!this.handleImg(doc, para, string, text, aRun, widgets, k, exactFlag)) continue;
                ++s;
                continue;
            }
            if (WordHandle.judgeTextArea(string, widgets)) {
                i = this.handleTextArea(string, text, aRun, widgets, k);
                s -= i;
                continue;
            }
            if (WordHandle.judgeSelect(string, widgets)) {
                this.handleSelect(param, string, text, aRun, widgets, k);
                continue;
            }
            if (WordHandle.judgeFile(string, widgets)) {
                this.handleFile(string, text, aRun, widgets, k);
                continue;
            }
            if (WordHandle.judgeRichText(string, widgets)) {
                this.handleRichText(string, text, aRun, widgets, richTextMap, k);
                continue;
            }
            if (WordHandle.judgeInputOrSer(string, widgets)) {
                if (!this.handleInputOrSer(string, text, aRun, widgets, k)) continue;
                ++s;
                continue;
            }
            if (WordHandle.judgeSignature(string, widgets)) {
                if (!this.handleSignature(string, text, aRun, widgets, k)) continue;
                ++s;
                continue;
            }
            if (WordHandle.judgeSuggestion(string, widgets)) {
                i = this.handleSuggestion(string, text, aRun, widgets, richTextMap, k);
                s -= i;
                continue;
            }
            aRun.setText(text, k);
        }
    }

    private void replaceTemp1(Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList<String> temps = new ArrayList<String>();
        Matcher matcher = WordHandle.matcher(tempString);
        while (matcher.find()) {
            String group = matcher.group();
            temps.add(group);
        }
        for (String string : temps) {
            int endIndex;
            int startIndex;
            String result = string.substring(startIndex = string.indexOf(35) + 1, endIndex = string.indexOf(125));
            if (HussarUtils.isNotEmpty((Object)widgets.get(result)) && widgets.get(result).equals(WidgetType.JXDNRichText.getType())) {
                tempString = tempString.replace(string, "{{" + result + "}}");
                richTextMap.put(result, String.valueOf(param.get(string)));
            }
            if (!HussarUtils.isNotEmpty((Object)widgets.get(result)) || !widgets.get(result).equals(WidgetType.JXDNSuggestion.getType())) continue;
            String widgetStr = widgets.get("widgetsStr");
            JSONArray array = JSON.parseArray((String)widgetStr);
            for (Object o : array) {
                JSONObject object;
                List list;
                JSONObject jsonObject;
                Object name;
                if (!(o instanceof JSONObject) || !HussarUtils.isNotEmpty((Object)(name = (jsonObject = (JSONObject)o).get((Object)"name"))) || !String.valueOf(name).equals(result) || (list = (List)(object = (JSONObject)jsonObject.get((Object)"props")).get((Object)"showFields")).size() == 1 && ((String)list.get(0)).equals("name")) continue;
                tempString = tempString.replace(string, "{{" + result + "}}");
                richTextMap.put(result, String.valueOf(param.get(string)));
            }
        }
        aRun.setText(tempString, 0);
    }

    private void handleRichText(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, int position) {
        int startIndex = tempString.indexOf(35) + 1;
        int endIndex = tempString.indexOf(125);
        String result = tempString.substring(startIndex, endIndex);
        aRun.setText("{{" + result + "}}", position);
        richTextMap.put(result, replaceText);
    }

    private boolean handleInputOrSer(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        String codeMode = "";
        if (tempString.contains("|") && tempString.contains("size")) {
            String[] split = tempString.split("\\|");
            if (split.length > 2) {
                codeMode = split[1];
                String size = split[2];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains("fixed")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                if (split1.length == 2) {
                    List<Double> wh;
                    if ("qrcode".equals(codeMode)) {
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, 1.0);
                        WordHandle.insertCode(tempString, codeMode, replaceText, wh.get(0).intValue(), wh.get(1).intValue(), BarcodeFormat.QR_CODE, aRun, ErrorCorrectionLevel.M);
                    } else {
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, 1.5);
                        WordHandle.insertCode(tempString, codeMode, replaceText, wh.get(0).intValue(), wh.get(1).intValue(), BarcodeFormat.CODE_128, aRun, ErrorCorrectionLevel.H);
                    }
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleImg(XWPFDocument doc, XWPFParagraph para, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position, boolean exactFlag) {
        List<Object> wh = new ArrayList();
        int mode = 0;
        String imageconfig = tempString.substring(tempString.indexOf("=") + 1, tempString.indexOf("}"));
        String[] split = imageconfig.split("\\*");
        String width = split[0];
        String height = split[1];
        if (!width.contains("auto")) {
            if (height.contains("fixed")) {
                String[] split1 = height.split("_");
                height = split1[0];
                mode = 1;
            } else if (height.contains("_")) {
                String[] split2 = height.split("_");
                height = split2[0];
                mode = 2;
            } else {
                height = "auto";
                mode = 3;
            }
        }
        JSONArray parse = (JSONArray)JSONArray.parse((String)replaceText);
        InputStream inputStream = null;
        ByteArrayInputStream stream = null;
        ByteArrayInputStream stream2 = null;
        if (HussarUtils.isNotEmpty((Object)parse)) {
            block41: {
                for (Object obj : parse) {
                    if (!(obj instanceof JSONObject)) continue;
                    JSONObject jsonObject = (JSONObject)obj;
                    String id = String.valueOf(jsonObject.get((Object)"id"));
                    String type = String.valueOf(jsonObject.get((Object)"type"));
                    String name = String.valueOf(jsonObject.get((Object)"name"));
                    byte[] bytes = this.showImageByte(Long.valueOf(id));
                    double widthToHeight = 0.0;
                    byte[] bs = new byte[]{};
                    try {
                        inputStream = new ByteArrayInputStream(bytes);
                        stream = new ByteArrayInputStream(bytes);
                        stream2 = new ByteArrayInputStream(bytes);
                        bs = IOUtils.toByteArray((InputStream)stream);
                        BufferedImage image = ImageIO.read(new ByteArrayInputStream(bs));
                        widthToHeight = (double)image.getWidth() / (double)image.getHeight();
                        if (!HussarUtils.isNotEmpty((Object)(inputStream = this.handleWebp(inputStream, stream2, this.outputPath, image)))) continue;
                        wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                        if (HussarUtils.isEmpty(wh)) {
                            LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                        }
                        aRun.addPicture(inputStream, WordHandle.judgeImgType(type), name, ((Double)wh.get(0)).intValue() * 36000, ((Double)wh.get(1)).intValue() * 36000);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25,\u56fe\u7247\uff1a{}", (Object)tempString, (Object)jsonObject);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            if (stream2 == null) continue;
                            ((InputStream)stream2).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    XmlCursor xmlCursor;
                    XWPFParagraph paragraph;
                    CTPPr pPr;
                    int posOfParagraph;
                    XWPFParagraph next;
                    CTDrawing drawing;
                    if (!exactFlag || !HussarUtils.isNotEmpty((Object)aRun.getEmbeddedPictures()) || !HussarUtils.isNotEmpty((Object)aRun.getCTR()) || !HussarUtils.isNotEmpty((Object)aRun.getCTR().getDrawingList()) || !HussarUtils.isNotEmpty((Object)(drawing = aRun.getCTR().getDrawingArray(0)).getInlineList())) break block41;
                    CTGraphicalObject graphic = drawing.getInlineArray(0).getGraphic();
                    String anchorXML = "<wp:anchor  xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"0\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\"><wp:simplePos x=\"0\" y=\"0\"/><wp:positionH relativeFrom=\"column\"><wp:posOffset>635</wp:posOffset></wp:positionH><wp:positionV relativeFrom=\"paragraph\"><wp:posOffset>" + -(589280 * ((Double)wh.get(1)).intValue() / 20) + "</wp:posOffset></wp:positionV><wp:extent cx=\"" + ((Double)wh.get(0)).intValue() * 36000 + "\" cy=\"" + ((Double)wh.get(1)).intValue() * 36000 + "\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:wrapNone/><wp:docPr id=\"1\" name=\"Drawing 0\" descr=\"11\"/><wp:cNvGraphicFramePr/></wp:anchor>";
                    CTDrawing drawing1 = null;
                    try {
                        drawing1 = CTDrawing.Factory.parse((String)anchorXML);
                    }
                    catch (XmlException e) {
                        e.printStackTrace();
                    }
                    CTAnchor anchor = drawing1.getAnchorArray(0);
                    anchor.setGraphic(graphic);
                    drawing.setAnchorArray(new CTAnchor[]{anchor});
                    drawing.removeInline(0);
                    XmlObject copyPPr = null;
                    if (HussarUtils.isNotEmpty((Object)para.getCTP()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr())) {
                        CTPPr pPr2 = para.getCTP().getPPr();
                        copyPPr = pPr2.copy();
                    }
                    if (HussarUtils.isEmpty((Object)(next = doc.getParagraphArray((posOfParagraph = doc.getPosOfParagraph(para)) + 1)))) {
                        next = doc.createParagraph();
                    }
                    if (HussarUtils.isEmpty((Object)(pPr = (paragraph = doc.insertNewParagraph(xmlCursor = next.getCTP().newCursor())).getCTP().getPPr()))) {
                        pPr = paragraph.getCTP().addNewPPr();
                    }
                    pPr.set(copyPPr);
                    if (HussarUtils.isNotEmpty((Object)para.getCTP()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr()) && HussarUtils.isNotEmpty((Object)para.getCTP().getPPr().getSectPr())) {
                        CTPPr oriPPr = para.getCTP().getPPr();
                        oriPPr.unsetSectPr();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u56fe\u7247\u6d6e\u4e8e\u6587\u5b57\u4e0a\u65b9\u5931\u8d25", (Throwable)e);
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    public InputStream handleWebp(InputStream inputStream, InputStream stream, String outputPath, BufferedImage image) throws IOException {
        boolean isWebp = this.imgType(stream);
        if (isWebp) {
            String path = outputPath + "wordTemplate" + File.separator + "webp" + File.separator;
            File filePath = new File(outputPath + "wordTemplate" + File.separator + "webp" + File.separator);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            String newPath = path + System.currentTimeMillis() + ".png";
            ImageIO.write((RenderedImage)image, "png", new File(newPath));
            return Files.newInputStream(Paths.get(newPath, new String[0]), new OpenOption[0]);
        }
        return inputStream;
    }

    public boolean imgType(InputStream inputStream) throws IOException {
        byte[] fileHeader = new byte[4];
        inputStream.read(fileHeader, 0, fileHeader.length);
        inputStream.close();
        String header = this.bytes2Hex(fileHeader);
        return header.contains("52494646");
    }

    public String bytes2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            sb.append(hex.length() == 2 ? hex : "0" + hex);
        }
        return sb.toString();
    }

    private boolean handleSignature(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        if (tempString.contains("|") && tempString.contains("size") && HussarUtils.isNotEmpty((Object)replaceText)) {
            String[] split = tempString.split("\\|");
            if (split.length > 1) {
                String size = split[1];
                int mode = 0;
                String imageconfig = size.substring(size.indexOf("=") + 1, size.indexOf("}"));
                String[] split1 = imageconfig.split("\\*");
                String width = split1[0];
                String height = split1[1];
                if (!width.contains("auto")) {
                    String[] split2;
                    if (height.contains("fixed")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 1;
                    } else if (height.contains("_")) {
                        split2 = height.split("_");
                        height = split2[0];
                        mode = 2;
                    } else {
                        height = "auto";
                        mode = 3;
                    }
                }
                double widthToHeight = 0.0;
                if (split1.length == 2) {
                    int index = replaceText.indexOf(",");
                    replaceText = replaceText.substring(index + 1);
                    ByteArrayInputStream inputStream = null;
                    try {
                        Base64.Decoder decoder = Base64.getDecoder();
                        byte[] b = decoder.decode(replaceText);
                        inputStream = new ByteArrayInputStream(b);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    if (HussarUtils.isNotEmpty((Object)inputStream)) {
                        try {
                            List<Double> wh = WordHandle.getImageWidthAndHeight(width, height, mode, widthToHeight);
                            if (HussarUtils.isEmpty(wh)) {
                                LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u53c2\u6570\u6709\u8bef", (Object)tempString);
                            }
                            aRun.addPicture((InputStream)inputStream, WordHandle.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", wh.get(0).intValue() * 36000, wh.get(1).intValue() * 36000);
                        }
                        catch (Exception e) {
                            LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                        }
                    }
                }
            }
            return true;
        }
        aRun.setText(replaceText, position);
        return false;
    }

    private int handleSuggestion(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, Map<String, String> richTextMap, int position) {
        int add = 0;
        if (HussarUtils.isNotEmpty((Object)replaceText)) {
            JSONArray array = JSON.parseArray((String)replaceText);
            for (Object o : array) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)o;
                Object object1 = jsonObject.get((Object)"signature");
                if (HussarUtils.isNotEmpty((Object)object1)) {
                    String signature = String.valueOf(object1);
                    int index = signature.indexOf(",");
                    signature = signature.substring(index + 1);
                    ByteArrayInputStream inputStream = null;
                    try {
                        Base64.Decoder decoder = Base64.getDecoder();
                        byte[] b = decoder.decode(signature);
                        inputStream = new ByteArrayInputStream(b);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247byte\u6570\u7ec4\u8bfb\u53d6\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    if (!HussarUtils.isNotEmpty((Object)inputStream)) continue;
                    try {
                        aRun.addPicture((InputStream)inputStream, WordHandle.judgeImgType("PNG"), "\u624b\u5199\u7b7e\u540d", 1080000, 720000);
                    }
                    catch (Exception e) {
                        LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u56fe\u7247\u63d2\u5165\u5931\u8d25", (Object)tempString);
                        LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                    }
                    continue;
                }
                Object name = jsonObject.get((Object)"userName");
                if (!HussarUtils.isNotEmpty((Object)name)) continue;
                String userName = String.valueOf(name);
                aRun.setText(userName, position + ++add);
            }
        } else {
            aRun.setText(replaceText, position);
        }
        return add;
    }

    private int handleTextArea(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        int add = 0;
        if (replaceText.contains("\n")) {
            String[] strings = replaceText.split("\\n");
            aRun.setText(strings[0], position);
            for (int i = 1; i < strings.length; ++i) {
                aRun.addBreak();
                aRun.setText(strings[i], position + ++add);
            }
        } else {
            aRun.setText(replaceText, position);
        }
        return add;
    }

    private void handleSelect(Map<String, Object> param, String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        if (!this.selectionBoxEnable) {
            aRun.setText(replaceText, position);
        } else {
            JSONObject jsonObject;
            Object idObjs;
            String sub = tempString.substring(tempString.indexOf("#") + 1, tempString.indexOf("}"));
            if (sub.contains(".")) {
                sub = sub.split("\\.")[1];
            }
            String substring = sub;
            String widgetsStr = widgets.get("widgetsStr");
            JSONArray jsonArray = JSON.parseArray((String)widgetsStr);
            ArrayList<String> ids = new ArrayList<String>();
            String idKey = substring + "_value";
            Object dataValue = param.get("dataValue");
            if (HussarUtils.isNotEmpty((Object)dataValue) && HussarUtils.isNotEmpty((Object)(idObjs = (jsonObject = (JSONObject)dataValue).get((Object)idKey)))) {
                String idStr = String.valueOf(idObjs);
                String[] idArr = idStr.split(",");
                ids.addAll(Arrays.asList(idArr));
            }
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<String> boxs = new ArrayList<String>();
            ArrayList optionList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)replaceText)) {
                String[] checkBox = replaceText.split(",");
                boxs.addAll(Arrays.asList(checkBox));
            }
            jsonArray.forEach(obj -> {
                JSONObject props;
                Object options;
                Object object;
                JSONObject jsonObject;
                if (obj instanceof JSONObject && (jsonObject = (JSONObject)obj).get((Object)"name").equals(substring) && (object = jsonObject.get((Object)"props")) instanceof JSONObject && (options = (props = (JSONObject)object).get((Object)"options")) instanceof JSONArray) {
                    JSONArray jsonArray1 = (JSONArray)options;
                    jsonArray1.forEach(obj1 -> {
                        if (obj1 instanceof JSONObject) {
                            optionList.add(obj1);
                        }
                    });
                }
            });
            block0: for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                for (Object object : optionList) {
                    String valueStr;
                    if (!(object instanceof JSONObject)) continue;
                    JSONObject jsonObject2 = (JSONObject)object;
                    Object value = jsonObject2.get((Object)"value");
                    Object label = jsonObject2.get((Object)"label");
                    if (!(value instanceof String) || !(label instanceof String) || !(valueStr = String.valueOf(value)).equals(id)) continue;
                    String box = (String)boxs.get(i);
                    jsonObject2.put("label", (Object)box);
                    continue block0;
                }
            }
            for (Object object : optionList) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject jsonObject3 = (JSONObject)object;
                Object value = jsonObject3.get((Object)"value");
                Object label = jsonObject3.get((Object)"label");
                if (!(value instanceof String) || !(label instanceof String)) continue;
                String valueStr = String.valueOf(value);
                String labelStr = String.valueOf(label);
                values.add(valueStr);
                labels.add(labelStr);
            }
            StringBuilder checkBoxText = new StringBuilder();
            ArrayList<Integer> find = new ArrayList<Integer>();
            for (String label : labels) {
                boolean isFind = false;
                for (String box : boxs) {
                    if (!label.equals(box)) continue;
                    checkBoxText.append("R").append(label).append("      ");
                    find.add(boxs.indexOf(box));
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                checkBoxText.append("\u00a3").append(label).append("      ");
            }
            for (String box : boxs) {
                int index = boxs.indexOf(box);
                if (find.contains(index)) continue;
                checkBoxText.append("R").append(box).append("      ");
            }
            aRun.setText("\uffe5" + checkBoxText, position);
        }
    }

    private void handleFile(String tempString, String replaceText, XWPFRun aRun, Map<String, String> widgets, int position) {
        JSONArray parse = (JSONArray)JSONArray.parse((String)replaceText);
        if (HussarUtils.isNotEmpty((Object)parse)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parse.size() - 1; ++i) {
                JSONObject o = (JSONObject)parse.get(i);
                String fileName = String.valueOf(o.get((Object)"name"));
                sb.append(fileName).append(",");
            }
            String fileNameLast = String.valueOf(((JSONObject)parse.get(parse.size() - 1)).get((Object)"name"));
            sb.append(fileNameLast);
            replaceText = sb.toString();
        }
        aRun.setText(replaceText, position);
    }

    private static void insertCode(String tempString, String mode, String replaceText, int width, int height, BarcodeFormat barcodeFormat, XWPFRun aRun, ErrorCorrectionLevel errorCorrectionLevel) {
        try {
            BufferedImage bufferedImage = GenerateCode.generateCode(replaceText, mode, barcodeFormat, errorCorrectionLevel);
            if (HussarUtils.isNotEmpty((Object)bufferedImage)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                aRun.addPicture((InputStream)byteArrayInputStream, 6, mode, width * 36000, height * 36000);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u5360\u4f4d\u7b26\uff1a{} \u4e8c\u7ef4\u7801/\u6761\u5f62\u7801\u751f\u6210\u5931\u8d25", (Object)tempString);
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    private static int judgeImgType(String type) {
        if ("EMF".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("WMF".equalsIgnoreCase(type)) {
            return 3;
        }
        if ("PICT".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("JPEG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("DIB".equalsIgnoreCase(type)) {
            return 7;
        }
        if ("GIF".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("TIFF".equalsIgnoreCase(type)) {
            return 9;
        }
        if ("EPS".equalsIgnoreCase(type)) {
            return 10;
        }
        if ("BMP".equalsIgnoreCase(type)) {
            return 11;
        }
        if ("WPG".equalsIgnoreCase(type)) {
            return 12;
        }
        LOGGER.error("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u7c7b\u578b\uff1a{},\u5df2\u81ea\u52a8\u8f6c\u4e3aPNG\u683c\u5f0f", (Object)type);
        return 6;
    }

    public XWPFDocument generateWord(Map<String, Object> param, XWPFDocument doc, Map<String, String> widgets, JSONObject parse, Map<String, String> richTextMap) {
        try {
            if (param != null) {
                param.put("dataValue", parse);
                WordHandle.analysisPlaceholder(doc, widgets);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInPara(doc, param, widgets, richTextMap);
                if (HussarUtils.isNotEmpty((Object)parse.get((Object)"exportType"))) {
                    WordHandle.wordExportHandlePre(doc);
                }
                WordHandle.analysisTable(doc);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInTable(doc, param, widgets, richTextMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u6570\u636e{} \u66ff\u6362\u5931\u8d25", param);
            throw new BaseException((Throwable)e);
        }
        return doc;
    }

    public XWPFDocument generateWord1(Map<String, Object> param, XWPFDocument doc, Map<String, String> widgets, JSONObject parse, Map<String, String> richTextMap) {
        try {
            if (param != null) {
                WordHandle.analysisPlaceholder(doc, widgets);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInPara1(doc, param, widgets, richTextMap);
                WordHandle.analysisTable(doc);
                WordHandle.getFormData(hashMap, parse);
                this.replaceInTable1(doc, param, widgets, richTextMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("word\u6a21\u677f\u6253\u5370\u6570\u636e{} \u66ff\u6362\u5931\u8d25", param);
            throw new BaseException((Throwable)e);
        }
        return doc;
    }

    private void replaceInPara(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList paragraphs = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        List xwpfFooters = doc.getFooterList();
        pageHeaders.forEach(header -> paragraphs.addAll(header.getParagraphs()));
        xwpfFooters.forEach(footer -> paragraphs.addAll(footer.getParagraphs()));
        paragraphs.addAll(doc.getParagraphs());
        for (XWPFParagraph para : paragraphs) {
            try {
                this.wpsHandlePara(para);
                this.replaceInPara(doc, para, params, widgets, richTextMap);
                if (!this.selectionBoxEnable) continue;
                this.replaceSelect(para, params, widgets);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("word\u6a21\u677f\u6253\u5370\u6587\u6863{} \u4e0d\u5b58\u5728", (Object)doc);
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void replaceInPara1(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList paragraphs = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        pageHeaders.forEach(header -> paragraphs.addAll(header.getParagraphs()));
        paragraphs.addAll(doc.getParagraphs());
        for (XWPFParagraph para : paragraphs) {
            try {
                this.replaceInPara1(para, params, widgets, richTextMap);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("word\u6a21\u677f\u6253\u5370\u6587\u6863{} \u4e0d\u5b58\u5728", (Object)doc);
                throw new BaseException((Throwable)e);
            }
        }
    }

    private void replaceSelect(XWPFParagraph para, Map<String, Object> param, Map<String, String> widgets) {
        if (para.getParagraphText().contains("\uffe5")) {
            List runR = para.getRuns();
            int fontSize = ((XWPFRun)runR.get(0)).getFontSize();
            HashMap<Integer, List> listMap = new HashMap<Integer, List>();
            int size = runR.size();
            for (int i = 0; i < size; ++i) {
                XWPFRun xwpfRun2 = (XWPFRun)runR.get(i);
                String text = xwpfRun2.text();
                if (!text.contains("\uffe5") || !text.contains("R") && !text.contains("\u00a3")) continue;
                ArrayList<Integer> indexList = new ArrayList<Integer>();
                int k2 = 0;
                while (HussarUtils.isNotEmpty((Object)xwpfRun2.text())) {
                    xwpfRun2.setText("", k2);
                    ++k2;
                }
                boolean isFind = false;
                int start = 0;
                for (int s = 0; s < text.length(); ++s) {
                    XWPFRun run2;
                    String substring;
                    char ch = text.charAt(s);
                    if (!isFind) {
                        if (ch != 'R' && ch != '\u00a3') continue;
                        start = s;
                        isFind = true;
                        XWPFRun run3 = para.createRun();
                        indexList.add(runR.indexOf(run3));
                        run3.setText(String.valueOf(ch));
                        continue;
                    }
                    if (ch == 'R' || ch == '\u00a3') {
                        int end = s--;
                        substring = text.substring(start + 1, end);
                        run2 = para.createRun();
                        indexList.add(runR.indexOf(run2));
                        run2.setText(substring);
                        isFind = false;
                    }
                    if (s != text.length() - 1) continue;
                    substring = text.substring(start + 1);
                    run2 = para.createRun();
                    indexList.add(runR.indexOf(run2));
                    run2.setText(substring);
                }
                listMap.put(i, indexList);
            }
            ArrayList runList = new ArrayList(runR);
            if (HussarUtils.isNotEmpty(listMap)) {
                AtomicInteger k1 = new AtomicInteger();
                listMap.forEach((k, v) -> {
                    for (int x = 0; x < v.size(); ++x) {
                        int parseInt = Integer.parseInt(String.valueOf(v.get(x)));
                        XWPFRun remove = (XWPFRun)runList.remove(parseInt);
                        runList.add(k + x + 1 + k1.get(), remove);
                    }
                    k1.addAndGet(v.size());
                });
            }
            LinkedHashMap map = new LinkedHashMap();
            runList.forEach(xwpfRun -> {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put(xwpfRun.text(), xwpfRun.getFontFamily());
                map.put(runList.indexOf(xwpfRun), map1);
            });
            runR.forEach(run -> {
                int i = runR.indexOf(run);
                Map map1 = (Map)map.get(i);
                run.setText("", 0);
                String text = "";
                String font = null;
                for (String key : map1.keySet()) {
                    if (!key.equals("\uffe5")) {
                        text = key;
                    }
                    font = (String)map1.get(key);
                }
                run.setText(text);
            });
            for (XWPFRun xwpfRun3 : runR) {
                this.setFontSize(fontSize, xwpfRun3);
                if (!xwpfRun3.text().equals("R") && !xwpfRun3.text().equals("\u00a3") && !xwpfRun3.text().isEmpty()) continue;
                CTFonts font = xwpfRun3.getCTR().addNewRPr().addNewRFonts();
                font.setAscii("Wingdings 2");
                font.setCs("Wingdings 2");
                font.setEastAsia("Wingdings 2");
                font.setHAnsi("Wingdings 2");
            }
        }
    }

    private static String replaceText(String text, Map<String, Object> map) {
        Matcher matcher;
        String replaceText = text;
        if (text != null && (matcher = WordHandle.matcher(text)).find()) {
            while ((matcher = WordHandle.matcher(text)).find()) {
                String group = matcher.group();
                if (map.containsKey(group)) {
                    String value = String.valueOf(map.get(group));
                    text = replaceText = matcher.replaceFirst(value);
                    continue;
                }
                text = matcher.replaceFirst("");
            }
            if ("null".equals(text)) {
                replaceText = "";
            }
        }
        return replaceText;
    }

    private void setFontSize(int size, XWPFRun run) {
        if (size != -1) {
            run.setFontSize(size);
        }
    }

    private void replaceInTable(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList tables = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        pageHeaders.forEach(header -> tables.addAll(header.getTables()));
        tables.addAll(doc.getTables());
        for (XWPFTable table : tables) {
            this.handleTable(doc, table, params, widgets, richTextMap);
        }
    }

    private void handleTable(XWPFDocument doc, XWPFTable table, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        List rows = table.getRows();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        HashSet<Integer> removeRows = new HashSet<Integer>();
        for (int k = 0; k < rows.size(); ++k) {
            XWPFTableRow row = (XWPFTableRow)rows.get(k);
            List cells = row.getTableCells();
            boolean flag = true;
            String tableName = "";
            int lastIndex = 0;
            boolean indexFlag = false;
            for (int i = 0; i < cells.size(); ++i) {
                XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                if (k == 0) {
                    widths.add(cell.getWidth());
                }
                List paras = cell.getParagraphs();
                String text = cell.getText();
                Matcher matcher = WordHandle.matcher(text);
                if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) {
                    removeRows.add(k);
                    while (matcher.find()) {
                        String[] strings;
                        Object obj = params.get(matcher.group());
                        if (!(obj instanceof List)) continue;
                        List list = (List)obj;
                        String childName = matcher.group();
                        String substring1 = childName.substring(childName.indexOf("#") + 1, childName.indexOf("}"));
                        String currentTableName = "";
                        if (substring1.contains(".") && ((strings = substring1.split("\\.")).length == 2 || strings.length == 3)) {
                            if (!tableName.equals(strings[0])) {
                                flag = true;
                            }
                            currentTableName = strings[0];
                        }
                        if (flag) {
                            for (int j = 0; j < list.size(); ++j) {
                                String[] strings2;
                                String[] split1;
                                String result;
                                int endIndex;
                                String cellTableName;
                                String group;
                                HashMap<String, Object> map;
                                String key21;
                                Matcher matcher1;
                                String text1;
                                CTJc ctjc;
                                CTPPr ctppr;
                                CTP ctp;
                                CTTc cttc;
                                CTPPr pPr;
                                XWPFTableCell newCell;
                                XWPFTableCell sourceCell;
                                int l;
                                XWPFTableRow tableRow = HussarUtils.isEmpty((Object)tableName) ? table.insertNewTableRow(k + j + 1) : (lastIndex < j + 1 ? table.insertNewTableRow(k + j + 1) : (XWPFTableRow)rows.get(k + j + 1));
                                Object obj1 = list.get(j);
                                JSONObject parse = DeepCopy.deepCopyJsonObject(obj1);
                                if (!tableRow.getTableCells().isEmpty()) {
                                    for (l = i; l < cells.size(); ++l) {
                                        sourceCell = (XWPFTableCell)cells.get(l);
                                        newCell = tableRow.getCell(l);
                                        newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
                                        pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
                                        if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
                                            cttc = newCell.getCTTc();
                                            ctp = (CTP)cttc.getPList().get(0);
                                            ctppr = ctp.getPPr();
                                            if (ctppr == null) {
                                                ctppr = ctp.addNewPPr();
                                            }
                                            if ((ctjc = ctppr.getJc()) == null) {
                                                ctjc = ctppr.addNewJc();
                                            }
                                            ctjc.setVal(pPr.getJc().getVal());
                                        }
                                        text1 = sourceCell.getText();
                                        matcher1 = WordHandle.matcher(text1);
                                        key21 = "";
                                        map = new HashMap<String, Object>();
                                        group = "";
                                        cellTableName = "";
                                        while (matcher1.find()) {
                                            group = matcher1.group();
                                            if (group.contains(".")) {
                                                int startIndex = group.indexOf(35) + 1;
                                                result = group.substring(startIndex, endIndex = group.indexOf(125));
                                                split1 = result.split("\\.");
                                                if (split1.length != 2) continue;
                                                cellTableName = split1[0];
                                                if (split1[1].contains("|")) {
                                                    strings2 = split1[1].split("\\|");
                                                    if (strings2.length == 3) {
                                                        key21 = strings2[0];
                                                        map.put(group, parse.get((Object)key21));
                                                    }
                                                    if (strings2.length != 2) continue;
                                                    key21 = strings2[0];
                                                    map.put(group, parse.get((Object)key21));
                                                    continue;
                                                }
                                                key21 = split1[1];
                                                map.put(group, parse.get((Object)key21));
                                                continue;
                                            }
                                            String group1 = String.valueOf(params.get(group));
                                            map.put(group, group1);
                                        }
                                        if (HussarUtils.isNotEmpty((Object)cellTableName) && !cellTableName.equals(currentTableName)) continue;
                                        this.replaceCell(newCell, sourceCell, doc, map, widgets, richTextMap);
                                    }
                                    continue;
                                }
                                indexFlag = true;
                                for (l = 0; l < cells.size(); ++l) {
                                    sourceCell = (XWPFTableCell)cells.get(l);
                                    newCell = tableRow.addNewTableCell();
                                    newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
                                    pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
                                    if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
                                        cttc = newCell.getCTTc();
                                        ctp = (CTP)cttc.getPList().get(0);
                                        ctppr = ctp.getPPr();
                                        if (ctppr == null) {
                                            ctppr = ctp.addNewPPr();
                                        }
                                        if ((ctjc = ctppr.getJc()) == null) {
                                            ctjc = ctppr.addNewJc();
                                        }
                                        ctjc.setVal(pPr.getJc().getVal());
                                    }
                                    text1 = sourceCell.getText();
                                    matcher1 = WordHandle.matcher(text1);
                                    key21 = "";
                                    map = new HashMap();
                                    group = "";
                                    cellTableName = "";
                                    while (matcher1.find()) {
                                        group = matcher1.group();
                                        if (group.contains(".")) {
                                            int startIndex = group.indexOf(35) + 1;
                                            result = group.substring(startIndex, endIndex = group.indexOf(125));
                                            split1 = result.split("\\.");
                                            if (split1.length != 2 && split1.length != 3) continue;
                                            cellTableName = split1[0];
                                            if (split1[split1.length - 1].contains("|")) {
                                                strings2 = split1[1].split("\\|");
                                                if (strings2.length == 3) {
                                                    key21 = strings2[0];
                                                    map.put(group, parse.get((Object)key21));
                                                }
                                                if (strings2.length != 2) continue;
                                                key21 = strings2[0];
                                                map.put(group, parse.get((Object)key21));
                                                continue;
                                            }
                                            key21 = split1[1];
                                            if (split1.length == 2) {
                                                map.put(group, parse.get((Object)key21));
                                                continue;
                                            }
                                            map.put(group, result);
                                            continue;
                                        }
                                        String group1 = String.valueOf(params.get(group));
                                        map.put(group, group1);
                                    }
                                    if (HussarUtils.isNotEmpty((Object)cellTableName) && !cellTableName.equals(currentTableName)) continue;
                                    this.replaceCell(newCell, sourceCell, doc, map, widgets, richTextMap);
                                }
                            }
                            tableName = currentTableName;
                            lastIndex = list.size();
                        }
                        flag = false;
                    }
                    continue;
                }
                for (XWPFParagraph para : paras) {
                    try {
                        this.wpsHandlePara(para);
                        this.replaceInPara(doc, para, params, widgets, richTextMap);
                        if (!this.selectionBoxEnable) continue;
                        this.replaceSelect(para, params, widgets);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                        throw new BaseException((Throwable)e);
                    }
                }
            }
        }
        List collect = removeRows.stream().sorted().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(collect)) {
            int removeNum = 0;
            for (Integer removeRow : collect) {
                removeRow = removeRow - removeNum;
                ++removeNum;
                table.removeRow(removeRow.intValue());
            }
        }
    }

    private void replaceCell(XWPFTableCell newCell, XWPFTableCell sourceCell, XWPFDocument doc, Map<String, Object> map, Map<String, String> widgets, Map<String, String> richTextMap) {
        for (XWPFParagraph sourcePh : sourceCell.getParagraphs()) {
            List paragraphs;
            int index = sourceCell.getParagraphs().indexOf(sourcePh);
            XWPFParagraph newPh = index < (paragraphs = newCell.getParagraphs()).size() ? (XWPFParagraph)paragraphs.get(index) : newCell.addParagraph();
            XWPFRun sourceRun = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            try {
                for (XWPFRun run1 : sourcePh.getRuns()) {
                    XWPFRun runNew = newPh.createRun();
                    runNew.setText(run1.text());
                    runNew.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                    runNew.setColor(sourceRun.getColor());
                    runNew.setBold(sourceRun.isBold());
                    runNew.setItalic(sourceRun.isItalic());
                    this.setFontSize(sourceRun.getFontSize(), runNew);
                }
                this.replaceInPara(doc, newPh, map, widgets, richTextMap);
            }
            catch (Exception e) {
                LOGGER.error("\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
            }
        }
    }

    private void wpsHandlePara(XWPFParagraph para) {
        ArrayList<Character> chars = new ArrayList<Character>();
        ArrayList<String> colors = new ArrayList<String>();
        ArrayList<Boolean> bolds = new ArrayList<Boolean>();
        ArrayList<Boolean> italics = new ArrayList<Boolean>();
        ArrayList<Integer> fontSizes = new ArrayList<Integer>();
        ArrayList<String> fontFamilys = new ArrayList<String>();
        ArrayList<STHighlightColor.Enum> highlightColors = new ArrayList<STHighlightColor.Enum>();
        ArrayList<STThemeColor.Enum> themeColors = new ArrayList<STThemeColor.Enum>();
        ArrayList<UnderlinePatterns> underlinePatterns = new ArrayList<UnderlinePatterns>();
        ArrayList<String> underlineColors = new ArrayList<String>();
        ArrayList<Boolean> strikeThroughs = new ArrayList<Boolean>();
        ArrayList<Boolean> doubleStrikeThroughs = new ArrayList<Boolean>();
        ArrayList<VerticalAlign> verticalAligns = new ArrayList<VerticalAlign>();
        ArrayList<STEm.Enum> emphasisMarks = new ArrayList<STEm.Enum>();
        ArrayList<Integer> textPositions = new ArrayList<Integer>();
        ArrayList<Integer> characterSpacings = new ArrayList<Integer>();
        ArrayList<Integer> textScales = new ArrayList<Integer>();
        ArrayList<String> xmls = new ArrayList<String>();
        boolean hasXml = false;
        if (HussarUtils.isNotEmpty((Object)para)) {
            List runs1 = para.getRuns();
            for (XWPFRun run1 : runs1) {
                List embeddedPictures = run1.getEmbeddedPictures();
                if (HussarUtils.isNotEmpty((Object)embeddedPictures)) {
                    return;
                }
                String phonetic = run1.getPhonetic();
                if (!HussarUtils.isNotEmpty((Object)phonetic)) continue;
                hasXml = true;
            }
            String paragraphText = para.getParagraphText();
            if (paragraphText.contains("$") && paragraphText.contains("{") && paragraphText.contains("#") && paragraphText.contains("}")) {
                Boolean italic;
                Boolean bold;
                List runs = para.getRuns();
                for (XWPFRun run : runs) {
                    if (!HussarUtils.isNotEmpty((Object)run)) continue;
                    String text = run.text();
                    String fontFamily = run.getFontFamily();
                    String color = run.getColor();
                    bold = run.isBold();
                    italic = run.isItalic();
                    int fontSize = run.getFontSize();
                    UnderlinePatterns underline = run.getUnderline();
                    String underlineColor = run.getUnderlineColor();
                    STThemeColor.Enum underlineThemeColor = run.getUnderlineThemeColor();
                    STHighlightColor.Enum textHightlightColor = run.getTextHightlightColor();
                    boolean strikeThrough = run.isStrikeThrough();
                    boolean doubleStrikeThrough = run.isDoubleStrikeThrough();
                    VerticalAlign subscript = run.getSubscript();
                    STEm.Enum emphasisMark = run.getEmphasisMark();
                    int textPosition = run.getTextPosition();
                    int characterSpacing = run.getCharacterSpacing();
                    int textScale = run.getTextScale();
                    String phonetic = run.getPhonetic();
                    String xml = "";
                    if (HussarUtils.isNotEmpty((Object)phonetic)) {
                        XmlCursor c = run.getCTR().newCursor();
                        xml = c.getObject().toString();
                    }
                    if (!HussarUtils.isNotEmpty((Object)text)) continue;
                    for (int i = 0; i < text.length(); ++i) {
                        char c = text.charAt(i);
                        chars.add(Character.valueOf(c));
                        fontFamilys.add(fontFamily);
                        colors.add(color);
                        bolds.add(bold);
                        italics.add(italic);
                        fontSizes.add(fontSize);
                        highlightColors.add(textHightlightColor);
                        underlinePatterns.add(underline);
                        underlineColors.add(underlineColor);
                        strikeThroughs.add(strikeThrough);
                        themeColors.add(underlineThemeColor);
                        doubleStrikeThroughs.add(doubleStrikeThrough);
                        verticalAligns.add(subscript);
                        emphasisMarks.add(emphasisMark);
                        textPositions.add(textPosition);
                        characterSpacings.add(characterSpacing);
                        textScales.add(textScale);
                        xmls.add(xml);
                    }
                }
                for (int j = 0; j < chars.size(); ++j) {
                    List brList;
                    CTHpsMeasure ctSize;
                    XmlObject xmlObject;
                    CTRImpl ctr;
                    String text;
                    Character c = (Character)chars.get(j);
                    String color = (String)colors.get(j);
                    int fontSize = (Integer)fontSizes.get(j);
                    String fontFamily = (String)fontFamilys.get(j);
                    bold = (Boolean)bolds.get(j);
                    italic = (Boolean)italics.get(j);
                    UnderlinePatterns patterns = (UnderlinePatterns)underlinePatterns.get(j);
                    String underlineColor = (String)underlineColors.get(j);
                    STThemeColor.Enum themeColor = (STThemeColor.Enum)themeColors.get(j);
                    STHighlightColor.Enum anEnum = (STHighlightColor.Enum)highlightColors.get(j);
                    Boolean st = (Boolean)strikeThroughs.get(j);
                    Boolean dSt = (Boolean)doubleStrikeThroughs.get(j);
                    VerticalAlign verticalAlign = (VerticalAlign)verticalAligns.get(j);
                    STEm.Enum eM = (STEm.Enum)emphasisMarks.get(j);
                    Integer tP = (Integer)textPositions.get(j);
                    Integer cS = (Integer)characterSpacings.get(j);
                    Integer textScale = (Integer)textScales.get(j);
                    String xml = (String)xmls.get(j);
                    if (runs.size() >= j + 1) {
                        List brList2;
                        XWPFRun xwpfRun = (XWPFRun)runs.get(j);
                        text = xwpfRun.text();
                        ctr = (CTRImpl)xwpfRun.getCTR();
                        if (hasXml) {
                            if (HussarUtils.isNotEmpty((Object)xml)) {
                                XmlCursor xmlCursor = ctr.newCursor();
                                try {
                                    xmlObject = XmlObject.Factory.parse((String)xml);
                                    xmlCursor.getObject().set(xmlObject);
                                }
                                catch (XmlException e) {
                                    LOGGER.error("\u62fc\u97f3\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                                }
                            } else {
                                XmlCursor xmlCursor = ctr.newCursor();
                                xmlCursor.removeXmlContents();
                            }
                        }
                        if (text.equals("\n") && HussarUtils.isNotEmpty((Object)(brList2 = ctr.getBrList()))) {
                            ctr.removeBr(0);
                        }
                        if (c.toString().equals("\n")) {
                            xwpfRun.addBreak();
                        }
                        if (fontSize != -1) {
                            xwpfRun.setFontSize(fontSize);
                        } else {
                            CTRPr rPr = ctr.getRPr();
                            if (rPr == null) {
                                rPr = ctr.addNewRPr();
                            }
                            ctSize = rPr.isSetSz() ? rPr.getSz() : rPr.addNewSz();
                            ctSize.setVal(BigInteger.valueOf(21L));
                        }
                        if (HussarUtils.isEmpty((Object)fontFamily)) {
                            fontFamily = "\u5b8b\u4f53";
                        }
                        xwpfRun.setFontFamily(fontFamily, XWPFRun.FontCharRange.ascii);
                        xwpfRun.setFontFamily(fontFamily, XWPFRun.FontCharRange.cs);
                        xwpfRun.setFontFamily(fontFamily, XWPFRun.FontCharRange.hAnsi);
                        xwpfRun.setFontFamily(fontFamily, XWPFRun.FontCharRange.eastAsia);
                        xwpfRun.setColor(color);
                        xwpfRun.setBold(bold.booleanValue());
                        xwpfRun.setItalic(italic.booleanValue());
                        xwpfRun.setUnderline(patterns);
                        xwpfRun.setUnderlineColor(underlineColor);
                        xwpfRun.setUnderlineThemeColor(String.valueOf(themeColor));
                        xwpfRun.setTextHighlightColor(String.valueOf(anEnum));
                        xwpfRun.setStrikeThrough(st.booleanValue());
                        xwpfRun.setDoubleStrikethrough(dSt.booleanValue());
                        xwpfRun.setSubscript(verticalAlign);
                        xwpfRun.setEmphasisMark(String.valueOf(eM));
                        xwpfRun.setTextPosition(tP.intValue());
                        xwpfRun.setCharacterSpacing(cS.intValue());
                        xwpfRun.setTextScale(textScale.intValue());
                        xwpfRun.setText(c.toString(), 0);
                        continue;
                    }
                    XWPFRun run = para.createRun();
                    text = run.text();
                    ctr = (CTRImpl)run.getCTR();
                    if (text.equals("\n") && HussarUtils.isNotEmpty((Object)(brList = ctr.getBrList()))) {
                        ctr.removeBr(0);
                    }
                    if (c.toString().equals("\n")) {
                        run.addBreak();
                    }
                    run.setColor(color);
                    if (HussarUtils.isEmpty((Object)fontFamily)) {
                        fontFamily = "\u5b8b\u4f53";
                    }
                    run.setFontFamily(fontFamily, XWPFRun.FontCharRange.ascii);
                    run.setFontFamily(fontFamily, XWPFRun.FontCharRange.cs);
                    run.setFontFamily(fontFamily, XWPFRun.FontCharRange.hAnsi);
                    run.setFontFamily(fontFamily, XWPFRun.FontCharRange.eastAsia);
                    run.setTextHighlightColor(String.valueOf(anEnum));
                    run.setStrikeThrough(st.booleanValue());
                    run.setDoubleStrikethrough(dSt.booleanValue());
                    run.setUnderline(patterns);
                    run.setUnderlineColor(underlineColor);
                    run.setUnderlineThemeColor(String.valueOf(themeColor));
                    run.setBold(bold.booleanValue());
                    run.setItalic(italic.booleanValue());
                    run.setEmphasisMark(String.valueOf(eM));
                    run.setTextPosition(tP.intValue());
                    run.setCharacterSpacing(cS.intValue());
                    run.setSubscript(verticalAlign);
                    run.setTextScale(textScale.intValue());
                    if (fontSize != -1) {
                        run.setFontSize(fontSize);
                    } else {
                        CTRPr rPr = ctr.getRPr();
                        if (rPr == null) {
                            rPr = ctr.addNewRPr();
                        }
                        ctSize = rPr.isSetSz() ? rPr.getSz() : rPr.addNewSz();
                        ctSize.setVal(BigInteger.valueOf(21L));
                    }
                    if (hasXml) {
                        if (HussarUtils.isNotEmpty((Object)xml)) {
                            XmlCursor xmlCursor = run.getCTR().newCursor();
                            try {
                                xmlObject = XmlObject.Factory.parse((String)xml);
                                xmlCursor.getObject().set(xmlObject);
                            }
                            catch (XmlException e) {
                                LOGGER.error("\u62fc\u97f3\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                            }
                            continue;
                        }
                        run.setText(c.toString(), 0);
                        continue;
                    }
                    run.setText(c.toString(), 0);
                }
            }
        }
    }

    private void replaceInTable1(XWPFDocument doc, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        ArrayList tables = new ArrayList();
        List pageHeaders = doc.getHeaderList();
        pageHeaders.forEach(header -> tables.addAll(header.getTables()));
        tables.addAll(doc.getTables());
        for (XWPFTable table : tables) {
            List rows = table.getRows();
            ArrayList<Integer> widths = new ArrayList<Integer>();
            for (int k = 0; k < rows.size(); ++k) {
                XWPFTableRow row = (XWPFTableRow)rows.get(k);
                List cells = row.getTableCells();
                for (int i = 0; i < cells.size(); ++i) {
                    XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                    if (k == 0) {
                        widths.add(cell.getWidth());
                    }
                    List paras = cell.getParagraphs();
                    String text = cell.getText();
                    if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) continue;
                    for (XWPFParagraph para : paras) {
                        try {
                            this.replaceInPara1(para, params, widgets, richTextMap);
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                            throw new BaseException((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private static Matcher matcher(String str) {
        return Pattern.compile("\\$\\{(.+?)\\}", 2).matcher(str);
    }

    private static void analysisPlaceholder(XWPFDocument document, Map<String, String> widgets) {
        ArrayList paragraphs = new ArrayList();
        List pageHeaders = document.getHeaderList();
        List xwpfFooters = document.getFooterList();
        pageHeaders.forEach(header -> paragraphs.addAll(header.getParagraphs()));
        xwpfFooters.forEach(footer -> paragraphs.addAll(footer.getParagraphs()));
        paragraphs.addAll(document.getParagraphs());
        for (XWPFParagraph paragraph : paragraphs) {
            String paragraphText = paragraph.getParagraphText();
            Matcher matcher = WordHandle.matcher(paragraphText);
            while (matcher.find()) {
                String key = matcher.group();
                String value = WordHandle.getFormValue(key);
                if (value.contains(".")) {
                    String[] split = value.split("\\.");
                    value = split[0];
                }
                if (HussarUtils.isNotEmpty((Object)widgets.get(value))) {
                    if (widgets.get(value).equals(WidgetType.CHILDREN_TABLE.getType()) || widgets.get(value).equals(WidgetType.JXDNChildrenTableAgg.getType())) continue;
                    hashMap.put(key, value);
                    continue;
                }
                if (value.equals("flowHistoryInfo")) continue;
                hashMap.put(key, value);
            }
        }
    }

    private static void analysisTable(XWPFDocument document) {
        ArrayList tables = new ArrayList();
        List pageHeaders = document.getHeaderList();
        pageHeaders.forEach(header -> tables.addAll(header.getTables()));
        tables.addAll(document.getTables());
        for (XWPFTable table : tables) {
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    Matcher matcher = WordHandle.matcher(cell.getText());
                    while (matcher.find()) {
                        String key = matcher.group();
                        String value = WordHandle.getFormValue(key);
                        hashMap.put(key, value);
                    }
                }
            }
        }
    }

    private static void wordExportHandlePre(XWPFDocument document) {
        JSONArray jsonArray = new JSONArray();
        hashMap.put("\u5b50\u8868", jsonArray);
        Iterator tablesIterator = document.getTablesIterator();
        while (tablesIterator.hasNext()) {
            XWPFTable table = (XWPFTable)tablesIterator.next();
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    String text = cell.getText();
                    String newText = "";
                    Matcher matcher = WordHandle.matcher(cell.getText());
                    while (matcher.find()) {
                        String key = matcher.group();
                        String substring = key.substring(key.indexOf("#") + 1, key.indexOf("}"));
                        if (substring.contains(".")) {
                            jsonArray.add((Object)substring);
                        }
                        String newSubstring = "\u4e3b\u8868." + substring;
                        String newKey = key.replace(substring, newSubstring);
                        newText = text.replace(key, newKey);
                        List paragraphs = cell.getParagraphs();
                        for (XWPFParagraph paragraph : paragraphs) {
                            List runs = paragraph.getRuns();
                            for (XWPFRun run : runs) {
                                run.setText("", 0);
                            }
                        }
                        XWPFParagraph paragraph = (XWPFParagraph)paragraphs.get(0);
                        List runs = paragraph.getRuns();
                        if (HussarUtils.isEmpty((Object)runs)) {
                            paragraph.createRun();
                        }
                        XWPFRun xwpfRun = (XWPFRun)paragraph.getRuns().get(0);
                        xwpfRun.setText(newText, 0);
                    }
                }
            }
        }
    }

    private void wordExportHandlePost(JSONObject parse, XWPFDocument document, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        Object object1 = parse.get((Object)"\u4e3b\u8868");
        JSONArray host = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)object1)) {
            host = (JSONArray)object1;
        }
        HashMap newTable = new HashMap();
        JSONArray jsonArray = new JSONArray();
        Object object = hashMap.get("\u5b50\u8868");
        if (HussarUtils.isNotEmpty((Object)object)) {
            jsonArray = (JSONArray)object;
            List tables = document.getTables();
            for (XWPFTable table : tables) {
                List rows = table.getRows();
                int k = 0;
                for (XWPFTableRow row : rows) {
                    boolean flag = false;
                    List tableCells = row.getTableCells();
                    for (XWPFTableCell tableCell : tableCells) {
                        String text = tableCell.getText();
                        for (Object o : jsonArray) {
                            String[] split;
                            if (!text.contains(o.toString())) continue;
                            flag = true;
                            if (!o.toString().contains(".") || (split = o.toString().split("\\.")).length <= 1) continue;
                            String tableName = split[0];
                            Object object2 = host.get(k);
                            JSONObject jsonObject = (JSONObject)object2;
                            Object object3 = jsonObject.get((Object)tableName);
                            String newKey = "${" + k + "#" + o + "}";
                            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
                            JSONObject value = new JSONObject();
                            value.put(newKey, object3);
                            map.put(newKey, value);
                            newTable.put(tableCell, map);
                        }
                    }
                    if (!flag) continue;
                    ++k;
                }
            }
        }
        for (XWPFTableCell xwpfTableCell : newTable.keySet()) {
            Map map = (Map)newTable.get(xwpfTableCell);
            String newKey = "";
            JSONObject jsonObject = new JSONObject();
            Iterator<Object> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                newKey = key = (String)iterator.next();
                jsonObject = (JSONObject)map.get(key);
            }
            XWPFParagraph paragraph = xwpfTableCell.getParagraphArray(0);
            XWPFTable cellTable = xwpfTableCell.insertNewTbl(paragraph.getCTP().newCursor());
            xwpfTableCell.removeParagraph(0);
            cellTable.getCTTbl().addNewTblPr();
            cellTable.getCTTbl().getTblPr().addNewTblW();
            cellTable.setWidth("120%");
            cellTable.setWidthType(TableWidthType.PCT);
            CTBorder ctBorderLeft = cellTable.getCTTbl().getTblPr().addNewTblBorders().addNewLeft();
            ctBorderLeft.setVal(STBorder.SINGLE);
            ctBorderLeft.setSz(new BigInteger("4"));
            CTBorder borderRight = cellTable.getCTTbl().getTblPr().getTblBorders().addNewRight();
            borderRight.setVal(STBorder.SINGLE);
            borderRight.setSz(new BigInteger("4"));
            CTBorder addNewTop = cellTable.getCTTbl().getTblPr().getTblBorders().addNewTop();
            addNewTop.setVal(STBorder.SINGLE);
            addNewTop.setSz(new BigInteger("4"));
            CTBorder addNewBottom = cellTable.getCTTbl().getTblPr().getTblBorders().addNewBottom();
            addNewBottom.setVal(STBorder.SINGLE);
            addNewBottom.setSz(new BigInteger("4"));
            CTBorder addNewInsideH = cellTable.getCTTbl().getTblPr().getTblBorders().addNewInsideH();
            addNewInsideH.setVal(STBorder.SINGLE);
            addNewInsideH.setSz(new BigInteger("4"));
            CTBorder addNewInsideV = cellTable.getCTTbl().getTblPr().getTblBorders().addNewInsideV();
            addNewInsideV.setVal(STBorder.SINGLE);
            addNewInsideV.setSz(new BigInteger("4"));
            cellTable.getCTTbl().getTblPr().addNewJc().setVal(STJc.CENTER);
            xwpfTableCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
            cellTable.removeRow(0);
            XWPFTableRow row = cellTable.insertNewTableRow(0);
            XWPFTableCell cell = row.addNewTableCell();
            cell.setWidth("100%");
            cell.setWidthType(TableWidthType.DXA);
            XWPFParagraph xwpfParagraph = cell.addParagraph();
            XWPFRun run = xwpfParagraph.createRun();
            run.setText(newKey);
            this.handleTable(document, cellTable, (Map<String, Object>)jsonObject, widgets, richTextMap);
        }
    }

    private static String getFormValue(String textPlaceholder) {
        if (textPlaceholder.contains("|")) {
            return textPlaceholder.substring(textPlaceholder.indexOf("#") + 1, textPlaceholder.indexOf("|"));
        }
        return textPlaceholder.substring(textPlaceholder.indexOf("#") + 1, textPlaceholder.indexOf("}"));
    }

    private static void getFormData(Map<String, Object> hashMap, JSONObject dataJson) {
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            Object obj;
            String key;
            block11: {
                String key1;
                String[] split;
                String value;
                block9: {
                    String key2;
                    block10: {
                        key = entry.getKey();
                        value = String.valueOf(entry.getValue());
                        obj = null;
                        if (!value.contains(".")) break block9;
                        split = value.split("\\.");
                        if (entry.getValue() instanceof JSONArray) continue;
                        if (split.length != 2) break block10;
                        key1 = split[0];
                        key2 = split[1];
                        Object obj1 = dataJson.get((Object)key1);
                        if (obj1 != null && obj1 instanceof List) {
                            List list = (List)obj1;
                            hashMap.put(key, list);
                            continue;
                        }
                        break block11;
                    }
                    if (split.length != 3) break block11;
                    key1 = split[0];
                    key2 = split[1];
                    String key3 = split[2];
                    Object obj1 = dataJson.get((Object)key1);
                    if (obj1 != null && obj1 instanceof List) {
                        List list = (List)obj1;
                        hashMap.put(key, list);
                        continue;
                    }
                    break block11;
                }
                if (value.contains("|")) {
                    split = value.split("\\|");
                    if (split.length == 2 || split.length == 3) {
                        key1 = split[0];
                        obj = dataJson.get((Object)key1);
                    }
                } else if (dataJson.containsKey((Object)value)) {
                    obj = value.equals("printUserName") && HussarUtils.isEmpty((Object)dataJson.get((Object)value)) ? "\u5916\u90e8\u7528\u6237" : dataJson.get((Object)value);
                } else {
                    if (key.equals("dataValue")) continue;
                    hashMap.remove(key);
                    continue;
                }
            }
            if (obj != null) {
                hashMap.put(key, obj);
                continue;
            }
            if (key.equals("dataValue")) continue;
            hashMap.put(key, "");
        }
    }

    private String getContent(InputStream ... ises) throws IOException {
        if (ises != null) {
            StringBuilder result = new StringBuilder();
            for (InputStream is : ises) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
            }
            return result.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo entry(String mark, JSONObject parse, String inputFilePath, String outputFilePath, String fileName, Map<String, String> widgets) {
        Long fileId = 0L;
        FileInputStream fileInputStream = null;
        Path path = Paths.get(outputFilePath, new String[0]);
        long timestamp = System.currentTimeMillis();
        Path temporaryPath = Paths.get(this.outputPath + "wordTemplate" + File.separator + "temporary" + File.separator + timestamp + ".docx", new String[0]);
        Path temporaryPathTwo = Paths.get(this.outputPath + "wordTemplate" + File.separator + "temporary" + File.separator + (timestamp + 100L) + ".docx", new String[0]);
        File filePath = new File(this.outputPath + "wordTemplate" + File.separator + "temporary" + File.separator);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        int taskState = 1;
        XWPFDocument xwpfDocument1 = null;
        XWPFTemplate template = null;
        XWPFTemplate templateTwo = null;
        FileOutputStream out = null;
        FileOutputStream outTwo = null;
        XWPFDocument document = null;
        Object documentTwo = null;
        XWPFDocument xwpfDocument = null;
        File file = null;
        File fileTwo = null;
        try (FileInputStream inputStream = new FileInputStream(inputFilePath);
             OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
             XWPFDocument document1 = new XWPFDocument((InputStream)inputStream);
             InputStream cssInput = WordHandle.class.getResourceAsStream("/wordPrint/wordPrint.css");){
            Object configure;
            ConfigureBuilder configureBuilder;
            HashMap<String, String> richTextMap = new HashMap<String, String>();
            JSONObject parse1 = new JSONObject();
            LinkedHashMap<String, List<String>> cssParse = new LinkedHashMap<String, List<String>>();
            ArrayList delParse = new ArrayList();
            ArrayList underParse = new ArrayList();
            cssParse.put("-\u5220\u9664\u7ebf-", delParse);
            cssParse.put("-\u4e0b\u5212\u7ebf-", underParse);
            String css = HussarUtils.isNotEmpty((Object)cssInput) ? this.getContent(cssInput) : "";
            if (HussarUtils.isNotEmpty((Object)parse)) {
                if (parse.containsKey((Object)"\u4e3b\u8868")) {
                    Iterator object = parse.get((Object)"\u4e3b\u8868");
                    JSONArray jsonArray = (JSONArray)object;
                    jsonArray.forEach(o -> {
                        JSONObject jsonObject = (JSONObject)o;
                        int index = jsonArray.indexOf((Object)jsonObject);
                        this.handleRich(jsonObject, widgets, parse1, css, cssParse, index);
                        for (String key : jsonObject.keySet()) {
                            this.handleSu(jsonObject, widgets, key, parse1, index);
                        }
                    });
                } else {
                    this.handleRich(parse, widgets, parse1, css, cssParse, null);
                    for (Object key : parse.keySet()) {
                        this.handleSu(parse, widgets, (String)key, parse1, null);
                    }
                }
                xwpfDocument1 = this.generateWord1(hashMap, document1, widgets, parse1, richTextMap);
                configureBuilder = Configure.builder();
                if (HussarUtils.isNotEmpty(richTextMap)) {
                    for (String key : richTextMap.keySet()) {
                        configureBuilder.bind(key, (RenderPolicy)new HtmlRenderPolicy());
                    }
                }
                configure = configureBuilder.build();
                template = XWPFTemplate.compile((XWPFDocument)xwpfDocument1, (Configure)configure);
                template.render(richTextMap);
                file = new File(temporaryPath.toString());
                out = new FileOutputStream(file);
                template.write((OutputStream)out);
                document = new XWPFDocument(Files.newInputStream(Paths.get(String.valueOf(temporaryPath), new String[0]), new OpenOption[0]));
            }
            xwpfDocument = this.generateWord(hashMap, document, widgets, parse, richTextMap);
            if (HussarUtils.isNotEmpty((Object)mark)) {
                DocxUtil.makeFullWaterMarkByWordArt(xwpfDocument, mark);
            }
            if (parse.containsKey((Object)"\u4e3b\u8868")) {
                configureBuilder = Configure.builder();
                if (HussarUtils.isNotEmpty((Object)parse1)) {
                    for (String key : parse1.keySet()) {
                        configureBuilder.bind(key, (RenderPolicy)new HtmlRenderPolicy());
                    }
                }
                configure = configureBuilder.build();
                templateTwo = XWPFTemplate.compile((XWPFDocument)xwpfDocument, (Configure)configure);
                templateTwo.render((Object)parse1);
                fileTwo = new File(temporaryPathTwo.toString());
                outTwo = new FileOutputStream(fileTwo);
                templateTwo.write((OutputStream)outTwo);
                xwpfDocument = new XWPFDocument(Files.newInputStream(Paths.get(String.valueOf(temporaryPathTwo), new String[0]), new OpenOption[0]));
            }
            List paragraphs = xwpfDocument.getParagraphs();
            this.handleHtmlColor(paragraphs, cssParse);
            this.handleTableHtmlColor(xwpfDocument, cssParse);
            try {
                BodyElementType type;
                IBodyElement iBodyElement;
                boolean delLastP = false;
                int paraPos = 0;
                List bodyElements = xwpfDocument.getBodyElements();
                if (HussarUtils.isNotEmpty((Object)bodyElements) && HussarUtils.isNotEmpty((Object)(iBodyElement = (IBodyElement)bodyElements.get(bodyElements.size() - 1))) && (type = iBodyElement.getElementType()) == BodyElementType.PARAGRAPH) {
                    XWPFParagraph paragraph;
                    paraPos = bodyElements.size() - 1;
                    List paragraphs1 = xwpfDocument.getParagraphs();
                    if (HussarUtils.isNotEmpty((Object)paragraphs1) && HussarUtils.isEmpty((Object)(paragraph = (XWPFParagraph)paragraphs1.get(paragraphs1.size() - 1)).getRuns()) && HussarUtils.isEmpty((Object)paragraph.getFootnoteText())) {
                        delLastP = true;
                    }
                }
                if (delLastP && paraPos != 0) {
                    xwpfDocument.removeBodyElement(paraPos);
                    LOGGER.info("word\u6253\u5370\u6a21\u677f\u5220\u9664\u7a7a\u6bb5\u843d\u6210\u529f");
                }
            }
            catch (Exception e) {
                LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u5220\u9664\u7a7a\u6bb5\u843d\u5931\u8d25", (Throwable)e);
            }
            xwpfDocument.write(outputStream);
            fileInputStream = new FileInputStream(new File(outputFilePath));
            int length = fileInputStream.available();
            byte[] fileBytes = new byte[length];
            int bytesRead = fileInputStream.read(fileBytes);
            MockMultipartFile multipartFile = new MockMultipartFile(fileName, fileName, ".docx", fileBytes);
            ApiResponse upload = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            fileId = (Long)upload.getData();
        }
        catch (Exception e) {
            taskState = -1;
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (xwpfDocument1 != null) {
                    xwpfDocument1.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (template != null) {
                    template.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (templateTwo != null) {
                    templateTwo.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (outTwo != null) {
                    outTwo.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (document != null) {
                    document.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (xwpfDocument != null) {
                    xwpfDocument.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (file.exists()) {
                file.delete();
            }
            if (HussarUtils.isNotEmpty((Object)fileTwo) && fileTwo.exists()) {
                fileTwo.delete();
            }
        }
        hashMap.clear();
        return new TaskInfo(taskState, fileId);
    }

    private void handleRich(JSONObject parse, Map<String, String> widgets, JSONObject parse1, String css, Map<String, List<String>> cssParse, Integer index) {
        parse.forEach((key, value) -> {
            if (HussarUtils.isNotEmpty(widgets.get(key)) && ((String)widgets.get(key)).equals(WidgetType.JXDNRichText.getType())) {
                String contents = "<!DOCTYPE html>\n<html lang=\"zh-cn\">\n<head>\n    <meta charset=\"UTF-8\">\n    <style>\n" + css + "    </style>\n</head>\n<body>\n" + value + "</body>\n</html>";
                String html = this.matcherColor(contents);
                Document doc = Jsoup.parse((String)html);
                html = this.handleSpan(doc, cssParse, html);
                html = this.handleUnderLand(doc, cssParse, html);
                html = this.handleDelete(doc, cssParse, html);
                html = this.handleMark(doc, cssParse, html);
                this.handleTable(doc, cssParse, html);
                String oldKey = key;
                if (HussarUtils.isNotEmpty((Object)index)) {
                    key = key + index.toString();
                    parse.put(oldKey, (Object)("{{" + key + "}}"));
                    parse1.put(key, (Object)html);
                } else {
                    parse1.put(key, (Object)html);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo entryBatch(String mark, List<JSONObject> datas, String inputFilePath, String outputFilePath, String fileName, Map<String, String> widgets) throws Exception {
        Long fileId = 0L;
        FileInputStream fileInputStream = null;
        int taskState = 1;
        Path path = Paths.get(outputFilePath, new String[0]);
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        ArrayList<XWPFDocument> documents = new ArrayList<XWPFDocument>();
        ArrayList<XWPFDocument> documentList = new ArrayList<XWPFDocument>();
        ArrayList<XWPFDocument> xwpfDocuments = new ArrayList<XWPFDocument>();
        ArrayList<FileOutputStream> outputStreams = new ArrayList<FileOutputStream>();
        ArrayList<File> files = new ArrayList<File>();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> newHRIds = new ArrayList<String>();
        ArrayList<String> newFRIds = new ArrayList<String>();
        taskState = this.entryHandleBatch(mark, datas, inputFilePath, null, widgets, documents, taskState, documentList, xwpfDocuments, outputStreams, files, stringBuilder, newHRIds, newFRIds);
        try {
            XWPFDocument xmd = (XWPFDocument)documents.get(0);
            CTSectPr sectPr1 = xmd.getDocument().getBody().getSectPr();
            if ((HussarUtils.isNotEmpty((Object)xmd.getHeaderList()) || HussarUtils.isNotEmpty((Object)xmd.getFooterList())) && HussarUtils.isNotEmpty((Object)sectPr1)) {
                xmd.getDocument().getBody().unsetSectPr();
            }
            WordHandle.appendBody(xmd, stringBuilder, newHRIds, newFRIds);
            stringBuilder = null;
            LOGGER.info("\u6b63\u5728\u8f93\u51fa\u5408\u5e76\u540e\u7684\u6587\u6863");
            xmd.write(outputStream);
            LOGGER.info("\u5408\u5e76\u540e\u7684\u6587\u6863\u8f93\u51fa\u5b8c\u6210");
            fileInputStream = new FileInputStream(new File(outputFilePath));
            int length = fileInputStream.available();
            byte[] fileBytes = new byte[length];
            int bytesRead = fileInputStream.read(fileBytes);
            MockMultipartFile multipartFile = new MockMultipartFile(fileName, fileName, ".docx", fileBytes);
            ApiResponse upload = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            fileId = (Long)upload.getData();
        }
        catch (Exception ex) {
            taskState = -1;
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)ex);
        }
        finally {
            try {
                if (documents.get(0) != null) {
                    ((XWPFDocument)documents.get(0)).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ((XWPFDocument)documents.get(0)).close();
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new TaskInfo(taskState, fileId);
    }

    public static void appendBody(XWPFDocument src, StringBuilder stringBuilder, List<String> newHRIds, List<String> newFRIds) throws Exception {
        CTPageSz pageSz;
        CTSectPr sectPr;
        List headerList = src.getHeaderList();
        List footerList = src.getFooterList();
        if (HussarUtils.isEmpty((Object)headerList) && HussarUtils.isEmpty((Object)footerList) && HussarUtils.isNotEmpty((Object)stringBuilder) && (sectPr = src.getDocument().getBody().getSectPr()) != null && (pageSz = sectPr.getPgSz()) != null) {
            int width = pageSz.getW().intValue();
            int height = pageSz.getH().intValue();
            LOGGER.info("\u9875\u9762\u5bbd\u5ea6\uff1a{}", (Object)width);
            LOGGER.info("\u9875\u9762\u9ad8\u5ea6\uff1a{}", (Object)height);
            CTBody body = src.getDocument().getBody();
            CTPPr ctpPr1 = body.addNewP().addNewPPr();
            CTSectPr ctSectPr1 = ctpPr1.addNewSectPr();
            ctSectPr1.addNewType().setVal(STSectionMark.NEXT_PAGE);
            CTPageSz pageSize = ctSectPr1.addNewPgSz();
            pageSize.setOrient(STPageOrientation.LANDSCAPE);
            pageSize.setW(BigInteger.valueOf(width));
            pageSize.setH(BigInteger.valueOf(height));
        }
        CTBody src1Body = src.getDocument().getBody();
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String srcString = src1Body.xmlText();
        if (HussarUtils.isNotEmpty((Object)src.getHeaderList())) {
            ArrayList<String> headerReferences = new ArrayList<String>();
            String regex = "<w:headerReference\\sw:type=\"default\"\\sr:id=\"rId\\d+\"/>";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(srcString);
            while (matcher.find()) {
                headerReferences.add(matcher.group());
            }
            if (HussarUtils.isNotEmpty(newHRIds)) {
                newHRIds.remove(0);
            }
            if (HussarUtils.isNotEmpty(newFRIds)) {
                newFRIds.remove(0);
            }
            block1: for (String headerReference : headerReferences) {
                for (String newRId : newHRIds) {
                    if (!headerReference.contains(newRId)) continue;
                    srcString = srcString.replace(headerReference, "");
                    continue block1;
                }
            }
        }
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String mainPart = srcString.substring(srcString.indexOf(">") + 1, srcString.lastIndexOf("<"));
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(mainPart);
        sb.append((CharSequence)stringBuilder);
        LOGGER.info("\u5408\u5e76\u6587\u6863\u5b8c\u6210");
        CTBody makeBody = CTBody.Factory.parse((String)sb.append(sufix).toString());
        LOGGER.info("\u751f\u6210\u65b0Body\u5b8c\u6210");
        src1Body.set((XmlObject)makeBody);
        LOGGER.info("\u8bbe\u7f6e\u65b0Body\u5b8c\u6210");
        makeBody = null;
    }

    private int getRelationIndex(XWPFDocument doc, XWPFRelation relation) {
        int i = 1;
        for (POIXMLDocumentPart.RelationPart rp : doc.getRelationParts()) {
            if (!rp.getRelationship().getRelationshipType().equals(relation.getRelation())) continue;
            ++i;
        }
        return i;
    }

    private CTHdrFtr buildHdr(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper, XWPFParagraph[] pars) {
        CTHdrFtr hdr = this.buildHdrFtr(pars, wrapper);
        this.setHeaderReference(doc, type, wrapper);
        return hdr;
    }

    private CTHdrFtr buildHdrFooter(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper, XWPFParagraph[] pars) {
        CTHdrFtr hdr = this.buildHdrFtr(pars, wrapper);
        this.setFooterReference(doc, type, wrapper);
        return hdr;
    }

    private void setHeaderReference(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper) {
        CTHdrFtrRef ref = doc.getDocument().getBody().getSectPr().addNewHeaderReference();
        ref.setType(type);
        ref.setId(doc.getRelationId((POIXMLDocumentPart)wrapper));
    }

    private void setFooterReference(XWPFDocument doc, STHdrFtr.Enum type, XWPFHeaderFooter wrapper) {
        CTHdrFtrRef ref = doc.getDocument().getBody().getSectPr().addNewFooterReference();
        ref.setType(type);
        ref.setId(doc.getRelationId((POIXMLDocumentPart)wrapper));
    }

    private CTHdrFtr buildHdrFtr(XWPFParagraph[] paragraphs, XWPFHeaderFooter wrapper) {
        CTHdrFtr ftr = wrapper._getHdrFtr();
        if (paragraphs != null) {
            for (int i = 0; i < paragraphs.length; ++i) {
                ftr.addNewP();
                ftr.setPArray(i, paragraphs[i].getCTP());
            }
        }
        return ftr;
    }

    private void assignHeader(XWPFDocument doc, XWPFHeader hdr, STHdrFtr.Enum type) {
        List headerList = doc.getHeaderList();
        headerList.add(hdr);
    }

    private void createEmptyHeader(XWPFDocument src, List<String> newHRIds) {
        HdrDocument hdrDoc = HdrDocument.Factory.newInstance();
        XWPFRelation relation = XWPFRelation.HEADER;
        int i = this.getRelationIndex(src, relation);
        XWPFHeader wrapper = (XWPFHeader)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
        wrapper.setXWPFDocument(src);
        CTHdrFtr hdr = this.buildHdr(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
        wrapper.setHeaderFooter(hdr);
        hdrDoc.setHdr(hdr);
        String relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
        newHRIds.add(relationId);
    }

    private void createEmptyFooter(XWPFDocument src, List<String> newFRIds) {
        HdrDocument hdrDoc = HdrDocument.Factory.newInstance();
        XWPFRelation relation = XWPFRelation.FOOTER;
        int i = this.getRelationIndex(src, relation);
        XWPFFooter wrapper = (XWPFFooter)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
        wrapper.setXWPFDocument(src);
        CTHdrFtr hdr = this.buildHdrFooter(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
        wrapper.setHeaderFooter(hdr);
        hdrDoc.setHdr(hdr);
        String relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
        newFRIds.add(relationId);
    }

    private void firstSectPrHandle(XWPFDocument document1, List<String> newHRIds, List<String> newFRIds) {
        XWPFParagraph emptySectP;
        CTPPr pPr1;
        List paragraphList = document1.getParagraphs();
        CTSectPr commonSectPr = null;
        CTSectPr sectPr1 = document1.getDocument().getBody().getSectPr();
        if (HussarUtils.isNotEmpty((Object)sectPr1)) {
            if (HussarUtils.isNotEmpty((Object)sectPr1.getHeaderReferenceList())) {
                int defaultHeaderIndex = -1;
                List headerReferenceList = sectPr1.getHeaderReferenceList();
                for (CTHdrFtrRef ctHdrFtrRef : headerReferenceList) {
                    if (!ctHdrFtrRef.getId().equals(newHRIds.get(0))) continue;
                    defaultHeaderIndex = headerReferenceList.indexOf(ctHdrFtrRef);
                }
                if (defaultHeaderIndex != -1) {
                    sectPr1.removeHeaderReference(defaultHeaderIndex);
                }
            }
            if (HussarUtils.isNotEmpty((Object)sectPr1.getFooterReferenceList())) {
                int defaultFIndex = -1;
                List footerReferenceList = sectPr1.getFooterReferenceList();
                Iterator iterator = footerReferenceList.iterator();
                while (iterator.hasNext()) {
                    CTHdrFtrRef ctHdrFtrRef;
                    ctHdrFtrRef = (CTHdrFtrRef)iterator.next();
                    if (!ctHdrFtrRef.getId().equals(newFRIds.get(0))) continue;
                    defaultFIndex = footerReferenceList.indexOf(ctHdrFtrRef);
                }
                if (defaultFIndex != -1) {
                    sectPr1.removeFooterReference(defaultFIndex);
                }
            }
            commonSectPr = sectPr1;
        }
        ArrayList<XWPFParagraph> emptySectPs = new ArrayList<XWPFParagraph>();
        for (XWPFParagraph paragraph : paragraphList) {
            CTPPr pPr = paragraph.getCTP().getPPr();
            if (pPr == null) continue;
            CTSectPr sectPr = pPr.getSectPr();
            if (sectPr != null) {
                List footerReferenceList;
                List headerReferenceList = sectPr.getHeaderReferenceList();
                if (HussarUtils.isEmpty((Object)headerReferenceList) && HussarUtils.isNotEmpty(newHRIds)) {
                    emptySectPs.clear();
                    String emptyId = newHRIds.get(0);
                    CTHdrFtrRef ctHdrFtrRef = sectPr.addNewHeaderReference();
                    ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
                    ctHdrFtrRef.setId(emptyId);
                }
                if (!HussarUtils.isEmpty((Object)(footerReferenceList = sectPr.getFooterReferenceList())) || !HussarUtils.isNotEmpty(newFRIds)) continue;
                emptySectPs.clear();
                String emptyId = newFRIds.get(0);
                CTHdrFtrRef ctHdrFtrRef = sectPr.addNewFooterReference();
                ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
                ctHdrFtrRef.setId(emptyId);
                continue;
            }
            emptySectPs.add(paragraph);
        }
        if (HussarUtils.isNotEmpty(emptySectPs) && (pPr1 = (emptySectP = (XWPFParagraph)emptySectPs.get(emptySectPs.size() - 1)).getCTP().getPPr()) != null) {
            CTSectPr ctSectPr = pPr1.addNewSectPr();
            XmlObject copy = commonSectPr.copy();
            ctSectPr.set(copy);
        }
    }

    private void lastSectPrHandle(XWPFDocument xwpfDocument, List<String> newHRIds, List<String> newFRIds) {
        List paragraphList = xwpfDocument.getParagraphs();
        for (XWPFParagraph paragraph : paragraphList) {
            List footerReferenceList;
            CTSectPr sectPr;
            CTPPr pPr = paragraph.getCTP().getPPr();
            if (pPr == null || (sectPr = pPr.getSectPr()) == null) continue;
            List headerReferenceList = sectPr.getHeaderReferenceList();
            if (HussarUtils.isEmpty((Object)headerReferenceList) && HussarUtils.isNotEmpty(newHRIds)) {
                String emptyId = newHRIds.get(0);
                CTHdrFtrRef ctHdrFtrRef = sectPr.addNewHeaderReference();
                ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
                ctHdrFtrRef.setId(emptyId);
            }
            if (!HussarUtils.isEmpty((Object)(footerReferenceList = sectPr.getFooterReferenceList())) || !HussarUtils.isNotEmpty(newFRIds)) continue;
            String emptyId = newFRIds.get(0);
            CTHdrFtrRef ctHdrFtrRef = sectPr.addNewFooterReference();
            ctHdrFtrRef.setType(STHdrFtr.DEFAULT);
            ctHdrFtrRef.setId(emptyId);
        }
    }

    private String getPartName(PackagePartName partName) {
        String name = partName.getName();
        String regex = "/[^/]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(name);
        String pName = matcher.find() ? matcher.group().substring(1) : "";
        return pName;
    }

    private void handleAppendWord(XWPFDocument src, List<JSONObject> datas, XWPFDocument xwpfDocument2, XmlOptions optionsOuter, StringBuilder sb, JSONObject parse, List<String> newHRIds, List<String> newFRIds) throws InvalidFormatException, IOException, XmlException {
        CTPageSz pageSz;
        CTSectPr sectPr;
        int index;
        HashMap<String, String> rId_Type = new HashMap<String, String>();
        List headerList1 = xwpfDocument2.getHeaderList();
        List footerList = xwpfDocument2.getFooterList();
        if (HussarUtils.isNotEmpty((Object)headerList1) || HussarUtils.isNotEmpty((Object)footerList)) {
            String partName;
            String relationId;
            Object ctHdrFtr;
            XWPFParagraph paragraph;
            CTHdrFtr hdr;
            XWPFHeader wrapper;
            int i;
            XWPFRelation relation;
            HdrDocument hdrDoc;
            if (datas.indexOf(parse) == datas.size() - 1) {
                this.lastSectPrHandle(xwpfDocument2, newHRIds, newFRIds);
            } else {
                this.firstSectPrHandle(xwpfDocument2, newHRIds, newFRIds);
                if (HussarUtils.isNotEmpty((Object)xwpfDocument2.getDocument().getBody().getSectPr())) {
                    xwpfDocument2.getDocument().getBody().unsetSectPr();
                }
            }
            HashMap<String, String> newRId_Type = new HashMap<String, String>();
            for (XWPFHeader xwpfHeader1 : headerList1) {
                hdrDoc = HdrDocument.Factory.newInstance();
                relation = XWPFRelation.HEADER;
                i = this.getRelationIndex(src, relation);
                wrapper = (XWPFHeader)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
                wrapper.setXWPFDocument(src);
                hdr = this.buildHdr(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
                wrapper.setHeaderFooter(hdr);
                hdrDoc.setHdr(hdr);
                for (XWPFParagraph xwpfParagraph : xwpfHeader1.getParagraphs()) {
                    paragraph = wrapper.createParagraph();
                    paragraph.getCTP().set(xwpfParagraph.getCTP().copy());
                }
                ctHdrFtr = xwpfHeader1._getHdrFtr();
                wrapper.setHeaderFooter((CTHdrFtr)ctHdrFtr);
                relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
                newHRIds.add(relationId);
                partName = this.getPartName(xwpfHeader1.getPackagePart().getPartName());
                newRId_Type.put(relationId, partName);
            }
            for (XWPFFooter xwpfFooter : footerList) {
                hdrDoc = HdrDocument.Factory.newInstance();
                relation = XWPFRelation.FOOTER;
                i = this.getRelationIndex(src, relation);
                wrapper = (XWPFFooter)src.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), i);
                wrapper.setXWPFDocument(src);
                hdr = this.buildHdr(src, STHdrFtr.DEFAULT, (XWPFHeaderFooter)wrapper, null);
                wrapper.setHeaderFooter(hdr);
                hdrDoc.setHdr(hdr);
                for (XWPFParagraph xwpfParagraph : xwpfFooter.getParagraphs()) {
                    paragraph = wrapper.createParagraph();
                    paragraph.getCTP().set(xwpfParagraph.getCTP().copy());
                }
                ctHdrFtr = xwpfFooter._getHdrFtr();
                wrapper.setHeaderFooter((CTHdrFtr)ctHdrFtr);
                relationId = src.getRelationId((POIXMLDocumentPart)wrapper);
                newFRIds.add(relationId);
                partName = this.getPartName(xwpfFooter.getPackagePart().getPartName());
                newRId_Type.put(relationId, partName);
            }
            ArrayList parts = xwpfDocument2.getPackage().getParts();
            PackagePart docPackagePart = parts.stream().filter(part -> part.getContentType().equals("application/vnd.openxmlformats-package.relationships+xml") && part.getPartName().getName().equals("/word/_rels/document.xml.rels")).findFirst().get();
            InputStream inputStream1 = docPackagePart.getInputStream();
            XmlOptions options = new XmlOptions();
            XmlObject xmlObject = XmlObject.Factory.parse((InputStream)inputStream1, (XmlOptions)options);
            String xmlString = xmlObject.toString();
            String regexForId = "Id\\s*=\\s*\"([^\"]*)\"";
            String regexForTarget = "Target\\s*=\\s*\"([^\"]*)\"";
            Pattern patternId = Pattern.compile(regexForId);
            Pattern patternTarget = Pattern.compile(regexForTarget);
            Matcher matcherId = patternId.matcher(xmlString);
            Matcher matcherTarget = patternTarget.matcher(xmlString);
            while (matcherTarget.find() && matcherId.find()) {
                if (!matcherTarget.group(1).contains("header") && !matcherTarget.group(1).contains("footer")) continue;
                rId_Type.put(matcherId.group(1), matcherTarget.group(1));
            }
            for (String rId : rId_Type.keySet()) {
                String type = (String)rId_Type.get(rId);
                for (String newRid : newRId_Type.keySet()) {
                    String newType = (String)newRId_Type.get(newRid);
                    if (!newType.equals(type)) continue;
                    rId_Type.put(rId, newRid);
                }
            }
        }
        if ((index = datas.indexOf(parse)) == 0) {
            return;
        }
        if (index != datas.size() - 1 && (sectPr = xwpfDocument2.getDocument().getBody().getSectPr()) != null && (pageSz = sectPr.getPgSz()) != null) {
            int width = pageSz.getW().intValue();
            int height = pageSz.getH().intValue();
            System.out.println("\u9875\u9762\u5bbd\u5ea6\uff1a" + width + " TWIPS");
            System.out.println("\u9875\u9762\u9ad8\u5ea6\uff1a" + height + " TWIPS");
            CTBody body = xwpfDocument2.getDocument().getBody();
            CTPPr ctpPr1 = body.addNewP().addNewPPr();
            CTSectPr ctSectPr1 = ctpPr1.addNewSectPr();
            ctSectPr1.addNewType().setVal(STSectionMark.NEXT_PAGE);
            CTPageSz pageSize = ctSectPr1.addNewPgSz();
            pageSize.setOrient(STPageOrientation.LANDSCAPE);
            pageSize.setW(BigInteger.valueOf(width));
            pageSize.setH(BigInteger.valueOf(height));
        }
        List allPictures = xwpfDocument2.getAllPictures();
        HashMap<String, String> map = new HashMap<String, String>();
        for (XWPFPictureData picture : allPictures) {
            String before = xwpfDocument2.getRelationId((POIXMLDocumentPart)picture);
            String after = src.addPictureData(picture.getData(), 6);
            map.put(before, after);
        }
        LOGGER.info("\u6b63\u5728\u5408\u5e76\u7b2c\uff1a{}\u4e2a\u6587\u6863", (Object)index);
        CTBody src2Body = xwpfDocument2.getDocument().getBody();
        String appendString = src2Body.xmlText(optionsOuter);
        src2Body = null;
        String addPart = appendString.substring(appendString.indexOf(">") + 1, appendString.lastIndexOf("<"));
        map.putAll(rId_Type);
        if (map != null && !map.isEmpty()) {
            String patter = StringUtils.join(map.keySet(), (String)"|");
            Pattern compile = Pattern.compile(patter);
            Matcher matcher = compile.matcher(addPart);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String value = (String)map.get(matcher.group());
                if (value == null) continue;
                matcher.appendReplacement(stringBuffer, value);
            }
            matcher.appendTail(stringBuffer);
            addPart = stringBuffer.toString();
        }
        appendString = null;
        sb.append(addPart);
        addPart = null;
        xwpfDocument2.close();
        xwpfDocument2 = null;
        LOGGER.info("\u7b2c\uff1a{}\u4e2a\u6587\u6863\u5408\u5e76\u5b8c\u6210", (Object)index);
    }

    public static XWPFDocument appendBody(XWPFDocument src, XWPFDocument append) throws Exception {
        CTBody src1Body = src.getDocument().getBody();
        XWPFRun run = src.createParagraph().createRun();
        run.addBreak(BreakType.PAGE);
        CTBody src2Body = append.getDocument().getBody();
        List allPictures = append.getAllPictures();
        HashMap<String, String> map = new HashMap<String, String>();
        for (XWPFPictureData picture : allPictures) {
            String before = append.getRelationId((POIXMLDocumentPart)picture);
            String after = src.addPictureData(picture.getData(), 6);
            map.put(before, after);
        }
        WordHandle.appendBody(src1Body, src2Body, map);
        return src;
    }

    private static void appendBody(CTBody src, CTBody append, Map<String, String> map) throws Exception {
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String appendString = append.xmlText(optionsOuter);
        String srcString = src.xmlText();
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String mainPart = srcString.substring(srcString.indexOf(">") + 1, srcString.lastIndexOf("<"));
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        String addPart = appendString.substring(appendString.indexOf(">") + 1, appendString.lastIndexOf("<"));
        if (map != null && !map.isEmpty()) {
            String patter = StringUtils.join(map.keySet(), (String)"|");
            Pattern compile = Pattern.compile(patter);
            Matcher matcher = compile.matcher(addPart);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String value = map.get(matcher.group());
                if (value == null) continue;
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            addPart = sb.toString();
        }
        CTBody makeBody = CTBody.Factory.parse((String)(prefix + mainPart + addPart + sufix));
        src.set((XmlObject)makeBody);
    }

    private int entryHandleBatch(String mark, List<JSONObject> datas, String inputFilePath, AttachmentManagerModelVo attachmentManagerModelVo, Map<String, String> widgets, List<XWPFDocument> documents, int taskState, List<XWPFDocument> documentList, List<XWPFDocument> xwpfDocuments, List<FileOutputStream> outputStreams, List<File> files, StringBuilder stringBuilder, List<String> newHRIds, List<String> newFRIds) throws IOException {
        InputStream cssInput;
        File filePath = new File(this.outputPath + "wordTemplate" + File.separator + "temporary" + File.separator);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        String css = HussarUtils.isNotEmpty((Object)(cssInput = WordHandle.class.getResourceAsStream("/wordPrint/wordPrint.css"))) ? this.getContent(cssInput) : "";
        FileInputStream inputStream = new FileInputStream(inputFilePath);
        ByteArrayOutputStream baos = WordHandle.cloneInputStream(inputStream);
        XmlOptions optionsOuter = new XmlOptions();
        for (JSONObject parse : datas) {
            LOGGER.info("\u6b63\u5728\u5904\u7406\u7b2c\uff1a{}\u6761\u6570\u636e", (Object)(datas.indexOf(parse) + 1));
            taskState = this.handleBatchParse(mark, datas, inputFilePath, attachmentManagerModelVo, widgets, documents, taskState, documentList, xwpfDocuments, outputStreams, files, parse, css, baos, null, optionsOuter, stringBuilder, newHRIds, newFRIds);
        }
        if (HussarUtils.isNotEmpty((Object)cssInput)) {
            cssInput.close();
        }
        inputStream.close();
        baos.close();
        return taskState;
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleBatchParse(String mark, List<JSONObject> datas, String inputFilePath, AttachmentManagerModelVo attachmentManagerModelVo, Map<String, String> widgets, List<XWPFDocument> documents, int taskState, List<XWPFDocument> documentList, List<XWPFDocument> xwpfDocuments, List<FileOutputStream> outputStreams, List<File> files, JSONObject parse, String css, ByteArrayOutputStream baos, XWPFDocument doc, XmlOptions optionsOuter, StringBuilder stringBuilder, List<String> newHRIds, List<String> newFRIds) throws IOException {
        long timestamp = System.currentTimeMillis();
        Path temporaryPath = Paths.get(this.outputPath + "wordTemplate" + File.separator + "temporary" + File.separator + timestamp + ".docx", new String[0]);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        XWPFDocument document1 = new XWPFDocument((InputStream)inputStream);
        try {
            HashMap<String, String> richTextMap = new HashMap<String, String>();
            JSONObject parseHtml = new JSONObject();
            LinkedHashMap<String, List<String>> cssParse = new LinkedHashMap<String, List<String>>();
            ArrayList delParse = new ArrayList();
            ArrayList underParse = new ArrayList();
            cssParse.put("-\u5220\u9664\u7ebf-", delParse);
            cssParse.put("-\u4e0b\u5212\u7ebf-", underParse);
            this.handleRichHtml(css, parse, widgets, cssParse, parseHtml);
            document1 = this.generateRichWord(document1, widgets, parseHtml, richTextMap, temporaryPath, cssParse, parse, outputStreams, documentList, files);
            if (HussarUtils.isNotEmpty((Object)mark)) {
                DocxUtil.makeFullWaterMarkByWordArt(document1, mark);
            }
            if (HussarUtils.isEmpty(documents)) {
                documents.add(document1);
                if (HussarUtils.isNotEmpty((Object)document1.getHeaderList())) {
                    this.createEmptyHeader(document1, newHRIds);
                }
                if (HussarUtils.isNotEmpty((Object)document1.getFooterList())) {
                    this.createEmptyFooter(document1, newFRIds);
                }
                if (HussarUtils.isNotEmpty((Object)document1.getFooterList()) || HussarUtils.isNotEmpty((Object)document1.getHeaderList())) {
                    this.firstSectPrHandle(document1, newHRIds, newFRIds);
                }
            } else {
                this.handleAppendWord(documents.get(0), datas, document1, optionsOuter, stringBuilder, parse, newHRIds, newFRIds);
            }
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            taskState = -1;
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)inputFilePath);
            LOGGER.error("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            ((InputStream)inputStream).close();
            if (datas.indexOf(parse) != 0 && HussarUtils.isNotEmpty((Object)document1)) {
                document1.close();
            }
            for (File f : files) {
                if (!HussarUtils.isNotEmpty((Object)f) || !f.exists()) continue;
                boolean delete = f.delete();
                LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)delete);
            }
        }
        if (datas.indexOf(parse) != 0 && HussarUtils.isNotEmpty((Object)document1)) {
            document1.close();
        }
        for (File f : files) {
            if (!HussarUtils.isNotEmpty((Object)f) || !f.exists()) continue;
            boolean delete = f.delete();
            LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)delete);
        }
        hashMap.clear();
        return taskState;
    }

    private void handleRichHtml(String css, JSONObject parse, Map<String, String> widgets, Map<String, List<String>> cssParse, JSONObject parseHtml) throws IOException {
        if (HussarUtils.isNotEmpty((Object)parse)) {
            this.handleRich(parse, widgets, parseHtml, css, cssParse, null);
            for (String key : parse.keySet()) {
                this.handleSu(parse, widgets, key, parseHtml, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XWPFDocument generateRichWord(XWPFDocument document1, Map<String, String> widgets, JSONObject parseHtml, Map<String, String> richTextMap, Path temporaryPath, Map<String, List<String>> cssParse, JSONObject parse, List<FileOutputStream> outputStreams, List<XWPFDocument> documentList, List<File> files) throws IOException {
        XWPFDocument xWPFDocument;
        XWPFTemplate template = null;
        FileOutputStream out = null;
        XWPFDocument document = null;
        File file = null;
        try {
            this.generateWord1(hashMap, document1, widgets, parseHtml, richTextMap);
            if (HussarUtils.isNotEmpty(richTextMap)) {
                ConfigureBuilder configureBuilder = Configure.builder();
                for (String key : richTextMap.keySet()) {
                    configureBuilder.bind(key, (RenderPolicy)new HtmlRenderPolicy());
                }
                Configure configure = configureBuilder.build();
                template = XWPFTemplate.compile((XWPFDocument)document1, (Configure)configure);
                template.render(richTextMap);
                file = new File(temporaryPath.toString());
                out = new FileOutputStream(file);
                template.write((OutputStream)out);
                document = new XWPFDocument(Files.newInputStream(Paths.get(String.valueOf(temporaryPath), new String[0]), new OpenOption[0]));
            } else {
                document = document1;
            }
            List paragraphs = document.getParagraphs();
            this.handleHtmlColor(paragraphs, cssParse);
            this.handleTableHtmlColor(document, cssParse);
            xWPFDocument = this.generateWord(hashMap, document, widgets, parse, richTextMap);
            this.closeTemplate(template);
        }
        catch (Exception e) {
            LOGGER.error("Word\u6253\u5370\u6a21\u677f\u89e3\u6790\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
        try {
            if (template != null) {
                template.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (document != null) {
                document.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (HussarUtils.isNotEmpty((Object)out)) {
            out.close();
        }
        if (!HussarUtils.isNotEmpty((Object)file)) return xWPFDocument;
        if (!file.exists()) return xWPFDocument;
        boolean delete = file.delete();
        LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)delete);
        return xWPFDocument;
        finally {
            this.closeTemplate(template);
            try {
                if (template != null) {
                    template.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (document != null) {
                    document.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (HussarUtils.isNotEmpty((Object)out)) {
                out.close();
            }
            if (HussarUtils.isNotEmpty((Object)file) && file.exists()) {
                boolean delete2 = file.delete();
                LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6:{}", (Object)delete2);
            }
        }
    }

    private void handleSu(JSONObject parse, Map<String, String> widgets, String key, JSONObject parse1, Integer index) {
        String content = "";
        String signature = "";
        String approveTime = "";
        String html = "";
        StringBuilder allBody = new StringBuilder();
        if (HussarUtils.isNotEmpty((Object)widgets.get(key)) && widgets.get(key).equals(WidgetType.JXDNSuggestion.getType())) {
            JSONArray array;
            String widgetStr = widgets.get("widgetsStr");
            JSONArray a1 = JSON.parseArray((String)widgetStr);
            for (Object o : a1) {
                JSONObject object;
                List list;
                JSONObject jsonObject;
                Object name;
                if (!(o instanceof JSONObject) || !HussarUtils.isNotEmpty((Object)(name = (jsonObject = (JSONObject)o).get((Object)"name"))) || !String.valueOf(name).equals(key) || (list = (List)(object = (JSONObject)jsonObject.get((Object)"props")).get((Object)"showFields")).size() != 1 || !((String)list.get(0)).equals("name") || !HussarUtils.isEmpty((Object)index)) continue;
                return;
            }
            Object object = parse.get((Object)key);
            if (HussarUtils.isNotEmpty((Object)object) && HussarUtils.isNotEmpty((Object)(array = JSON.parseArray((String)String.valueOf(object))))) {
                for (Object object1 : array) {
                    Object object3;
                    HashSet<String> set = new HashSet<String>();
                    String text = "";
                    if (!HussarUtils.isNotEmpty(object1)) continue;
                    JSONObject jsonObject = (JSONObject)object1;
                    Object object2 = jsonObject.get((Object)"content");
                    if (HussarUtils.isNotEmpty((Object)object2)) {
                        set.add("content");
                        content = String.valueOf(object2);
                    }
                    if (HussarUtils.isNotEmpty((Object)(object3 = jsonObject.get((Object)"signature")))) {
                        set.add("user");
                        signature = String.valueOf(object3);
                        text = "<img width=\"64px\" height=\"30px\" src=\"" + signature + "\">\n";
                    } else {
                        Object object5 = jsonObject.get((Object)"userName");
                        if (HussarUtils.isNotEmpty((Object)object5)) {
                            set.add("user");
                            text = signature = String.valueOf(object5);
                        }
                    }
                    Object object4 = jsonObject.get((Object)"approveTime");
                    if (HussarUtils.isNotEmpty((Object)object4)) {
                        set.add("time");
                        approveTime = String.valueOf(object4);
                        approveTime = this.handleApproveTime(approveTime, widgets, key);
                    }
                    html = set.contains("content") ? SuggestionTemp.getHtml() : SuggestionTemp.getNoContentHtml();
                    String body = SuggestionTemp.getBody(set);
                    String replace = body.replace("{{content}}", content).replace("{{approveTime}}", approveTime).replace("{{user}}", text);
                    allBody.append(replace);
                }
            }
            html = html.replace("{{template}}", allBody.toString());
            String oldKey = key;
            if (HussarUtils.isNotEmpty((Object)index)) {
                key = key + index.toString();
                parse.put(oldKey, (Object)("{{" + key + "}}"));
                parse1.put(key, (Object)html);
            } else {
                parse.put(key, (Object)html);
                parse1.put(key, (Object)html);
            }
        }
    }

    private String handleApproveTime(String approveTime, Map<String, String> widgets, String key) {
        String string = widgets.get("widgetsStr");
        String format = "";
        if (HussarUtils.isNotEmpty((Object)string)) {
            String widget = JSON.parseArray((String)string);
            Iterator iterator = widget.iterator();
            while (iterator.hasNext()) {
                JSONObject jsonObject;
                Object object;
                Object o = iterator.next();
                if (!HussarUtils.isNotEmpty(o) || !String.valueOf(object = (jsonObject = (JSONObject)o).get((Object)"name")).equals(key)) continue;
                Object object1 = jsonObject.get((Object)"props");
                JSONObject props = (JSONObject)object1;
                Object object2 = props.get((Object)"format");
                format = String.valueOf(object2);
                break;
            }
        }
        switch (format) {
            case "yyyy-MM-dd HH": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6";
                break;
            }
            case "yyyy-MM-dd": {
                format = "yyyy\u5e74MM\u6708dd\u65e5";
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206";
                break;
            }
            case "yyyy-MM-dd HH:mm:ss": {
                format = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
            }
        }
        long timestamp = Long.parseLong(approveTime);
        LocalDateTime dateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return dateTime.format(formatter);
    }

    private void handleTable(Document doc, Map<String, List<String>> cssParse, String html) {
    }

    private String handleMark(Document doc, Map<String, List<String>> cssParse, String html) {
        Elements marks = doc.select("mark");
        for (Element markCss : marks) {
            String cssClass = markCss.attr("class");
            String text = markCss.text();
            ArrayList<String> color = new ArrayList<String>();
            switch (cssClass) {
                case "marker-yellow": {
                    this.setCss(cssParse, markCss, text, color, "yellow");
                    break;
                }
                case "marker-green": {
                    this.setCss(cssParse, markCss, text, color, "green");
                    break;
                }
                case "marker-blue": {
                    this.setCss(cssParse, markCss, text, color, "72ccfd");
                    break;
                }
                case "marker-pink": {
                    this.setCss(cssParse, markCss, text, color, "fc7899");
                    break;
                }
                case "pen-red": {
                    this.setCss(cssParse, markCss, text, color, "e71313");
                    break;
                }
                case "pen-green": {
                    this.setCss(cssParse, markCss, text, color, "128a00");
                }
            }
        }
        return doc.html();
    }

    private String handleUnderLand(Document doc, Map<String, List<String>> cssParse, String html) {
        List<String> underParse = cssParse.get("-\u4e0b\u5212\u7ebf-");
        Elements marks = doc.select("u");
        for (Element markCss : marks) {
            String text = markCss.text();
            String patternString = "%(.*?)%";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) {
                markCss.text("%" + text + "%");
            }
            underParse.add(text);
        }
        cssParse.put("-\u4e0b\u5212\u7ebf-", underParse);
        return doc.html();
    }

    private String handleDelete(Document doc, Map<String, List<String>> cssParse, String html) {
        List<String> delParse = cssParse.get("-\u5220\u9664\u7ebf-");
        Elements marks = doc.select("s");
        for (Element markCss : marks) {
            String text = markCss.text();
            String patternString = "%(.*?)%";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) {
                markCss.text("%" + text + "%");
                delParse.add(text);
                continue;
            }
            delParse.add(matcher.group(1));
        }
        cssParse.put("-\u5220\u9664\u7ebf-", delParse);
        return doc.html();
    }

    private void setCss(Map<String, List<String>> cssParse, Element markCss, String text, List<String> color, String css) {
        String patternString = "%(.*?)%";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            text = matcher.group(1);
        }
        if (!cssParse.containsKey(text)) {
            color.add(css);
            cssParse.put(text, color);
        } else {
            cssParse.get(text).add(css);
        }
        markCss.text("%" + text + "%");
    }

    private String handleSpan(Document doc, Map<String, List<String>> cssParse, String html) {
        Elements spans = doc.select("span");
        for (Element span : spans) {
            String pattern;
            Pattern p;
            Matcher m;
            String style = span.attr("style");
            String text = span.text();
            if (!style.contains("background-color") || !(m = (p = Pattern.compile(pattern = "background-color:#[0-9a-fA-F]+;")).matcher(style)).matches()) continue;
            ArrayList<String> color = new ArrayList<String>();
            style = m.group();
            color.add(style.substring(style.indexOf("#") + 1, style.indexOf(";")));
            span.text("%" + text + "%");
            if (!cssParse.containsKey(text)) {
                cssParse.put(text, color);
                continue;
            }
            cssParse.get(text).add(style.substring(style.indexOf("#") + 1, style.indexOf(";")));
        }
        return doc.html();
    }

    private void handleHtmlColor(List<XWPFParagraph> paragraphs, Map<String, List<String>> cssParse) {
        List<String> under = cssParse.get("-\u4e0b\u5212\u7ebf-");
        List<String> del = cssParse.get("-\u5220\u9664\u7ebf-");
        for (XWPFParagraph paragraph : paragraphs) {
            List runs = paragraph.getRuns();
            block1: for (XWPFRun run : runs) {
                String text = run.text();
                for (String key : cssParse.keySet()) {
                    String patternString = "%(.*?)%";
                    Pattern pattern = Pattern.compile(patternString);
                    Matcher matcher = pattern.matcher(text);
                    if (!matcher.find()) continue;
                    String group = matcher.group(1);
                    if (key.equals(group)) {
                        run.setText("", 0);
                        run.setText(key, 0);
                        String cssParseString = "";
                        List<String> list = cssParse.get(key);
                        if (!list.isEmpty()) {
                            cssParseString = list.get(0);
                            list.remove(0);
                        }
                        if (cssParseString.equals("yellow") || cssParseString.equals("green")) {
                            run.setTextHighlightColor(cssParseString);
                            continue block1;
                        }
                        if (cssParseString.equals("e71313") || cssParseString.equals("128a00")) {
                            run.setColor(cssParseString);
                            continue block1;
                        }
                        CTShd shd = CTShd.Factory.newInstance();
                        shd.setFill((Object)cssParseString);
                        shd.setVal(STShd.CLEAR);
                        run.getCTR().getRPr().setShd(shd);
                        continue block1;
                    }
                    if (under.contains(group)) {
                        run.setUnderline(UnderlinePatterns.SINGLE);
                        under.remove(key);
                    }
                    if (!del.contains(group)) continue;
                    run.setStrikeThrough(true);
                    del.remove(key);
                }
            }
        }
    }

    private void handleTableHtmlColor(XWPFDocument doc, Map<String, List<String>> cssParse) {
        List tables = doc.getTables();
        if (HussarUtils.isNotEmpty((Object)tables)) {
            tables.forEach(xwpfTable -> {
                List rows = xwpfTable.getRows();
                if (HussarUtils.isNotEmpty((Object)rows)) {
                    rows.forEach(xwpfTableRow -> {
                        List tableCells = xwpfTableRow.getTableCells();
                        if (HussarUtils.isNotEmpty((Object)tableCells)) {
                            tableCells.forEach(xwpfTableCell -> {
                                if (HussarUtils.isNotEmpty((Object)xwpfTableCell)) {
                                    List tableCellParagraphs = xwpfTableCell.getParagraphs();
                                    this.handleHtmlColor(tableCellParagraphs, cssParse);
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private void closeFile(FileOutputStream o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeInputFile(FileInputStream o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeOutputStream(OutputStream o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeTemplate(XWPFTemplate o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void closeXWPFDocument(XWPFDocument o) {
        if (HussarUtils.isNotEmpty((Object)o)) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private String matcherColor(String htmlString) {
        HashMap hslColors = new HashMap();
        Pattern pattern = Pattern.compile("hsl\\(\\s*(\\d+),\\s*(\\d+)%\\s*,\\s*(\\d+)%\\s*\\)");
        Matcher matcher = pattern.matcher(htmlString);
        while (matcher.find()) {
            ArrayList<String> list = new ArrayList<String>();
            String hue = matcher.group(1);
            String saturation = matcher.group(2);
            String lightness = matcher.group(3);
            list.add(hue);
            list.add(saturation);
            list.add(lightness);
            hslColors.put(matcher.group(0), list);
        }
        if (HussarUtils.isNotEmpty(hslColors)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry entry : hslColors.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                double hue = Double.parseDouble((String)value.get(0));
                double saturation = Double.parseDouble((String)value.get(1));
                double lightness = Double.parseDouble((String)value.get(2));
                String hex = this.gentHex(hue, saturation, lightness);
                map.put(key, hex);
            }
            for (Map.Entry entry : map.entrySet()) {
                htmlString = htmlString.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return htmlString;
    }

    public String gentHex(double H, double S, double L) {
        int[] rgb = WordHandle.hslToRgb(H /= 360.0, S /= 100.0, L /= 100.0);
        int red = rgb[0];
        int green = rgb[1];
        int blue = rgb[2];
        return String.format("#%02x%02x%02x", red, green, blue);
    }

    private static int[] hslToRgb(double h, double s, double l) {
        double r;
        double g;
        double b;
        if (s == 0.0) {
            g = b = l;
            r = b;
        } else {
            double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
            double p = 2.0 * l - q;
            r = WordHandle.hueToRgb(p, q, h + 0.3333333333333333);
            g = WordHandle.hueToRgb(p, q, h);
            b = WordHandle.hueToRgb(p, q, h - 0.3333333333333333);
        }
        int red = (int)Math.round(r * 255.0);
        int green = (int)Math.round(g * 255.0);
        int blue = (int)Math.round(b * 255.0);
        return new int[]{red, green, blue};
    }

    private static double hueToRgb(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (t < 0.16666666666666666) {
            return p + (q - p) * 6.0 * t;
        }
        if (t < 0.5) {
            return q;
        }
        if (t < 0.6666666666666666) {
            return p + (q - p) * (0.6666666666666666 - t) * 6.0;
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void wordHandle(WordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)WordHandle.getFormatTime(timeStart));
            if (HussarUtils.isEmpty((Object)wordPrintParamsDto)) {
                throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String formId = wordPrintParamsDto.getFormId();
            String id = wordPrintParamsDto.getId();
            String templateId = wordPrintParamsDto.getTemplateId();
            String appId = wordPrintParamsDto.getAppId();
            String processInstId = wordPrintParamsDto.getProcessInstId();
            String businessId = wordPrintParamsDto.getBusinessId();
            String tabType = wordPrintParamsDto.getTabType();
            String exportType = wordPrintParamsDto.getExportType();
            String viewId = wordPrintParamsDto.getViewId();
            List filters = wordPrintParamsDto.getFilter();
            Object data = null;
            if (HussarUtils.isEmpty((Object)exportType)) {
                data = ((ApiResponse)this.sysPrintTemplateService.formQuery(formId, id, tabType, appId).getBody()).getData();
            } else {
                HashMap<String, List> params = new HashMap<String, List>();
                List ids = wordPrintParamsDto.getIds();
                if (HussarUtils.isNotEmpty((Object)ids)) {
                    Filter idsFilter = new Filter();
                    idsFilter.setField("RECORD_ID");
                    idsFilter.setMatch("AND");
                    idsFilter.setRule("_in");
                    idsFilter.setVal(String.join((CharSequence)",", ids));
                    filters.add(idsFilter);
                }
                params.put("superQueryConditionDto", filters);
                data = ((ApiResponse)this.sysPrintTemplateService.tableQuery(formId, viewId, params, appId).getBody()).getData();
            }
            if (HussarUtils.isEmpty((Object)data)) {
                throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            WidgetsAndData widgetsAndData = (WidgetsAndData)data;
            EngineResultEntity entity = widgetsAndData.getEntity();
            Map widgets = widgetsAndData.getMap();
            String jsonString = JSONObject.toJSONString((Object)entity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            JSONObject parse = (JSONObject)JSONObject.parse((String)jsonString);
            parse.put("exportType", (Object)exportType);
            parse.put("langCode", (Object)wordPrintParamsDto.getLangCode());
            if (HussarUtils.isNotEmpty((Object)processInstId) && HussarUtils.isNotEmpty((Object)businessId)) {
                BpmResponseResult result = InstanceEngineService.queryFlowHistoryInfo((String)businessId, (String)processInstId);
                JSONArray jsonArray = result.getResult();
                JSONArray jsonArray1 = new JSONArray();
                if (HussarUtils.isEmpty((Object)jsonArray)) {
                    LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u4e0d\u5b58\u5728,processInstId\uff1a{}\uff0cbusinessId\uff1a{}", (Object)processInstId, (Object)businessId);
                } else {
                    JSONObject jsonObject = (JSONObject)jsonArray.get(0);
                    Object object = jsonObject.get((Object)"completeList");
                    jsonArray1 = (JSONArray)object;
                    for (Object o2 : jsonArray1) {
                        JSONObject jsonObject1 = (JSONObject)o2;
                        jsonObject1.put("index", (Object)(jsonArray1.indexOf(o2) + 1));
                        Object object1 = jsonObject1.get((Object)"comment");
                        if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                        String comment = String.valueOf(object1);
                        try {
                            JSONObject jsonObject2 = JSONObject.parseObject((String)comment);
                            jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                        }
                        catch (Exception e) {
                            LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                        }
                    }
                }
                parse.put("flowHistoryInfo", (Object)jsonArray1);
            }
            String printTime = WordHandle.getFormatTime(System.currentTimeMillis());
            String printTimeNoHour = WordHandle.getFormatTimeNoHour(System.currentTimeMillis());
            UserDetails userDetails = wordPrintParamsDto.getUserDetails();
            if (parse.containsKey((Object)"\u4e3b\u8868")) {
                Object object = parse.get((Object)"\u4e3b\u8868");
                JSONArray jsonArray = (JSONArray)object;
                jsonArray.forEach(o -> {
                    JSONObject jsonObject = (JSONObject)o;
                    jsonObject.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
                    jsonObject.put("printDateTime", (Object)printTime);
                });
            }
            parse.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
            String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
            parse.put("printDateTime", (Object)printTime);
            JSONObject content = (JSONObject)JSONObject.parseObject((String)((SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)((Object)templateId))).getContent(), JSONObject.class);
            Long fileID = Long.valueOf(String.valueOf(content.get((Object)"id")));
            AttachmentManagerModelVo attachmentManagerServiceByFileId = this.ossService.getByFileId(fileID);
            if (HussarUtils.isEmpty((Object)attachmentManagerServiceByFileId)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)((Object)templateId));
            if (HussarUtils.isEmpty((Object)printTemplate)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            String fileName = this.handlerGeneFileName(printTemplate, printTimeNoHour, formId, parse);
            String outputPathNew = this.outputPath + "wordTemplate" + File.separator;
            Random random = new Random();
            long fileId = random.nextLong() >>> 16 & 0xFFFFL;
            String outputFilePath = outputPathNew + File.separator + fileId + ".docx";
            File file = new File(outputPathNew);
            if (!file.exists()) {
                file.mkdirs();
            }
            TaskInfo taskInfo = this.entry(mark, parse, this.downLoadCompent.copyOssFile(fileID), outputFilePath, fileName, widgets);
            taskState = taskInfo.getTaskStatus();
            fileId = taskInfo.getFileId();
            this.updateTask(taskState, fileId, taskId);
        }
        catch (Exception e) {
            try {
                LOGGER.error("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                e.printStackTrace();
                this.updateTask(-1, null, taskId);
            }
            catch (Throwable throwable) {
                long timeEnd = System.currentTimeMillis();
                LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
                EngineUserUtil.remove();
                throw throwable;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
            EngineUserUtil.remove();
        }
        long timeEnd = System.currentTimeMillis();
        LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
        EngineUserUtil.remove();
    }

    private void queryFlowHis(String processInstId, String businessId, JSONObject parse) {
        if (HussarUtils.isNotEmpty((Object)processInstId) && HussarUtils.isNotEmpty((Object)businessId)) {
            BpmResponseResult result = InstanceEngineService.queryFlowHistoryInfo((String)businessId, (String)processInstId);
            JSONArray jsonArray = result.getResult();
            JSONArray jsonArray1 = new JSONArray();
            if (HussarUtils.isEmpty((Object)jsonArray)) {
                LOGGER.error("\u6d41\u7a0b\u5386\u53f2\u4fe1\u606f\u4e0d\u5b58\u5728,processInstId\uff1a{}\uff0cbusinessId\uff1a{}", (Object)processInstId, (Object)businessId);
            } else {
                JSONObject jsonObject = (JSONObject)jsonArray.get(0);
                Object object = jsonObject.get((Object)"completeList");
                jsonArray1 = (JSONArray)object;
                for (Object o : jsonArray1) {
                    JSONObject jsonObject1 = (JSONObject)o;
                    jsonObject1.put("index", (Object)(jsonArray1.indexOf(o) + 1));
                    Object object1 = jsonObject1.get((Object)"comment");
                    if (!HussarUtils.isNotEmpty((Object)object1)) continue;
                    String comment = String.valueOf(object1);
                    try {
                        JSONObject jsonObject2 = JSONObject.parseObject((String)comment);
                        jsonObject1.put("comment", jsonObject2.get((Object)"msg"));
                    }
                    catch (Exception e) {
                        LOGGER.info("\u6d41\u7a0b\u8bc4\u8bba\u975ejson\u683c\u5f0f");
                    }
                }
            }
            parse.put("flowHistoryInfo", (Object)jsonArray1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarTransactional
    @HussarDs(value="#dataSourceKey")
    public void wordHandleBatch(WordPrintParamsDto wordPrintParamsDto, String dataSourceKey) {
        Long taskId = wordPrintParamsDto.getTaskId();
        int taskState = -1;
        long timeStart = System.currentTimeMillis();
        try {
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)WordHandle.getFormatTime(timeStart));
            if (HussarUtils.isEmpty((Object)wordPrintParamsDto)) {
                throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String formId = wordPrintParamsDto.getFormId();
            String id = wordPrintParamsDto.getId();
            String templateId = wordPrintParamsDto.getTemplateId();
            String appId = wordPrintParamsDto.getAppId();
            Map flowIds = wordPrintParamsDto.getFlowIds();
            String tabType = wordPrintParamsDto.getTabType();
            String exportType = wordPrintParamsDto.getExportType();
            String viewId = wordPrintParamsDto.getViewId();
            String langCode = wordPrintParamsDto.getLangCode();
            Object data = this.queryDataBatch(exportType, formId, viewId, id, appId, wordPrintParamsDto, tabType);
            if (HussarUtils.isEmpty((Object)data)) {
                throw new BaseException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            WidgetsAndData widgetsAndData = (WidgetsAndData)data;
            EngineResultEntity entity = widgetsAndData.getEntity();
            ArrayList<JSONObject> datas = new ArrayList<JSONObject>();
            this.handleDataBatch(entity, flowIds, datas);
            UserDetails userDetails = wordPrintParamsDto.getUserDetails();
            String printTime = WordHandle.getFormatTime(System.currentTimeMillis());
            String printTimeNoHour = WordHandle.getFormatTimeNoHour(System.currentTimeMillis());
            datas.forEach(dataItem -> {
                dataItem.put("langCode", (Object)langCode);
                dataItem.put("printUserName", (Object)(HussarUtils.isNotEmpty((Object)userDetails) ? userDetails.getUserName() : null));
                dataItem.put("printDateTime", (Object)printTime);
            });
            Map widgets = widgetsAndData.getMap();
            String mark = this.waterMarkComponent.getWaterMark(Long.valueOf(appId), userDetails);
            JSONObject content = (JSONObject)JSONObject.parseObject((String)((SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)((Object)templateId))).getContent(), JSONObject.class);
            Long fileID = Long.valueOf(String.valueOf(content.get((Object)"id")));
            AttachmentManagerModelVo attachmentManagerServiceByFileId = this.ossService.getByFileId(fileID);
            if (HussarUtils.isEmpty((Object)attachmentManagerServiceByFileId)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            SysPrintTemplate printTemplate = (SysPrintTemplate)this.sysPrintTemplateService.getById((Serializable)((Object)templateId));
            if (HussarUtils.isEmpty((Object)printTemplate)) {
                LOGGER.error("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728,\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)templateId);
                throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            JSONObject fileNameObj = new JSONObject();
            fileNameObj.put("langCode", (Object)langCode);
            fileNameObj.put("mode", (Object)FileNameMode.DEFAULT.getType());
            String fileName = this.handlerGeneFileName(printTemplate, printTimeNoHour, formId, fileNameObj);
            String outputPathNew = this.outputPath + "wordTemplate" + File.separator;
            Random random = new Random();
            long fileId = random.nextLong() >>> 16 & 0xFFFFL;
            String outputFilePath = outputPathNew + File.separator + fileId + ".docx";
            File file = new File(outputPathNew);
            if (!file.exists()) {
                file.mkdirs();
            }
            TaskInfo taskInfo = this.entryBatch(mark, datas, this.downLoadCompent.copyOssFile(fileID), outputFilePath, fileName, widgets);
            taskState = taskInfo.getTaskStatus();
            fileId = taskInfo.getFileId();
            this.updateTask(taskState, fileId, taskId);
        }
        catch (Exception e) {
            try {
                LOGGER.error("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)taskId, (Object)e.getMessage());
                this.updateTask(-1, null, taskId);
            }
            catch (Throwable throwable) {
                long timeEnd = System.currentTimeMillis();
                LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
                EngineUserUtil.remove();
                throw throwable;
            }
            long timeEnd = System.currentTimeMillis();
            LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
            EngineUserUtil.remove();
        }
        long timeEnd = System.currentTimeMillis();
        LOGGER.info("word\u6a21\u677f\u89e3\u6790\u4efb\u52a1\uff1a{}\u7ed3\u675f\uff0c\u4efb\u52a1\u72b6\u6001\uff1a{}\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u672c\u6b21\u89e3\u6790\u8017\u65f6\uff1a{}ms", (Object)taskId, (Object)(taskState == 1 ? "\u89e3\u6790\u6210\u529f" : "\u89e3\u6790\u5931\u8d25"), (Object)WordHandle.getFormatTime(timeEnd), (Object)(timeEnd - timeStart));
        EngineUserUtil.remove();
    }

    private Object queryDataBatch(String exportType, String formId, String viewId, String id, String appId, WordPrintParamsDto wordPrintParamsDto, String tabType) {
        Object data;
        if (HussarUtils.isEmpty((Object)exportType)) {
            data = ((ApiResponse)this.sysPrintTemplateService.formQuery(formId, id, tabType, appId).getBody()).getData();
        } else {
            HashMap params = new HashMap();
            ArrayList<Filter> filters = new ArrayList<Filter>();
            List ids = wordPrintParamsDto.getIds();
            if (HussarUtils.isNotEmpty((Object)ids)) {
                Filter idsFilter = new Filter();
                idsFilter.setField("RECORD_ID");
                idsFilter.setMatch("AND");
                idsFilter.setRule("_in");
                idsFilter.setVal(String.join((CharSequence)",", ids));
                filters.add(idsFilter);
            }
            params.put("superQueryConditionDto", filters);
            data = ((ApiResponse)this.sysPrintTemplateService.tableQuery(formId, viewId, params, appId).getBody()).getData();
        }
        return data;
    }

    private void handleDataBatch(EngineResultEntity entity, Map<String, Map<String, String>> flowIds, List<JSONObject> datas) {
        Object dataObj = entity.get((Object)"\u4e3b\u8868");
        if (HussarUtils.isNotEmpty((Object)dataObj)) {
            List list = (List)dataObj;
            list.forEach(o -> {
                JSONObject jsonObject = new JSONObject(o);
                String jsonString = JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                JSONObject parse = (JSONObject)JSONObject.parse((String)jsonString);
                Object object = parse.get((Object)"RECORD_ID");
                String dataId = String.valueOf(object);
                if (HussarUtils.isNotEmpty((Object)flowIds)) {
                    Map map = (Map)flowIds.get(dataId);
                    String processInstId = (String)map.get("processInstId");
                    String businessId = (String)map.get("businessId");
                    this.queryFlowHis(processInstId, businessId, parse);
                }
                datas.add(parse);
            });
        }
    }

    private void updateTask(int taskState, Long fileId, Long taskId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(SysWordPrintTask::getFileId, (Object)fileId)).set(SysWordPrintTask::getTaskStatus, (Object)taskState)).eq(SysWordPrintTask::getTaskId, (Object)taskId);
        boolean flag = this.sysWordPrintTaskService.update((Wrapper)updateWrapper);
        if (!flag) {
            LOGGER.error("\u6253\u5370\u4efb\u52a1\u66f4\u65b0\u5931\u8d25,\u4efb\u52a1id\uff1a{}", (Object)taskId);
            throw new BaseException("\u6253\u5370\u4efb\u52a1\u66f4\u65b0\u5931\u8d25");
        }
    }

    private String handlerGeneFileName(SysPrintTemplate printTemplate, String printTime, String formId, JSONObject parse) {
        String fileName = null;
        Object modeObj = parse.get((Object)"mode");
        SysPrintGeneFileName geneFileName = (SysPrintGeneFileName)JSON.parseObject((String)printTemplate.getFileName(), SysPrintGeneFileName.class);
        if (HussarUtils.isNotEmpty((Object)geneFileName)) {
            if (HussarUtils.isNotEmpty((Object)modeObj)) {
                geneFileName.setMode(Integer.parseInt(String.valueOf(modeObj)));
            }
            FileNameMode mode = FileNameMode.getFileNameMode((int)geneFileName.getMode());
            String template = geneFileName.getTemplate();
            SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
            if (HussarUtils.isEmpty((Object)sysForm)) {
                LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
                throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728");
            }
            switch (Objects.requireNonNull(mode)) {
                case DEFAULT: {
                    Object object = parse.get((Object)"langCode");
                    if (HussarUtils.isNotEmpty((Object)object)) {
                        String langCode = String.valueOf(object);
                        fileName = this.i18nUtil.getCommonI18nByKeys(langCode, sysForm.getI18nKeys(), "formName", sysForm.getFormName());
                    } else {
                        fileName = sysForm.getFormName();
                    }
                    fileName = fileName + "_" + printTime;
                    break;
                }
                case TITLE: {
                    Object o = parse.get((Object)"title");
                    fileName = String.valueOf(o);
                    break;
                }
                case TEMPLATE: {
                    JSONObject parse1 = new JSONObject();
                    parse.put("formName", (Object)sysForm.getFormName());
                    Matcher matcher = WordHandle.matcher(template);
                    while (matcher.find()) {
                        String key2 = matcher.group();
                        String value2 = matcher.group(1);
                        parse1.put(key2, (Object)value2);
                    }
                    parse.forEach((key, value) -> parse1.forEach((key1, value1) -> {
                        if (value1.equals(key)) {
                            if (HussarUtils.isEmpty((Object)value)) {
                                parse1.put(key1, (Object)"");
                            } else {
                                parse1.put(key1, value);
                            }
                        }
                    }));
                    fileName = WordHandle.replaceText(template, (Map<String, Object>)parse1);
                }
            }
        }
        if (!HussarUtils.isNull(fileName)) {
            String regex = "\\d{4}-\\d{2}-\\d{2}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(fileName);
            while (matcher.find()) {
                String group = matcher.group();
                String replace = group.replace(":", "");
                String replace1 = replace.replace("-", "");
                String replace2 = replace1.replace(" ", "_");
                fileName = fileName.replace(group, replace2);
            }
            fileName = fileName.replace(" ", "");
            fileName = fileName.replace("\\", "");
            fileName = fileName.replace("/", "");
            fileName = fileName.replace(":", "");
            fileName = fileName.replace("*", "");
            fileName = fileName.replace("?", "");
            fileName = fileName.replace("\"", "");
            fileName = fileName.replace(">", "");
            fileName = fileName.replace("<", "");
            fileName = (fileName = fileName.replace("|", "")).length() > 50 ? fileName.substring(0, 50) : fileName;
        }
        return fileName + ".docx";
    }

    private String showImage(Long id) {
        AttachmentManagerModel image;
        String absolutePath = null;
        if (HussarUtils.isNotEmpty((Object)id) && !HussarUtils.isEmpty((Object)(image = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)id)))) {
            String fileName = image.getAttachmentName();
            String fileSavePath = image.getAttachmentDir();
            String suffix = WordHandle.getSuffix(fileName);
            absolutePath = fileSavePath + id + suffix;
        }
        return absolutePath;
    }

    private byte[] showImageByte(Long id) {
        return (byte[])this.ossService.backgroundDownload(id).getData();
    }

    public static String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private static List<Double> getImageWidthAndHeight(String width, String height, int mode, double widthToHeight) {
        if (widthToHeight == 0.0) {
            widthToHeight = 1.5;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        if (mode == 0) {
            list.add(Double.parseDouble(height) * widthToHeight);
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 1) {
            list.add(Double.valueOf(width));
            list.add(Double.valueOf(height));
            return list;
        }
        if (mode == 3 || mode == 2) {
            list.add(Double.parseDouble(width));
            list.add(Double.parseDouble(width) / widthToHeight);
            return list;
        }
        list.add(Double.parseDouble(width));
        list.add(Double.parseDouble(height));
        return list;
    }

    public static String getFormatTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String getFormatTimeNoHour(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static boolean judgeImage(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.IMAGE.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.IMAGE.getType());
        }
        return false;
    }

    public static boolean judgeSuggestion(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.JXDNSuggestion.getType());
    }

    public static boolean judgeSignature(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.JXDNSignature.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.JXDNSignature.getType());
        }
        return false;
    }

    public static boolean judgeFile(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.FILE.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.FILE.getType());
    }

    public static boolean judgeRichText(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.JXDNRichText.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.JXDNRichText.getType());
    }

    public static boolean judgeTextArea(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.TEXTAREA.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.TEXTAREA.getType());
    }

    public static boolean judgeSelect(String tmp, Map<String, String> widgets) {
        int endIndex;
        int startIndex = tmp.indexOf(35) + 1;
        String result = tmp.substring(startIndex, endIndex = tmp.indexOf(125));
        if (result.contains(".")) {
            String[] strings = result.split("\\.");
            if (strings.length == 2) {
                result = strings[1];
                if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                    return false;
                }
                return widgets.get(result).equals(WidgetType.CHECK_BOX_GROUP.getType()) || widgets.get(result).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(result).equals(WidgetType.SELECT.getType()) || widgets.get(result).equals(WidgetType.RADIO_GROUP.getType());
            }
            return false;
        }
        if (HussarUtils.isEmpty((Object)widgets.get(result))) {
            return false;
        }
        return widgets.get(result).equals(WidgetType.CHECK_BOX_GROUP.getType()) || widgets.get(result).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(result).equals(WidgetType.SELECT.getType()) || widgets.get(result).equals(WidgetType.RADIO_GROUP.getType());
    }

    public static boolean judgeInputOrSer(String tmp, Map<String, String> widgets) {
        if (tmp.contains("|")) {
            int endIndex;
            int startIndex = tmp.indexOf(35) + 1;
            String result = tmp.substring(startIndex, endIndex = tmp.indexOf(124, startIndex));
            if (result.contains(".")) {
                String[] strings = result.split("\\.");
                if (strings.length == 2) {
                    result = strings[1];
                    if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                        return false;
                    }
                    return widgets.get(result).equals(WidgetType.INPUT.getType()) || widgets.get(result).equals(WidgetType.JXDNSerialNumber.getType());
                }
                return false;
            }
            if (HussarUtils.isEmpty((Object)widgets.get(result))) {
                return false;
            }
            return widgets.get(result).equals(WidgetType.INPUT.getType()) || widgets.get(result).equals(WidgetType.JXDNSerialNumber.getType());
        }
        return false;
    }

    private void handleTableOptimize(XWPFDocument doc, XWPFTable table, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap) {
        List rows = table.getRows();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        HashSet<Integer> removeRows = new HashSet<Integer>();
        for (int k = 0; k < rows.size(); ++k) {
            XWPFTableRow row = (XWPFTableRow)rows.get(k);
            List cells = row.getTableCells();
            boolean flag = true;
            String tableName = "";
            int lastIndex = 0;
            boolean indexFlag = false;
            for (int i = 0; i < cells.size(); ++i) {
                XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                if (k == 0) {
                    widths.add(cell.getWidth());
                }
                List paras = cell.getParagraphs();
                String text = cell.getText();
                Matcher matcher = WordHandle.matcher(text);
                if (text.contains(".") && text.contains("$") && text.contains("{") && text.contains("#") && text.contains("}")) {
                    removeRows.add(k);
                    while (matcher.find()) {
                        String[] strings;
                        Object obj = params.get(matcher.group());
                        if (!(obj instanceof List)) continue;
                        List list = (List)obj;
                        String childName = matcher.group();
                        String substring1 = childName.substring(childName.indexOf("#"), childName.indexOf("}"));
                        String currentTableName = "";
                        if (substring1.contains(".") && ((strings = substring1.split("\\.")).length == 2 || strings.length == 3)) {
                            if (!tableName.equals(strings[0])) {
                                flag = true;
                            }
                            currentTableName = strings[0];
                        }
                        if (flag) {
                            for (int j = 0; j < list.size(); ++j) {
                                XWPFTableRow tableRow = HussarUtils.isEmpty((Object)tableName) ? table.insertNewTableRow(k + j + 1) : (lastIndex < j + 1 ? table.insertNewTableRow(k + j + 1) : (XWPFTableRow)rows.get(k + j + 1));
                                Object obj1 = list.get(j);
                                JSONObject parse = (JSONObject)JSONObject.parse((String)String.valueOf(obj1));
                                indexFlag = this.handleTableForRow(doc, tableRow, cells, params, widgets, richTextMap, parse, indexFlag, i, j);
                            }
                            tableName = currentTableName;
                            lastIndex = list.size();
                        }
                        flag = false;
                    }
                    continue;
                }
                for (XWPFParagraph para : paras) {
                    try {
                        this.wpsHandlePara(para);
                        this.replaceInPara(doc, para, params, widgets, richTextMap);
                        if (!this.selectionBoxEnable) continue;
                        this.replaceSelect(para, params, widgets);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.error("word\u6253\u5370\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                        throw new BaseException((Throwable)e);
                    }
                }
            }
        }
        List collect = removeRows.stream().sorted().collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(collect)) {
            int removeNum = 0;
            for (Integer removeRow : collect) {
                removeRow = removeRow - removeNum;
                ++removeNum;
                table.removeRow(removeRow.intValue());
            }
        }
    }

    private void copyCellStyle(XWPFTableCell sourceCell, XWPFTableCell newCell) {
        newCell.getCTTc().setTcPr(sourceCell.getCTTc().getTcPr());
        newCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
        CTPPr pPr = ((CTP)sourceCell.getCTTc().getPList().get(0)).getPPr();
        if (pPr != null && pPr.getJc() != null && pPr.getJc().getVal() != null) {
            CTJc ctjc;
            CTTc cttc = newCell.getCTTc();
            CTP ctp = (CTP)cttc.getPList().get(0);
            CTPPr ctppr = ctp.getPPr();
            if (ctppr == null) {
                ctppr = ctp.addNewPPr();
            }
            if ((ctjc = ctppr.getJc()) == null) {
                ctjc = ctppr.addNewJc();
            }
            ctjc.setVal(pPr.getJc().getVal());
        }
    }

    private List<String[]> matchText(Matcher matcher1, JSONObject parse, Map<String, Object> params, String text1, Map<String, Object> map) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String key21 = "";
        String group = "";
        while (matcher1.find()) {
            String[] stringArray = new String[2];
            group = matcher1.group();
            if (group.contains(".")) {
                int endIndex;
                int startIndex = group.indexOf(35) + 1;
                String result = group.substring(startIndex, endIndex = group.indexOf(125));
                String[] split1 = result.split("\\.");
                if (split1.length == 2 || split1.length == 3) {
                    if (split1[split1.length - 1].contains("|")) {
                        String[] strings = split1[1].split("\\|");
                        if (strings.length == 3) {
                            key21 = strings[0];
                            map.put(group, parse.get((Object)key21));
                        }
                        if (strings.length == 2) {
                            key21 = strings[0];
                            map.put(group, parse.get((Object)key21));
                        }
                    } else {
                        key21 = split1[1];
                        if (split1.length == 2) {
                            map.put(group, parse.get((Object)key21));
                        } else {
                            map.put(group, result);
                        }
                    }
                }
            } else {
                String group1 = String.valueOf(params.get(group));
                map.put(group, group1);
            }
            stringArray[0] = key21;
            stringArray[1] = group;
            list.add(stringArray);
        }
        return list;
    }

    private boolean handleEmptyRow(XWPFDocument doc, XWPFTableRow tableRow, List<XWPFTableCell> cells, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap, JSONObject parse, int i, int j) {
        for (int l = 0; l < cells.size(); ++l) {
            XWPFTableCell sourceCell = cells.get(l);
            XWPFTableCell newCell = tableRow.addNewTableCell();
            this.copyCellStyle(sourceCell, newCell);
            String text1 = sourceCell.getText();
            Matcher matcher1 = WordHandle.matcher(text1);
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<String[]> strings = this.matchText(matcher1, parse, params, text1, map);
            boolean hasIndex = false;
            for (String[] string : strings) {
                String key21 = string[0];
                String group = string[1];
                if (!key21.equals("index")) continue;
                hasIndex = true;
                map.put(group, j + 1);
                break;
            }
            if (hasIndex) {
                this.handleEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], false, strings.get(0)[1], text1, map, widgets, richTextMap, j);
                continue;
            }
            this.handleNoEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], strings.get(0)[1], text1, map, widgets, richTextMap, j);
        }
        return true;
    }

    private void handleNoEmptyRow(XWPFDocument doc, XWPFTableRow tableRow, List<XWPFTableCell> cells, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap, JSONObject parse, boolean indexFlag, int i, int j) {
        for (int l = i; l < cells.size(); ++l) {
            XWPFTableCell sourceCell = cells.get(l);
            XWPFTableCell newCell = tableRow.getCell(l);
            this.copyCellStyle(sourceCell, newCell);
            String text1 = sourceCell.getText();
            Matcher matcher1 = WordHandle.matcher(text1);
            HashMap<String, Object> map = new HashMap<String, Object>();
            List<String[]> strings = this.matchText(matcher1, parse, params, text1, map);
            boolean hasIndex = false;
            for (String[] string : strings) {
                String key21 = string[0];
                String group = string[1];
                if (!key21.equals("index")) continue;
                hasIndex = true;
                map.put(group, j + 1);
                break;
            }
            if (hasIndex) {
                this.handleEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], indexFlag, strings.get(0)[1], text1, map, widgets, richTextMap, j);
                continue;
            }
            this.handleNoEmptyParse(doc, newCell, sourceCell, strings.get(0)[0], strings.get(0)[1], text1, map, widgets, richTextMap, j);
        }
    }

    private void handleEmptyParse(XWPFDocument doc, XWPFTableCell newCell, XWPFTableCell sourceCell, String key21, boolean indexFlag, String group, String text1, Map<String, Object> map, Map<String, String> widgets, Map<String, String> richTextMap, int j) {
        XWPFRun sourceRun;
        XWPFRun run;
        List paragraphs = newCell.getParagraphs();
        XWPFParagraph newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
        XWPFParagraph sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
        if (sourcePh.getRuns().isEmpty()) {
            run = newPh.createRun();
        } else {
            sourceRun = (XWPFRun)sourcePh.getRuns().get(0);
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            run = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
            run.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
            run.setColor(sourceRun.getColor());
            run.setBold(sourceRun.isBold());
            run.setItalic(sourceRun.isItalic());
            this.setFontSize(sourceRun.getFontSize(), run);
        }
        if ("index".equals(key21)) {
            run.setText(WordHandle.replaceText(text1, map));
        } else if (HussarUtils.isNotEmpty((Object)widgets.get(key21)) && (widgets.get(key21).equals(WidgetType.SELECT_MUL.getType()) || widgets.get(key21).equals(WidgetType.SELECT.getType()))) {
            sourceRun = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            try {
                for (XWPFRun run1 : sourcePh.getRuns()) {
                    XWPFRun runNew = newPh.createRun();
                    runNew.setText(run1.text());
                    runNew.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                    runNew.setColor(sourceRun.getColor());
                    runNew.setBold(sourceRun.isBold());
                    runNew.setItalic(sourceRun.isItalic());
                    this.setFontSize(sourceRun.getFontSize(), runNew);
                }
                this.replaceInPara(doc, newPh, map, widgets, richTextMap);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
            }
        } else {
            run.setText("");
        }
    }

    private void handleNoEmptyParse(XWPFDocument doc, XWPFTableCell newCell, XWPFTableCell sourceCell, String key21, String group, String text1, Map<String, Object> map, Map<String, String> widgets, Map<String, String> richTextMap, int j) {
        List paragraphs = newCell.getParagraphs();
        XWPFParagraph newPh = paragraphs.isEmpty() ? newCell.addParagraph() : (XWPFParagraph)paragraphs.get(0);
        XWPFParagraph sourcePh = (XWPFParagraph)sourceCell.getParagraphs().get(0);
        XWPFRun sourceRun = sourcePh.getRuns().isEmpty() ? sourcePh.createRun() : (XWPFRun)sourcePh.getRuns().get(0);
        if (WordHandle.judgeInputOrSer(text1, widgets) || WordHandle.judgeImage(text1, widgets) || WordHandle.judgeFile(text1, widgets) || WordHandle.judgeTextArea(text1, widgets) || WordHandle.judgeSelect(text1, widgets) || WordHandle.judgeSignature(text1, widgets)) {
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            try {
                for (XWPFRun run1 : sourcePh.getRuns()) {
                    XWPFRun runNew = newPh.createRun();
                    runNew.setText(run1.text());
                    runNew.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
                    runNew.setColor(sourceRun.getColor());
                    runNew.setBold(sourceRun.isBold());
                    runNew.setItalic(sourceRun.isItalic());
                    this.setFontSize(sourceRun.getFontSize(), runNew);
                }
                this.replaceInPara(doc, newPh, map, widgets, richTextMap);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("\u5b50\u8868\u5b57\u6bb5\u66ff\u6362\u5931\u8d25");
            }
        } else {
            newPh.getCTP().setPPr(sourcePh.getCTP().getPPr());
            XWPFRun run = newPh.getRuns().isEmpty() ? newPh.createRun() : (XWPFRun)newPh.getRuns().get(0);
            run.setFontFamily(((XWPFRun)sourcePh.getRuns().get(0)).getFontFamily());
            run.setColor(sourceRun.getColor());
            run.setBold(sourceRun.isBold());
            run.setItalic(sourceRun.isItalic());
            this.setFontSize(sourceRun.getFontSize(), run);
            run.setText(WordHandle.replaceText(text1, map));
        }
    }

    private boolean handleTableForRow(XWPFDocument doc, XWPFTableRow tableRow, List<XWPFTableCell> cells, Map<String, Object> params, Map<String, String> widgets, Map<String, String> richTextMap, JSONObject parse, boolean indexFlag, int i, int j) {
        if (!tableRow.getTableCells().isEmpty()) {
            this.handleNoEmptyRow(doc, tableRow, cells, params, widgets, richTextMap, parse, indexFlag, i, j);
        } else {
            indexFlag = this.handleEmptyRow(doc, tableRow, cells, params, widgets, richTextMap, parse, i, j);
        }
        return indexFlag;
    }

    public static class TaskInfo {
        private int taskStatus;
        private Long fileId;

        public int getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(int taskStatus) {
            this.taskStatus = taskStatus;
        }

        public Long getFileId() {
            return this.fileId;
        }

        public void setFileId(Long fileId) {
            this.fileId = fileId;
        }

        public TaskInfo() {
        }

        public TaskInfo(int taskStatus, Long fileId) {
            this.taskStatus = taskStatus;
            this.fileId = fileId;
        }
    }
}

