/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.plugin.service.impl;

import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.verify.PluginVerify;
import java.nio.file.Path;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginWrapper;
import org.pf4j.PropertiesPluginDescriptorFinder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PluginVerifyServiceImpl
implements PluginVerify {
    public Path verify(Path path) throws Exception {
        PropertiesPluginDescriptorFinder pluginDescriptorFinder = new PropertiesPluginDescriptorFinder();
        if (path == null) {
            throw new IllegalArgumentException("path can not be null");
        }
        if (!pluginDescriptorFinder.isApplicable(path)) {
            throw new Exception(path.toString() + " : plugin illegal");
        }
        PluginDescriptor pluginDescriptor = pluginDescriptorFinder.find(path);
        if (pluginDescriptor == null) {
            throw new Exception(path.toString() + " : Not found plugin Descriptor");
        }
        if (StringUtils.isEmpty((Object)pluginDescriptor.getPluginId())) {
            throw new Exception(path.toString() + " : Plugin id can't be empty");
        }
        if (StringUtils.isEmpty((Object)pluginDescriptor.getPluginClass())) {
            throw new Exception(path.toString() + " : Not found plugin Class");
        }
        return path;
    }

    public PluginDescriptor getPluginDescriptorByJarPath(Path path) throws Exception {
        PropertiesPluginDescriptorFinder pluginDescriptorFinder = new PropertiesPluginDescriptorFinder();
        this.verify(path);
        PluginDescriptor pluginDescriptor = pluginDescriptorFinder.find(path);
        return pluginDescriptor;
    }

    public PluginWrapper getPluginWrapper(String pluginId) {
        DefaultPluginManager pluginManager = new DefaultPluginManager();
        return pluginManager.getPlugin(pluginId);
    }
}

