/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.message.job;

import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushTaskService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class MsgPushTaskPoller
implements BasicProcessor {
    @Resource
    private SysMsgPushTaskService msgPushTaskService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    private static final Logger logger = LoggerFactory.getLogger(MsgPushTaskPoller.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult process(TaskContext context) {
        String dataSourceKey = DataModelUtil.currentDsName();
        if ("master".equals(dataSourceKey)) {
            boolean tenantOpen = TenantCacheUtil.openTenant();
            HashSet<String> connNameList = new HashSet<String>();
            Map normalTenants = new HashMap<String, DefaultTenant>();
            if (tenantOpen) {
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                normalTenants = this.sysTenantService.getNormalTenants();
            } else {
                connNameList.add("master");
                normalTenants.put("master", new DefaultTenant());
            }
            for (String connName : connNameList) {
                HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                if (hussarTenantDefinition == null) {
                    logger.error("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                }
                try {
                    HussarHttpServletRequest hussarHttpServletRequest = new HussarHttpServletRequest();
                    hussarHttpServletRequest.addHeader("tcode", hussarTenantDefinition.getTenantCode());
                    ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)hussarHttpServletRequest);
                    RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
                    HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                    this.msgPushTaskService.dealMsgTask(hussarTenantDefinition.getConnName(), hussarTenantDefinition.getTenantCode());
                }
                catch (Exception e) {
                    logger.error("\u6d88\u606f\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1\u6570\u636e\u6e90\u5207\u6362\u5f02\u5e38\uff1a", (Throwable)e);
                }
                finally {
                    HussarContextHolder.remove();
                }
            }
        }
        return new ProcessResult(true, "success");
    }
}

