/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lefttree.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.GroupViewService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GroupViewServiceImpl
implements GroupViewService {
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IHussarBaseUserBoService userBoService;

    public ApiResponse<Object> listGroup(String appId, String formId, String viewId, Map<String, Object> params) {
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)this.canvasSchemaService.get(formId).getData();
        String jsonString = JSONObject.toJSONString((Object)params.get("groupAggregation"));
        Map groupParams = (Map)JSON.parseObject((String)jsonString, HashMap.class);
        List groupNames = JSON.parseArray((String)JSONObject.toJSONString(groupParams.get("group")), String.class);
        String groupName = (String)groupNames.get(0);
        List widgets = formCanvasSchema.widgetsWithSys();
        String type = WidgetType.INPUT.getType();
        Widget currentWidget = new Widget();
        for (Widget widget : widgets) {
            if (!HussarUtils.equals((Object)widget.getName(), (Object)groupName)) continue;
            type = widget.getType();
            currentWidget = widget;
        }
        Long total = this.countTotal(appId, formId, viewId, params);
        if (HussarUtils.equals((Object)currentWidget.getType(), (Object)WidgetType.ADDRESS.getType())) {
            ArrayList<String> newGroups = new ArrayList<String>();
            newGroups.add(groupName + "_label");
            newGroups.add(groupName + "_detailed");
            newGroups.add(groupName + "_code");
            groupParams.put("group", newGroups);
            params.put("groupAggregation", groupParams);
            ResponseEntity responseEntity = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
            ApiResponse body = (ApiResponse)responseEntity.getBody();
            JSONObject result = JSON.parseObject((String)JSONObject.toJSONString((Object)body.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            result.put("total", (Object)total);
            body.setData((Object)result);
            return body;
        }
        ResponseEntity apiResponseResponseEntity = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
        ApiResponse body = (ApiResponse)apiResponseResponseEntity.getBody();
        JSONObject result = JSON.parseObject((String)JSONObject.toJSONString((Object)body.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        List dataMap = JSON.parseArray((String)JSONObject.toJSONString((Object)result.get((Object)"data"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Map.class);
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (HussarUtils.isNotEmpty((Object)result.get((Object)"data"))) {
            if (HussarUtils.equals((Object)type, (Object)WidgetType.JXDNSwitch.getType())) {
                Object textEntry = currentWidget.getProps().get((Object)"textEntry");
                List config = JSON.parseArray((String)JSONObject.toJSONString((Object)textEntry), String.class);
                for (Map map : dataMap) {
                    if (HussarUtils.isNotEmpty(map.get(groupName))) {
                        String label = (String)config.get((Integer)map.get(groupName));
                        map.put(groupName + "_label", label);
                    }
                    resultList.add(map);
                }
            } else if (HussarUtils.equals((Object)type, (Object)WidgetType.JXDNUser.getType()) || HussarUtils.equals((Object)type, (Object)WidgetType.JXDNOrg.getType())) {
                if (HussarUtils.equals((Object)groupName, (Object)"createUser_user")) {
                    ArrayList<Long> userIds = new ArrayList<Long>();
                    for (Object map : dataMap) {
                        if (!HussarUtils.isNotEmpty(map.get(groupName))) continue;
                        userIds.add((Long)map.get(groupName));
                    }
                    Map userInfo = this.userBoService.getUserInfo(userIds);
                    for (Map map : dataMap) {
                        if (HussarUtils.isNotEmpty(map.get(groupName))) {
                            String userName = HussarUtils.isNotEmpty(userInfo.get((Long)map.get(groupName))) ? ((SysUsers)userInfo.get((Long)map.get(groupName))).getUserName() : map.get(groupName).toString();
                            map.put(groupName + "_label", userName);
                        }
                        resultList.add(map);
                    }
                } else {
                    for (Map map : dataMap) {
                        if (HussarUtils.isNotEmpty(map.get(groupName))) {
                            List maps = JSON.parseArray((String)map.get(groupName).toString(), Map.class);
                            Map userMap = (Map)maps.get(0);
                            map.put(groupName + "_id", userMap.get("id"));
                            map.put(groupName + "_label", userMap.get("label"));
                        }
                        resultList.add(map);
                    }
                }
            } else if (HussarUtils.equals((Object)type, (Object)WidgetType.DATE.getType())) {
                for (Map map : dataMap) {
                    if (HussarUtils.isNotEmpty(map.get(groupName))) {
                        LocalDateTime time = LocalDateTime.parse(map.get(groupName).toString());
                        map.put(groupName, time);
                    }
                    resultList.add(map);
                }
            } else if (HussarUtils.equals((Object)type, (Object)WidgetType.NUMBER.getType())) {
                for (Map map : dataMap) {
                    if (HussarUtils.isNotEmpty(map.get(groupName))) {
                        Double number = (Double)JSON.parseObject((String)map.get(groupName).toString(), Double.class);
                        map.put(groupName, number);
                    }
                    resultList.add(map);
                }
            } else {
                resultList.addAll(dataMap);
            }
            result.put("data", resultList);
        }
        result.put("total", (Object)total);
        body.setData((Object)result);
        return body;
    }

    public ApiResponse<Object> load(String appId, String formId, String viewId, Map<String, Object> params) {
        ResponseEntity apiResponseResponseEntity = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
        return (ApiResponse)apiResponseResponseEntity.getBody();
    }

    private Long countTotal(String appId, String formId, String viewId, Map<String, Object> params) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("superQueryConditionDto", params.get("superQueryConditionDto"));
        Object[] viewIds = ViewIdEnum.sysViews().toArray(new String[0]);
        if (!HussarUtils.contains((Object[])viewIds, (Object)viewId)) {
            viewId = "";
        }
        ResponseEntity totalResult = this.formOperateExposedService.tableQuery(formId, viewId, queryParams, appId);
        Long total = 0L;
        Object data = ((ApiResponse)totalResult.getBody()).getData();
        if (HussarUtils.isNotEmpty((Object)data)) {
            PageVo pageVo = (PageVo)data;
            total = pageVo.getCount();
        }
        return total;
    }
}

