/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.extapi.service.ISysFormExtApiService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.constant.TableNameTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.dto.CopyMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormCopyService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormCheckConfigVo;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptMethod;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptMethodRelated;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptParam;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptRecord;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptMethodService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptParamService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRelatedService;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleInfo;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.util.FormCopyUtil;
import com.jxdinfo.hussar.formdesign.application.util.FormUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseSetting;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.NavLeftTreeOption;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.WidgetItem;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FormCopyServiceImpl
implements IFormCopyService {
    @Resource
    private CanvasService canvasService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private SettingSchemaService<FormSettingSchema> settingSchemaService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ViewService viewService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private AppImportInfoServiceImpl appImportInfoService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private SysMsgPushConfigService msgPushConfigService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private FormMapService formMapService;
    @Resource
    private ISysRuleInfoService ruleInfoService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private SysDataPullTaskService sysDataPullTaskService;
    @Resource
    private FormImportInfoServiceImpl formImportInfoService;
    @Resource
    private AppSyncService appSyncService;
    private static final String PUBLIC_VIEW = "public";
    @Resource
    private ScriptRecordService scriptRecordService;
    @Resource
    private ScriptMethodService scriptMethodService;
    @Resource
    private ScriptParamService scriptParamService;
    @Resource
    private ScriptRelatedService scriptRelatedService;
    @Resource
    private ISysFormExtApiService sysFormExtApiService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormCopyServiceImpl.class);

    @HussarTransactional
    public ApiResponse<Long> copyForm(SysFormDto sysFormDto) throws Exception {
        CopyMappingDto copyMappingDto = new CopyMappingDto();
        long copySysFormStart = System.currentTimeMillis();
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)sysFormDto.getId());
        Long newFormId = this.copySysForm(sysFormDto, copyMappingDto, sysForm);
        LOGGER.info("\u8868\u5355\u4fe1\u606f\u590d\u5236\u8017\u65f6\uff1a{}", (Object)ToolUtil.logTime((long)copySysFormStart));
        if (!"2".equals(sysFormDto.getFormType())) {
            long copyDesignerMidStart = System.currentTimeMillis();
            this.copyDesignerMidFile(copyMappingDto, sysFormDto, sysForm);
            LOGGER.info("\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6\u590d\u5236\u8017\u65f6\uff1a{}", (Object)ToolUtil.logTime((long)copyDesignerMidStart));
            long copyFlowDataStart = System.currentTimeMillis();
            this.copyFlowData(copyMappingDto);
            LOGGER.info("\u6d41\u7a0b\u914d\u7f6e\u590d\u5236\u8017\u65f6\uff1a{}", (Object)ToolUtil.logTime((long)copyFlowDataStart));
            long updateTableInfoStart = System.currentTimeMillis();
            this.updateTableInfo(copyMappingDto);
            LOGGER.info("\u6784\u5efa\u8868\u7ed3\u6784\u8017\u65f6\uff1a{}", (Object)ToolUtil.logTime((long)updateTableInfoStart));
            this.copyBusinessRule(copyMappingDto);
            this.copyExtensionApi(copyMappingDto);
        }
        this.appSyncService.copyForm(copyMappingDto.getNewFormId());
        return ApiResponse.success((Object)newFormId);
    }

    private void copyExtensionApi(CopyMappingDto copyMappingDto) {
        List sysFormExtApis = this.sysFormExtApiService.formExtApiAllList(copyMappingDto.getOldFormId());
        sysFormExtApis.forEach(sysFormExtApi -> {
            sysFormExtApi.setApiId(null);
            sysFormExtApi.setFormId(String.valueOf(copyMappingDto.getNewFormId()));
        });
        this.sysFormExtApiService.saveBatch((Collection)sysFormExtApis);
    }

    private Long copySysForm(SysFormDto sysFormDto, CopyMappingDto copyMappingDto, SysForm sysForm) {
        Long oldAppId;
        Long oldFormGroupId;
        Long userId = BaseSecurityUtil.getUser().getUserId();
        Long oldFormId = sysFormDto.getId();
        String oldTableName = sysForm.getTableName();
        String oldFormName = sysForm.getFormName();
        Long newFormGroupId = oldFormGroupId = sysForm.getFormGroupId();
        Long newAppId = oldAppId = sysForm.getAppId();
        sysFormDto.setFormType(sysForm.getFormType());
        String newTableName = oldTableName;
        if (sysFormDto.getUseOldTable()) {
            if (HussarUtils.isNotEmpty((Object)sysFormDto.getAppId())) {
                newAppId = sysFormDto.getAppId();
                sysForm.setAppId(newAppId);
            }
            newFormGroupId = sysFormDto.getFormGroupId();
            sysForm.setFormGroupId(newFormGroupId);
            if (HussarUtils.isEmpty((Object)sysForm.getSourceFormId())) {
                sysForm.setSourceFormId(oldFormId);
            }
            sysForm.setFormName(sysFormDto.getFormName());
            sysForm.setCreateSource(FormCreateTypeEnum.FORM_TO_FORM.getType());
            copyMappingDto.setUseOldTable(sysFormDto.getUseOldTable());
        } else {
            newTableName = HussarUtils.isNotEmpty((Object)sysFormDto.getTableName()) ? sysFormDto.getTableName() : (HussarUtils.isEmpty((Object)sysFormDto.getNameType()) ? FormUtil.generateTableName(sysForm.getFormType()) : (TableNameTypeEnum.APPEND.getType().equals(sysFormDto.getNameType()) ? oldTableName + "_" + IdWorker.getId((Object)sysForm) : (TableNameTypeEnum.REPLACE.getType().equals(sysFormDto.getNameType()) ? (sysForm.getTableName().lastIndexOf("_") == -1 ? sysForm.getTableName() : sysForm.getTableName().substring(0, sysForm.getTableName().lastIndexOf("_")) + "_" + IdWorker.getId((Object)sysForm)) : FormUtil.generateTableName(sysForm.getFormType()))));
            sysForm.setTableName(newTableName);
            if (HussarUtils.isNotEmpty((Object)sysFormDto.getFormName())) {
                sysForm.setFormName(sysFormDto.getFormName());
            } else {
                sysForm.setFormName(this.generateFormName(oldFormId));
            }
        }
        sysForm.setId(null);
        sysForm.setSeq(this.sysFormMapper.maxSeq(newAppId, sysForm.getFormGroupId()) + 1);
        sysForm.setCreator(userId);
        sysForm.setCreateTime(LocalDateTime.now());
        sysForm.setLastEditor(userId);
        sysForm.setLastTime(LocalDateTime.now());
        if ("2".equals(sysFormDto.getFormType())) {
            DashEntry dashEntry = this.dashEntryService.copyPanel(oldFormId, sysForm.getFormName());
            sysForm.setId(dashEntry.getEntryId());
        }
        this.sysFormService.save((Object)sysForm);
        if (HussarUtils.isEmpty((Object)oldFormGroupId)) {
            oldFormGroupId = 0L;
        }
        copyMappingDto.setOldAppId(oldAppId);
        copyMappingDto.setNewAppId(newAppId);
        copyMappingDto.setOldFormId(oldFormId);
        copyMappingDto.setNewFormId(sysForm.getId());
        copyMappingDto.setFormType(sysForm.getFormType());
        copyMappingDto.getFormIdMap().put(oldFormId, sysForm.getId());
        copyMappingDto.getFormNameMap().put(oldFormName, sysForm.getFormName());
        copyMappingDto.getTableNameMap().put(oldTableName, newTableName);
        copyMappingDto.getFormGroupMap().put(oldFormGroupId, newFormGroupId);
        copyMappingDto.getAppIdMap().put(oldAppId, newAppId);
        this.sysFormService.initFormDevelopRole((SysFormDto)BeanUtil.copy((Object)sysForm, SysFormDto.class));
        AppContextUtil.setAppId((String)String.valueOf(sysForm.getAppId()));
        return sysForm.getId();
    }

    private void copyDesignerMidFile(CopyMappingDto copyMappingDto, SysFormDto sysFormDto, SysForm sysForm) throws Exception {
        String oldFormId = String.valueOf(copyMappingDto.getOldFormId());
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getOldAppId()));
        FormCanvasSchema formCanvasSchema = Optional.ofNullable(this.canvasSchemaService.get(oldFormId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u590d\u5236\u65f6\uff0c\u753b\u5e03\u83b7\u53d6\u5931\u8d25!"));
        this.recordReplaceMapping(formCanvasSchema, copyMappingDto, sysFormDto, sysForm);
        HashMap<Object, Object> canvasReplaceMap = new HashMap<Object, Object>();
        HashMap titleReplaceMap = new HashMap();
        copyMappingDto.getFormNameMap().forEach((key, value) -> {
            titleReplaceMap.put("\"title\":\"" + key + "\"", "\"title\":\"" + value + "\"");
            titleReplaceMap.put("\"formTitle\":\"" + key + "\"", "\"formTitle\":\"" + value + "\"");
        });
        canvasReplaceMap.putAll(copyMappingDto.getFormIdMap());
        canvasReplaceMap.putAll(copyMappingDto.getTableNameMap());
        canvasReplaceMap.putAll(copyMappingDto.getSubTableNameMap());
        canvasReplaceMap.putAll(copyMappingDto.getProcessKeyMap());
        canvasReplaceMap.putAll(copyMappingDto.getAppIdMap());
        canvasReplaceMap.putAll(titleReplaceMap);
        Long sourceFormId = formCanvasSchema.getSourceFormId();
        formCanvasSchema = this.replaceMapping(formCanvasSchema, FormCanvasSchema.class, canvasReplaceMap);
        formCanvasSchema.setSourceFormId(sourceFormId);
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getNewAppId()));
        this.canvasSchemaService.saveOrUpdate(formCanvasSchema);
        if (HussarUtils.isNotEmpty((Object)formCanvasSchema) && !sysFormDto.isShareSerialNumberFlag()) {
            this.appImportInfoService.clearSerialNumberId(formCanvasSchema);
            if (FormCreateTypeEnum.TABLE_TO_FORM.getType().equals(formCanvasSchema.getCreateSource())) {
                formCanvasSchema.setCreateSource(null);
            }
            this.canvasService.saveCanvasForCopy(formCanvasSchema);
        }
        HashMap<Object, Object> settingReplaceMap = new HashMap<Object, Object>();
        settingReplaceMap.putAll(copyMappingDto.getFormIdMap());
        settingReplaceMap.putAll(copyMappingDto.getSubTableNameMap());
        settingReplaceMap.putAll(copyMappingDto.getAppIdMap());
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getOldAppId()));
        FormSettingSchema formSettingSchema = Optional.ofNullable(this.settingSchemaService.get(oldFormId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u590d\u5236\u65f6\uff0c\u8868\u5355\u8bbe\u7f6e\u67e5\u8be2\u5931\u8d25!"));
        formSettingSchema = this.replaceMapping(formSettingSchema, FormSettingSchema.class, settingReplaceMap);
        if (HussarUtils.isNotEmpty((Object)formSettingSchema)) {
            AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getNewAppId()));
            this.settingSchemaService.saveOrUpdate((BaseSetting)formSettingSchema, formSettingSchema.getFormId());
        }
        this.copyCustomButton(copyMappingDto);
        HashMap<Object, Object> viewReplaceMap = new HashMap<Object, Object>();
        viewReplaceMap.putAll(copyMappingDto.getTableNameMap());
        viewReplaceMap.putAll(copyMappingDto.getFormIdMap());
        viewReplaceMap.putAll(copyMappingDto.getSubTableNameMap());
        viewReplaceMap.putAll(copyMappingDto.getAppIdMap());
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getOldAppId()));
        FormViewSchema formViewSchema = Optional.ofNullable(this.viewSchemaService.get(oldFormId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u590d\u5236\u65f6\uff0c\u8868\u5355\u89c6\u56fe\u83b7\u53d6\u5931\u8d25!"));
        formViewSchema = this.replaceMapping(formViewSchema, FormViewSchema.class, viewReplaceMap);
        formViewSchema.setFormTitle((String)copyMappingDto.getFormNameMap().get(formViewSchema.getFormTitle()));
        if (HussarUtils.isNotEmpty((Object)formViewSchema)) {
            AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getNewAppId()));
            this.processLeftTree(copyMappingDto, formViewSchema.getViews());
            this.viewService.save(formViewSchema);
        }
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getOldAppId()));
        List<StaffScope> staffScopes = Optional.ofNullable(this.staffScopeScemaService.list(oldFormId)).map(FormDesignResponse::getData).orElse(new ArrayList());
        if (HussarUtils.isNotEmpty((Object)staffScopes)) {
            AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getNewAppId()));
            HashMap<Object, Object> staffReplaceMap = new HashMap<Object, Object>(copyMappingDto.getFormIdMap());
            staffReplaceMap.putAll(copyMappingDto.getAppIdMap());
            staffScopes = FormCopyUtil.castObjectToList(this.replaceMapping(staffScopes, List.class, staffReplaceMap), StaffScope.class);
            this.staffScopeScemaService.saveOrUpdateBatch(staffScopes);
        }
        this.canvasService.saveReference(formCanvasSchema, null);
        this.copyFormCheckConfig(copyMappingDto);
        this.copyMsgPush(copyMappingDto);
        if (sysFormDto.getUseOldTable() && HussarUtils.isEmpty((Object)copyMappingDto.getSubTableNameMap())) {
            for (Widget widget : formCanvasSchema.childTables()) {
                String oleSubTableName = widget.getName();
                copyMappingDto.getSubTableNameMap().put(oleSubTableName, oleSubTableName);
            }
        }
        this.copyPrintTemplate(copyMappingDto);
        this.copyFormLinkData(copyMappingDto);
        this.copyDataPull(copyMappingDto);
        this.copyDataPush(copyMappingDto);
        this.copyDataPushMap(copyMappingDto);
        this.copyPublicView(copyMappingDto);
        this.copyScriptRecord(copyMappingDto, formCanvasSchema);
    }

    private void saveReference(FormCanvasSchema formCanvasSchema) throws JsonProcessingException {
        FormCanvasSchema noReferenceSchema = (FormCanvasSchema)JSONObject.parseObject((String)JSON.toJSONString((Object)formCanvasSchema), FormCanvasSchema.class);
        noReferenceSchema.setReferences((List)Lists.newArrayListWithCapacity((int)0));
        List widgets = noReferenceSchema.getWidgets();
        if (CollectionUtil.isNotEmpty((Collection)widgets)) {
            widgets = widgets.stream().filter(w -> !WidgetType.JXDNLinkForm.getType().equals(w.getType())).collect(Collectors.toList());
            noReferenceSchema.setWidgets(widgets);
            this.canvasService.saveReference(formCanvasSchema, noReferenceSchema);
        }
    }

    private void copyPrintTemplate(CopyMappingDto copyMappingDto) {
        List printTemplates = this.sysPrintTemplateService.list((Wrapper)new LambdaQueryWrapper().eq(SysPrintTemplate::getFormId, (Object)copyMappingDto.getOldFormId()));
        this.sysPrintTemplateService.copyPrintTemplate((ImportMappingDto)copyMappingDto, printTemplates);
    }

    private void copyPublicView(CopyMappingDto copyMappingDto) {
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getOldAppId()));
        List customViews = Optional.ofNullable(this.customViewService.get(String.valueOf(copyMappingDto.getOldFormId()))).map(FormDesignResponse::getData).orElse(new ArrayList());
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getNewAppId()));
        List<DataView> publicViews = customViews.stream().filter(view -> PUBLIC_VIEW.equals(view.getCategory())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(publicViews)) {
            HashMap<Object, Object> viewReplaceMap = new HashMap<Object, Object>();
            viewReplaceMap.putAll(copyMappingDto.getTableNameMap());
            viewReplaceMap.putAll(copyMappingDto.getFormIdMap());
            viewReplaceMap.putAll(copyMappingDto.getSubTableNameMap());
            viewReplaceMap.putAll(copyMappingDto.getAppIdMap());
            publicViews = FormCopyUtil.castObjectToList(this.replaceMapping(publicViews, List.class, viewReplaceMap), DataView.class);
            this.processLeftTree(copyMappingDto, publicViews);
            List<CustomView> publicViewList = publicViews.stream().map(dataView -> this.customViewService.convertToCustomView(dataView)).collect(Collectors.toList());
            publicViewList.forEach(customView -> {
                customView.setViewId(null);
                customView.setAppId(copyMappingDto.getNewAppId());
                customView.setFormId(copyMappingDto.getNewFormId());
            });
            this.customViewService.saveBatch(publicViewList);
        }
    }

    private void copyFormCheckConfig(CopyMappingDto copyMappingDto) {
        SysFormCheckConfigVo sysFormCheckConfigVo = (SysFormCheckConfigVo)this.sysFormCheckConfigService.getFormCheckConfig(copyMappingDto.getOldFormId()).getData();
        if (HussarUtils.isNotEmpty((Object)sysFormCheckConfigVo)) {
            String checkConfig = sysFormCheckConfigVo.getCheckConfig();
            String json = JSON.parse((String)checkConfig).toString();
            for (Map.Entry entry : copyMappingDto.getSubTableNameMap().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!json.contains(key)) continue;
                json = json.replace(key, value);
            }
            sysFormCheckConfigVo.setCheckConfigId(null);
            sysFormCheckConfigVo.setCheckConfig(json);
            sysFormCheckConfigVo.setFormId(copyMappingDto.getNewFormId());
            this.sysFormCheckConfigService.save((Object)sysFormCheckConfigVo);
        }
    }

    private void copyFormLinkData(CopyMappingDto copyMappingDto) {
        this.sysFormLinkService.copyFormLinkData(copyMappingDto);
    }

    private void copyCustomButton(CopyMappingDto copyMappingDto) {
        List customButtons = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)copyMappingDto.getOldFormId()));
        List<SysCustomButton> customButtonList = FormCopyUtil.castObjectToList(JSON.parseObject((String)JSON.toJSONString((Object)customButtons), List.class), SysCustomButton.class);
        if (HussarUtils.isNotEmpty(customButtonList)) {
            this.appImportInfoService.replaceCustomButton((ImportMappingDto)copyMappingDto, customButtonList, "3");
            this.sysCustomButtonService.saveBatch(customButtonList);
            this.sysCustomButtonService.mountBtnAuth2DevelopRole(copyMappingDto.getNewAppId(), customButtons);
        }
    }

    public void processLeftTree(CopyMappingDto copyMappingDto, List<DataView> dataViews) {
        Long newAppId = copyMappingDto.getNewAppId();
        Long oldFormId = copyMappingDto.getOldFormId();
        Long newFormId = copyMappingDto.getNewFormId();
        for (DataView dataView : dataViews) {
            int viewType = dataView.getViewType();
            NavLeftTreeOption leftTreeOption = dataView.getNavLeftTreeOption();
            switch (viewType) {
                case 1: {
                    WidgetItem filterWidget = leftTreeOption.getFilterWidget();
                    filterWidget.setAppId(newAppId);
                    filterWidget.setFormId(newFormId);
                    WidgetItem linkWidget = leftTreeOption.getLinkWidget();
                    WidgetItem supWidget = leftTreeOption.getSupWidget();
                    if (!HussarUtils.equals((Object)linkWidget.getFormId(), (Object)oldFormId)) break;
                    linkWidget.setAppId(newAppId);
                    linkWidget.setFormId(newFormId);
                    supWidget.setAppId(newAppId);
                    supWidget.setFormId(newFormId);
                    break;
                }
                case 2: {
                    WidgetItem titleWidget = leftTreeOption.getTitleWidget();
                    WidgetItem linkWidget = leftTreeOption.getLinkWidget();
                    WidgetItem supWidget = leftTreeOption.getSupWidget();
                    titleWidget.setAppId(newAppId);
                    titleWidget.setFormId(newFormId);
                    linkWidget.setAppId(newAppId);
                    linkWidget.setFormId(newFormId);
                    supWidget.setAppId(newAppId);
                    supWidget.setFormId(newFormId);
                    break;
                }
            }
        }
    }

    private void copyBusinessRule(CopyMappingDto copyMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRuleInfo::getFormId, (Object)copyMappingDto.getOldFormId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List ruleCardVos = this.ruleInfoService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)ruleCardVos)) {
            for (SysRuleInfo cardVo : ruleCardVos) {
                String value;
                String key;
                RuleFullVo ruleInfoDetail = this.ruleInfoService.getRuleInfoDetail(cardVo.getRuleId());
                String ruleInfoDetailStr = JSON.toJSONString((Object)ruleInfoDetail);
                ArrayList sortedEntries = new ArrayList(copyMappingDto.getSubTableNameMap().entrySet());
                HashMap<String, String> stringMap = new HashMap<String, String>();
                for (Map.Entry entry : copyMappingDto.getFormIdMap().entrySet()) {
                    key = String.valueOf(entry.getKey());
                    value = String.valueOf(entry.getValue());
                    stringMap.put(key, value);
                }
                for (Map.Entry entry : copyMappingDto.getAppIdMap().entrySet()) {
                    key = String.valueOf(entry.getKey());
                    value = String.valueOf(entry.getValue());
                    stringMap.put(key, value);
                }
                sortedEntries.addAll(stringMap.entrySet());
                sortedEntries.sort((o1, o2) -> ((String)o2.getKey()).length() - ((String)o1.getKey()).length());
                for (Map.Entry entry : sortedEntries) {
                    ruleInfoDetailStr = ruleInfoDetailStr.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                RuleFullVo ruleInfoDetailNew = (RuleFullVo)JSONObject.parseObject((String)ruleInfoDetailStr, RuleFullVo.class);
                ruleInfoDetailNew.setRuleId(null);
                ruleInfoDetailNew.setAppId(String.valueOf(copyMappingDto.getNewAppId()));
                ruleInfoDetailNew.setSourceForm(String.valueOf(copyMappingDto.getNewFormId()));
                try {
                    this.ruleInfoService.saveRule(ruleInfoDetailNew);
                }
                catch (Exception e) {
                    LOGGER.error("\u5bfc\u5165\u4e1a\u52a1\u89c4\u5219\u65f6\uff0c\u62a5\u9519", (Throwable)e);
                }
            }
        }
    }

    private void copyMsgPush(CopyMappingDto copyMappingDto) {
        Long oldFormId = copyMappingDto.getOldFormId();
        Long newFormId = copyMappingDto.getNewFormId();
        Long newAppId = copyMappingDto.getNewAppId();
        List sysMsgPushConfigList = this.msgPushConfigService.list((Wrapper)new LambdaQueryWrapper().eq(SysMsgPushConfig::getFormId, (Object)oldFormId));
        if (HussarUtils.isNotEmpty((Object)sysMsgPushConfigList)) {
            for (SysMsgPushConfig sysMsgPushConfig : sysMsgPushConfigList) {
                sysMsgPushConfig.setId(null);
                sysMsgPushConfig.setFormId(newFormId);
                sysMsgPushConfig.setAppId(newAppId);
                SecurityUser loginUser = BaseSecurityUtil.getUser();
                sysMsgPushConfig.setCreator(loginUser.getId());
                sysMsgPushConfig.setLastEditor(loginUser.getId());
                sysMsgPushConfig.setLastTime(null);
            }
            this.msgPushConfigService.saveBatch((Collection)sysMsgPushConfigList);
        }
    }

    private void copyDataPull(CopyMappingDto copyMappingDto) {
        Long oldFormId = copyMappingDto.getOldFormId();
        Long newFormId = copyMappingDto.getNewFormId();
        Long newAppId = copyMappingDto.getNewAppId();
        List sysDataPullConfigs = this.sysDataPullService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullConfig::getFormId, (Object)oldFormId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByDesc(SysDataPullConfig::getCreateTime));
        if (HussarUtils.isNotEmpty((Object)sysDataPullConfigs)) {
            for (SysDataPullConfig sysDataPullConfig : sysDataPullConfigs) {
                List list;
                Long oldId = sysDataPullConfig.getId();
                String fileMap = sysDataPullConfig.getFieldMaps();
                Map map = copyMappingDto.getSubTableNameMap();
                ArrayList sortedEntries = new ArrayList(map.entrySet());
                sortedEntries.sort((o1, o2) -> ((String)o2.getKey()).length() - ((String)o1.getKey()).length());
                for (Map.Entry entry : sortedEntries) {
                    fileMap = fileMap.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                sysDataPullConfig.setFieldMaps(fileMap);
                sysDataPullConfig.setId(null);
                sysDataPullConfig.setFormId(newFormId);
                sysDataPullConfig.setAppId(newAppId);
                SecurityUser loginUser = BaseSecurityUtil.getUser();
                sysDataPullConfig.setCreator(loginUser.getId());
                sysDataPullConfig.setLastEditor(loginUser.getId());
                sysDataPullConfig.setLastTime(LocalDateTime.now());
                SysDataPullConfigDto sysDataPullConfigDto = new SysDataPullConfigDto();
                BeanUtils.copyProperties((Object)sysDataPullConfig, (Object)sysDataPullConfigDto);
                this.sysDataPullService.saveConfig(sysDataPullConfigDto);
                if (sysDataPullConfigDto.getTriggerAction().equals("1") && !(list = this.sysCustomButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getDataPullId, (Object)oldId)).eq(SysCustomButton::getFormId, (Object)newFormId))).isEmpty()) {
                    for (SysCustomButton customButton : list) {
                        customButton.setDataPullId(sysDataPullConfigDto.getId());
                        this.sysCustomButtonService.saveOrUpdate((Object)customButton);
                    }
                }
                if (!"1".equals(sysDataPullConfigDto.getStatus()) || !StringUtil.isNotEmpty((String)sysDataPullConfigDto.getTriggerAction()) || !sysDataPullConfigDto.getTriggerAction().equals("0") || "1".equals(sysDataPullConfigDto.getDelFlag())) continue;
                this.sysDataPullTaskService.removeByConfigId(sysDataPullConfigDto.getId());
                HussarNoCodeThreadUtil.executeUserTask(() -> this.sysDataPullTaskService.asyncGenerateTaskBySaveConfig((SysDataPullConfig)sysDataPullConfigDto));
            }
        }
    }

    private void copyDataPush(CopyMappingDto copyMappingDto) {
        Long oldFormId = copyMappingDto.getOldFormId();
        Long newFormId = copyMappingDto.getNewFormId();
        Long newAppId = copyMappingDto.getNewAppId();
        List sysDataPushConfigs = this.pushDataService.list((Wrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getFormId, (Object)oldFormId));
        if (HussarUtils.isNotEmpty((Object)sysDataPushConfigs)) {
            for (SysDataPushConfig sysDataPushConfig : sysDataPushConfigs) {
                String fileMap = sysDataPushConfig.getFieldMaps();
                Map map = copyMappingDto.getSubTableNameMap();
                ArrayList sortedEntries = new ArrayList(map.entrySet());
                sortedEntries.sort((o1, o2) -> ((String)o2.getKey()).length() - ((String)o1.getKey()).length());
                for (Map.Entry entry : sortedEntries) {
                    fileMap = fileMap.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                Long oldId = sysDataPushConfig.getId();
                sysDataPushConfig.setFieldMaps(fileMap);
                sysDataPushConfig.setId(null);
                sysDataPushConfig.setFormId(newFormId);
                sysDataPushConfig.setAppId(newAppId);
                SecurityUser securityUser = BaseSecurityUtil.getUser();
                sysDataPushConfig.setCreator(securityUser.getId());
                sysDataPushConfig.setLastEditor(securityUser.getId());
                sysDataPushConfig.setLastTime(null);
                this.pushDataService.saveOrUpdate((Object)sysDataPushConfig);
                if (!sysDataPushConfig.getTriggerAction().equals("CUSTOM")) continue;
                List list = this.sysCustomButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getDataPushId, (Object)oldId)).eq(SysCustomButton::getFormId, (Object)newFormId));
                if (ToolUtil.isNotEmpty((Object)list)) {
                    for (SysCustomButton customButton : list) {
                        customButton.setDataPushId(sysDataPushConfig.getId());
                    }
                }
                this.sysCustomButtonService.saveOrUpdateBatch((Collection)list);
            }
        }
    }

    private void copyDataPushMap(CopyMappingDto copyMappingDto) {
        Long oldFormId = copyMappingDto.getOldFormId();
        Long newFormId = copyMappingDto.getNewFormId();
        Long appId = copyMappingDto.getNewAppId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FormMap::getFormId, (Object)oldFormId);
        FormMap formMap = (FormMap)this.formMapService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)formMap)) {
            String fileMap = formMap.getFieldMap();
            Map map = copyMappingDto.getSubTableNameMap();
            ArrayList sortedEntries = new ArrayList(map.entrySet());
            sortedEntries.sort((o1, o2) -> ((String)o2.getKey()).length() - ((String)o1.getKey()).length());
            for (Map.Entry entry : sortedEntries) {
                fileMap = fileMap.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            formMap.setFieldMap(fileMap);
            formMap.setId(null);
            formMap.setFormId(newFormId);
            formMap.setAppId(appId);
            this.formMapService.save((Object)formMap);
        }
    }

    private <T> T replaceMapping(T obj, Class<T> clazz, Map<Object, Object> replaceMap) {
        String text = JSON.toJSONStringWithDateFormat(obj, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(replaceMap.entrySet());
        sortedEntries.sort((o1, o2) -> o2.getKey().toString().length() - o1.getKey().toString().length());
        for (Map.Entry entry : sortedEntries) {
            text = text.replace(entry.getKey().toString(), entry.getValue().toString());
        }
        return (T)JSON.parseObject((String)text, clazz);
    }

    private void copyFlowData(CopyMappingDto copyMappingDto) {
        if ("1".equals(copyMappingDto.getFormType())) {
            this.appImportInfoService.recordReplaceMappingOfFlow((ImportMappingDto)copyMappingDto);
            Map formWorkFlow = this.flowMigrateService.exportFormWorkflow(copyMappingDto.getOldProcessKey());
            com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto flowCopyMappingDto = new com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto();
            BeanUtils.copyProperties((Object)copyMappingDto, (Object)flowCopyMappingDto);
            if (HussarUtils.isNotEmpty((Object)copyMappingDto.getTableNameMap())) {
                Map<String, String> mainTableNameMap = copyMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
                flowCopyMappingDto.setMainTableNameMap(mainTableNameMap);
            }
            if (ToolUtil.isNotEmpty((Object)copyMappingDto.getTaskTableNameMap())) {
                Map<String, String> taskTableNameMap = copyMappingDto.getTaskTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
                flowCopyMappingDto.setTaskTableNameMap(taskTableNameMap);
            }
            flowCopyMappingDto.setMainTableBusinessKeyMap(copyMappingDto.getTableNameMap());
            flowCopyMappingDto.getMainTableBusinessKeyMap().put("RECORD_ID", "RECORD_ID");
            this.flowMigrateService.importWorkflow(formWorkFlow, flowCopyMappingDto);
        }
    }

    private void recordReplaceMapping(FormCanvasSchema formCanvasSchema, CopyMappingDto copyMappingDto, SysFormDto sysFormDto, SysForm sysForm) {
        if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
            String oldFlowIdentity;
            if (!copyMappingDto.getUseOldTable()) {
                for (Widget widget : formCanvasSchema.childTables()) {
                    String oleSubTableName = widget.getName();
                    String newSubTableName = "";
                    newSubTableName = TableNameTypeEnum.APPEND.getType().equals(sysFormDto.getNameType()) ? oleSubTableName + "_" + IdWorker.getId((Object)sysForm) : (TableNameTypeEnum.REPLACE.getType().equals(sysFormDto.getNameType()) ? (oleSubTableName.lastIndexOf("_") == -1 ? oleSubTableName : oleSubTableName.substring(0, oleSubTableName.lastIndexOf("_")) + "_" + IdWorker.getId((Object)sysForm)) : "field_jxdnchildrentable_" + RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz0123456789", (int)16));
                    copyMappingDto.getSubTableNameMap().put(oleSubTableName, newSubTableName);
                    this.storeTempGrandSonTableNameMapping(copyMappingDto, widget);
                }
            }
            if (copyMappingDto.getUseOldTable()) {
                if (HussarUtils.isEmpty((Object)formCanvasSchema.getSourceFormId())) {
                    formCanvasSchema.setSourceFormId(copyMappingDto.getOldFormId());
                }
                formCanvasSchema.setCreateSource(FormCreateTypeEnum.FORM_TO_FORM.getType());
            }
            if (HussarUtils.isNotEmpty((Object)(oldFlowIdentity = formCanvasSchema.getIdentity()))) {
                copyMappingDto.setOldProcessKey(oldFlowIdentity);
                String newFlowIdentity = oldFlowIdentity.substring(0, oldFlowIdentity.length() - 18) + RandomUtil.randomString((String)"0123456789", (int)18);
                copyMappingDto.getProcessKeyMap().put(oldFlowIdentity, newFlowIdentity);
            }
        }
    }

    private void storeTempGrandSonTableNameMapping(CopyMappingDto copyMappingDto, Widget widget) {
        List grandsonChild;
        List children = widget.getChildren();
        if (CollectionUtil.isNotEmpty((Collection)children) && CollectionUtil.isNotEmpty(grandsonChild = children.stream().filter(c -> WidgetType.CHILDREN_TABLE.getType().equals(c.getType())).collect(Collectors.toList()))) {
            for (Widget grandson : grandsonChild) {
                String oldGrandsonTableName = grandson.getName();
                String randomgrandsonName = RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz0123456789", (int)16);
                String newGrandsonTableName = "table_" + randomgrandsonName;
                copyMappingDto.getSubTableNameMap().put(oldGrandsonTableName, newGrandsonTableName);
            }
        }
    }

    private void updateTableInfo(CopyMappingDto copyMappingDto) throws Exception {
        AppContextUtil.setAppId((String)String.valueOf(copyMappingDto.getNewAppId()));
    }

    private void reSync(String formId) throws Exception {
        FormDesignResponse form = this.formOperateService.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)((FormSchema)form.getData()));
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.sync(dataModelBase);
    }

    public String fileCopyRename(String fileName, List<String> sameFolderFileNames, String suffix) {
        if (HussarUtils.isEmpty(sameFolderFileNames)) {
            return fileName;
        }
        String newFileName = fileName + " - " + suffix;
        Pattern copyPattern = Pattern.compile(fileName + " - " + suffix + "(\\(\\d+\\))?");
        ArrayList copyIndex = new ArrayList();
        sameFolderFileNames.forEach(name -> {
            Matcher copyMatcher = copyPattern.matcher((CharSequence)name);
            if (copyMatcher.matches()) {
                String indexWithBrackets = copyMatcher.group(1);
                int index = indexWithBrackets == null ? 1 : Integer.parseInt(indexWithBrackets.substring(indexWithBrackets.indexOf(40) + 1, indexWithBrackets.indexOf(41)));
                copyIndex.add(index);
            }
        });
        if (HussarUtils.isNotEmpty(copyIndex)) {
            List indexes = copyIndex.stream().distinct().sorted().collect(Collectors.toList());
            int newFileCopyIndex = 1;
            for (Integer index : indexes) {
                if (index == newFileCopyIndex++) continue;
                --newFileCopyIndex;
                break;
            }
            newFileName = newFileName + (newFileCopyIndex == 1 ? "" : "(" + newFileCopyIndex + ")");
        }
        return newFileName;
    }

    private String generateFormName(Long formId) {
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        String oldFormName = sysForm.getFormName();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysForm::getAppId, (Object)sysForm.getAppId());
        if (HussarUtils.isNull((Object)sysForm.getFormGroupId())) {
            lambdaQueryWrapper.isNull(SysForm::getFormGroupId);
        } else {
            lambdaQueryWrapper.eq(SysForm::getFormGroupId, (Object)sysForm.getFormGroupId());
        }
        List sameGroupFormList = this.sysFormService.list((Wrapper)lambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)sameGroupFormList)) {
            List<String> formNames = sameGroupFormList.stream().map(SysForm::getFormName).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            return this.fileCopyRename(oldFormName, formNames, "\u526f\u672c");
        }
        LOGGER.error("\u8868\u5355\u590d\u5236\u65f6\uff0c\u5206\u7ec4\u4e0b\u8868\u5355\u4e0d\u5b58\u5728\uff01formId:{},groupId:{}", (Object)sysForm.getId(), (Object)sysForm.getFormGroupId());
        throw new BaseException("\u8868\u5355\u590d\u5236\u65f6\uff0c\u5206\u7ec4\u4e0b\u8868\u5355\u4e0d\u5b58\u5728");
    }

    private void copyScriptRecord(CopyMappingDto copyMappingDto, FormCanvasSchema formCanvasSchema) throws Exception {
        List scriptRecords = this.scriptRecordService.list((Wrapper)new LambdaQueryWrapper().eq(ScriptRecord::getFormId, (Object)copyMappingDto.getOldFormId()));
        if (ObjectUtils.isEmpty((Object)scriptRecords)) {
            return;
        }
        HashMap<ScriptRecord, Long> recordIdMap = new HashMap<ScriptRecord, Long>();
        for (Object scriptRecord : scriptRecords) {
            recordIdMap.put((ScriptRecord)scriptRecord, scriptRecord.getId());
            scriptRecord.setFormId(String.valueOf(copyMappingDto.getNewFormId()));
            scriptRecord.setId(null);
        }
        this.scriptRecordService.saveBatch((Collection)scriptRecords);
        HashMap<Long, Long> recordIdToIdMap = new HashMap<Long, Long>();
        for (Object scriptRecord : scriptRecords) {
            Long l = (Long)recordIdMap.get(scriptRecord);
            recordIdToIdMap.put(l, scriptRecord.getId());
        }
        if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
            HashMap scriptsReferNew = Maps.newHashMapWithExpectedSize((int)5);
            for (Map.Entry entry : recordIdToIdMap.entrySet()) {
                scriptsReferNew.put(String.valueOf(recordIdToIdMap.get(entry.getKey())), entry.getValue());
            }
            formCanvasSchema.getProps().put("scriptsRefer", scriptsReferNew);
            this.canvasSchemaService.saveOrUpdate(formCanvasSchema);
        }
        LambdaQueryWrapper methodWrapper = new LambdaQueryWrapper();
        methodWrapper.in(ScriptMethod::getScriptId, recordIdMap.values());
        List scriptMethods = this.scriptMethodService.list((Wrapper)methodWrapper);
        if (ObjectUtils.isNotEmpty((Object)scriptMethods)) {
            HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
            for (Object scriptMethod : scriptMethods) {
                Long newId = (Long)recordIdToIdMap.get(scriptMethod.getScriptId());
                scriptMethod.setScriptId(newId);
                hashMap.put(scriptMethod, scriptMethod.getId());
                scriptMethod.setId(null);
            }
            this.scriptMethodService.saveBatch((Collection)scriptMethods);
            HashMap<Long, Long> methodIdToIdMap = new HashMap<Long, Long>();
            for (ScriptMethod scriptMethod : scriptMethods) {
                Long oldId = (Long)hashMap.get(scriptMethod);
                methodIdToIdMap.put(oldId, scriptMethod.getId());
            }
            LambdaQueryWrapper paramWrapper = new LambdaQueryWrapper();
            paramWrapper.in(ScriptParam::getMethodId, hashMap.values());
            List scriptParams = this.scriptParamService.list((Wrapper)paramWrapper);
            if (HussarUtils.isNotEmpty((Object)scriptParams)) {
                for (ScriptParam scriptParam : scriptParams) {
                    Long newId = (Long)methodIdToIdMap.get(scriptParam.getMethodId());
                    scriptParam.setMethodId(newId);
                    scriptParam.setId(null);
                }
                this.scriptParamService.saveBatch((Collection)scriptParams);
            }
            LambdaQueryWrapper relateWrapper = new LambdaQueryWrapper();
            relateWrapper.in(ScriptMethodRelated::getMethodId, hashMap.values());
            List scriptMethodRelateds = this.scriptRelatedService.list((Wrapper)relateWrapper);
            if (HussarUtils.isNotEmpty((Object)scriptMethodRelateds)) {
                for (ScriptMethodRelated scriptMethodRelated : scriptMethodRelateds) {
                    Long newId = (Long)methodIdToIdMap.get(scriptMethodRelated.getMethodId());
                    scriptMethodRelated.setMethodId(newId);
                    scriptMethodRelated.setId(null);
                }
                this.scriptRelatedService.saveBatch((Collection)scriptMethodRelateds);
            }
        }
    }
}

