/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.tool.aspect;

import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppPublishStatusVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.UpgradeStatusVo;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.UpgradeProgressCache;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AppUpProgressCacheAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppUpProgressCacheAspect.class);
    private static final String PUBLISH_CACHE_NAME = "publish_progress";

    @Around(value="@annotation(annotation)", argNames="joinPoint, annotation")
    public Object around(ProceedingJoinPoint joinPoint, UpgradeProgressCache annotation) throws Throwable {
        LOGGER.info("\u5347\u7ea7\u5e94\u7528: {}", (Object)annotation.msg());
        Object result = joinPoint.proceed();
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args) && args[0] instanceof AppUpgradeDto) {
            AppUpgradeDto appUpgradeDto = (AppUpgradeDto)args[0];
            if (appUpgradeDto.isCrossPublish()) {
                String publishCacheKey = (String)TransmittableThreadLocalHolder.get((String)"publishCacheKey");
                int finishedSteps = 9;
                HussarCacheUtil.put((String)PUBLISH_CACHE_NAME, (Object)publishCacheKey, (Object)new AppPublishStatusVo.Builder().status(Integer.valueOf(finishedSteps + annotation.status())).msg(annotation.msg()).finishFlag(Boolean.valueOf(annotation.finish())).errorFlag(Boolean.FALSE).build());
            } else {
                Object object = TransmittableThreadLocalHolder.get((String)"upgradeCacheKey");
                if (HussarUtils.isNotEmpty((Object)object) && object instanceof String) {
                    String upgradeCacheKey = (String)object;
                    HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().status(Integer.valueOf(annotation.status())).msg(annotation.msg()).finishFlag(Boolean.valueOf(annotation.finish())).errorFlag(Boolean.FALSE).build());
                }
            }
        }
        return result;
    }

    @AfterThrowing(value="@annotation(annotation)", argNames="joinPoint, annotation, exception", throwing="exception")
    public void afterThrowing(JoinPoint joinPoint, UpgradeProgressCache annotation, Exception exception) {
        LOGGER.error("\u5347\u7ea7\u5e94\u7528\u5931\u8d25: {}", (Object)exception.getMessage());
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args) && args[0] instanceof AppUpgradeDto) {
            AppUpgradeDto appUpgradeDto = (AppUpgradeDto)args[0];
            if (appUpgradeDto.isCrossPublish()) {
                String publishCacheKey = (String)TransmittableThreadLocalHolder.get((String)"publishCacheKey");
                int finishedSteps = 9;
                HussarCacheUtil.put((String)PUBLISH_CACHE_NAME, (Object)publishCacheKey, (Object)new AppPublishStatusVo.Builder().status(Integer.valueOf(finishedSteps + annotation.status())).msg(exception.getMessage()).finishFlag(Boolean.valueOf(annotation.finish())).errorFlag(Boolean.TRUE).build());
            } else {
                Object object = TransmittableThreadLocalHolder.get((String)"upgradeCacheKey");
                if (HussarUtils.isNotEmpty((Object)object) && object instanceof String) {
                    String upgradeCacheKey = (String)object;
                    HussarCacheUtil.put((String)"upgrade_progress", (Object)upgradeCacheKey, (Object)new UpgradeStatusVo.Builder().status(Integer.valueOf(annotation.status())).msg(exception.getMessage()).finishFlag(Boolean.valueOf(annotation.finish())).errorFlag(Boolean.TRUE).build());
                }
            }
        }
    }
}

