/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.tool.aspect;

import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppPublishStatusVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ProgressCache;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AppEiProgressAspect {
    public static final String EXPORT_CACHE_NAME = "export_progress";
    public static final String EXPORT_CACHE_KEY = "export_progress";
    public static final String IMPORT_CACHE_NAME = "import_progress";
    public static final String IMPORT_CACHE_KEY = "import_progress";
    public static final String PUBLISH_CACHE_NAME = "publish_progress";

    @Around(value="execution(* *(..)) && @annotation(annotation)", argNames="joinPoint,annotation")
    public Object around(ProceedingJoinPoint joinPoint, ProgressCache annotation) throws Throwable {
        ToolUtil.getLogger(AppEiProgressAspect.class).info("\u5bfc\u51fa\u5e94\u7528\uff1a{}", (Object)annotation.msg());
        Object proceed = joinPoint.proceed();
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args)) {
            if (args[0] instanceof AppExportDto && ((AppExportDto)args[0]).isCrossPublish()) {
                String publishCacheKey = (String)TransmittableThreadLocalHolder.get((String)"publishCacheKey");
                HussarCacheUtil.put((String)PUBLISH_CACHE_NAME, (Object)publishCacheKey, (Object)new AppPublishStatusVo.Builder().status(Integer.valueOf(annotation.status())).msg(annotation.msg()).finishFlag(Boolean.FALSE).errorFlag(Boolean.FALSE).build());
            } else {
                long fileId = 0L;
                if (annotation.finish() && proceed instanceof Long) {
                    fileId = Long.parseLong(String.valueOf(proceed));
                }
                String exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey");
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)annotation.status(), (String)annotation.msg(), (Long)fileId, (boolean)false));
            }
        }
        return proceed;
    }

    @AfterThrowing(pointcut="execution(* *(..)) && @annotation(annotation)", throwing="exception")
    public void afterThrowing(JoinPoint joinPoint, ProgressCache annotation, Exception exception) {
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args)) {
            if (args[0] instanceof AppExportDto && ((AppExportDto)args[0]).isCrossPublish()) {
                String publishCacheKey = (String)TransmittableThreadLocalHolder.get((String)"publishCacheKey");
                HussarCacheUtil.put((String)PUBLISH_CACHE_NAME, (Object)publishCacheKey, (Object)new AppPublishStatusVo.Builder().status(Integer.valueOf(annotation.status())).msg(exception.getMessage()).finishFlag(Boolean.TRUE).errorFlag(Boolean.TRUE).build());
            } else {
                String exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey");
                HussarCacheUtil.put((String)"export_progress", (Object)exportCacheKey, (Object)ExportStatusVo.put((int)annotation.status(), (String)exception.getMessage(), (Long)0L, (boolean)true));
            }
        }
    }

    @Around(value="execution(* *(..)) && @annotation(annotation)", argNames="joinPoint,annotation")
    public Object around(ProceedingJoinPoint joinPoint, ImportProgressCache annotation) throws Throwable {
        ToolUtil.getLogger(AppEiProgressAspect.class).info("\u5bfc\u5165\u5e94\u7528\uff1a{}", (Object)annotation.msg());
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args)) {
            if (args[0] instanceof AppImportDto && ((AppImportDto)args[0]).isCrossPublish()) {
                String publishCacheKey = (String)TransmittableThreadLocalHolder.get((String)"publishCacheKey");
                int finishedSteps = 9;
                HussarCacheUtil.put((String)PUBLISH_CACHE_NAME, (Object)publishCacheKey, (Object)new AppPublishStatusVo.Builder().status(Integer.valueOf(finishedSteps + annotation.status())).msg(annotation.msg()).finishFlag(Boolean.valueOf(annotation.finish())).errorFlag(Boolean.FALSE).build());
            } else {
                String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)annotation.status(), (String)annotation.msg(), (boolean)annotation.finish(), (boolean)false));
            }
        }
        return joinPoint.proceed();
    }

    @AfterThrowing(pointcut="execution(* *(..)) && @annotation(annotation)", throwing="exception")
    public void afterThrowing(JoinPoint joinPoint, ImportProgressCache annotation, Exception exception) {
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args)) {
            if (args[0] instanceof AppImportDto && ((AppImportDto)args[0]).isCrossPublish()) {
                String publishCacheKey = (String)TransmittableThreadLocalHolder.get((String)"publishCacheKey");
                int finishedSteps = 9;
                HussarCacheUtil.put((String)PUBLISH_CACHE_NAME, (Object)publishCacheKey, (Object)new AppPublishStatusVo.Builder().status(Integer.valueOf(finishedSteps + annotation.status())).msg(exception.getMessage()).finishFlag(Boolean.TRUE).errorFlag(Boolean.TRUE).build());
            } else {
                String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
                HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.put((int)annotation.status(), (String)exception.getMessage(), (boolean)annotation.finish(), (boolean)true));
            }
        }
    }
}

