/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.strategy;

import com.jxdinfo.hussar.formdesign.application.print.strategy.IWidgetStrategy;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class WidgetStrategyContext
implements ApplicationContextAware {
    private static final EnumMap<WidgetType, IWidgetStrategy> widgetStrategyMap = new EnumMap(WidgetType.class);

    public void setApplicationContext(ApplicationContext applicationContext) {
        Map beansOfType = applicationContext.getBeansOfType(IWidgetStrategy.class);
        this.setBeansToMap(beansOfType);
    }

    private void setBeansToMap(Map<String, IWidgetStrategy> beanMap) {
        for (Map.Entry<String, IWidgetStrategy> entry : beanMap.entrySet()) {
            WidgetType widgetType;
            String k = entry.getKey();
            IWidgetStrategy v = entry.getValue();
            if (!HussarUtils.isNotEmpty((Object)k) || (widgetType = v.getWidgetType()) == null) continue;
            widgetStrategyMap.put(widgetType, v);
        }
    }

    public static IWidgetStrategy getStrategy(WidgetType widgetType) {
        return HussarUtils.isNotEmpty((Object)widgetStrategyMap.get(widgetType)) ? widgetStrategyMap.get(widgetType) : (IWidgetStrategy)SpringUtil.getBean((String)"defaultStrategy", IWidgetStrategy.class);
    }
}

