/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.constant.DataOprLogConst;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.model.SysDataOperateLog;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.service.ISysDataOperateLogService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogType;
import com.jxdinfo.hussar.formdesign.application.util.DeepCopy;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class OperateLogComponent {
    @Value(value="${hussar.nocode.dataOperateLog.storageType:mysql}")
    private String storageType;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private ISysDataOperateLogService sysDataOperateLogService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    private static final Logger LOGGER = LoggerFactory.getLogger(OperateLogComponent.class);

    public void batchDel(ProceedingJoinPoint joinPoint, Long userId, OperateLogType operateLogType) {
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        Object idsObj = args[1];
        Long appId = Long.valueOf(String.valueOf(args[2]));
        String ids = String.valueOf(idsObj);
        LOGGER.info("\u5f00\u59cb\u5f02\u6b65\u89e3\u6790\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)ids);
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList logs = new ArrayList();
        try {
            idList.forEach(id -> {
                SysDataOperateLog log = this.newLog((String)id, String.valueOf(formId), String.valueOf(appId), 2, new JSONArray(), new JSONArray(), (Map<String, Object>)new HashMap<String, Object>(), (Map<String, Object>)new HashMap<String, Object>(), operateLogType, new JSONArray());
                log.setCreator(userId);
                logs.add(log);
            });
            LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)ids);
            if (this.storageType.equals("mysql")) {
                this.sysDataOperateLogService.saveBatch(logs);
            } else {
                logs.forEach(sysDataOperateLog -> {
                    sysDataOperateLog.setOperateId(Long.valueOf(IdWorker.getId((Object)sysDataOperateLog)));
                    sysDataOperateLog.setCreateTime(this.localDateTime());
                    sysDataOperateLog.setLastTime(sysDataOperateLog.getCreateTime());
                    sysDataOperateLog.setLastEditor(sysDataOperateLog.getCreator());
                });
                this.mongoTemplate.insertAll(logs);
            }
        }
        catch (Exception e) {
            LOGGER.error("deleteBatch\u5f02\u6b65\u89e3\u6790\u5f02\u5e38\uff0c\u8868\u5355id:{},\u6570\u636eid:{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, ids, e});
        }
    }

    public void singleDataHandle(JSONObject newData, JSONObject oldData, Long appId, Long formId, String dataId, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, Long userId, OperateLogType operateLogType, JSONArray widgets) {
        SysDataOperateLog log = this.newLog(dataId, String.valueOf(formId), String.valueOf(appId), HussarUtils.isNotEmpty((Object)oldData) ? 1 : 0, childList, childCountList, newParams, oldParams, operateLogType, widgets);
        if (operateLogType.getMode() == 6) {
            Object user = newData.get((Object)"createUser_user");
            if (HussarUtils.isNotEmpty((Object)user)) {
                log.setCreator(Long.valueOf(String.valueOf(user)));
            } else {
                log.setCreator(userId);
            }
        } else {
            log.setCreator(userId);
        }
        if (this.storageType.equals("mysql")) {
            this.sysDataOperateLogService.save((Object)log);
        } else {
            log.setOperateId(Long.valueOf(IdWorker.getId((Object)log)));
            log.setCreateTime(this.localDateTime());
            log.setLastTime(log.getCreateTime());
            log.setLastEditor(log.getCreator());
            this.mongoTemplate.insert((Object)log);
        }
    }

    public String judgeDevice(HttpServletRequest request) {
        if (HussarUtils.isEmpty((Object)request)) {
            return "Unknown";
        }
        String userAgent = request.getHeader("User-Agent");
        if (HussarUtils.isEmpty((Object)userAgent)) {
            return "Unknown";
        }
        String device = userAgent.contains("Android") || userAgent.contains("iPhone") || userAgent.contains("iPad") || userAgent.contains("Mobile") ? "Mobile" : (userAgent.contains("Windows") || userAgent.contains("Macintosh") ? "PC" : "Unknown");
        return device;
    }

    public JSONObject getDataFormDB(String dataId, String appId, String formId, String tabTye) {
        ResponseEntity responseEntity = this.formOperateExposedService.formQuery(formId, dataId, tabTye, appId, Boolean.TRUE.booleanValue());
        ApiResponse body = (ApiResponse)responseEntity.getBody();
        Object oldObj = body.getData();
        if (HussarUtils.isEmpty((Object)oldObj)) {
            LOGGER.error("\u8868\u5355\u539f\u59cb\u6570\u636e\u4e0d\u5b58\u5728,\u5e94\u7528id\uff1a{},\u8868\u5355id\uff1a{}\uff0c\u6570\u636eid\uff1a{}", new Object[]{appId, formId, dataId});
        }
        LOGGER.info("\u8868\u5355\u539f\u59cb\u6570\u636e\uff1a{}", (Object)this.toJsonObj(oldObj));
        return this.toJsonObj(oldObj);
    }

    public void batchAdd(JSONArray newArray, String tableName, Long appId, Long formId, int opType, OperateLogType operateLogType, Long userId, int mode) {
        newArray.forEach(jsonObj -> {
            JSONObject jsonObj1 = (JSONObject)jsonObj;
            jsonObj1.put("childList", (Object)new JSONArray());
            jsonObj1.put("childCountList", (Object)new JSONArray());
            jsonObj1.put("newParams", new HashMap());
            jsonObj1.put("oldParams", new HashMap());
            jsonObj1.put("widget", (Object)new JSONArray());
        });
        this.logSaveBatch(tableName, String.valueOf(formId), String.valueOf(appId), newArray, opType, operateLogType, userId, mode);
    }

    public void editDataLogSaveBatch(int opType, JSONArray newArray, String tableName, JSONArray newDataS, Long appId, Long formId, JSONArray oldDataS, OperateLogType operateLogType, Long userId) {
        this.getDataSBatch(newArray, tableName, newDataS, appId, formId);
        JSONArray editIds = new JSONArray();
        JSONArray toLogs = new JSONArray();
        block0: for (Object data : oldDataS) {
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            Object o = jsonObject.get((Object)tableName);
            String s = String.valueOf(o);
            for (Object newData : newDataS) {
                JSONObject jsonObject1 = JSON.parseObject((String)JSON.toJSONString(newData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                Object o1 = jsonObject1.get((Object)tableName);
                String s1 = String.valueOf(o1);
                if (!s.equals(s1)) continue;
                editIds.add((Object)s1);
                JSONArray childList = new JSONArray();
                JSONArray childCountList = new JSONArray();
                HashMap<String, Object> newParams = new HashMap<String, Object>();
                HashMap<String, Object> oldParams = new HashMap<String, Object>();
                JSONArray widgets = new JSONArray();
                if (this.compareData(jsonObject, jsonObject1, childList, childCountList, newParams, oldParams, tableName, String.valueOf(formId), widgets)) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)s1, (Object)formId);
                    editIds.remove((Object)s1);
                    continue block0;
                }
                if (newParams.isEmpty() && oldParams.isEmpty()) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)s1, (Object)formId);
                    editIds.remove((Object)s1);
                    continue block0;
                }
                jsonObject1.put("childList", (Object)childList);
                jsonObject1.put("childCountList", (Object)childCountList);
                jsonObject1.put("newParams", newParams);
                jsonObject1.put("oldParams", oldParams);
                jsonObject1.put("widget", (Object)widgets);
                toLogs.add((Object)jsonObject1);
            }
        }
        LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u4fee\u6539\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)editIds);
        this.logSaveBatch(tableName, String.valueOf(formId), String.valueOf(appId), toLogs, opType, operateLogType, userId, operateLogType.getMode());
    }

    public void getDataSBatch(JSONArray array, String formName, JSONArray dataS, Long appId, Long formId) {
        ArrayList idsList = new ArrayList();
        array.forEach(jsonObj -> {
            Object o = ((JSONObject)jsonObj).get((Object)"RECORD_ID");
            String s = String.valueOf(o);
            idsList.add(s);
        });
        String ids = String.join((CharSequence)",", idsList);
        HashMap params = new HashMap();
        Filter idsFilter = new Filter();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        idsFilter.setField(formName);
        idsFilter.setMatch("AND");
        idsFilter.setRule("_in");
        idsFilter.setVal(ids);
        filters.add(idsFilter);
        params.put("superQueryConditionDto", filters);
        ResponseEntity apiResponse = this.formOperateExposedService.tableQueryByCondition(String.valueOf(appId), String.valueOf(formId), params);
        PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(apiResponse.getBody())).getData();
        List dataTemp = pageData.getData();
        dataS.addAll((Collection)dataTemp);
        LOGGER.info("\u67e5\u8be2\u8868\u5355\u6570\u636e\u5b8c\u6210\uff0c\u8868\u5355id:{},\u6570\u636eid:{},\u6570\u636e\uff1a{}", new Object[]{formId, ids, dataS});
    }

    public JSONArray getJsonObj(JSONObject jsonObject) {
        JSONArray array = new JSONArray();
        Object importList = jsonObject.get((Object)"importList");
        List list = (List)importList;
        if (HussarUtils.isNotEmpty((Object)list)) {
            array.addAll((Collection)list);
        }
        return array;
    }

    public SysDataOperateLog newLog(String dataId, String formId, String appId, int opType, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, OperateLogType operateLogType, JSONArray widgets) {
        if (HussarUtils.isNull((Object)operateLogType)) {
            operateLogType = new OperateLogType();
            operateLogType.setMode(0);
        }
        JSONArray newWidgets = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)widgets)) {
            block0: for (Object o : widgets) {
                JSONObject jsonObject = (JSONObject)o;
                String name = String.valueOf(jsonObject.get((Object)"name"));
                for (String key : newParams.keySet()) {
                    if (!key.contains(name)) continue;
                    newWidgets.add((Object)jsonObject);
                    continue block0;
                }
            }
        }
        return new SysDataOperateLog(Long.valueOf(dataId), Long.valueOf(formId), Long.valueOf(appId), JSON.toJSONString(oldParams), JSON.toJSONString(newParams), JSON.toJSONString((Object)childList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), this.count(newParams), opType, operateLogType.getMode(), HussarUtils.isNotEmpty((Object)operateLogType.getTriggerFormId()) ? Long.valueOf(operateLogType.getTriggerFormId()) : null, JSON.toJSONString((Object)childCountList), operateLogType.getDevice(), HussarUtils.isNotEmpty((Object)operateLogType.getButtonId()) ? Long.valueOf(operateLogType.getButtonId()) : null, JSON.toJSONString((Object)newWidgets, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    private int count(Map<String, Object> newParams) {
        int size = newParams.size();
        for (String o : newParams.keySet()) {
            if (!o.toString().contains("_detail")) continue;
            --size;
        }
        return size;
    }

    private void logSaveBatch(String tableName, String formId, String appId, JSONArray newData, int opType, OperateLogType operateLogType, Long userId, int mode) {
        ArrayList logs = new ArrayList();
        newData.forEach(jsonObj -> {
            JSONObject jsonObj1 = (JSONObject)jsonObj;
            SysDataOperateLog log = this.newLog(String.valueOf(jsonObj1.get((Object)tableName)), formId, appId, opType, (JSONArray)jsonObj1.get((Object)"childList"), (JSONArray)jsonObj1.get((Object)"childCountList"), (Map)jsonObj1.get((Object)"newParams"), (Map)jsonObj1.get((Object)"oldParams"), operateLogType, (JSONArray)jsonObj1.get((Object)"widget"));
            if (mode == 6) {
                Object user = jsonObj1.get((Object)"createUser_user");
                if (HussarUtils.isNotEmpty((Object)user)) {
                    log.setCreator(Long.valueOf(String.valueOf(user)));
                } else {
                    log.setCreator(userId);
                }
            } else {
                log.setCreator(userId);
            }
            logs.add(log);
        });
        if (this.storageType.equals("mysql")) {
            this.sysDataOperateLogService.saveBatch(logs);
        } else {
            logs.forEach(log -> {
                log.setOperateId(Long.valueOf(IdWorker.getId((Object)log)));
                log.setCreateTime(this.localDateTime());
                log.setLastTime(log.getCreateTime());
                log.setLastEditor(log.getCreator());
            });
            this.mongoTemplate.insertAll(logs);
        }
    }

    public JSONObject toJsonObj(Object obj) {
        String dataJson = JsonUtil.toJson((Object)obj);
        return JSON.parseObject((String)dataJson);
    }

    public boolean compareData(JSONObject oldData, JSONObject newData, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, String tableName, String formId, JSONArray widgets) {
        LOGGER.info("\u6570\u636e\u6bd4\u8f83\u5f00\u59cb\uff0c\u65e7\u6570\u636e\uff1a{},\u65b0\u6570\u636e\uff1a{}", (Object)oldData, (Object)newData);
        if (HussarUtils.isEmpty((Object)oldData)) {
            for (String key : newData.keySet()) {
                newParams.put(key, newData.get((Object)key));
            }
        } else {
            HashMap<String, String> widgetMap = new HashMap<String, String>();
            this.getWidgets(formId, widgetMap);
            widgets.addAll((Collection)JSON.parseArray((String)((String)widgetMap.get("widgets"))));
            this.cleanData(oldData, 0, tableName, widgetMap);
            this.cleanData(newData, 0, tableName, widgetMap);
            LOGGER.info("\u6e05\u9664\u540e\u6570\u636e\uff1a\u8001{}\uff0c\u65b0{}", (Object)oldData, (Object)newData);
            if (JSON.toJSONString((Object)oldData).equals(JSON.toJSONString((Object)newData))) {
                return true;
            }
            for (String key : newData.keySet()) {
                if (HussarUtils.isNotEmpty(widgetMap.get(key)) && ((String)widgetMap.get(key)).equals(WidgetType.JXDN_SUGGESTION.getType()) || !oldData.containsKey((Object)key)) continue;
                if (HussarUtils.isNotEmpty(widgetMap.get(key)) && (((String)widgetMap.get(key)).equals(WidgetType.CHILDREN_TABLE.getType()) || ((String)widgetMap.get(key)).equals(WidgetType.JXDNChildrenTableAgg.getType()))) {
                    JSONObject childCount = new JSONObject();
                    JSONObject childCountMap = new JSONObject();
                    JSONObject map = new JSONObject();
                    JSONArray updateList = new JSONArray();
                    JSONArray updateChild = new JSONArray();
                    JSONArray oldChildren = (JSONArray)oldData.get((Object)key);
                    JSONArray newChildren = (JSONArray)newData.get((Object)key);
                    JSONArray childDelData = new JSONArray();
                    OperateLogComponent.childEquals(oldChildren, newChildren, key, oldParams, newParams, widgetMap);
                    if (HussarUtils.isEmpty((Object)oldChildren) && HussarUtils.isEmpty((Object)newChildren)) continue;
                    OperateLogComponent.getDelChildList(oldChildren, childDelData, newChildren);
                    for (Object newChild : newChildren) {
                        JSONObject newJsonObject = (JSONObject)newChild;
                        String newId = String.valueOf(newJsonObject.get((Object)"RECORD_ID"));
                        JSONObject oldJsonObject = OperateLogComponent.getOldDataByNewId(oldChildren, newId, key);
                        this.cleanData(newJsonObject, 1, tableName, widgetMap);
                        if (HussarUtils.isEmpty((Object)oldJsonObject)) {
                            OperateLogComponent.handleChildNewData(newJsonObject, updateChild, childCount, widgetMap);
                            continue;
                        }
                        boolean isUpdate = true;
                        JSONObject updateMap = new JSONObject();
                        this.cleanData(oldJsonObject, 1, tableName, widgetMap);
                        JSONObject newCompare = DeepCopy.deepCopyJsonObject(newJsonObject);
                        JSONObject oldCompare = DeepCopy.deepCopyJsonObject(oldJsonObject);
                        ArrayList oldList = new ArrayList();
                        ArrayList newList = new ArrayList();
                        oldCompare.forEach((k, v) -> {
                            if (k.contains("_label")) {
                                String[] strings = k.split("_label");
                                String string = strings[0];
                                if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                                    oldList.add(k);
                                }
                                if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                                    oldList.add(k);
                                }
                            }
                        });
                        oldList.forEach(arg_0 -> ((JSONObject)oldCompare).remove(arg_0));
                        newCompare.forEach((k, v) -> {
                            if (k.contains("_label")) {
                                String[] strings = k.split("_label");
                                String string = strings[0];
                                if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                                    newList.add(k);
                                }
                                if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                                    newList.add(k);
                                }
                            }
                        });
                        newList.forEach(arg_0 -> ((JSONObject)newCompare).remove(arg_0));
                        if (!newCompare.toJSONString().equals(oldCompare.toJSONString())) {
                            for (String key2 : newJsonObject.keySet()) {
                                if (!oldJsonObject.containsKey((Object)key2)) continue;
                                DataRecord dataRecord = new DataRecord();
                                Object oldR = oldJsonObject.get((Object)key2);
                                Object newR = newJsonObject.get((Object)key2);
                                if (this.compareChildNo(key2, dataRecord, oldJsonObject, newJsonObject, widgetMap)) continue;
                                if (key2.contains("_code")) {
                                    String[] strings = key2.split("_code");
                                    String address = strings[0];
                                    address = address + "_label";
                                    if (OperateLogComponent.objEquals(oldJsonObject.get((Object)key2), newJsonObject.get((Object)key2))) {
                                        this.compareChild(newJsonObject.get((Object)address), oldJsonObject.get((Object)address), dataRecord);
                                    } else {
                                        dataRecord.setNewData("");
                                        if (HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)address))) {
                                            dataRecord.setOldData(oldJsonObject.get((Object)address));
                                        } else {
                                            dataRecord.setOldData("");
                                        }
                                        dataRecord.setMode(3);
                                    }
                                    key2 = address;
                                } else if (HussarUtils.isNotEmpty(widgetMap.get(key2)) && ((String)widgetMap.get(key2)).equals(WidgetType.IMAGE.getType())) {
                                    if (OperateLogComponent.objEquals(oldJsonObject.get((Object)key2), newJsonObject.get((Object)key2))) {
                                        key2 = key2 + "_label";
                                        this.compareChild(newJsonObject.get((Object)key2), oldJsonObject.get((Object)key2), dataRecord);
                                    } else {
                                        key2 = key2 + "_label";
                                        dataRecord.setNewData("");
                                        if (HussarUtils.isNotEmpty((Object)oldJsonObject.get((Object)key2))) {
                                            dataRecord.setOldData(oldJsonObject.get((Object)key2));
                                        } else {
                                            dataRecord.setOldData("");
                                        }
                                        dataRecord.setMode(3);
                                    }
                                } else {
                                    this.compareChild(newR, oldR, dataRecord);
                                }
                                updateMap.put(key2, (Object)dataRecord);
                                if (!isUpdate) continue;
                                updateMap.put("row", (Object)new Mode("1"));
                                if (childCount.containsKey((Object)"UPDATE")) {
                                    childCount.put("UPDATE", (Object)(Integer.parseInt(String.valueOf(childCount.get((Object)"UPDATE"))) + 1));
                                } else {
                                    childCount.put("UPDATE", (Object)1);
                                }
                                isUpdate = false;
                            }
                        }
                        if (!HussarUtils.isNotEmpty((Object)updateMap)) continue;
                        updateChild.add((Object)updateMap);
                    }
                    this.cleanChildData(childDelData, tableName, widgetMap);
                    OperateLogComponent.handleChildDelData(childDelData, updateChild, childCount, widgetMap);
                    if (HussarUtils.isNotEmpty((Object)updateChild)) {
                        updateList.addAll((Collection)updateChild);
                        map.put(key, (Object)updateList);
                        childList.add((Object)map);
                    }
                    if (!HussarUtils.isNotEmpty((Object)childCount)) continue;
                    childCountMap.put(key, (Object)childCount);
                    childCountList.add((Object)childCountMap);
                    continue;
                }
                if (this.compareAddress(key, oldData, newData, oldParams, newParams, widgetMap) || this.compareImage(key, oldData, newData, oldParams, newParams, widgetMap) || !OperateLogComponent.objEquals(oldData.get((Object)key), newData.get((Object)key))) continue;
                LOGGER.info("\u5b57\u6bb5{}\u88ab\u4fee\u6539\uff0c\u8868\u5355id{}", (Object)key, (Object)formId);
                oldParams.put(key, HussarUtils.isNotEmpty((Object)oldData.get((Object)key)) ? oldData.get((Object)key) : "");
                newParams.put(key, newData.get((Object)key));
            }
        }
        return false;
    }

    private void compareChild(Object newR, Object oldR, DataRecord dataRecord) {
        if (HussarUtils.isNotEmpty((Object)newR) && HussarUtils.isEmpty((Object)oldR)) {
            dataRecord.setNewData(newR);
            dataRecord.setOldData("");
            dataRecord.setMode(0);
        } else if (HussarUtils.isNotEmpty((Object)newR) && HussarUtils.isNotEmpty((Object)oldR) && OperateLogComponent.objEquals(newR, oldR)) {
            dataRecord.setNewData(newR);
            dataRecord.setOldData(oldR);
            dataRecord.setMode(1);
        } else if (HussarUtils.isEmpty((Object)newR) && HussarUtils.isNotEmpty((Object)oldR)) {
            dataRecord.setNewData("");
            dataRecord.setOldData(oldR);
            dataRecord.setMode(2);
        } else if (!OperateLogComponent.objEquals(oldR, newR)) {
            dataRecord.setNewData("");
            if (HussarUtils.isNotEmpty((Object)oldR)) {
                dataRecord.setOldData(oldR);
            } else {
                dataRecord.setOldData("");
            }
            dataRecord.setMode(3);
        }
    }

    private boolean compareChildNo(String key, DataRecord dataRecord, JSONObject oldData, JSONObject newData, Map<String, String> widgetMap) {
        if (key.contains("_label")) {
            String[] strings = key.split("_label");
            String string = strings[0];
            if (widgetMap.get(string).equals(WidgetType.ADDRESS.getType())) {
                return true;
            }
            if (widgetMap.get(string).equals(WidgetType.IMAGE.getType())) {
                return true;
            }
        }
        return false;
    }

    private boolean compareAddress(String key, JSONObject oldData, JSONObject newData, Map<String, Object> oldParams, Map<String, Object> newParams, Map<String, String> widgetMap) {
        if (key.contains("_code")) {
            String[] strings = key.split("_code");
            String address = strings[0];
            address = address + "_label";
            if (OperateLogComponent.objEquals(oldData.get((Object)key), newData.get((Object)key))) {
                oldParams.put(address, HussarUtils.isNotEmpty((Object)oldData.get((Object)address)) ? oldData.get((Object)address) : "");
                newParams.put(address, HussarUtils.isNotEmpty((Object)newData.get((Object)address)) ? newData.get((Object)address) : "");
            }
            return true;
        }
        if (key.contains("_label")) {
            String[] strings = key.split("_label");
            String string = strings[0];
            return widgetMap.get(string).equals(WidgetType.ADDRESS.getType());
        }
        return false;
    }

    private boolean compareImage(String key, JSONObject oldData, JSONObject newData, Map<String, Object> oldParams, Map<String, Object> newParams, Map<String, String> widgetMap) {
        if (HussarUtils.isNotEmpty((Object)widgetMap.get(key)) && widgetMap.get(key).equals(WidgetType.IMAGE.getType()) && OperateLogComponent.objEquals(oldData.get((Object)key), newData.get((Object)key))) {
            oldParams.put(key, HussarUtils.isNotEmpty((Object)oldData.get((Object)(key = key + "_label"))) ? oldData.get((Object)key) : "");
            newParams.put(key, HussarUtils.isNotEmpty((Object)newData.get((Object)key)) ? newData.get((Object)key) : "");
            return true;
        }
        if (key.contains("_label")) {
            String[] strings = key.split("_label");
            String string = strings[0];
            return widgetMap.get(string).equals(WidgetType.IMAGE.getType());
        }
        return false;
    }

    private static JSONObject getOldDataByNewId(JSONArray oldData, String newId, String key) {
        List objectList = oldData.stream().filter(jsonObj -> String.valueOf(((JSONObject)jsonObj).get((Object)"RECORD_ID")).equals(newId)).collect(Collectors.toList());
        if (!objectList.isEmpty()) {
            return (JSONObject)objectList.get(0);
        }
        return new JSONObject();
    }

    private static void getDelChildList(JSONArray oldChild, JSONArray childDelData, JSONArray newChild) {
        oldChild.forEach(jsonObj -> {
            JSONObject obj = (JSONObject)jsonObj;
            Object recordId = obj.get((Object)"RECORD_ID");
            List objectList = newChild.stream().filter(jsonObj2 -> String.valueOf(((JSONObject)jsonObj2).get((Object)"RECORD_ID")).equals(recordId)).collect(Collectors.toList());
            if (objectList.isEmpty()) {
                childDelData.add((Object)obj);
            }
        });
    }

    private static void handleChildDelData(JSONArray childDelData, JSONArray updateChild, JSONObject childCount, Map<String, String> widgetMap) {
        JSONObject jsonObject;
        for (Object obj : childDelData) {
            jsonObject = (JSONObject)obj;
            ArrayList list = new ArrayList();
            jsonObject.forEach((k, v) -> {
                if (k.contains("_code")) {
                    list.add(k);
                }
                if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.IMAGE.getType())) {
                    list.add(k);
                }
            });
            list.forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
        }
        for (Object obj : childDelData) {
            jsonObject = (JSONObject)obj;
            jsonObject.replaceAll((k, v) -> {
                if (HussarUtils.isEmpty((Object)v)) {
                    return new DataRecord("", "", 3);
                }
                return new DataRecord(v, "", 2);
            });
            jsonObject.put("row", (Object)new Mode("2"));
            if (childCount.containsKey((Object)"DEL")) {
                childCount.put("DEL", (Object)(Integer.parseInt(String.valueOf(childCount.get((Object)"DEL"))) + 1));
            } else {
                childCount.put("DEL", (Object)1);
            }
            updateChild.add((Object)jsonObject);
        }
    }

    private static void handleChildNewData(JSONObject jsonObject, JSONArray updateChild, JSONObject childCount, Map<String, String> widgetMap) {
        ArrayList list = new ArrayList();
        jsonObject.forEach((k, v) -> {
            if (k.contains("_code")) {
                list.add(k);
            }
            if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.IMAGE.getType())) {
                list.add(k);
            }
        });
        list.forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
        jsonObject.replaceAll((k, v) -> {
            if (HussarUtils.isEmpty((Object)v)) {
                return new DataRecord("", "", 3);
            }
            return new DataRecord("", v, 0);
        });
        jsonObject.put("row", (Object)new Mode("0"));
        if (childCount.containsKey((Object)"ADD")) {
            childCount.put("ADD", (Object)(Integer.parseInt(String.valueOf(childCount.get((Object)"ADD"))) + 1));
        } else {
            childCount.put("ADD", (Object)1);
        }
        updateChild.add((Object)jsonObject);
    }

    private static boolean objEquals(Object oldObj, Object newObj) {
        if (oldObj == null && newObj == null) {
            return false;
        }
        if (oldObj == null) {
            return true;
        }
        if (newObj == null) {
            return true;
        }
        return !JSON.toJSONString((Object)oldObj).equals(JSON.toJSONString((Object)newObj));
    }

    private static void childEquals(JSONArray oldChildren, JSONArray newChildren, String key, Map<String, Object> oldParams, Map<String, Object> newParams, Map<String, String> widgetMap) {
        if (HussarUtils.isEmpty((Object)oldChildren)) {
            if (HussarUtils.isNotEmpty((Object)newChildren)) {
                oldParams.put(key, "\u65e0\u6570\u636e");
                newParams.put(key, "\u65b0\u589e\u4e86\u6570\u636e");
            }
            return;
        }
        if (HussarUtils.isNotEmpty((Object)oldChildren)) {
            if (HussarUtils.isEmpty((Object)newChildren)) {
                oldParams.put(key, "\u6709\u6570\u636e");
                newParams.put(key, "\u5220\u9664\u4e86\u6570\u636e");
                return;
            }
            if (!JSON.toJSONString((Object)newChildren).equals(JSON.toJSONString((Object)oldChildren))) {
                JSONArray newArr = new JSONArray();
                newChildren.forEach(newChild -> {
                    JSONObject newCompare = DeepCopy.deepCopyJsonObject(newChild);
                    newArr.add((Object)newCompare);
                });
                JSONArray oldArr = new JSONArray();
                oldChildren.forEach(oldChild -> {
                    JSONObject oldCompare = DeepCopy.deepCopyJsonObject(oldChild);
                    oldArr.add((Object)oldCompare);
                });
                newArr.forEach(newChild -> {
                    JSONObject newO = (JSONObject)newChild;
                    ArrayList newList = new ArrayList();
                    newO.forEach((k, v) -> {
                        if (k.contains("_label")) {
                            String[] strings = k.split("_label");
                            String string = strings[0];
                            if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                                newList.add(k);
                            }
                            if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                                newList.add(k);
                            }
                        }
                        if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.CHILDREN_TABLE.getType())) {
                            newList.add(k);
                        }
                        if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.JXDNChildrenTableAgg.getType())) {
                            newList.add(k);
                        }
                    });
                    newList.forEach(arg_0 -> ((JSONObject)newO).remove(arg_0));
                });
                oldArr.forEach(oldChild -> {
                    JSONObject oldO = (JSONObject)oldChild;
                    ArrayList oldList = new ArrayList();
                    oldO.forEach((k, v) -> {
                        if (k.contains("_label")) {
                            String[] strings = k.split("_label");
                            String string = strings[0];
                            if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.ADDRESS.getType())) {
                                oldList.add(k);
                            }
                            if (HussarUtils.isNotEmpty(widgetMap.get(string)) && ((String)widgetMap.get(string)).equals(WidgetType.IMAGE.getType())) {
                                oldList.add(k);
                            }
                        }
                        if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.CHILDREN_TABLE.getType())) {
                            oldList.add(k);
                        }
                        if (HussarUtils.isNotEmpty(widgetMap.get(k)) && ((String)widgetMap.get(k)).equals(WidgetType.JXDNChildrenTableAgg.getType())) {
                            oldList.add(k);
                        }
                    });
                    oldList.forEach(arg_0 -> ((JSONObject)oldO).remove(arg_0));
                });
                if (!JSON.toJSONString((Object)newArr).equals(JSON.toJSONString((Object)oldArr))) {
                    oldParams.put(key, "\u6709\u6570\u636e");
                    newParams.put(key, "\u4fee\u6539\u4e86\u6570\u636e");
                }
            }
        }
    }

    public Map<String, String> getWidgets(String formId, Map<String, String> map) {
        FormCanvasSchema canvasSchema = Optional.ofNullable(this.canvasSchemaService.get(formId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25"));
        List originWidgets = canvasSchema.widgets();
        List childrenWidgets = canvasSchema.childTables();
        ArrayList widgets = new ArrayList();
        widgets.addAll(originWidgets);
        widgets.addAll(childrenWidgets);
        String widgetsJson = JSON.toJSONString(widgets, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        widgets.forEach(widget -> {
            map.put(widget.getName(), widget.getType());
            if (widget.getType().equals(WidgetType.CHILDREN_TABLE.getType()) || widget.getType().equals(WidgetType.JXDNChildrenTableAgg.getType())) {
                List children = widget.getChildren();
                children.forEach(widget1 -> map.put(widget1.getName(), widget1.getType()));
            }
        });
        map.put("widgets", widgetsJson);
        return map;
    }

    private void cleanData(JSONObject data, int mode, String tableName, Map<String, String> widgetMap) {
        LOGGER.info("\u753b\u5e03\u6570\u636e\uff1a{}", widgetMap);
        List widgets = DataOprLogConst.widgets();
        ArrayList<String> widgetTypes = new ArrayList<String>();
        widgetTypes.add(WidgetType.JXDNOrgMulti.getType());
        widgetTypes.add(WidgetType.JXDNUserMulti.getType());
        widgetTypes.add(WidgetType.JXDNUser.getType());
        widgetTypes.add(WidgetType.SELECT_MUL.getType());
        widgetTypes.add(WidgetType.JXDNOrg.getType());
        widgetTypes.add(WidgetType.FILE.getType());
        widgetTypes.add(WidgetType.SELECT.getType());
        widgetTypes.add(WidgetType.RADIO_GROUP.getType());
        widgetTypes.add(WidgetType.CHECK_BOX_GROUP.getType());
        data.forEach((key, value) -> {
            if (widgetTypes.contains(widgetMap.get(key))) {
                widgets.add(key);
            }
        });
        ArrayList list = new ArrayList();
        if (mode == 1) {
            ArrayList<String> childWidgets = new ArrayList<String>();
            childWidgets.add(WidgetType.CHILDREN_TABLE.getType());
            childWidgets.add(WidgetType.JXDNChildrenTableAgg.getType());
            data.forEach((key, value) -> {
                if (childWidgets.contains(widgetMap.get(key))) {
                    widgets.add(key);
                }
            });
            widgets.add("F_RECORD_ID");
            widgets.add("RECORD_ID");
            widgets.add(tableName);
        }
        data.forEach((key, value) -> {
            for (String widget : widgets) {
                boolean isWidget = false;
                if (key.contains(widget) && !key.contains("_label")) {
                    list.add(key);
                    isWidget = true;
                }
                if (HussarUtils.isNotEmpty(widgetMap.get(key)) && ((String)widgetMap.get(key)).equals(WidgetType.ADDRESS.getType())) {
                    list.add(key);
                    isWidget = true;
                }
                if (key.contains("ref_id")) {
                    list.add(key);
                    isWidget = true;
                }
                if (key.contains("ref_child_id")) {
                    list.add(key);
                    isWidget = true;
                }
                if (!isWidget) continue;
                break;
            }
        });
        for (String key2 : list) {
            data.remove((Object)key2);
        }
    }

    private void cleanChildData(JSONArray jsonArray, String tableName, Map<String, String> widgetMap) {
        if (HussarUtils.isNotEmpty((Object)jsonArray)) {
            for (Object obj : jsonArray) {
                JSONObject jsonObject = (JSONObject)obj;
                this.cleanData(jsonObject, 1, tableName, widgetMap);
            }
        }
    }

    public LocalDateTime localDateTime() {
        return LocalDateTime.now();
    }

    private static class Mode {
        private String mode;

        public Mode() {
        }

        public Mode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }
    }

    private static class DataRecord {
        private Object oldData;
        private Object newData;
        private int mode;

        public DataRecord() {
        }

        public DataRecord(Object oldData, Object newData, int mode) {
            this.oldData = oldData;
            this.newData = newData;
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public Object getOldData() {
            return this.oldData;
        }

        public void setOldData(Object oldData) {
            this.oldData = oldData;
        }

        public Object getNewData() {
            return this.newData;
        }

        public void setNewData(Object newData) {
            this.newData = newData;
        }
    }
}

