/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogComponent;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OperateLogAsync {
    @Resource
    private OperateLogComponent operateLogComponent;
    private static final Logger LOGGER = LoggerFactory.getLogger(OperateLogAsync.class);

    @Async
    public void formSaveAsync(Object value, String tableName, String appId, String formId, JSONObject oldData, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, Long userId, OperateLogType operateLogType, JSONArray widgets, JSONObject newData, String dataId) throws InterruptedException {
        try {
            LOGGER.info("\u5f00\u59cb\u5f02\u6b65\u89e3\u6790\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)dataId);
            if (HussarUtils.isNotEmpty((Object)oldData)) {
                if (this.operateLogComponent.compareData(oldData, newData, childList, childCountList, newParams, oldParams, tableName, formId, widgets)) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)dataId, (Object)formId);
                    return;
                }
                if (newParams.isEmpty() && oldParams.isEmpty()) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)dataId, (Object)formId);
                    return;
                }
            }
            LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)dataId);
            this.operateLogComponent.singleDataHandle(newData, oldData, Long.valueOf(appId), Long.valueOf(formId), dataId, childList, childCountList, newParams, oldParams, userId, operateLogType, widgets);
        }
        catch (Exception e) {
            LOGGER.error("formSave\u5f02\u6b65\u89e3\u6790\u53d1\u751f\u5f02\u5e38\uff0c\u8868\u5355id:{},\u6570\u636e:{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, oldData, e});
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    @Async
    public void formIncrementSaveAsync(Object formData, String tableName, Long appId, AtomicInteger type, Long formId, JSONArray oldDataS, JSONArray newDataS, Long userId, OperateLogType operateLogType, JSONArray editIds) {
        try {
            int mode;
            JSONObject jsonObject;
            Object dataObj;
            JSONObject data = this.operateLogComponent.toJsonObj(formData);
            JSONArray newArray = new JSONArray();
            Object saveAndUpdate = data.get((Object)"saveAndUpdate");
            if (HussarUtils.isNotEmpty((Object)saveAndUpdate) && HussarUtils.isNotEmpty((Object)(dataObj = (jsonObject = (JSONObject)saveAndUpdate).get((Object)tableName)))) {
                newArray.addAll((Collection)JSON.parseArray((String)JSON.toJSONString((Object)dataObj)));
            }
            if ((mode = operateLogType.getMode()) == 1) {
                if (type.get() == 1) {
                    LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{}", (Object)formId);
                    this.operateLogComponent.batchAdd(newArray, tableName, appId, formId, 0, operateLogType, userId, mode);
                }
                if (type.get() == 2) {
                    this.operateLogComponent.editDataLogSaveBatch(1, newArray, tableName, newDataS, appId, formId, oldDataS, operateLogType, userId);
                }
                if (type.get() == 3) {
                    JSONArray editArray = new JSONArray();
                    List objectList = newArray.stream().filter(jsonObj -> {
                        Object o = ((JSONObject)jsonObj).get((Object)tableName);
                        String id = String.valueOf(o);
                        return editIds.contains((Object)id);
                    }).collect(Collectors.toList());
                    editArray.addAll(objectList);
                    JSONArray addArray = new JSONArray();
                    List objectList1 = newArray.stream().filter(jsonObj -> {
                        Object o = ((JSONObject)jsonObj).get((Object)tableName);
                        String id = String.valueOf(o);
                        return !editIds.contains((Object)id);
                    }).collect(Collectors.toList());
                    addArray.addAll(objectList1);
                    LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u65b0\u589e\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{}", (Object)formId);
                    this.operateLogComponent.batchAdd(addArray, tableName, appId, formId, 0, operateLogType, userId, mode);
                    this.operateLogComponent.editDataLogSaveBatch(1, editArray, tableName, newDataS, appId, formId, oldDataS, operateLogType, userId);
                }
            } else {
                this.operateLogComponent.editDataLogSaveBatch(1, newArray, tableName, newDataS, appId, formId, oldDataS, operateLogType, userId);
            }
        }
        catch (Exception e) {
            LOGGER.error("formIncrementSave\u5f02\u6b65\u89e3\u6790\u53d1\u751f\u5f02\u5e38\uff0c\u8868\u5355id:{},\u6570\u636e:{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, oldDataS, e});
        }
    }

    @Async
    public void taleSaveAsync(Map<String, Object> map, String tableName, Long appId, Long formId, JSONArray oldDataS, JSONArray newDataS, JSONArray editIds, Long userId, OperateLogType operateLogType, AtomicInteger type) {
        try {
            int mode = operateLogType.getMode();
            LOGGER.info("\u5f00\u59cb\u5f02\u6b65\u89e3\u6790\uff0c\u89e3\u6790\u7c7b\u578b\uff1a{}\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", new Object[]{mode, formId, editIds});
            String newString = JSONObject.toJSONString(map);
            JSONObject newObj = JSONObject.parseObject((String)newString);
            JSONArray newArray = this.operateLogComponent.getJsonObj(newObj);
            if (mode == 4 || mode == 5 || mode == 6) {
                LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)editIds);
                this.operateLogComponent.batchAdd(newArray, tableName, appId, formId, 0, operateLogType, userId, mode);
            }
            if (mode == 1) {
                if (type.get() == 1) {
                    LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{}", (Object)formId);
                    this.operateLogComponent.batchAdd(newArray, tableName, appId, formId, 0, operateLogType, userId, mode);
                }
                if (type.get() == 2) {
                    this.operateLogComponent.editDataLogSaveBatch(1, newArray, tableName, newDataS, appId, formId, oldDataS, operateLogType, userId);
                }
                if (type.get() == 3) {
                    JSONArray editArray = new JSONArray();
                    List objectList = newArray.stream().filter(jsonObj -> {
                        Object o = ((JSONObject)jsonObj).get((Object)tableName);
                        String id = String.valueOf(o);
                        return editIds.contains((Object)id);
                    }).collect(Collectors.toList());
                    editArray.addAll(objectList);
                    JSONArray addArray = new JSONArray();
                    List objectList1 = newArray.stream().filter(jsonObj -> {
                        Object o = ((JSONObject)jsonObj).get((Object)tableName);
                        String id = String.valueOf(o);
                        return !editIds.contains((Object)id);
                    }).collect(Collectors.toList());
                    addArray.addAll(objectList1);
                    LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u65b0\u589e\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{}", (Object)formId);
                    this.operateLogComponent.batchAdd(addArray, tableName, appId, formId, 0, operateLogType, userId, mode);
                    this.operateLogComponent.editDataLogSaveBatch(1, editArray, tableName, newDataS, appId, formId, oldDataS, operateLogType, userId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("taleSave\u5f02\u6b65\u89e3\u6790\u53d1\u751f\u5f02\u5e38\uff0c\u8868\u5355id:{},\u6570\u636e:{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, oldDataS, e});
        }
    }

    @Async
    public void flowFormSubmitAsync(Object proceed, String tableName, Long appId, Long formId, JSONObject oldData, JSONArray childList, JSONArray childCountList, Map<String, Object> newParams, Map<String, Object> oldParams, Long userId, OperateLogType operateLogType, JSONArray widgets, JSONObject newData, String dataId) {
        try {
            LOGGER.info("\u5f00\u59cb\u5f02\u6b65\u89e3\u6790\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)dataId);
            LOGGER.info("\u5728\u6570\u636e\u5e93\u67e5\u8be2\u5230\u7684\u6570\u636e\uff1a" + newData.toJSONString());
            if (HussarUtils.isNotEmpty((Object)oldData)) {
                if (this.operateLogComponent.compareData(oldData, newData, childList, childCountList, newParams, oldParams, tableName, String.valueOf(formId), widgets)) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)dataId, (Object)formId);
                    return;
                }
                if (newParams.isEmpty() && oldParams.isEmpty()) {
                    LOGGER.info("\u6570\u636e\u65e0\u53d8\u5316\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\u7684\u4fdd\u5b58\u65e5\u5fd7\uff0c\u6570\u636eid:{},\u8868\u5355id:{}", (Object)dataId, (Object)formId);
                    return;
                }
            }
            LOGGER.info("\u89e3\u6790\u5df2\u5b8c\u6210\uff0c\u5f00\u59cb\u4fdd\u5b58\u8868\u5355\u6570\u636e\u65e5\u5fd7\uff0c\u8868\u5355id:{},\u6570\u636eid:{}", (Object)formId, (Object)dataId);
            this.operateLogComponent.singleDataHandle(newData, oldData, appId, formId, dataId, childList, childCountList, newParams, oldParams, userId, operateLogType, widgets);
        }
        catch (Exception e) {
            LOGGER.error("flowFormSubmit\u5f02\u6b65\u89e3\u6790\u53d1\u751f\u5f02\u5e38\uff0c\u8868\u5355id:{},\u6570\u636e:{},\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, oldData, e});
        }
    }

    @Async
    public void delDataLogAsync(ProceedingJoinPoint joinPoint, Long userId, OperateLogType operateLogType) {
        this.operateLogComponent.batchDel(joinPoint, userId, operateLogType);
    }
}

