/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.service.impl.SysFormServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitRoleButtonServiceImpl")
public class SysAppVisitRoleButtonServiceImpl
extends HussarServiceImpl<SysAppVisitRoleButtonMapper, SysAppVisitRoleButton>
implements ISysAppVisitRoleButtonService {
    @Resource
    private SysAppVisitRoleButtonMapper sysAppVisitRoleButtonMapper;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysFormServiceImpl sysFormServiceImpl;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private IPermissionService permissionService;

    public ApiResponse<Boolean> addButtonAuthorityRoles(ButtonAuthoritiesDto buttonAuthoritiesDto) {
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)buttonAuthoritiesDto.getFormId())).eq(SysAppVisitRoleButton::getRoleId, (Object)buttonAuthoritiesDto.getRoleId()));
        ArrayList<SysAppVisitRoleButton> sysAppVisitRoleButtons = new ArrayList<SysAppVisitRoleButton>();
        List buttonDtoList = buttonAuthoritiesDto.getButtonDtoList();
        for (ButtonDto buttonDto : buttonDtoList) {
            SysAppVisitRoleButton sysAppVisitRoleButton = new SysAppVisitRoleButton();
            sysAppVisitRoleButton.setAppId(buttonAuthoritiesDto.getAppId());
            sysAppVisitRoleButton.setRoleId(buttonAuthoritiesDto.getRoleId());
            sysAppVisitRoleButton.setFormId(buttonAuthoritiesDto.getFormId());
            sysAppVisitRoleButton.setButtonName(buttonDto.getButtonName());
            sysAppVisitRoleButton.setButtonCode(buttonDto.getButtonCode());
            sysAppVisitRoleButtons.add(sysAppVisitRoleButton);
        }
        return ApiResponse.success((Object)this.saveBatch(sysAppVisitRoleButtons));
    }

    @HussarTransactional
    public void saveBatchButtonAuthority(List<ButtonAuthoritiesDto> buttonAuthoritiesDto) {
        if (HussarUtils.isEmpty(buttonAuthoritiesDto)) {
            ApiResponse.success((Object)Boolean.TRUE);
            return;
        }
        Long appId = buttonAuthoritiesDto.get(0).getAppId();
        Long roleId = buttonAuthoritiesDto.get(0).getRoleId();
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId)).eq(SysAppVisitRoleButton::getRoleId, (Object)roleId));
        ArrayList sysAppVisitRoleButtons = new ArrayList();
        buttonAuthoritiesDto.forEach(authoritiesDto -> {
            List buttonDtoList = authoritiesDto.getButtonDtoList();
            buttonDtoList.forEach(buttonDto -> {
                SysAppVisitRoleButton sysAppVisitRoleButton = new SysAppVisitRoleButton();
                sysAppVisitRoleButton.setAppId(appId);
                sysAppVisitRoleButton.setRoleId(roleId);
                sysAppVisitRoleButton.setFormId(authoritiesDto.getFormId());
                sysAppVisitRoleButton.setButtonName(buttonDto.getButtonName());
                sysAppVisitRoleButton.setButtonCode(buttonDto.getButtonCode());
                sysAppVisitRoleButtons.add(sysAppVisitRoleButton);
            });
        });
        if (HussarUtils.isNotEmpty(sysAppVisitRoleButtons)) {
            this.saveBatch(sysAppVisitRoleButtons);
        }
    }

    public ApiResponse<List<ButtonVo>> getButtonAuthorityRolesList(Long formId, Long roleId) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysAppVisitRoleButton::getFormId, (Object)formId);
        ew.eq(SysAppVisitRoleButton::getRoleId, (Object)roleId);
        List roleButtonList = this.list((Wrapper)ew);
        ArrayList<ButtonVo> buttonVos = new ArrayList<ButtonVo>();
        for (SysAppVisitRoleButton sysAppVisitRoleButton : roleButtonList) {
            ButtonVo buttonVo = new ButtonVo();
            buttonVo.setButtonCode(sysAppVisitRoleButton.getButtonCode());
            buttonVo.setButtonName(sysAppVisitRoleButton.getButtonName());
            buttonVos.add(buttonVo);
        }
        return ApiResponse.success(buttonVos);
    }

    public ApiResponse<List<ButtonVo>> formAuthorityButton(Long formId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            SecurityUser shiroUser = BaseSecurityUtil.getUser();
            List rolesList = shiroUser.getRolesList();
            if (HussarUtils.isNotEmpty((Object)shiroUser)) {
                SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
                AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
                Long appId = sysForm.getAppId();
                SysApplication appDetail = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
                AssertUtil.isNotNull((Object)appDetail, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
                Long developRoleId = appDetail.getDevelopRoleId();
                if (shiroUser.isSuperAdmin() || rolesList.contains(developRoleId)) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
                    this.sysFormService.sysCreateButton(buttonAuthoritiesDto);
                    List sysButtonList = buttonAuthoritiesDto.getButtonDtoList();
                    for (ButtonDto buttonDto : sysButtonList) {
                        result.add(BeanUtil.copy((Object)buttonDto, ButtonVo.class));
                    }
                    List customButtonList = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
                    for (SysCustomButton customButton : customButtonList) {
                        ButtonVo buttonVo = new ButtonVo();
                        buttonVo.setButtonCode(customButton.getAction());
                        buttonVo.setButtonName(customButton.getAlias());
                        result.add(buttonVo);
                    }
                    return ApiResponse.success(result);
                }
                if (HussarUtils.isNotEmpty((Object)rolesList)) {
                    return ApiResponse.success((Object)this.permissionService.getButtonRoleResource(formId, rolesList));
                }
            }
            return ApiResponse.success();
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public Map<Long, List<ButtonVo>> listButtonAuthorityByAppId(Long appId, Long roleId) {
        HashMap<Long, List<ButtonVo>> buttonAuthorityVoMap = new HashMap<Long, List<ButtonVo>>();
        List roleButtonList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId)).eq(SysAppVisitRoleButton::getRoleId, (Object)roleId));
        Map<Long, List<SysAppVisitRoleButton>> buttonAuthorityGroup = roleButtonList.stream().collect(Collectors.groupingBy(SysAppVisitRoleButton::getFormId));
        List sysFormList = this.sysFormService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        for (SysForm sysForm : sysFormList) {
            ArrayList buttonVos = new ArrayList();
            buttonAuthorityVoMap.put(sysForm.getId(), buttonVos);
            List authorizedButtonActions = ((List)Optional.ofNullable(buttonAuthorityGroup.get(sysForm.getId())).orElse(new ArrayList())).stream().map(SysAppVisitRoleButton::getButtonCode).collect(Collectors.toList());
            ButtonAuthoritiesDto sysButtonAuthoritiesDto = new ButtonAuthoritiesDto();
            this.sysFormServiceImpl.sysCreateButton(sysButtonAuthoritiesDto);
            List sysButtonAuthorities = sysButtonAuthoritiesDto.getButtonDtoList().stream().map(buttonDto -> {
                ButtonVo buttonVo = new ButtonVo();
                buttonVo.setButtonCode(buttonDto.getButtonCode());
                buttonVo.setButtonName(buttonDto.getButtonName());
                buttonVo.setChecked(Boolean.valueOf(authorizedButtonActions.contains(buttonVo.getButtonCode())));
                return buttonVo;
            }).collect(Collectors.toList());
            Map customButtonGroup = this.sysCustomButtonService.listCustomButtonByAppId(appId);
            List customButtons = Optional.ofNullable(customButtonGroup.get(sysForm.getId())).orElse(new ArrayList());
            List customButtonAuthorities = customButtons.stream().map(customButton -> {
                ButtonVo buttonVo = new ButtonVo();
                buttonVo.setButtonCode(customButton.getAction());
                buttonVo.setButtonName(customButton.getAlias());
                buttonVo.setChecked(Boolean.valueOf(authorizedButtonActions.contains(buttonVo.getButtonCode())));
                return buttonVo;
            }).collect(Collectors.toList());
            buttonVos.clear();
            buttonVos.addAll(sysButtonAuthorities);
            buttonVos.addAll(customButtonAuthorities);
        }
        return buttonAuthorityVoMap;
    }
}

