/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FormRoleVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"hussar.nocode.permission.controlType"}, havingValue="default", matchIfMissing=true)
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.permissionService")
public class DefaultPermissionServiceImpl
implements IPermissionService {
    @Resource
    private SysAppVisitRoleButtonMapper sysAppVisitRoleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper sysUpAppVisitRoleFieldMapper;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService roleOrganDataAuthorityService;
    @Resource
    private ISysAppVisitDataLogicService dataLogicService;
    @Autowired
    private ISysAppVisitDataLogicFilterService sysAppVisitDataLogicFilterService;

    public List<ButtonVo> getButtonRoleResource(Long formId, List<Long> rolesList) {
        return this.sysAppVisitRoleButtonMapper.selectByFromId(formId, rolesList);
    }

    public List<FormRoleVo> getFormAuthorizeRolesList(Long formId) {
        ApiResponse formAuthorizeRolesList = this.sysAppVisitFormAuthorizeRolesService.getFormAuthorizeRolesList(null, formId);
        if (!formAuthorizeRolesList.isSuccess() || HussarUtils.isEmpty((Object)formAuthorizeRolesList.getData())) {
            return Collections.emptyList();
        }
        return (List)formAuthorizeRolesList.getData();
    }

    public OrganDataAuthorityFeignVo formAuthorityOrganData(Long formId, Long roleId) {
        ApiResponse dataAuthorityFeignVoApiResponse = this.roleOrganDataAuthorityService.formAuthorityOrganData(formId, roleId);
        if (dataAuthorityFeignVoApiResponse.isSuccess() && HussarUtils.isNotEmpty((Object)dataAuthorityFeignVoApiResponse.getData())) {
            return (OrganDataAuthorityFeignVo)dataAuthorityFeignVoApiResponse.getData();
        }
        return null;
    }

    public DataLogicAuthorityVo dataLogicAuthorityByFormId(Long formId, Long roleId) {
        SysAppVisitDataLogic sysAppVisitDataLogic = (SysAppVisitDataLogic)this.dataLogicService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).eq(SysAppVisitDataLogic::getRoleId, (Object)roleId));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogic)) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
            List dataLogicFilterVos = this.sysAppVisitDataLogicFilterService.dataLogicFilterList(sysAppVisitDataLogic.getId());
            dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
            return dataLogicAuthorityVo;
        }
        return null;
    }

    public List<FieldAuthorityVo> getFormFieldAuthority(Long formId, List<Long> roleIds) {
        return this.sysUpAppVisitRoleFieldMapper.selectByFormId(formId, roleIds);
    }
}

