/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.SysAppAuthorizeDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppAuthorizeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.sysAppAuthorizeServiceImpl")
public class SysAppAuthorizeServiceImpl
extends HussarServiceImpl<SysAppAuthorizeMapper, SysAppAuthorize>
implements ISysAppAuthorizeService {
    @Resource
    private SysAppAuthorizeMapper appAuthorizeMapper;
    @Resource
    private ISysRolesExternalService sysRolesService;
    @Resource
    private ISysAppDevelopTeamService developTeamService;

    @HussarTransactional
    public Boolean addAuthorize(SysAppAuthorizeDto appAuthorizeDto) {
        List roleIds = appAuthorizeDto.getRoleIds();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysAppAuthorize::getAppId, (Object)appAuthorizeDto.getAppId());
        this.remove((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)roleIds)) {
            return true;
        }
        ArrayList appAuthorizeList = Lists.newArrayListWithCapacity((int)10);
        for (Long roleId : roleIds) {
            SysAppAuthorize appAuthorizeT = new SysAppAuthorize();
            appAuthorizeT.setAppId(appAuthorizeDto.getAppId());
            appAuthorizeT.setRoleId(roleId);
            appAuthorizeList.add(appAuthorizeT);
        }
        return this.saveBatch(appAuthorizeList);
    }

    public ApiResponse<List<RoleVo>> getAppRoleList(Long appId) {
        List<SysAppAuthorizeVo> appAuthorizeContainRoleInfo = this.appAuthorizeMapper.getAppAuthorizeContainRoleInfo(appId);
        if (HussarUtils.isEmpty(appAuthorizeContainRoleInfo)) {
            return ApiResponse.success(new ArrayList(), (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList roleVos = Lists.newArrayListWithCapacity((int)10);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (SysAppAuthorizeVo authorizeVo : appAuthorizeContainRoleInfo) {
            RoleVo roleVo = new RoleVo();
            roleVo.setId(authorizeVo.getRoleId());
            roleVo.setRoleName(authorizeVo.getRoleName());
            roleVos.add(roleVo);
            roleIds.add(authorizeVo.getRoleId());
        }
        List list = this.sysRolesService.getRoleInfoByIds(roleIds);
        Map<Long, RoleVo> map = list.stream().collect(Collectors.toMap(RoleVo::getId, r -> r));
        roleVos.forEach(r -> {
            RoleVo role = (RoleVo)map.get(r.getId());
            if (HussarUtils.isNotEmpty((Object)role)) {
                r.setRoleName(role.getRoleName());
            }
        });
        return ApiResponse.success((Object)roleVos);
    }

    public List<Long> getCurrentUserAuthorityApp() {
        SecurityUser user = BaseSecurityUtil.getUser();
        List rolesList = user.getRolesList();
        rolesList.add(user.getUserId());
        Map extendUserMap = user.getExtendUserMap();
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("deptId"))) {
            rolesList.add(Long.valueOf(extendUserMap.get("deptId").toString()));
        }
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("postId"))) {
            rolesList.add(Long.valueOf(extendUserMap.get("postId").toString()));
        }
        rolesList.add(-1L);
        List<Long> appIdList = new ArrayList<Long>();
        List authorizeList = this.list((Wrapper)new LambdaQueryWrapper().in(SysAppAuthorize::getRoleId, (Collection)rolesList));
        if (HussarUtils.isNotEmpty((Object)authorizeList)) {
            appIdList = authorizeList.stream().map(SysAppAuthorize::getAppId).distinct().collect(Collectors.toList());
        }
        return appIdList;
    }

    public boolean checkIfLoginUserHasAppAdminPermission(SysApplication app) {
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        boolean isSuperAdmin = loginUser.isSuperAdmin();
        boolean isInDevelopTeam = this.developTeamService.checkCurrentUserInTeam(app.getId());
        boolean isAppCreator = loginUser.getId().equals(app.getCreator());
        return isSuperAdmin || isInDevelopTeam || isAppCreator;
    }
}

