/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppPackageService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class AppPackageServiceImpl
implements IAppPackageService {
    @Resource
    private IAppExportInfoService appExportInfoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppPackageServiceImpl.class);

    public Long packageApp(Long appId, boolean crossPublishFlag) {
        Long exportFileId;
        AppExportDto appExportDto = new AppExportDto();
        appExportDto.setAppAuthRoleIds(new ArrayList());
        appExportDto.setFlowAuthRoleIds(new ArrayList());
        appExportDto.setFormAuthRoleIds(new ArrayList());
        appExportDto.setAppId(appId);
        appExportDto.setCrossPublish(crossPublishFlag);
        try {
            this.appExportInfoService.init(appExportDto);
            this.appExportInfoService.exportAppInfo(appExportDto);
            this.appExportInfoService.exportFormInfo(appExportDto);
            this.appExportInfoService.exportFormAuthorityInfo(appExportDto);
            this.appExportInfoService.exportDesignerMidFile(appExportDto);
            this.appExportInfoService.exportFlowConfigInfo(appExportDto);
            this.appExportInfoService.exportCommData(appExportDto);
            if (appExportDto.getExportDataFlag()) {
                this.appExportInfoService.exportBusinessData(appExportDto);
            }
            this.appExportInfoService.generateMetaInfo(appExportDto);
            exportFileId = this.appExportInfoService.uploadExportFile(appExportDto);
            this.appExportInfoService.clear();
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u6253\u5305\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new HussarException("\u5e94\u7528\u6253\u5305\u5f02\u5e38:" + e.getMessage());
        }
        return exportFileId;
    }
}

