/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportThreadService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportServiceImpl")
@HussarTokenDs
public class AppImportServiceImpl
implements IAppImportService {
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IAppImportThreadService appImportThreadService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    private static final Logger logger = LoggerFactory.getLogger(AppImportServiceImpl.class);

    public ApiResponse<AppAttachmentParseVo> parseAttachment(MultipartFile file) {
        String path;
        try {
            path = this.appFileExtendService.fileDecrypt(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = path.substring(0, path.length() - 7);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        AppExportMetaDto appExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, AppExportMetaDto.class);
        if (appExportMetaDto == null || HussarUtils.isEmpty((Object)appExportMetaDto.getAppName())) {
            return ApiResponse.fail((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u5e94\u7528\u6587\u4ef6");
        }
        AppAttachmentParseVo appAttachmentParseVo = new AppAttachmentParseVo();
        appAttachmentParseVo.setPath(unZipPath);
        appAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)appExportMetaDto.getPassword()));
        BeanUtils.copyProperties((Object)appExportMetaDto, (Object)appAttachmentParseVo);
        return ApiResponse.success((Object)appAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(AppImportDto appImportDto) {
        String inputPwd = DigestUtil.sha1Hex((String)appImportDto.getPassword());
        String metaFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "hussar.meta"});
        AppExportMetaDto appExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, AppExportMetaDto.class);
        assert (appExportMetaDto != null);
        String password = appExportMetaDto.getPassword();
        return ApiResponse.success((Object)inputPwd.equals(password));
    }

    public Boolean verifyAppName(String appName) {
        List existAppName = this.applicationService.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)appName));
        List recycleAppNames = this.sysAppRecycleService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppName, (Object)appName));
        return ToolUtil.isEmpty((Object)existAppName) && ToolUtil.isEmpty((Object)recycleAppNames);
    }

    @Async
    public void importApp(AppImportDto appImportDto, SecurityUser user, String importCacheKey) throws Exception {
        logger.info("\u5e94\u7528\u5bfc\u5165 => \u5f00\u59cb\u6267\u884c...");
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
        TransmittableThreadLocalHolder.set((String)"importCacheKey", (Object)importCacheKey);
        this.appImportThreadService.startImportThread(appImportDto);
        TransmittableThreadLocalHolder.clear((String)"loginUser");
        logger.info("\u5e94\u7528\u5bfc\u5165 => \u6267\u884c\u5b8c\u6bd5\uff01");
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class));
    }

    public void importSuccessCallBack(String appId) {
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)((Object)appId));
        if (ToolUtil.isNotEmpty((Object)application) && HussarUtils.isNotEmpty((Object)application.getDevelopRoleId())) {
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            Map extendUserMap = userDetails.getExtendUserMap();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            Object rolesList = extendUserMap.get("rolesList");
            if (HussarUtils.isNotEmpty(rolesList)) {
                roleIds.addAll((List)rolesList);
            }
            roleIds.add(application.getDevelopRoleId());
            userDetails.addExtendUserMap("rolesList", roleIds);
            SecurityUtil.getTokenSession((String)userDetails.getTokenValue(), (String)userDetails.getTenantCode()).addUserDetailToTokenSession(userDetails, userDetails.getTokenValue(), userDetails.getTenantCode());
            HussarCacheUtil.evict((String)"login_user_info", (Object)userDetails.getAccessToken());
        }
    }
}

