/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.rule.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleTrigger;
import com.jxdinfo.hussar.formdesign.application.message.middle.RepeatRule;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysTimingTriggerTask;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerTaskService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class TimingTriggerTaskPoller
implements BasicProcessor {
    @Resource
    private ISysTimingTriggerTaskService sysTimingTriggerTaskService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    @Resource
    private NoCodeRuleTrigger noCodeRuleTrigger;
    private static final String EXECUTE_STATUS = "1";
    private static final String UN_EXECUTE_STATUS = "0";
    private static final Logger logger = LoggerFactory.getLogger(TimingTriggerTaskPoller.class);

    public ProcessResult process(TaskContext taskContext) {
        ProcessResult processResult = new ProcessResult(true);
        LocalDateTime now = LocalDateTime.now();
        logger.info("\u4e1a\u52a1\u89c4\u5219\u5b9a\u65f6\u89e6\u53d1 => \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff1a{}", (Object)now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        List sysTimingTriggerTaskList = this.sysTimingTriggerTaskService.queryTriggerTaskList(now);
        logger.info("\u4e1a\u52a1\u89c4\u5219\u5b9a\u65f6\u89e6\u53d1 => \u5f53\u524d\u5f85\u6267\u884c\u4efb\u52a1\u5217\u8868\uff1a{}", sysTimingTriggerTaskList.stream().map(SysTimingTriggerTask::getId).collect(Collectors.toList()));
        if (HussarUtils.isNotEmpty((Object)sysTimingTriggerTaskList)) {
            ArrayList<SysTimingTriggerTask> updatedTasks = new ArrayList<SysTimingTriggerTask>();
            ArrayList<SysTimingTriggerTask> newTasks = new ArrayList<SysTimingTriggerTask>();
            for (SysTimingTriggerTask sysTimingTriggerTask : sysTimingTriggerTaskList) {
                try {
                    this.noCodeRuleTrigger.triggeredByCond(sysTimingTriggerTask);
                }
                catch (Exception e) {
                    logger.error("\u5b9a\u65f6\u89e6\u53d1\u4e1a\u52a1\u89c4\u5219\uff0c\u6267\u884c\u52a8\u4f5c\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
                }
                sysTimingTriggerTask.setExecuteStatus(EXECUTE_STATUS);
                sysTimingTriggerTask.setExecuteTime(now);
                updatedTasks.add(sysTimingTriggerTask);
                RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)sysTimingTriggerTask.getRepeatRule(), RepeatRule.class);
                if ("only_once".equals(repeatRule.getType())) continue;
                LocalDateTime nextReminderTime = repeatRule.calculateNextReminderTime(sysTimingTriggerTask.getFirstTriggerTime(), now);
                if (!HussarUtils.isEmpty((Object)sysTimingTriggerTask.getEndTriggerTime()) && nextReminderTime.isAfter(sysTimingTriggerTask.getEndTriggerTime())) continue;
                SysTimingTriggerTask newTask = new SysTimingTriggerTask();
                BeanUtils.copyProperties((Object)sysTimingTriggerTask, (Object)newTask);
                newTask.setId(null);
                newTask.setNextTriggerTime(nextReminderTime);
                newTask.setExecuteStatus(UN_EXECUTE_STATUS);
                newTask.setExecuteTime(null);
                newTasks.add(newTask);
            }
            this.sysTimingTriggerTaskService.updateBatchById(updatedTasks);
            logger.info("\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u5b8c\u6bd5" + JSONObject.toJSONString(updatedTasks));
            this.sysTimingTriggerTaskService.saveBatch(newTasks);
            logger.info("\u521b\u5efa\u7684\u65b0\u4efb\u52a1" + JSONObject.toJSONString(updatedTasks));
        }
        return processResult;
    }
}

