/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.property.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.formdesign.application.property.dao.WidgetExpMapper;
import com.jxdinfo.hussar.formdesign.application.property.model.WidgetExp;
import com.jxdinfo.hussar.formdesign.application.property.model.WidgetExpGroup;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpGroupService;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.property.vo.WidgetExpGroupVo;
import com.jxdinfo.hussar.formdesign.application.property.vo.WidgetExpVo;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class WidgetExpServiceImpl
extends HussarServiceImpl<WidgetExpMapper, WidgetExp>
implements IWidgetExpService {
    @Resource
    private WidgetExpMapper widgetExpMapper;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private IWidgetExpGroupService widgetExpGroupService;
    private static final Logger LOGGER = LoggerFactory.getLogger(WidgetExpServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> importWidget(Long fileId, Long groupId) {
        String tempUnzipFilePath = null;
        try {
            AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)fileId);
            if (HussarUtils.isNotEmpty((Object)attachmentModel)) {
                String fileName = attachmentModel.getAttachmentName();
                String suffix = this.getSuffix(fileName);
                String attachmentPath = attachmentModel.getAttachmentDir() + fileId + suffix;
                try {
                    tempUnzipFilePath = ZipUtil.unzip((String)attachmentPath).getAbsolutePath();
                }
                catch (Exception e) {
                    LOGGER.error("\u89e3\u538bzip\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    throw new BaseException("\u4e0a\u4f20\u9644\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
                }
                String manifestPath = FileUtil.posixPath((String[])new String[]{tempUnzipFilePath, "manifest.json"});
                if (!new File(manifestPath).exists()) {
                    throw new BaseException("\u4e0a\u4f20\u9644\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
                }
                JSONObject manifestData = AppMigrateUtil.readFileToObject(manifestPath, JSONObject.class);
                if (HussarUtils.isNotEmpty((Object)manifestData)) {
                    if (!"JXDNExtWidget".equals(manifestData.getString("type"))) {
                        throw new BaseException("\u4e0a\u4f20\u9644\u4ef6\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
                    }
                    String widgetName = manifestData.getString("name");
                    LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(WidgetExp::getName, (Object)widgetName);
                    WidgetExp oldWidget = (WidgetExp)this.getOne((Wrapper)wrapper);
                    if (HussarUtils.isNotEmpty((Object)oldWidget)) {
                        this.assignValueToWidget(manifestData, oldWidget);
                        oldWidget.setFileId(fileId);
                        oldWidget.setGroupId(groupId);
                        oldWidget.setDelFlag("0");
                        this.updateById((BaseEntity)oldWidget);
                        AppMigrateUtil.deleteFolder(this.getUnzipPath(oldWidget.getName()));
                        ZipUtil.unzip((String)attachmentPath, (String)this.getUnzipPath(oldWidget.getName()));
                    } else {
                        WidgetExp widgetExp = new WidgetExp();
                        this.assignValueToWidget(manifestData, widgetExp);
                        widgetExp.setFileId(fileId);
                        widgetExp.setGroupId(groupId);
                        widgetExp.setDelFlag("0");
                        this.save((BaseEntity)widgetExp);
                        ZipUtil.unzip((String)attachmentPath, (String)this.getUnzipPath(widgetExp.getName()));
                    }
                }
            }
            ApiResponse apiResponse = ApiResponse.success();
            return apiResponse;
        }
        finally {
            if (HussarUtils.isNotEmpty(tempUnzipFilePath)) {
                AppMigrateUtil.deleteFolder(tempUnzipFilePath);
            }
        }
    }

    public ApiResponse<List<WidgetExpGroupVo>> getWidgets(String widgetName) {
        ArrayList<WidgetExpGroupVo> widgetExpGroupVos = new ArrayList<WidgetExpGroupVo>();
        List widgetExpGroups = this.widgetExpGroupService.list();
        List<WidgetExpVo> widgetExpVos = this.widgetExpMapper.getWidgetsByTitle(widgetName);
        for (WidgetExpGroup widgetExpGroup : widgetExpGroups) {
            WidgetExpGroupVo widgetExpGroupVo = new WidgetExpGroupVo();
            BeanUtils.copyProperties((Object)widgetExpGroup, (Object)widgetExpGroupVo);
            if (HussarUtils.isNotEmpty(widgetExpVos)) {
                List widgets = widgetExpVos.stream().filter(widgetExpVo -> Objects.equals(widgetExpVo.getGroupId(), widgetExpGroup.getGroupId())).collect(Collectors.toList());
                widgetExpGroupVo.setWidgets(widgets);
            }
            widgetExpGroupVos.add(widgetExpGroupVo);
        }
        return ApiResponse.success(widgetExpGroupVos);
    }

    public ApiResponse<Page<WidgetExpVo>> getWidgetsPage(PageInfo pageInfo, String widgetName, Long widgetGroupId) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<WidgetExpVo> widgetsList = this.widgetExpMapper.getWidgetsPage((Page<WidgetExpVo>)page, widgetName, widgetGroupId);
        page.setRecords(widgetsList);
        return ApiResponse.success((Object)page);
    }

    public void showImage(String widgetName, String fileName, HttpServletResponse response) {
        String logoPath = FileUtil.posixPath((String[])new String[]{this.getUnzipPath(widgetName), "assets", fileName});
        byte[] data = this.readFileToBinaryByPath(logoPath);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("image/jpeg;charset=UTF-8");
            IOUtils.write((byte[])data, (OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u7ec4\u4ef6\u56fe\u6807\u5931\u8d25\uff1a{}\uff01", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u8bfb\u53d6\u7ec4\u4ef6\u56fe\u6807\u5931\u8d25");
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)os)) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u62d3\u5c55\u7ec4\u4ef6\u8bfb\u53d6\u56fe\u6807\u54cd\u5e94\u6d41\u5173\u95ed\u5931\u8d25\uff1a{}\uff01", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public void downloadWidget(Long fileId, HttpServletResponse response) {
        this.attachmentManagerService.fileDownload(response, fileId);
    }

    public void deleteWidget(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(WidgetExp::getId, (Object)id);
        WidgetExp widget = (WidgetExp)this.getOne((Wrapper)wrapper);
        widget.setDelFlag("1");
        ((WidgetExpMapper)this.baseMapper).updateById(widget);
    }

    public String getWidgetFileContent(String widgetName, String fileName) throws IOException {
        String filePath = FileUtil.posixPath((String[])new String[]{this.getUnzipPath(widgetName), fileName});
        if (!new File(filePath).exists()) {
            throw new BaseException("\u6307\u5b9a\u6587\u4ef6\u540d\u8d44\u6e90\u4e0d\u5b58\u5728\uff01");
        }
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    public List<WidgetExp> getWidgetsByName(List<String> widgetNames) {
        if (HussarUtils.isEmpty(widgetNames)) {
            return new ArrayList<WidgetExp>();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(WidgetExp::getName, widgetNames);
        return ((WidgetExpMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private void assignValueToWidget(JSONObject manifestData, WidgetExp widgetExp) {
        widgetExp.setName(manifestData.getString("name"));
        widgetExp.setTitle(manifestData.getString("title"));
        widgetExp.setType(manifestData.getString("type"));
        widgetExp.setLogo(manifestData.getString("logo"));
        widgetExp.setDescription(manifestData.getString("description"));
        widgetExp.setAuthor(manifestData.getString("author"));
        widgetExp.setVersion(manifestData.getString("version"));
        widgetExp.setOptions(manifestData.getString("options"));
    }

    private String getUnzipPath(String widgetName) {
        String backProjectPath = this.formDesignProperties.getBackProjectPath();
        String noCodeStore = ".noCode-store";
        String expWidgetFIleName = "expWidgets";
        return FileUtil.posixPath((String[])new String[]{backProjectPath, noCodeStore, expWidgetFIleName, widgetName});
    }

    private byte[] readFileToBinaryByPath(String filePath) {
        try {
            byte[] data;
            try (FileInputStream fis = new FileInputStream(filePath);){
                data = IoUtil.readToByteArray((InputStream)fis);
            }
            return data;
        }
        catch (IOException var17) {
            LOGGER.error("errorMessage:{}", (Object)var17.getMessage(), (Object)var17);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }
}

