/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogAsync;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogComponent;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogThreadLocal;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.OperateLogType;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.DataOperateLog;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.vo.SysDataLogUserInfo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataOperateLogAspect {
    @Resource
    private OperateLogComponent operateLogComponent;
    @Resource
    private OperateLogAsync operateLogAsync;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private OperateLogThreadLocal operateLogThreadLocal;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataOperateLogAspect.class);

    @Around(value="execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.formSave(..)) && @annotation(dataOperateLog)")
    public Object formSaveAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        String saveDataOperateLog = dataOperateLog.saveDataOperateLog();
        if (HussarUtils.isNotEmpty((Object)saveDataOperateLog) && saveDataOperateLog.startsWith("#")) {
            String paramName = saveDataOperateLog.substring(1);
            Object[] values = joinPoint.getArgs();
            String[] names = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
            Boolean saveDataOperateLogValue = null;
            for (int i = 0; i < names.length; ++i) {
                if (!HussarUtils.equals((Object)paramName, (Object)names[i])) continue;
                saveDataOperateLogValue = (Boolean)values[i];
                break;
            }
            if (HussarUtils.equals((Object)Boolean.FALSE, saveDataOperateLogValue)) {
                return joinPoint.proceed();
            }
        }
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        JSONObject oldData = new JSONObject();
        JSONArray childList = new JSONArray();
        JSONArray childCountList = new JSONArray();
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        HashMap<String, Object> oldParams = new HashMap<String, Object>();
        JSONArray widgets = new JSONArray();
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        String tableName = "";
        Object formData = args[1];
        String appId = String.valueOf(args[2]);
        try {
            tableName = sysForm.getTableName();
            JSONObject data = this.operateLogComponent.toJsonObj(formData);
            Object dataIdObj = data.get((Object)tableName);
            if (HussarUtils.isNotEmpty((Object)dataIdObj)) {
                String dataId = String.valueOf(dataIdObj);
                oldData = this.operateLogComponent.getDataFormDB(dataId, appId, String.valueOf(formId), "0");
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("formSave\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38\uff0c\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u8868\u5355id\uff1a{}\uff0c\u6570\u636e\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, formData, e.getMessage()});
        }
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        String dataId = "";
        JSONObject newData = new JSONObject();
        try {
            dataId = String.valueOf(((ApiResponse)((ResponseEntity)value).getBody()).getData());
            newData = this.operateLogComponent.getDataFormDB(dataId, appId, String.valueOf(formId), "0");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4fdd\u5b58\u540e\u7684\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        this.operateLogAsync.formSaveAsync(value, tableName, appId, String.valueOf(formId), oldData, childList, childCountList, newParams, oldParams, userId, operateLogType, widgets, newData, dataId);
        return value;
    }

    @Around(value="execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.formIncrementSave(..)) && @annotation(dataOperateLog)")
    public Object formIncrementSaveAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        int mode = operateLogType.getMode();
        AtomicInteger type = null;
        JSONArray oldDataS = new JSONArray();
        JSONArray newDataS = new JSONArray();
        JSONArray editIds = new JSONArray();
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        String tableName = "";
        Object formData = args[1];
        String appId = String.valueOf(args[2]);
        JSONObject data = this.operateLogComponent.toJsonObj(formData);
        JSONArray oldArray = new JSONArray();
        Object saveAndUpdate = data.get((Object)"saveAndUpdate");
        try {
            Object jsonObject;
            Object dataObj;
            tableName = sysForm.getTableName();
            if (HussarUtils.isNotEmpty((Object)saveAndUpdate) && HussarUtils.isNotEmpty((Object)(dataObj = (jsonObject = (JSONObject)saveAndUpdate).get((Object)tableName)))) {
                oldArray.addAll((Collection)JSON.parseArray((String)JSON.toJSONString((Object)dataObj)));
            }
            if (mode == 1) {
                type = new AtomicInteger(2);
                for (Object jsonObj2 : oldArray) {
                    Object o = ((JSONObject)jsonObj2).get((Object)"RECORD_ID");
                    if (!HussarUtils.isNull((Object)o)) {
                        if (!"".equals(String.valueOf(o))) continue;
                        type.set(3);
                        break;
                    }
                    type.set(1);
                }
                if (type.get() == 2) {
                    this.operateLogComponent.getDataSBatch(oldArray, tableName, oldDataS, Long.valueOf(appId), formId);
                }
                if (type.get() == 3) {
                    List<Object> editList = oldArray.stream().filter(jsonObj -> !"".equals(((JSONObject)jsonObj).get((Object)"RECORD_ID"))).collect(Collectors.toList());
                    editList.forEach(jsonObj -> {
                        String id = String.valueOf(((JSONObject)jsonObj).get((Object)"RECORD_ID"));
                        editIds.add((Object)id);
                    });
                    this.operateLogComponent.getDataSBatch(new JSONArray(editList), tableName, oldDataS, Long.valueOf(appId), formId);
                }
            } else {
                this.operateLogComponent.getDataSBatch(oldArray, tableName, oldDataS, Long.valueOf(appId), formId);
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("formIncrementSave\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38\uff0c\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u8868\u5355id\uff1a{}\uff0c\u6570\u636e\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{formId, formData, e});
        }
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        LOGGER.info("\u64cd\u4f5c\u7c7b\u578b\uff1a{}\uff0c\u64cd\u4f5c\u6a21\u5f0f\uff1a{}", (Object)type, (Object)mode);
        this.operateLogAsync.formIncrementSaveAsync(formData, tableName, Long.valueOf(appId), type, formId, oldDataS, newDataS, userId, operateLogType, editIds);
        return value;
    }

    @Around(value="execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.tableSave(..)) && @annotation(dataOperateLog)")
    public Object tableSaveAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        SysForm sysForm;
        int mode;
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[1]));
        Long appId = Long.valueOf(String.valueOf(args[0]));
        Map map = (Map)args[2];
        String oldString = JSON.toJSONString((Object)map);
        JSONObject oldObj = JSON.parseObject((String)oldString);
        AtomicInteger type = null;
        JSONArray oldArray = this.operateLogComponent.getJsonObj(oldObj);
        OperateLogType operateLogType1 = new OperateLogType();
        OperateLogType operateLogType = this.operateLogThreadLocal.get();
        if (HussarUtils.isEmpty((Object)operateLogType)) {
            operateLogType1.setMode(-1);
            operateLogType1.setTriggerFormId(null);
            operateLogType1.setDevice("Unknown");
        } else {
            operateLogType1.setMode(operateLogType.getMode());
            operateLogType1.setTriggerFormId(operateLogType.getTriggerFormId());
            operateLogType1.setDevice(device);
            operateLogType1.setDataPullCreator(operateLogType.getDataPullCreator());
        }
        if (operateLogType1.getMode() == 6) {
            userId = operateLogType1.getDataPullCreator();
        }
        if ((mode = operateLogType1.getMode()) == 5 || mode == 1 || mode == 6) {
            this.operateLogThreadLocal.remove();
        }
        if (HussarUtils.isEmpty((Object)(sysForm = (SysForm)this.sysFormService.getById((Serializable)formId)))) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        String tableName = "";
        JSONArray oldDataS = new JSONArray();
        JSONArray newDataS = new JSONArray();
        JSONArray editIds = new JSONArray();
        try {
            Object o;
            tableName = sysForm.getTableName();
            if (mode == 4 || mode == 5 || mode == 6) {
                for (Object jsonObj2 : oldArray) {
                    o = ((JSONObject)jsonObj2).get((Object)tableName);
                    editIds.add(o);
                }
            }
            if (mode == 1) {
                type = new AtomicInteger(2);
                for (Object jsonObj2 : oldArray) {
                    o = ((JSONObject)jsonObj2).get((Object)"RECORD_ID");
                    if (!HussarUtils.isNull((Object)o)) {
                        if (!"".equals(String.valueOf(o))) continue;
                        type.set(3);
                        break;
                    }
                    type.set(1);
                }
                if (type.get() == 2) {
                    this.operateLogComponent.getDataSBatch(oldArray, tableName, oldDataS, appId, formId);
                }
                if (type.get() == 3) {
                    List<Object> editList = oldArray.stream().filter(jsonObj -> !"".equals(((JSONObject)jsonObj).get((Object)"RECORD_ID"))).collect(Collectors.toList());
                    editList.forEach(jsonObj -> {
                        String id = String.valueOf(((JSONObject)jsonObj).get((Object)"RECORD_ID"));
                        editIds.add((Object)id);
                    });
                    this.operateLogComponent.getDataSBatch(new JSONArray(editList), tableName, oldDataS, appId, formId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("tableSaveAround\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38,\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5e94\u7528id:{},\u8868\u5355id:{},\u4fdd\u5b58\u524d\u6570\u636e\uff1a{}", new Object[]{appId, formId, oldArray});
        }
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        if (mode == -1) {
            LOGGER.error("tableSaveAround\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38,\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5e94\u7528id:{},\u8868\u5355id:{},\u4fdd\u5b58\u524d\u6570\u636e\uff1a{}", new Object[]{appId, formId, oldArray});
            return null;
        }
        this.operateLogAsync.taleSaveAsync(map, tableName, appId, formId, oldDataS, newDataS, editIds, userId, operateLogType1, type);
        return null;
    }

    @Around(value="(execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.flowFormSubmit(..)) || execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.prevNodeReject(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.anyNodeReject(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.initialNodeReject(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.taskEntrust(..))|| execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.endProcess(..)))&& @annotation(dataOperateLog)")
    public Object flowFormAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        JSONArray childList = new JSONArray();
        JSONArray childCountList = new JSONArray();
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        HashMap<String, Object> oldParams = new HashMap<String, Object>();
        JSONArray widgets = new JSONArray();
        JSONObject oldData = new JSONObject();
        Object[] args = joinPoint.getArgs();
        Long formId = Long.valueOf(String.valueOf(args[0]));
        Object arg = args[1];
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        if (HussarUtils.isEmpty((Object)sysForm)) {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,\u8868\u5355id\uff1a{}", (Object)formId);
        }
        String tableName = "";
        Long appId = sysForm.getAppId();
        JSONObject data = this.operateLogComponent.toJsonObj(arg);
        Object formDataObj = data.get((Object)"formData");
        JSONObject formData = this.operateLogComponent.toJsonObj(formDataObj);
        try {
            tableName = sysForm.getTableName();
            if (HussarUtils.isNotEmpty((Object)formData.get((Object)tableName))) {
                String dataId = String.valueOf(formData.get((Object)tableName));
                oldData = this.operateLogComponent.getDataFormDB(dataId, String.valueOf(appId), String.valueOf(formId), "0");
            }
            LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("flowFormSubmit\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5f02\u5e38,\u65e5\u5fd7\u8bb0\u5f55\u53d6\u6d88,\u5e94\u7528id:{},\u8868\u5355id:{},\u4fdd\u5b58\u524d\u6570\u636e\uff1a{}", new Object[]{appId, formId, formData});
        }
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        String dataId = "";
        JSONObject newData = new JSONObject();
        try {
            dataId = String.valueOf(((ApiResponse)((ResponseEntity)value).getBody()).getData());
            newData = this.operateLogComponent.getDataFormDB(dataId, String.valueOf(appId), String.valueOf(formId), "0");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u4fdd\u5b58\u540e\u7684\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        this.operateLogAsync.flowFormSubmitAsync(value, tableName, appId, formId, oldData, childList, childCountList, newParams, oldParams, userId, operateLogType, widgets, newData, dataId);
        return value;
    }

    @Around(value="execution(* com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService.deleteBatch(..)) && @annotation(dataOperateLog)")
    public Object deleteBatchAround(ProceedingJoinPoint joinPoint, DataOperateLog dataOperateLog) throws Throwable {
        OperateLogType operateLogType = new OperateLogType();
        OperateLogType operateLogType1 = this.operateLogThreadLocal.get();
        if (HussarUtils.isNotEmpty((Object)operateLogType1)) {
            operateLogType.setMode(operateLogType1.getMode());
            operateLogType.setTriggerFormId(operateLogType1.getTriggerFormId());
            operateLogType.setRuleCreator(operateLogType1.getRuleCreator());
            operateLogType.setButtonId(operateLogType1.getButtonId());
            operateLogType.setDataPullCreator(operateLogType1.getDataPullCreator());
        }
        SysDataLogUserInfo userInfo = this.beforeHandler(dataOperateLog);
        String device = userInfo.getDevice();
        Long userId = userInfo.getUserId();
        if (operateLogType.getMode() == 6) {
            userId = operateLogType.getDataPullCreator();
        } else if (userId == 0L && HussarUtils.isNotEmpty((Object)operateLogType.getRuleCreator())) {
            userId = operateLogType.getRuleCreator();
        }
        operateLogType.setDevice(device);
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u524d\u89e3\u6790\u5df2\u5b8c\u6210");
        Object value = joinPoint.proceed();
        LOGGER.info("\u76ee\u6807\u65b9\u6cd5\u6267\u884c\u5df2\u5b8c\u6210");
        this.operateLogAsync.delDataLogAsync(joinPoint, userId, operateLogType);
        return value;
    }

    private SysDataLogUserInfo beforeHandler(DataOperateLog dataOperateLog) {
        Long userId;
        SysDataLogUserInfo userInfo = new SysDataLogUserInfo();
        LOGGER.info("\u6570\u636e\u64cd\u4f5c\u65e5\u5fd7\u5207\u9762\u6267\u884c\u5f00\u59cb\uff0c\u6a21\u5757\u540d\u79f0:{}\uff0c\u5177\u4f53\u4e1a\u52a1\u540d\u79f0\uff1a{}", (Object)dataOperateLog.moduleCode(), (Object)dataOperateLog.handleName());
        SecurityUser user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        String device = String.valueOf(HussarUtils.isNotEmpty((Object)TransmittableThreadLocalHolder.get((String)"device")) ? TransmittableThreadLocalHolder.get((String)"device") : "Unknown");
        if (HussarUtils.isEmpty((Object)user)) {
            LOGGER.error("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f");
            userId = 0L;
        } else {
            userId = HussarUtils.isNull((Object)user.getId()) ? Long.valueOf(0L) : user.getId();
        }
        userInfo.setUserId(userId);
        userInfo.setDevice(device);
        return userInfo;
    }
}

