/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.message.job;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.application.message.middle.RepeatRule;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushTask;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushTaskService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.msg.push.dto.AppImSendArticleDto;
import com.jxdinfo.hussar.msg.push.service.PushMsgService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class MsgPushTaskPoller
implements BasicProcessor {
    @Resource
    private SysMsgPushTaskService msgPushTaskService;
    @Resource
    private CanvasService canvasService;
    @Autowired(required=false)
    private PushMsgService pushMsgService;
    @Value(value="${hussar.nocode.redirect.long.ip}")
    private String socket;
    private static final Logger LOGGER = LoggerFactory.getLogger(MsgPushTaskPoller.class);

    public ProcessResult process(TaskContext taskContext) {
        LocalDateTime now = LocalDateTime.now();
        LOGGER.info("\u6d88\u606f\u63a8\u9001 => \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff1a{}", (Object)now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        List sysMsgPushTasks = this.msgPushTaskService.queryMsgPushTasks(now);
        LOGGER.info("\u6d88\u606f\u63a8\u9001 => \u5f53\u524d\u5f85\u63a8\u9001\u4efb\u52a1\u5217\u8868\uff1a{}", sysMsgPushTasks.stream().map(SysMsgPushTask::getId).collect(Collectors.toList()));
        if (HussarUtils.isNotEmpty((Object)sysMsgPushTasks)) {
            for (SysMsgPushTask sysMsgPushTask : sysMsgPushTasks) {
                try {
                    this.invokeMessageCenterInterface(sysMsgPushTask);
                }
                catch (Exception e) {
                    LOGGER.error("\u6d88\u606f\u63a8\u9001 => \u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25", (Throwable)e);
                }
            }
            ArrayList<SysMsgPushTask> updatedTasks = new ArrayList<SysMsgPushTask>();
            ArrayList<SysMsgPushTask> newTasks = new ArrayList<SysMsgPushTask>();
            for (SysMsgPushTask sysMsgPushTask : sysMsgPushTasks) {
                LocalDateTime nextReminderTime;
                sysMsgPushTask.setStatus("1");
                sysMsgPushTask.setExecuteTime(now);
                updatedTasks.add(sysMsgPushTask);
                RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)sysMsgPushTask.getRepeatRule(), RepeatRule.class);
                if ("only_once".equals(repeatRule.getType()) || (nextReminderTime = repeatRule.calculateNextReminderTime(sysMsgPushTask.getFirstReminderTime(), now)).isAfter(sysMsgPushTask.getEndReminderTime())) continue;
                SysMsgPushTask newTask = new SysMsgPushTask();
                BeanUtils.copyProperties((Object)sysMsgPushTask, (Object)newTask);
                newTask.setId(null);
                newTask.setNextReminderTime(nextReminderTime);
                newTask.setStatus("0");
                newTask.setExecuteTime(null);
                newTasks.add(newTask);
            }
            this.msgPushTaskService.saveBatch(newTasks);
            this.msgPushTaskService.updateBatchById(updatedTasks);
        }
        return null;
    }

    @Async
    void invokeMessageCenterInterface(SysMsgPushTask sysMsgPushTask) {
        List modes = JSON.parseArray((String)sysMsgPushTask.getReminderMode(), String.class);
        Iterator iterator = modes.iterator();
        block12: while (iterator.hasNext()) {
            String mode;
            switch (mode = (String)iterator.next()) {
                case "app_im": {
                    AppImSendArticleDto imPushDto = new AppImSendArticleDto();
                    imPushDto.setAppId("formMsgPush");
                    imPushDto.setAppSecret("296416d4aff41d2ead60e4d790e72318");
                    imPushDto.setSceneCode("formMsgPush");
                    String reminders = sysMsgPushTask.getReminders();
                    reminders = reminders.substring(1, reminders.length() - 1);
                    imPushDto.setUserIds(Arrays.asList(reminders.split(",")));
                    imPushDto.setText(sysMsgPushTask.getReminderContent());
                    imPushDto.setUrl(this.assemblyUrl(sysMsgPushTask));
                    LOGGER.info("\u8868\u5355\u6d88\u606f\u63a8\u9001 => \u6267\u884c\u63a8\u9001\u4efb\u52a1 {}", (Object)sysMsgPushTask.getId());
                    this.pushMsgService.sendAppImArticleMsg(imPushDto);
                    continue block12;
                }
                case "sms": {
                    LOGGER.info("\u77ed\u4fe1");
                    continue block12;
                }
                case "mail": {
                    LOGGER.info("\u90ae\u7bb1");
                    continue block12;
                }
                case "app_push": {
                    LOGGER.info("APP \u901a\u77e5");
                    continue block12;
                }
            }
            throw new HussarException("\u63d0\u9192\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        }
    }

    private String assemblyUrl(SysMsgPushTask task) {
        String formType = "";
        try {
            formType = ((FormCanvasSchema)this.canvasService.get(String.valueOf(task.getFormId())).getData()).getFormType();
        }
        catch (Exception e) {
            LOGGER.error("\u6d88\u606f\u63a8\u9001 => \u83b7\u53d6\u8868\u5355\u753b\u5e03\u4fe1\u606f\u5931\u8d25");
        }
        StringBuilder url = new StringBuilder(this.socket);
        if (HussarUtils.isEmpty((Object)task.getDataId())) {
            url.append("/hussarApp/#/container/list?appId=").append(task.getAppId()).append("&formId=").append(task.getFormId()).append("&formType=").append(formType);
        } else {
            url.append("/hussarApp/#/container/form?id=").append(task.getDataId()).append("&appId=").append(task.getAppId()).append("&formId=").append(task.getFormId()).append("&formType=").append(formType);
            if ("1".equals(formType)) {
                url.append("&tabType=0");
            }
        }
        return url.toString();
    }
}

