/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.button.aspect;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.button.utils.CustomButtonUtil;
import com.jxdinfo.hussar.formdesign.application.form.service.impl.SysFormServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ButtonAuthorityAspect {
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysFormServiceImpl sysFormServiceImpl;

    @Pointcut(value="execution(* com.jxdinfo.hussar.formdesign.application.authority.service.impl.SysAppVisitRoleButtonServiceImpl.getButtonAuthorityRolesList(..))")
    public void updateButtonAuthorityVo() {
    }

    @AfterReturning(value="updateButtonAuthorityVo()", returning="buttonResponse")
    public ApiResponse<List<ButtonVo>> afterReturningButtonAuthority(JoinPoint joinPoint, ApiResponse<List<ButtonVo>> buttonResponse) {
        List buttonAuthorities = (List)buttonResponse.getData();
        List authorizedButtonActions = buttonAuthorities.stream().map(ButtonVo::getButtonCode).collect(Collectors.toList());
        ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
        this.sysFormServiceImpl.sysCreateButton(buttonAuthoritiesDto);
        List sysButtonAuthorities = buttonAuthoritiesDto.getButtonDtoList().stream().map(buttonDto -> {
            ButtonVo buttonVo = new ButtonVo();
            buttonVo.setButtonCode(buttonDto.getButtonCode());
            buttonVo.setButtonName(buttonDto.getButtonName());
            buttonVo.setChecked(Boolean.valueOf(authorizedButtonActions.contains(buttonVo.getButtonCode())));
            return buttonVo;
        }).collect(Collectors.toList());
        Object[] args = joinPoint.getArgs();
        CustomButtonUtil.isEmpty(args).throwMessage("\u53c2\u6570\u4e3a\u7a7a");
        Long formId = (Long)args[0];
        List sysCustomButtons = this.sysCustomButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId)).orderByAsc(SysCustomButton::getSeq));
        List customButtonAuthorities = sysCustomButtons.stream().map(sysCustomButton -> {
            ButtonVo buttonVo = new ButtonVo();
            buttonVo.setButtonCode(sysCustomButton.getAction());
            buttonVo.setButtonName(sysCustomButton.getAlias());
            buttonVo.setChecked(Boolean.valueOf(authorizedButtonActions.contains(buttonVo.getButtonCode())));
            return buttonVo;
        }).collect(Collectors.toList());
        buttonAuthorities.clear();
        buttonAuthorities.addAll(sysButtonAuthorities);
        buttonAuthorities.addAll(customButtonAuthorities);
        return buttonResponse;
    }
}

