/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.application.application.constants.AppUpgradeConstant;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.UpgradeMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.enums.AppUpgradeType;
import com.jxdinfo.hussar.formdesign.application.application.model.SysApplicationVersion;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppPackageService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpChildrenTableContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpFormContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpGroupContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ChildWidgetVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVersionVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysFormWithChildren;
import com.jxdinfo.hussar.formdesign.application.application.vo.UpgradeStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.application.util.AppIoUtil;
import com.jxdinfo.hussar.formdesign.application.util.AppUpgradeUtil;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.mail.core.map.MapUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class AppUpgradeServiceImpl
implements IAppUpgradeService {
    @Resource
    private CanvasService canvasService;
    @Resource
    private IAppImportService appImportService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IAppUpgradeInfoService appUpgradeInfoService;
    @Resource
    private IAppPackageService appPackageService;
    @Resource
    private ISysApplicationVersionService sysApplicationVersionService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppUpgradeServiceImpl.class);

    public ApiResponse<AppAttachmentParseVo> analyzeUpgradePackage(MultipartFile upgradePackage) {
        return this.appImportService.parseAttachment(upgradePackage);
    }

    public ApiResponse<Boolean> verifyPassword(AppUpgradeDto appUpgradeDto) {
        return this.appImportService.verifyPassword((AppImportDto)appUpgradeDto);
    }

    public ApiResponse<List<AppUpGroupContrast>> contrastForm(AppUpgradeDto appUpgradeDto) {
        List<SysFormGroupVo> sysFormGroupVoList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "formGroups", SysFormGroupVo.class);
        List<SysFormVo> sysFormVoList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "forms", SysFormVo.class);
        SysSiftGroupList upgradeSiftGroup = this.sysFormService.combinedData(sysFormVoList, sysFormGroupVoList);
        SysApplication upgradeApp = AppIoUtil.readDataByKey(appUpgradeDto.getPath(), "app", "appInfo", SysApplication.class);
        AssertUtil.isNotNull((Object)upgradeApp, (String)"\u5347\u7ea7\u5e94\u7528\u4e0d\u5b58\u5728");
        List<FormSchema> formSchemas = AppIoUtil.readMidFiles(appUpgradeDto.getPath(), String.valueOf(upgradeApp.getId()));
        Map<String, FormCanvasSchema> upgradeCanvasMap = formSchemas.stream().map(FormSchema::getFormCanvas).collect(Collectors.toMap(BaseForm::getId, Function.identity()));
        List<AppUpGroupVo> upgradeGroupList = this.convertToGroupVo(upgradeSiftGroup, upgradeCanvasMap);
        List<AppUpGroupVo> currentGroupList = this.listFormGroupByAppId(appUpgradeDto.getCurrentAppId());
        List<AppUpGroupContrast> appUpGroupContrastList = this.contrastGroup(currentGroupList, upgradeGroupList);
        return ApiResponse.success(appUpGroupContrastList);
    }

    public List<AppUpGroupVo> listFormGroupByAppId(Long appId) {
        AssertUtil.isNotNull((Object)appId, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        SysSiftGroupList sysSiftGroupList = this.sysFormService.getFormList(null, null, null, appId);
        List sysFormList = this.sysFormService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        Map<String, FormCanvasSchema> canvasSchemaMap = sysFormList.stream().map(sysForm -> {
            try {
                return (FormCanvasSchema)this.canvasService.get(String.valueOf(sysForm.getId())).getData();
            }
            catch (Exception e) {
                throw new HussarException("\u753b\u5e03\u83b7\u53d6\u5931\u8d25");
            }
        }).collect(Collectors.toMap(BaseForm::getId, Function.identity()));
        return this.convertToGroupVo(sysSiftGroupList, canvasSchemaMap);
    }

    public ApiResponse<List<AppUpGroupVo>> listPackageFormGroup(AppUpgradeDto appUpgradeDto) {
        List<SysFormGroupVo> sysFormGroupVoList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "formGroups", SysFormGroupVo.class);
        List<SysFormVo> sysFormVoList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "forms", SysFormVo.class);
        SysSiftGroupList upgradeSiftGroup = this.sysFormService.combinedData(sysFormVoList, sysFormGroupVoList);
        SysApplication upgradeApp = AppIoUtil.readDataByKey(appUpgradeDto.getPath(), "app", "appInfo", SysApplication.class);
        AssertUtil.isNotNull((Object)upgradeApp, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        List<FormSchema> formSchemas = AppIoUtil.readMidFiles(appUpgradeDto.getPath(), String.valueOf(upgradeApp.getId()));
        Map<String, FormCanvasSchema> upgradeCanvasMap = formSchemas.stream().map(FormSchema::getFormCanvas).collect(Collectors.toMap(BaseForm::getId, Function.identity()));
        List<AppUpGroupVo> appUpGroupVoList = this.convertToGroupVo(upgradeSiftGroup, upgradeCanvasMap);
        return ApiResponse.success(appUpGroupVoList);
    }

    @HussarTransactional
    public ApiResponse<Boolean> upgradeSuccessCallback(AppUpgradeDto appUpgradeDto) {
        Long appId = appUpgradeDto.getCurrentAppId();
        SysApplicationVersionVo currentAppVersion = Optional.ofNullable(this.sysApplicationVersionService.getCurrentAppVersion(appId)).map(ApiResponse::getData).orElseThrow(() -> new HussarException("\u5e94\u7528\u5f53\u524d\u7248\u672c\u67e5\u8be2\u5931\u8d25"));
        Long currentVersionId = currentAppVersion.getId();
        String currentVersionNumber = currentAppVersion.getVersionNumber();
        SysApplicationVersion latestVersion = new SysApplicationVersion();
        latestVersion.setAppId(appId);
        latestVersion.setPackagePath(appUpgradeDto.getPath());
        latestVersion.setVersionNumber(AppUpgradeServiceImpl.generateLatestVersionNumber(currentVersionNumber));
        latestVersion.setCurrentFlag(Boolean.TRUE.booleanValue());
        HashMap<String, Map> upgradeMapping = new HashMap<String, Map>();
        upgradeMapping.put("formGroupIdMap", appUpgradeDto.getFormGroupIdMap());
        upgradeMapping.put("formIdMap", appUpgradeDto.getFormIdMap());
        upgradeMapping.put("subTableNameMap", appUpgradeDto.getSubTableNameMap());
        latestVersion.setUpgradeMapping(JSON.toJSONString(upgradeMapping));
        this.sysApplicationVersionService.save((Object)latestVersion);
        this.sysApplicationVersionService.updateCurrentFlag(appId, currentVersionId);
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    private static String generateLatestVersionNumber(String versionNumber) {
        String result;
        int splitIndex = versionNumber.indexOf("-");
        String today = LocalDate.now().toString().replace("-", "");
        if (splitIndex == -1 || !versionNumber.substring(0, splitIndex).equals(today)) {
            result = today + "-1";
        } else {
            String numStr = versionNumber.substring(splitIndex + 1);
            result = today + "-" + (Integer.parseInt(numStr) + 1);
        }
        return result;
    }

    public List<AppUpGroupContrast> contrastGroup(List<AppUpGroupVo> currentGroupList, List<AppUpGroupVo> targetGroupList) {
        ArrayList<AppUpGroupContrast> groupContrastList = new ArrayList<AppUpGroupContrast>();
        currentGroupList = Optional.ofNullable(currentGroupList).orElse(new ArrayList());
        targetGroupList = Optional.ofNullable(targetGroupList).orElse(new ArrayList());
        for (AppUpGroupVo currentGroup : currentGroupList) {
            String currentGroupName = currentGroup.getGroupName();
            boolean isMatched = false;
            for (AppUpGroupVo targetGroup : targetGroupList) {
                String targetGroupName = targetGroup.getGroupName();
                if (!HussarUtils.equals((Object)currentGroupName, (Object)targetGroupName)) continue;
                groupContrastList.add(new AppUpGroupContrast.Builder().currentGroupId(currentGroup.getId()).targetGroupId(targetGroup.getId()).groupName(currentGroupName).upgradeType(AppUpgradeType.UPGRADE.getName()).formContrastList(this.contrastFormList(currentGroup.getFormList(), targetGroup.getFormList())).build());
                targetGroupList.remove(targetGroup);
                isMatched = true;
                break;
            }
            if (isMatched) continue;
            groupContrastList.add(new AppUpGroupContrast.Builder().currentGroupId(currentGroup.getId()).groupName(currentGroupName).upgradeType(AppUpgradeType.NO_OPS.getName()).formContrastList(this.contrastFormList(currentGroup.getFormList(), new ArrayList<SysFormWithChildren>())).build());
        }
        for (AppUpGroupVo targetGroup : targetGroupList) {
            groupContrastList.add(new AppUpGroupContrast.Builder().targetGroupId(targetGroup.getId()).groupName(targetGroup.getGroupName()).upgradeType(AppUpgradeType.ADD.getName()).formContrastList(this.contrastFormList(new ArrayList<SysFormWithChildren>(), targetGroup.getFormList())).build());
        }
        return groupContrastList;
    }

    public ApiResponse<String> execute(AppUpgradeDto appUpgradeDto) {
        String upgradeTaskId = String.valueOf(UUID.randomUUID());
        TransmittableThreadLocalHolder.set((String)"upgradeCacheKey", (Object)upgradeTaskId);
        SecurityUser loginUser = NoCodeSecurityUtil.getUser();
        if (appUpgradeDto.isCrossPublish()) {
            loginUser = new SecurityUser();
            loginUser.setId(AppUpgradeConstant.SUPER_ADMIN);
            loginUser.setUserId(AppUpgradeConstant.SUPER_ADMIN);
        }
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
        ThreadPoolUtil.execute(() -> {
            UpgradeMappingDto upgradeMappingDto = this.initUpgradeMapping(appUpgradeDto);
            this.executeUpgradeProcess(appUpgradeDto, upgradeMappingDto);
        });
        return ApiResponse.success((Object)upgradeTaskId, (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private void executeUpgradeProcess(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        try {
            this.handleFirstUpgrade(appUpgradeDto);
            this.appUpgradeInfoService.upgradeApp(appUpgradeDto, upgradeMappingDto);
            this.appUpgradeInfoService.upgradeForm(appUpgradeDto, upgradeMappingDto);
            this.appUpgradeInfoService.upgradeMidFile(appUpgradeDto, upgradeMappingDto);
            this.appUpgradeInfoService.upgradeExtension(appUpgradeDto, upgradeMappingDto);
            this.appUpgradeInfoService.constructTable(appUpgradeDto, upgradeMappingDto);
            this.appUpgradeInfoService.upgradeFlow(appUpgradeDto, upgradeMappingDto);
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u5347\u7ea7\u5931\u8d25!", (Throwable)e);
        }
    }

    private void handleFirstUpgrade(AppUpgradeDto appUpgradeDto) {
        if (appUpgradeDto.isCrossPublish()) {
            return;
        }
        Long appId = appUpgradeDto.getCurrentAppId();
        SysApplicationVersion currentAppVersion = Optional.ofNullable(this.sysApplicationVersionService.getCurrentAppVersion(appId)).map(ApiResponse::getData).map(version -> (SysApplicationVersion)BeanUtil.copy((Object)version, SysApplicationVersion.class)).orElseThrow(() -> new HussarException("\u5e94\u7528\u5f53\u524d\u7248\u672c\u67e5\u8be2\u5931\u8d25"));
        if (HussarUtils.isNotEmpty((Object)currentAppVersion) && HussarUtils.isEmpty((Object)currentAppVersion.getPackagePath())) {
            Long appPackageId = this.appPackageService.packageApp(appId, Boolean.FALSE.booleanValue());
            AttachmentManagerModelVo appPackage = this.attachmentManagerService.getByFileId(appPackageId);
            String packagePath = null;
            try {
                packagePath = this.appFileExtendService.fileDecrypt(appPackage.getPath());
            }
            catch (Exception e) {
                LOGGER.error("\u5e94\u7528\u5305\u89e3\u6790\u5931\u8d25!", (Throwable)e);
            }
            currentAppVersion.setPackagePath(packagePath);
            HashMap<String, Map> upgradeMapping = new HashMap<String, Map>();
            upgradeMapping.put("formGroupIdMap", AppUpgradeUtil.valueToKey(appUpgradeDto.getFormGroupIdMap()));
            upgradeMapping.put("formIdMap", AppUpgradeUtil.valueToKey(appUpgradeDto.getFormIdMap()));
            upgradeMapping.put("subTableNameMap", AppUpgradeUtil.valueToKey(appUpgradeDto.getSubTableNameMap()));
            currentAppVersion.setUpgradeMapping(JSON.toJSONString(upgradeMapping));
            this.sysApplicationVersionService.updateById((Object)currentAppVersion);
        }
    }

    public ApiResponse<UpgradeStatusVo> getUpgradeProgress(String taskId) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"upgrade_progress", (Object)taskId, UpgradeStatusVo.class));
    }

    private UpgradeMappingDto initUpgradeMapping(AppUpgradeDto appUpgradeDto) {
        UpgradeMappingDto upgradeMappingDto = new UpgradeMappingDto();
        upgradeMappingDto.getFormGroupIdMap().putAll(MapUtil.reverse((Map)appUpgradeDto.getFormGroupIdMap()));
        upgradeMappingDto.getFormIdMap().putAll(MapUtil.reverse((Map)appUpgradeDto.getFormIdMap()));
        upgradeMappingDto.getSubTableNameMap().putAll(MapUtil.reverse((Map)appUpgradeDto.getSubTableNameMap()));
        upgradeMappingDto.setUpgradeFormIdList(new ArrayList(appUpgradeDto.getFormIdMap().values()));
        upgradeMappingDto.setUpgradeSubTableNameList(new ArrayList(appUpgradeDto.getSubTableNameMap().values()));
        return upgradeMappingDto;
    }

    private List<AppUpGroupVo> convertToGroupVo(SysSiftGroupList siftGroupList, Map<String, FormCanvasSchema> canvasSchemaMap) {
        ArrayList<AppUpGroupVo> appUpGroupVoList = new ArrayList<AppUpGroupVo>();
        if (HussarUtils.isEmpty((Object)siftGroupList)) {
            return appUpGroupVoList;
        }
        if (HussarUtils.isNotEmpty((Object)siftGroupList.getNoGroupList())) {
            AppUpGroupVo noGroup = new AppUpGroupVo();
            noGroup.setGroupName("\u672a\u5206\u7ec4");
            appUpGroupVoList.add(noGroup);
            for (SysForm sysForm : siftGroupList.getNoGroupList()) {
                SysFormWithChildren sysFormWithChildren = new SysFormWithChildren();
                BeanUtil.copyProperties((Object)sysForm, (Object)sysFormWithChildren);
                List childTableList = Optional.ofNullable(canvasSchemaMap.get(String.valueOf(sysForm.getId()))).map(FormCanvasSchema::childTables).map(childTables -> childTables.stream().map(widget -> (ChildWidgetVo)BeanUtil.copy((Object)widget, ChildWidgetVo.class)).collect(Collectors.toList())).orElse(new ArrayList());
                sysFormWithChildren.setChildren(childTableList);
                noGroup.getFormList().add(sysFormWithChildren);
            }
        }
        for (SysFormGroupVo sysFormGroupVo : siftGroupList.getHaveGroupList()) {
            List sysFormList = sysFormGroupVo.getSysFormList();
            AppUpGroupVo appUpGroupVo = new AppUpGroupVo();
            appUpGroupVoList.add(appUpGroupVo);
            BeanUtil.copyProperties((Object)sysFormGroupVo, (Object)appUpGroupVo);
            for (SysForm sysForm : sysFormList) {
                SysFormWithChildren sysFormWithChildren = new SysFormWithChildren();
                BeanUtil.copyProperties((Object)sysForm, (Object)sysFormWithChildren);
                List childTableList = Optional.ofNullable(canvasSchemaMap.get(String.valueOf(sysForm.getId()))).map(FormCanvasSchema::childTables).map(childTables -> childTables.stream().map(widget -> (ChildWidgetVo)BeanUtil.copy((Object)widget, ChildWidgetVo.class)).collect(Collectors.toList())).orElse(new ArrayList());
                sysFormWithChildren.setChildren(childTableList);
                appUpGroupVo.getFormList().add(sysFormWithChildren);
            }
        }
        return appUpGroupVoList;
    }

    private List<AppUpFormContrast> contrastFormList(List<SysFormWithChildren> currentFormList, List<SysFormWithChildren> targetFormList) {
        ArrayList<AppUpFormContrast> formContrastList = new ArrayList<AppUpFormContrast>();
        for (SysFormWithChildren currentForm : currentFormList) {
            String currentTitle = currentForm.getFormName();
            boolean isMatched = false;
            for (SysFormWithChildren targetForm : targetFormList) {
                String targetTitle = targetForm.getFormName();
                if (!HussarUtils.equals((Object)currentTitle, (Object)targetTitle)) continue;
                formContrastList.add(new AppUpFormContrast.Builder().currentId(currentForm.getId()).currentTitle(currentTitle).targetId(targetForm.getId()).targetTitle(targetTitle).childrenTableContrastList(this.contrastChildrenTable(currentForm.getChildren(), targetForm.getChildren())).upgradeType(AppUpgradeType.UPGRADE.getName()).build());
                targetFormList.remove(targetForm);
                isMatched = true;
                break;
            }
            if (isMatched) continue;
            formContrastList.add(new AppUpFormContrast.Builder().currentId(currentForm.getId()).currentTitle(currentForm.getFormName()).upgradeType(AppUpgradeType.NO_OPS.getName()).build());
        }
        for (SysFormWithChildren targetForm : targetFormList) {
            formContrastList.add(new AppUpFormContrast.Builder().targetId(targetForm.getId()).targetTitle(targetForm.getFormName()).upgradeType(AppUpgradeType.ADD.getName()).build());
        }
        return formContrastList;
    }

    private List<AppUpChildrenTableContrast> contrastChildrenTable(List<ChildWidgetVo> currentChildren, List<ChildWidgetVo> targetChildren) {
        ArrayList<AppUpChildrenTableContrast> childrenTableContrastList = new ArrayList<AppUpChildrenTableContrast>();
        for (ChildWidgetVo currentChild : currentChildren) {
            String currentTitle = currentChild.getTitle();
            boolean isMatched = false;
            for (ChildWidgetVo targetChild : targetChildren) {
                String targetTitle = targetChild.getTitle();
                if (!HussarUtils.equals((Object)currentTitle, (Object)targetTitle)) continue;
                childrenTableContrastList.add(new AppUpChildrenTableContrast.Builder().currentTitle(currentTitle).targetTitle(targetTitle).currentId(currentChild.getName()).targetId(targetChild.getName()).upgradeType(AppUpgradeType.UPGRADE.getName()).build());
                targetChildren.remove(targetChild);
                isMatched = true;
                break;
            }
            if (isMatched) continue;
            childrenTableContrastList.add(new AppUpChildrenTableContrast.Builder().currentTitle(currentChild.getTitle()).currentId(currentChild.getName()).upgradeType(AppUpgradeType.NO_OPS.getName()).build());
        }
        for (ChildWidgetVo targetChild : targetChildren) {
            childrenTableContrastList.add(new AppUpChildrenTableContrast.Builder().targetTitle(targetChild.getTitle()).targetId(targetChild.getName()).upgradeType(AppUpgradeType.ADD.getName()).build());
        }
        return childrenTableContrastList;
    }
}

