/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.model.SysApplicationRecord;
import com.jxdinfo.hussar.application.service.ISysApplicationRecordService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppExportRecord;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppExportRecordService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppExportImportServiceImpl")
@HussarTokenDs
public class AppExportServiceImpl
implements IAppExportService {
    @Resource
    private IAppExportInfoService appExportInfoService;
    @Resource
    private ISysAppExportRecordService sysAppExportRecordService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private ISysApplicationService appService;
    @Resource
    private ISysApplicationRecordService sysApplicationRecordService;
    @Resource
    private IAppExportService appExportService;
    @Resource
    private AttachmentManagerService attachmentManagerService;

    public ApiResponse<Void> export(AppExportDto appExportDto) {
        Long usr = BaseSecurityUtil.getUser().getId();
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        ThreadPoolUtil.execute(() -> {
            try {
                this.appExportInfoService.init(appExportDto);
                this.appExportInfoService.exportAppInfo(appExportDto);
                this.appExportInfoService.exportFormInfo(appExportDto);
                this.appExportInfoService.exportFormAuthorityInfo(appExportDto);
                this.appExportInfoService.exportDesignerMidFile(appExportDto);
                this.appExportInfoService.exportFlowConfigInfo(appExportDto);
                this.appExportInfoService.exportCommData(appExportDto);
                if (appExportDto.getExportDataFlag()) {
                    this.appExportInfoService.exportBusinessData(appExportDto);
                }
                this.appExportInfoService.generateMetaInfo(appExportDto);
                Thread.sleep(1000L);
                Long exportFileId = this.appExportInfoService.uploadExportFile(appExportDto);
                SysAppExportRecord record = new SysAppExportRecord();
                record.setType("1");
                record.setName(((SysApplication)this.appService.getById((Serializable)appExportDto.getAppId())).getAppName());
                record.setExportUserId(usr);
                record.setExportTime(LocalDateTime.now());
                record.setExportFileId(exportFileId);
                this.sysAppExportRecordService.save((Object)record);
                this.appExportInfoService.clear();
            }
            catch (Exception e) {
                ToolUtil.getLogger(AppExportServiceImpl.class).error("\u5bfc\u51fa\u5e94\u7528\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                SysApplicationRecord sysApplicationRecord = new SysApplicationRecord();
                ApiResponse exportProgress = this.appExportService.getExportProgress((String)TransmittableThreadLocalHolder.get((String)"exportCacheKey"));
                if (((ExportStatusVo)exportProgress.getData()).getStatus() == 9) {
                    sysApplicationRecord.setRecordStatus("2");
                    sysApplicationRecord.setShowMsg("\u5bfc\u51fa\u6210\u529f");
                    sysApplicationRecord.setRecordFileId(((ExportStatusVo)exportProgress.getData()).getExportFileId());
                    AttachmentManagerModelVo attachmentManagerServiceByFileId = this.attachmentManagerService.getByFileId(((ExportStatusVo)exportProgress.getData()).getExportFileId());
                    sysApplicationRecord.setRecordFileName(attachmentManagerServiceByFileId.getFileName());
                } else {
                    sysApplicationRecord.setRecordStatus("3");
                    sysApplicationRecord.setShowMsg("\u5bfc\u51fa\u5931\u8d25");
                    sysApplicationRecord.setRecordFileId(Long.valueOf(0L));
                    sysApplicationRecord.setRecordFileName("");
                }
                sysApplicationRecord.setCreator(usr);
                sysApplicationRecord.setAppId(appExportDto.getAppId());
                sysApplicationRecord.setRecordType("1");
                sysApplicationRecord.setAppMode("1");
                sysApplicationRecord.setRecordFilePassword(appExportDto.getExportPwd());
                this.sysApplicationRecordService.save((Object)sysApplicationRecord);
            }
        });
        return ApiResponse.success();
    }

    public ApiResponse<Long> packageApp(Long appId) {
        Long exportFileId;
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        AppExportDto appExportDto = new AppExportDto();
        appExportDto.setAppAuthRoleIds(new ArrayList());
        appExportDto.setFlowAuthRoleIds(new ArrayList());
        appExportDto.setFormAuthRoleIds(new ArrayList());
        appExportDto.setAppId(appId);
        try {
            this.appExportInfoService.init(appExportDto);
            this.appExportInfoService.exportAppInfo(appExportDto);
            this.appExportInfoService.exportFormInfo(appExportDto);
            this.appExportInfoService.exportFormAuthorityInfo(appExportDto);
            this.appExportInfoService.exportDesignerMidFile(appExportDto);
            this.appExportInfoService.exportFlowConfigInfo(appExportDto);
            this.appExportInfoService.exportCommData(appExportDto);
            if (appExportDto.getExportDataFlag()) {
                this.appExportInfoService.exportBusinessData(appExportDto);
            }
            this.appExportInfoService.generateMetaInfo(appExportDto);
            exportFileId = this.appExportInfoService.uploadExportFile(appExportDto);
            this.appExportInfoService.clear();
        }
        catch (Exception e) {
            throw new HussarException("\u6253\u5305\u5f02\u5e38");
        }
        return ApiResponse.success((Object)exportFileId);
    }

    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"export_progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    public void downloadExportFile(Long fileId, HttpServletResponse response) {
        this.appFileExtendService.fileDownload(fileId, response);
    }
}

