/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppLinkInner;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppWatermark;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppLinkInnerService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppWatermarkService;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppAuthRoleServiceImpl;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.model.PageExp;
import com.jxdinfo.hussar.formdesign.application.property.model.WidgetExp;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.property.service.impl.PageExpServiceImpl;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleInfo;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleTriggerAction;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.Impl.SysRuleInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CustomViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppExportInfoServiceImpl")
@HussarTokenDs
public class AppExportInfoServiceImpl
implements IAppExportInfoService {
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private ISysAppAuthorizeService appAuthService;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private PageExpServiceImpl pageExpService;
    @Resource
    private SysFormGroupMapper sysFormGroupMapper;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService formAuthService;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFiledMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private AppAuthRoleServiceImpl appAuthRoleService;
    @Resource
    private ISysRoleGroupService roleGroupService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private IWidgetExpService widgetExpService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysRuleInfoServiceImpl ruleInfoService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    @Resource
    private ISysFormLinkService formLinkService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private ISysAppLinkInnerService sysAppLinkInnerService;
    @Resource
    private ISysAppWatermarkService sysAppWatermarkService;
    @Resource
    private SysMsgPushConfigService sysMsgPushConfigService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private FormMapService formMapService;
    @Resource
    private CustomViewServiceImpl customViewService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    private static final Logger logger = LoggerFactory.getLogger(AppExportInfoServiceImpl.class);

    public void init(AppExportDto appExportDto) {
        String exportFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), ".export-store"});
        String basePath = FileUtil.posixPath((String[])new String[]{exportFolderPath, appExportDto.getAppId().toString(), UUID.randomUUID().toString()});
        appExportDto.setBasePath(basePath);
    }

    @ProgressCache(status=1, msg="\u6b63\u5728\u5bfc\u51fa\u5e94\u7528\u4fe1\u606f")
    public void exportAppInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysApplication application = (SysApplication)this.sysApplicationMapper.selectById(appExportDto.getAppId());
        map.put("appInfo", application);
        if (HussarUtils.isNotEmpty((Object)appExportDto.getAppAuthRoleIds())) {
            List appAuth = this.appAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppAuthorize::getAppId, (Object)appExportDto.getAppId())).in(SysAppAuthorize::getRoleId, (Collection)appExportDto.getAppAuthRoleIds()));
            map.put("appAuth", appAuth);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "app.json"}));
        this.exportAppLinkInner(appExportDto.getAppId(), basePath);
        this.exportAppWatermark(appExportDto.getAppId(), basePath);
    }

    private void exportAppLinkInner(Long appId, String basePath) {
        HashMap<String, SysAppLinkInner> map = new HashMap<String, SysAppLinkInner>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysAppLinkInner::getAppId, (Object)appId);
        SysAppLinkInner sysAppLinkInner = (SysAppLinkInner)this.sysAppLinkInnerService.getOne((Wrapper)wrapper);
        map.put("appLinkInner", sysAppLinkInner);
        String appLinkInnerFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "appLinkInner.json"});
        this.writeToFile(map, appLinkInnerFilePath);
    }

    private void exportAppWatermark(Long appId, String basePath) {
        HashMap<String, SysAppWatermark> map = new HashMap<String, SysAppWatermark>();
        SysAppWatermark sysAppWatermark = this.sysAppWatermarkService.getAppWatermark(appId);
        map.put("appWatermark", sysAppWatermark);
        String appWatermarkFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "appWatermark.json"});
        this.writeToFile(map, appWatermarkFilePath);
    }

    @ProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u51fa\u8868\u5355\u4fe1\u606f")
    public void exportFormInfo(AppExportDto appExportDto) throws IOException {
        String basePath = appExportDto.getBasePath();
        HashMap<String, List> map = new HashMap<String, List>();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        map.put("forms", forms);
        if (ToolUtil.isNotEmpty((Object)forms)) {
            List formGroupIds = forms.stream().map(SysForm::getFormGroupId).collect(Collectors.toList());
            List formGroups = this.sysFormGroupMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFormGroup::getId, formGroupIds));
            map.put("formGroups", formGroups);
        }
        this.exportPageExp(forms, basePath);
        this.exportDashboard(forms, basePath);
        List formAuthRoleIds = appExportDto.getFormAuthRoleIds();
        if (HussarUtils.isNotEmpty((Object)formAuthRoleIds)) {
            List formAuths = this.formAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appExportDto.getAppId())).in(SysAppVisitFormAuthorizeRoles::getRoleId, (Collection)formAuthRoleIds));
            map.put("formAuth", formAuths);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "form.json"}));
    }

    private void exportPageExp(List<SysForm> forms, String basePath) throws IOException {
        for (SysForm form : forms) {
            if (!"3".equals(form.getFormType())) continue;
            String pageName = form.getTableName();
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PageExp::getName, (Object)pageName);
            Long fileId = ((PageExp)this.pageExpService.getOne((Wrapper)wrapper)).getFileId();
            AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)fileId);
            String fileName = attachmentModel.getAttachmentName();
            int index = fileName.lastIndexOf(".");
            String suffix = index > -1 ? fileName.substring(index) : "";
            String attachmentPath = attachmentModel.getAttachmentDir() + fileId + suffix;
            String folderPath = basePath + File.separator + "pageExpand";
            File folder = new File(folderPath);
            boolean created = folder.mkdirs();
            if (created) {
                System.out.println("\u81ea\u5b9a\u4e49\u9875\u9762\u6587\u4ef6");
            }
            String destinationFolder = FileUtil.posixPath((String[])new String[]{folderPath, fileName});
            FileInputStream fileInputStream = new FileInputStream(attachmentPath);
            FileOutputStream fileOutputStream = new FileOutputStream(destinationFolder);
            ZipInputStream zipInput = new ZipInputStream(fileInputStream);
            ZipOutputStream zipOutput = new ZipOutputStream(fileOutputStream);
            ZipEntry entry = zipInput.getNextEntry();
            while (entry != null) {
                int bytesRead;
                zipOutput.putNextEntry(new ZipEntry(entry.getName()));
                byte[] buffer = new byte[1024];
                while ((bytesRead = zipInput.read(buffer)) > 0) {
                    zipOutput.write(buffer, 0, bytesRead);
                }
                zipOutput.closeEntry();
                entry = zipInput.getNextEntry();
            }
            zipInput.close();
            zipOutput.close();
            System.out.println("Zip\u538b\u7f29\u5305\u5df2\u6210\u529f\u590d\u5236\u5230\u76ee\u6807\u8def\u5f84\u3002");
        }
    }

    private void exportDashboard(List<SysForm> forms, String basePath) {
        HashMap<Long, List> exportFileMap = new HashMap<Long, List>();
        for (SysForm form : forms) {
            if (!"2".equals(form.getFormType())) continue;
            Wrapper wrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ENTRY_ID", (Object)form.getId())).or()).eq((Object)"PARENT_ID", (Object)form.getId())).orderByAsc((Object)"ENTRY_TYPE");
            List dashEntryList = this.dashEntryService.list(wrapper);
            exportFileMap.put(form.getId(), dashEntryList);
        }
        this.writeToFile(exportFileMap, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dashboard.json"}));
    }

    @ProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u51fa\u8868\u5355\u6743\u9650\u4fe1\u606f")
    public void exportFormAuthorityInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        if (ToolUtil.isNotEmpty((Object)appExportDto.getFormAuthRoleIds())) {
            HashMap<String, List> map = new HashMap<String, List>();
            LambdaQueryWrapper buttonWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)buttonWrapper.eq(SysAppVisitRoleButton::getAppId, (Object)appExportDto.getAppId())).in(SysAppVisitRoleButton::getRoleId, (Collection)appExportDto.getFormAuthRoleIds());
            List buttonAuth = this.roleButtonMapper.selectList((Wrapper)buttonWrapper);
            map.put("buttonAuth", buttonAuth);
            LambdaQueryWrapper filedWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)filedWrapper.eq(SysUpAppVisitRoleField::getAppId, (Object)appExportDto.getAppId())).in(SysUpAppVisitRoleField::getRoleId, (Collection)appExportDto.getFormAuthRoleIds());
            List filedAuth = this.roleFiledMapper.selectList((Wrapper)filedWrapper);
            map.put("filedAuth", filedAuth);
            LambdaQueryWrapper dataLogicWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)dataLogicWrapper.eq(SysAppVisitDataLogic::getAppId, (Object)appExportDto.getAppId())).in(SysAppVisitDataLogic::getRoleId, (Collection)appExportDto.getFormAuthRoleIds());
            List dataLogicAuth = this.dataLogicMapper.selectList((Wrapper)dataLogicWrapper);
            map.put("dataLogicAuth", dataLogicAuth);
            if (ToolUtil.isNotEmpty((Object)dataLogicAuth)) {
                List dataLogicFilterIds = dataLogicAuth.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
                List dataLogicFilters = this.dataLogicFilterMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, dataLogicFilterIds));
                map.put("dataLogicFilter", dataLogicFilters);
            }
            this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "formAuth.json"}));
        }
    }

    @ProgressCache(status=4, msg="\u6b63\u5728\u5bfc\u51fa\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void exportDesignerMidFile(AppExportDto appExportDto) throws IOException {
        String basePath = appExportDto.getBasePath();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        ArrayList<Long> formIds = new ArrayList<Long>();
        for (SysForm sysForm : forms) {
            if (!"0".equals(sysForm.getFormType()) && !"1".equals(sysForm.getFormType())) continue;
            formIds.add(sysForm.getId());
        }
        this.exportMid(appExportDto.getAppId(), FileUtil.posixPath((String[])new String[]{basePath, "appConfig"}), formIds, basePath);
        this.exportBusinessRule(formIds, basePath);
        this.exportCustomButton(formIds, basePath);
        this.exportFormCheckConfig(formIds, basePath);
        this.exportFormLinkData(formIds, basePath);
        this.exportMsgPush(appExportDto.getAppId(), basePath);
        this.exportPrintTemplate(appExportDto.getAppId(), basePath);
        this.exportDataPull(appExportDto.getAppId(), basePath);
        this.exportDataPush(appExportDto.getAppId(), basePath);
        this.exportDataPushMap(appExportDto.getAppId(), basePath);
        this.exportPublicView(formIds, basePath);
    }

    private void exportPrintTemplate(Long appId, String basePath) {
        HashMap<String, List> map = new HashMap<String, List>();
        List printTemplates = this.sysPrintTemplateService.list((Wrapper)new LambdaQueryWrapper().eq(SysPrintTemplate::getAppId, (Object)appId));
        String templateFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "printTemplate", "templateFile"});
        try {
            this.sysPrintTemplateService.exportPrintTemplate(printTemplates, templateFilePath);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6a21\u677f\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
        }
        map.put("printTemplateData", printTemplates);
        String printTemplatePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "printTemplate", "printTemplate.json"});
        this.writeToFile(map, printTemplatePath);
    }

    public void exportCustomButton(List<Long> formIds, String basePath) {
        if (HussarUtils.isNotEmpty(formIds)) {
            HashMap<String, List> map = new HashMap<String, List>();
            List customButtons = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().in(SysCustomButton::getFormId, formIds));
            map.put("customButtonData", customButtons);
            String customButtonPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "customButton.json"});
            this.writeToFile(map, customButtonPath);
        }
    }

    private void exportMid(Long appId, String path, List<Long> formIds, String basePath) throws IOException {
        AppContextUtil.setAppId((String)String.valueOf(appId));
        String appIdStr = String.valueOf(appId);
        ArrayList<String> widgetsAll = new ArrayList<String>();
        for (Long formId : formIds) {
            String formName = ((FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(formId)).getData()).getName();
            String midFilePath = FileUtil.posixPath((String[])new String[]{path, appIdStr, formName});
            FormCanvasSchema canvasSchema = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(formId)).getData();
            String canvasFin = formName + ".fd";
            String canvasPath = FileUtil.posixPath((String[])new String[]{midFilePath, "canvas", canvasFin});
            this.writeToFile(canvasSchema, canvasPath);
            List widgets = canvasSchema.getWidgets();
            if (HussarUtils.isNotEmpty((Object)widgets)) {
                for (Widget widget : widgets) {
                    if (!"JXDNExtWidget".equals(widget.getType())) continue;
                    widgetsAll.add(widget.getProps().getString("extname"));
                }
            }
            SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
            FormSettingSchema settingSchema = (FormSettingSchema)bean.get(String.valueOf(formId)).getData();
            String settingFin = formName + ".setting";
            String settingPath = FileUtil.posixPath((String[])new String[]{midFilePath, "setting", settingFin});
            this.writeToFile(settingSchema, settingPath);
            FormViewSchema viewSchema = (FormViewSchema)this.viewService.get(String.valueOf(formId)).getData();
            String viewFin = formName + ".vd";
            String viewPath = FileUtil.posixPath((String[])new String[]{midFilePath, "view", viewFin});
            this.writeToFile(viewSchema, viewPath);
            List staffScopes = (List)this.staffScopeScemaService.list(String.valueOf(formId)).getData();
            String staffFileName = formName + "history" + ".stf";
            String staffFilePath = FileUtil.posixPath((String[])new String[]{midFilePath, "staff", staffFileName});
            this.writeToFile(staffScopes, staffFilePath);
        }
        LinkedHashSet set = new LinkedHashSet(widgetsAll);
        widgetsAll.clear();
        widgetsAll.addAll(set);
        this.exportWidgetExp(widgetsAll, basePath);
    }

    private void exportWidgetExp(List<String> widgets, String basePath) throws IOException {
        for (String widgetName : widgets) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(WidgetExp::getName, (Object)widgetName);
            Long fileId = ((WidgetExp)this.widgetExpService.getOne((Wrapper)wrapper)).getFileId();
            AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)fileId);
            String fileName = attachmentModel.getAttachmentName();
            int index = fileName.lastIndexOf(".");
            String suffix = index > -1 ? fileName.substring(index) : "";
            String attachmentPath = attachmentModel.getAttachmentDir() + fileId + suffix;
            String folderPath = basePath + File.separator + "widgetExpand";
            File folder = new File(folderPath);
            boolean created = folder.mkdirs();
            if (created) {
                System.out.println("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u6587\u4ef6");
            }
            String destinationFolder = FileUtil.posixPath((String[])new String[]{folderPath, fileName});
            FileInputStream fileInputStream = new FileInputStream(attachmentPath);
            FileOutputStream fileOutputStream = new FileOutputStream(destinationFolder);
            ZipInputStream zipInput = new ZipInputStream(fileInputStream);
            ZipOutputStream zipOutput = new ZipOutputStream(fileOutputStream);
            ZipEntry entry = zipInput.getNextEntry();
            while (entry != null) {
                int bytesRead;
                zipOutput.putNextEntry(new ZipEntry(entry.getName()));
                byte[] buffer = new byte[1024];
                while ((bytesRead = zipInput.read(buffer)) > 0) {
                    zipOutput.write(buffer, 0, bytesRead);
                }
                zipOutput.closeEntry();
                entry = zipInput.getNextEntry();
            }
            zipInput.close();
            zipOutput.close();
            System.out.println("Zip\u538b\u7f29\u5305\u5df2\u6210\u529f\u590d\u5236\u5230\u76ee\u6807\u8def\u5f84\u3002");
        }
    }

    private void exportBusinessRule(List<Long> formIds, String basePath) {
        ArrayList allRules = new ArrayList();
        for (Long formId : formIds) {
            String formIdStr = String.valueOf(formId);
            ArrayList<RuleFullVo> ruleFullVos = new ArrayList<RuleFullVo>();
            List triggerActions = this.sysRuleTriggerActionService.getActionsByFormId(formIdStr);
            if (HussarUtils.isEmpty((Object)triggerActions)) continue;
            for (SysRuleTriggerAction triggerAction : triggerActions) {
                LambdaQueryWrapper wrapper;
                SysRuleInfo sysRuleInfo;
                String delFlag;
                String ruleId = triggerAction.getRuleId();
                if (!HussarUtils.isNotEmpty((Object)this.ruleInfoService.getRuleInfoDetail(ruleId)) || !"0".equals(delFlag = (sysRuleInfo = (SysRuleInfo)this.ruleInfoService.getOne((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRuleInfo::getRuleId, (Object)ruleId)))).getDelFlag())) continue;
                ruleFullVos.add(this.ruleInfoService.getRuleInfoDetail(ruleId));
            }
            allRules.addAll(ruleFullVos);
        }
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "rule.json"});
        this.writeToFile(allRules, flowFilePath);
    }

    private void exportFormLinkData(List<Long> formIds, String basePath) {
        Map formLinkExportData = this.formLinkService.getFormLinkExportData(formIds);
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "formLink.json"});
        this.writeToFile(formLinkExportData, flowFilePath);
    }

    private void exportFormCheckConfig(List<Long> formIds, String basePath) {
        List formCheckConfigList = this.sysFormCheckConfigService.getFormCheckConfigList(formIds);
        String formCheckConfigFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "checkConfig.json"});
        this.writeToFile(formCheckConfigList, formCheckConfigFilePath);
    }

    @ProgressCache(status=5, msg="\u6b63\u5728\u5bfc\u51fa\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f")
    public void exportFlowConfigInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        Map flowDataMap = this.flowMigrateService.exportWorkflow(appExportDto.getAppId());
        String flowFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "flow.json"});
        this.writeToFile(flowDataMap, flowFilePath);
    }

    @ProgressCache(status=6, msg="\u6b63\u5728\u5bfc\u51fa\u516c\u5171\u6570\u636e")
    public void exportCommData(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        HashSet roleIds = new HashSet();
        roleIds.addAll(appExportDto.getAppAuthRoleIds());
        roleIds.addAll(appExportDto.getFormAuthRoleIds());
        roleIds.addAll(appExportDto.getFlowAuthRoleIds());
        if (ToolUtil.isNotEmpty(roleIds)) {
            HashMap<String, List> roleDataMap = new HashMap<String, List>();
            List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
            roleDataMap.put("roles", roles);
            List roleGroupIds = roles.stream().map(SysRoles::getGroupId).filter(Objects::nonNull).collect(Collectors.toList());
            List roleGroups = this.roleGroupService.selectRoleGroupByIds(roleGroupIds);
            roleDataMap.put("roleGroups", roleGroups);
            this.writeToFile(roleDataMap, FileUtil.posixPath((String[])new String[]{basePath, "commonData", "commonData.json"}));
        }
    }

    @ProgressCache(status=7, msg="\u6b63\u5728\u5bfc\u51fa\u4e1a\u52a1\u6570\u636e")
    public void exportBusinessData(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        HashMap<String, List> map = new HashMap<String, List>();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        for (SysForm sysForm : forms) {
            logger.info("exportBusinessData sysForm : {}", (Object)JSONObject.toJSONString((Object)sysForm));
            if (!"0".equals(sysForm.getFormType()) && !"1".equals(sysForm.getFormType())) continue;
            logger.info("form id : {},name : {}", (Object)sysForm.getId(), (Object)sysForm.getFormName());
            ResponseEntity result = this.formOperateExposedService.tableQueryAll(String.valueOf(appExportDto.getAppId()), String.valueOf(sysForm.getId()));
            List data = ((PageVo)((ApiResponse)Objects.requireNonNull(result.getBody())).getData()).getData();
            map.put(sysForm.getTableName(), data);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{basePath, "businessData", "businessData.json"}));
    }

    @ProgressCache(status=8, msg="\u6b63\u5728\u751f\u6210\u5bfc\u51fa\u5e94\u7528\u5143\u4fe1\u606f")
    public void generateMetaInfo(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        AppExportMetaDto appExportMeta = new AppExportMetaDto();
        SysApplication sysApplication = (SysApplication)this.sysApplicationMapper.selectById(appExportDto.getAppId());
        BeanUtils.copyProperties((Object)sysApplication, (Object)appExportMeta);
        appExportMeta.setAppAuthRoleVo(this.appAuthRoleService.getAppAuthRoleTree(appExportDto.getAppAuthRoleIds(), appExportDto.getFormAuthRoleIds(), appExportDto.getFlowAuthRoleIds()));
        appExportMeta.setVersion(AppMigrateUtil.getMigrateVersion());
        if (ToolUtil.isNotEmpty((Object)appExportDto.getExportPwd())) {
            appExportMeta.setPassword(DigestUtil.sha1Hex((String)appExportDto.getExportPwd()));
        }
        this.writeToFile(appExportMeta, FileUtil.posixPath((String[])new String[]{basePath, "hussar.meta"}));
    }

    @ProgressCache(status=9, msg="\u5e94\u7528\u5bfc\u51fa\u6210\u529f", finish=true)
    public Long uploadExportFile(AppExportDto appExportDto) {
        String basePath = appExportDto.getBasePath();
        String appName = ((SysApplication)this.sysApplicationMapper.selectById(appExportDto.getAppId())).getAppName();
        return this.appFileExtendService.fileEncrypt(appName, basePath);
    }

    public void clear() {
        String exportFilePath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), ".export-store"});
    }

    private void writeToFile(Object object, String path) {
        String content = JSONObject.toJSONStringWithDateFormat((Object)object, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        String filePath = ToolUtil.pathFomatterByOS((String)path);
        try {
            FileUtils.writeStringToFile((File)new File(filePath), (String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("\u5e94\u7528\u5bfc\u51fa => \u5e94\u7528\u6570\u636e\u5199\u5165\u6587\u4ef6\u5f02\u5e38");
        }
    }

    private void exportMsgPush(Long appId, String basePath) {
        List configs = this.sysMsgPushConfigService.listByAppId(appId);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String msgPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "msg.json"});
            this.writeToFile(configs, msgPushPath);
        }
    }

    private void exportDataPull(Long appId, String basePath) {
        SysDataPullConfigDto sysDataPullConfigDto = new SysDataPullConfigDto();
        sysDataPullConfigDto.setAppId(appId);
        List configs = this.sysDataPullService.listByCondition(sysDataPullConfigDto);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String msgPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPull.json"});
            this.writeToFile(configs, msgPushPath);
        }
    }

    private void exportDataPush(Long appId, String basePath) {
        List configs = this.pushDataService.listByAppId(appId);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String dataPushPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPush.json"});
            this.writeToFile(configs, dataPushPath);
        }
    }

    private void exportDataPushMap(Long appId, String basePath) {
        List configs = this.formMapService.listByAppId(appId);
        if (HussarUtils.isNotEmpty((Object)configs)) {
            String dataPushMapPath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "dataPushMap.json"});
            this.writeToFile(configs, dataPushMapPath);
        }
    }

    private void exportPublicView(List<Long> formIds, String basePath) {
        ArrayList formPublicViewList = new ArrayList();
        if (HussarUtils.isEmpty(formIds)) {
            return;
        }
        formIds.forEach(formId -> {
            List viewList = (List)this.customViewService.get(String.valueOf(formId)).getData();
            if (HussarUtils.isNotEmpty((Object)viewList)) {
                formPublicViewList.addAll(viewList);
            }
        });
        if (HussarUtils.isEmpty(formPublicViewList)) {
            return;
        }
        List publicView = formPublicViewList.stream().filter(dataView -> "public".equals(dataView.getCategory())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(publicView)) {
            String formPublicFilePath = FileUtil.posixPath((String[])new String[]{basePath, "appConfig", "publicView.json"});
            this.writeToFile(publicView, formPublicFilePath);
        }
    }
}

