/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.core.util.PingYinUtil;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppFormTreeVo;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.SysAppVisitFormAuthorizeRolesDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldVo;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.AppMenuVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.MobilePageInfo;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.ureport.service.ICreateBlankReportService;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.sysFormServiceImpl")
public class SysFormServiceImpl
extends HussarServiceImpl<SysFormMapper, SysForm>
implements ISysFormService {
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private SysFormGroupMapper sysFormGroupMapper;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private SysApplicationMapper applicationMapper;
    @Resource
    private ISysAppVisitRoleButtonService roleButtonService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper formAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFieldMapper;
    @Resource
    private SysAppVisitRoleOrganDataAuthorityMapper roleOrganDataAuthorityMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Resource
    private ICreateBlankReportService iCreateBlankReportService;
    @Resource
    private ModuleInfoService moduleInfoService;
    @Resource
    private PageInfoService pageInfoService;
    @Resource
    private DataInfoService dataInfoService;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> addForm(SysFormDto sysFormDto) throws IOException, LcdpException {
        StringBuilder uid = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        for (int i = 0; i < 16; ++i) {
            uid.append(rd.nextInt(10));
        }
        String pyIndexStr = PingYinUtil.getPYIndexStr((String)sysFormDto.getFormName(), (boolean)true);
        if (pyIndexStr.length() > 6) {
            pyIndexStr = pyIndexStr.substring(0, 6);
        }
        sysFormDto.setTableName(pyIndexStr + "_" + uid);
        sysFormDto.setFormStatus("1");
        this.save((BaseEntity)sysFormDto);
        if (HussarUtils.equals((Object)sysFormDto.getFormType(), (Object)"2")) {
            if (HussarUtils.equals((Object)sysFormDto.getBoardType(), (Object)"0")) {
                Long id = sysFormDto.getId();
                this.iCreateBlankReportService.create(String.format("%s-%s", id, "web"));
            }
            if (HussarUtils.equals((Object)sysFormDto.getBoardType(), (Object)"1")) {
                this.createReport(sysFormDto);
            }
        }
        BaseForm baseForm = new BaseForm();
        baseForm.setId(sysFormDto.getId().toString());
        baseForm.setName(sysFormDto.getTableName());
        baseForm.setTitle(sysFormDto.getFormName());
        baseForm.setFormType(sysFormDto.getFormType());
        baseForm.setIcon(sysFormDto.getFormIcon());
        if ("1".equals(sysFormDto.getFormType())) {
            baseForm.setIdentity("bpm_" + PingYinUtil.getPYIndexStr((String)sysFormDto.getFormName(), (boolean)true) + sysFormDto.getId());
        }
        if (HussarUtils.equals((Object)sysFormDto.getFormType(), (Object)"1") || HussarUtils.equals((Object)sysFormDto.getFormType(), (Object)"0")) {
            try {
                this.formOperateExposedService.create(baseForm, sysFormDto.getAppId().toString());
            }
            catch (Exception e) {
                throw new BaseException("\u8868\u5355\u521d\u59cb\u5316\u8d44\u6e90\u5931\u8d25!", (Throwable)e);
            }
        }
        this.initFormDevelopRole(sysFormDto);
        return ApiResponse.success((Object)sysFormDto.getId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    private void createReport(SysFormDto sysFormDto) throws IOException, LcdpException {
        ModuleInfo moduleInfo = new ModuleInfo();
        String formId = String.valueOf(sysFormDto.getId());
        moduleInfo.setId(String.valueOf(sysFormDto.getId()));
        moduleInfo.setName(String.format("%s%s", "m", formId));
        moduleInfo.setDesc(sysFormDto.getFormName());
        moduleInfo.setType("Module");
        moduleInfo.setModuleType("Module");
        moduleInfo.setParentId("#");
        this.moduleInfoService.createDirectory(moduleInfo);
        String webJson = ToolUtil.loadResource(SysFormServiceImpl.class, (String)"/boardTemplate/web.json");
        PageInfo pageInfo = (PageInfo)JSONObject.parseObject((String)webJson, PageInfo.class);
        String webPageId = String.format("web%s", sysFormDto.getId());
        pageInfo.setId(webPageId);
        pageInfo.setDesc(sysFormDto.getFormName());
        pageInfo.setName(webPageId);
        pageInfo.setParentId(formId);
        this.pageInfoService.create((BaseFile)pageInfo);
        String mobileJson = ToolUtil.loadResource(SysFormServiceImpl.class, (String)"/boardTemplate/mobile.json");
        MobilePageInfo mobilePageInfo = (MobilePageInfo)JSONObject.parseObject((String)mobileJson, MobilePageInfo.class);
        String mobilePageId = String.format("mobile%s", sysFormDto.getId());
        mobilePageInfo.setId(mobilePageId);
        mobilePageInfo.setDesc(sysFormDto.getFormName());
        mobilePageInfo.setName(mobilePageId);
        mobilePageInfo.setParentId(formId);
        this.dataInfoService.create((BaseFile)mobilePageInfo);
    }

    private void initFormDevelopRole(SysFormDto sysFormDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysApplication::getId, (Object)sysFormDto.getAppId());
        SysApplication application = (SysApplication)this.applicationMapper.selectOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)application.getDevelopRoleId())) {
            return;
        }
        SysAppVisitFormAuthorizeRolesDto formAuthorizeRoles = new SysAppVisitFormAuthorizeRolesDto();
        formAuthorizeRoles.setId(Long.valueOf(IdWorker.getId((Object)new SysAppVisitFormAuthorizeRolesDto())));
        formAuthorizeRoles.setAppId(sysFormDto.getAppId());
        formAuthorizeRoles.setFormId(sysFormDto.getId());
        formAuthorizeRoles.setRoleIdList(Arrays.asList(application.getDevelopRoleId()));
        ApiResponse addFormAuthorizeRoleRes = this.sysAppVisitFormAuthorizeRolesService.addFormAuthorizeRoles(formAuthorizeRoles);
        if (!addFormAuthorizeRoleRes.isSuccess()) {
            throw new BaseException("\u5f00\u53d1\u8005\u89d2\u8272\u65b0\u589e\u8868\u5355\u53ef\u8bbf\u95ee\u6388\u6743\u5931\u8d25");
        }
        ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
        buttonAuthoritiesDto.setAppId(sysFormDto.getAppId());
        buttonAuthoritiesDto.setFormId(sysFormDto.getId());
        buttonAuthoritiesDto.setRoleId(application.getDevelopRoleId());
        this.sysCreateButton(buttonAuthoritiesDto);
        ApiResponse addButtonAuthorityRoleRes = this.roleButtonService.addButtonAuthorityRoles(buttonAuthoritiesDto);
        if (!addButtonAuthorityRoleRes.isSuccess()) {
            throw new BaseException("\u5f00\u53d1\u8005\u89d2\u8272\u65b0\u589e\u8868\u5355\u64cd\u4f5c\u6743\u9650\u5931\u8d25");
        }
    }

    private void sysCreateButton(ButtonAuthoritiesDto buttonAuthoritiesDto) {
        ArrayList buttonDtos = Lists.newArrayListWithCapacity((int)3);
        ButtonDto create = new ButtonDto();
        create.setButtonCode(Button.CREATE_OPERATE.getButtonCode());
        create.setButtonName(Button.CREATE_OPERATE.getButtonName());
        ButtonDto edit = new ButtonDto();
        edit.setButtonCode(Button.EDIT_OPERATE.getButtonCode());
        edit.setButtonName(Button.EDIT_OPERATE.getButtonName());
        ButtonDto delete = new ButtonDto();
        delete.setButtonCode(Button.DELETE_OPERATE.getButtonCode());
        delete.setButtonName(Button.DELETE_OPERATE.getButtonName());
        buttonDtos.add(create);
        buttonDtos.add(edit);
        buttonDtos.add(delete);
        buttonAuthoritiesDto.setButtonDtoList((List)buttonDtos);
    }

    public ApiResponse<Boolean> editForm(SysFormDto sysFormDto) throws IOException, LcdpException {
        boolean flag = this.updateById((BaseEntity)sysFormDto);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        if (HussarUtils.equals((Object)sysFormDto.getFormType(), (Object)"2") && HussarUtils.equals((Object)sysFormDto.getBoardType(), (Object)"1")) {
            PageInfo pageInfo = (PageInfo)this.pageInfoService.get(String.format("web%s", sysFormDto.getId()));
            pageInfo.setDesc(sysFormDto.getFormName());
            this.pageInfoService.updateFileMeta((BaseFile)pageInfo);
            MobilePageInfo mobilePageInfo = (MobilePageInfo)this.dataInfoService.get(String.format("mobile%s", sysFormDto.getId()));
            mobilePageInfo.setDesc(sysFormDto.getFormName());
            this.dataInfoService.updateFileMeta((BaseFile)mobilePageInfo);
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteForm(Long formId) throws IOException, LcdpException {
        SysForm sysForm = (SysForm)this.getById(formId);
        boolean flag = this.removeById(formId);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        if (HussarUtils.equals((Object)sysForm.getFormType(), (Object)"2") && HussarUtils.equals((Object)sysForm.getBoardType(), (Object)"1")) {
            this.pageInfoService.delete(String.format("web%s", formId));
            this.dataInfoService.delete(String.format("mobile%s", sysForm.getId()));
        }
        this.deleteFormOtherAuthorityInfo(formId);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    private void deleteFormOtherAuthorityInfo(Long formId) {
        this.formAuthorizeRolesMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId));
        this.roleButtonMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId));
        this.roleFieldMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId));
        this.roleOrganDataAuthorityMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId));
        List sysAppVisitDataLogics = this.dataLogicMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogics)) {
            List logicIds = sysAppVisitDataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicMapper.deleteBatchIds(logicIds);
            this.dataLogicFilterMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, logicIds));
        }
    }

    public SysSiftGroupList getFormList(String formName, String formStatus, Long appId) {
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(formName, formStatus, null, appId);
        List<Object> sysFormGroups = new ArrayList();
        if (HussarUtils.isEmpty((Object)formName) && HussarUtils.isEmpty((Object)formStatus)) {
            sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, null);
        } else {
            ArrayList<Long> groupIds = new ArrayList<Long>();
            for (SysFormVo sysFormVo : sysFormList) {
                Long formGroupId = sysFormVo.getFormGroupId();
                if (!HussarUtils.isNotEmpty((Object)formGroupId)) continue;
                groupIds.add(formGroupId);
            }
            if (HussarUtils.isNotEmpty(groupIds)) {
                sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, groupIds);
            }
        }
        if (HussarUtils.isEmpty(sysFormList)) {
            sysSiftGroupList.setHaveGroupList(JSONObject.parseArray((String)JSONObject.toJSONString(sysFormGroups), SysFormGroupVo.class));
            return sysSiftGroupList;
        }
        return this.combinedData(sysFormList, sysFormGroups);
    }

    public ApiResponse<List<AppMenuVo>> getFormMenuList(Long appId) {
        List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthorityFormList(appId).getData();
        if (HussarUtils.isEmpty((Object)formIds)) {
            return ApiResponse.success(new ArrayList(), (String)"\u6ca1\u6709\u53ef\u8bbf\u95ee\u7684\u83dc\u5355");
        }
        List<Object> sysFormGroups = new ArrayList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(null, null, formIds, appId);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (SysForm sysForm : sysFormList) {
            groupIds.add(sysForm.getFormGroupId());
        }
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, groupIds);
        }
        ArrayList<AppMenuVo> resultList = new ArrayList<AppMenuVo>();
        for (SysFormGroupVo sysFormGroup : sysFormGroups) {
            AppMenuVo appMenuVo = new AppMenuVo();
            appMenuVo.setId(sysFormGroup.getId());
            appMenuVo.setSeq(sysFormGroup.getSeq());
            appMenuVo.setName(sysFormGroup.getGroupName());
            appMenuVo.setIcon(sysFormGroup.getGroupIcon());
            appMenuVo.setIconType(sysFormGroup.getGroupIconType());
            appMenuVo.setIconColor(sysFormGroup.getGroupIconColor());
            appMenuVo.setType("1");
            resultList.add(appMenuVo);
        }
        Map map = JSON.parseArray((String)JSON.toJSONString(resultList), AppMenuVo.class).stream().distinct().collect(Collectors.toMap(AppMenuVo::getId, AppMenuVo2 -> AppMenuVo2, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            AppMenuVo appMenuVo = (AppMenuVo)map.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)appMenuVo)) {
                AppMenuVo result = this.giveAppMenuVoProperty(sysForm);
                map.put(result.getId(), result);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)appMenuVo.getAppMenuVoList())) {
                appMenuVo.getAppMenuVoList().add(this.giveAppMenuVoProperty(sysForm));
            }
            if (!HussarUtils.isEmpty((Object)appMenuVo.getAppMenuVoList())) continue;
            ArrayList<AppMenuVo> menuVoList = new ArrayList<AppMenuVo>();
            menuVoList.add(this.giveAppMenuVoProperty(sysForm));
            appMenuVo.setAppMenuVoList(menuVoList);
        }
        return ApiResponse.success(new ArrayList(map.values()));
    }

    public ApiResponse<SysForm> getDetailById(Long formId) {
        return ApiResponse.success((Object)this.getById(formId));
    }

    public ApiResponse<List<SysForm>> getSysFormByAppId(Long appId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysForm::getAppId, (Object)appId);
        return ApiResponse.success((Object)this.list((Wrapper)lambdaQueryWrapper));
    }

    public ApiResponse<List<SysAppFormTreeVo>> getAppFormList(Long appId) {
        ArrayList<SysAppFormTreeVo> treeList = new ArrayList<SysAppFormTreeVo>();
        SysApplication sysApplication = (SysApplication)this.applicationService.getById((Serializable)appId);
        SysAppFormTreeVo appTreeVo = new SysAppFormTreeVo();
        appTreeVo.setLabel(sysApplication.getAppName());
        appTreeVo.setId(sysApplication.getId().toString());
        appTreeVo.setHasChildren(Boolean.valueOf(true));
        appTreeVo.setIcon(sysApplication.getAppIcon());
        appTreeVo.setIconType(sysApplication.getAppIconType());
        appTreeVo.setIconColor(sysApplication.getAppIconColor());
        appTreeVo.setType(1);
        treeList.add(appTreeVo);
        LambdaQueryWrapper formWrapper = Wrappers.lambdaQuery();
        formWrapper.eq(HussarUtils.isNotEmpty((Object)appId), SysFormGroup::getAppId, (Object)appId);
        formWrapper.orderByAsc(SysFormGroup::getSeq);
        List formGroupList = this.sysFormGroupMapper.selectList((Wrapper)formWrapper);
        for (SysFormGroup sysFormGroup : formGroupList) {
            SysAppFormTreeVo formGroupTreeVo = new SysAppFormTreeVo();
            formGroupTreeVo.setId(sysFormGroup.getId().toString());
            formGroupTreeVo.setLabel(sysFormGroup.getGroupName());
            formGroupTreeVo.setParentId(sysFormGroup.getAppId().toString());
            formGroupTreeVo.setIcon(sysFormGroup.getGroupIcon());
            formGroupTreeVo.setIconType(sysFormGroup.getGroupIconType());
            formGroupTreeVo.setIconColor(sysFormGroup.getGroupIconColor());
            formGroupTreeVo.setType(2);
            treeList.add(formGroupTreeVo);
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(HussarUtils.isNotEmpty((Object)appId), SysForm::getAppId, (Object)appId);
        queryWrapper2.orderByAsc(SysForm::getSeq);
        List formList = this.list((Wrapper)queryWrapper2);
        for (SysForm sysForm : formList) {
            SysAppFormTreeVo formTreeVo = new SysAppFormTreeVo();
            formTreeVo.setId(sysForm.getId().toString());
            formTreeVo.setLabel(sysForm.getFormName());
            if (HussarUtils.isEmpty((Object)sysForm.getFormGroupId())) {
                formTreeVo.setParentId(sysForm.getAppId().toString());
            } else {
                formTreeVo.setParentId(sysForm.getFormGroupId().toString());
            }
            formTreeVo.setIcon(sysForm.getFormIcon());
            formTreeVo.setIconType(sysForm.getFormIconType());
            formTreeVo.setIconColor(sysForm.getFormIconColor());
            formTreeVo.setType(3);
            treeList.add(formTreeVo);
        }
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(treeList));
    }

    public ApiResponse<List<FieldVo>> getFormField(Long formId, String appId) {
        try {
            List widgetFields = (List)this.formOperateExposedService.widgets(formId.toString(), appId).getData();
            ArrayList<FieldVo> fieldVos = new ArrayList<FieldVo>();
            if (HussarUtils.isNotEmpty((Object)widgetFields)) {
                for (WidgetField widgetField : widgetFields) {
                    FieldVo fieldVo = new FieldVo();
                    fieldVo.setFieldId(widgetField.getName());
                    fieldVo.setFieldName(widgetField.getTitle());
                    fieldVo.setType(widgetField.getType());
                    fieldVo.setUsage(widgetField.getUsage());
                    fieldVo.setDataType(widgetField.getDataType());
                    fieldVo.setRealField(widgetField.getIsRealField());
                    fieldVo.setProps(widgetField.getProps());
                    if (HussarUtils.isNotEmpty((Object)widgetField.getChildren())) {
                        ArrayList fieldVosChildren = Lists.newArrayListWithCapacity((int)10);
                        widgetField.getChildren().forEach(c -> {
                            FieldVo cT = new FieldVo();
                            cT.setFieldId(c.getName());
                            cT.setFieldName(widgetField.getTitle() + "." + c.getTitle());
                            cT.setType(c.getType());
                            cT.setUsage(c.getUsage());
                            cT.setDataType(c.getDataType());
                            cT.setRealField(c.getIsRealField());
                            cT.setProps(c.getProps());
                            fieldVosChildren.add(cT);
                        });
                        fieldVo.setChildren((List)fieldVosChildren);
                    }
                    fieldVos.add(fieldVo);
                }
            }
            return ApiResponse.success(fieldVos);
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6\u8868\u5355\u5185\u5b57\u6bb5\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    private SysSiftGroupList combinedData(List<SysFormVo> sysFormList, List<SysFormGroupVo> sysFormGroups) {
        ArrayList<SysForm> noGroupList = new ArrayList<SysForm>();
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysFormGroups), SysFormGroupVo.class).stream().distinct().collect(Collectors.toMap(SysFormGroup::getId, sysFormGroupVo -> sysFormGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            SysFormGroupVo sysFormGroupVo2 = (SysFormGroupVo)resultCollect.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)sysFormGroupVo2)) {
                noGroupList.add(sysForm);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)sysFormGroupVo2.getSysFormList())) {
                sysFormGroupVo2.getSysFormList().add(sysForm);
            }
            if (!HussarUtils.isEmpty((Object)sysFormGroupVo2.getSysFormList())) continue;
            ArrayList<SysForm> formGroupList = new ArrayList<SysForm>();
            formGroupList.add(sysForm);
            sysFormGroupVo2.setSysFormList(formGroupList);
        }
        sysSiftGroupList.setHaveGroupList(new ArrayList(resultCollect.values()));
        sysSiftGroupList.setNoGroupList(noGroupList);
        return sysSiftGroupList;
    }

    private AppMenuVo giveAppMenuVoProperty(SysForm sysForm) {
        AppMenuVo trans = new AppMenuVo();
        trans.setId(sysForm.getId());
        trans.setSeq(sysForm.getSeq());
        trans.setName(sysForm.getFormName());
        trans.setIcon(sysForm.getFormIcon());
        trans.setIconType(sysForm.getFormIconType());
        trans.setIconColor(sysForm.getFormIconColor());
        trans.setFormType(sysForm.getFormType());
        trans.setTableName(sysForm.getTableName());
        trans.setBoardType(sysForm.getBoardType());
        trans.setType("2");
        return trans;
    }
}

