/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppCallBackService;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionAppSdkOff;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.HussarNocodeAppCallBackServiceImpl")
@HussarTokenDs
@Conditional(value={ConditionAppSdkOff.class})
public class HussarNocodeAppCallBackServiceImpl
implements IHussarAppCallBackService {
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private SysAppAuthorizeMapper appAuthorizeMapper;
    @Resource
    private SysFormMapper formMapper;
    @Resource
    private SysFormGroupMapper formGroupMapper;
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper formAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFieldMapper;
    @Resource
    private SysAppVisitRoleOrganDataAuthorityMapper roleOrganDataAuthorityMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Autowired
    private ISysApplicationBoService iSysApplicationBoService;

    public String getAppType() {
        return "1";
    }

    public void deleteApp(SysApplication app) {
    }

    public void updateApp(SysApplication app) {
    }

    public void addApp(SysApplication app) {
        SysApplicationDto sysApplicationDto = new SysApplicationDto();
        BeanUtil.copyProperties((Object)app, (Object)sysApplicationDto);
        sysApplicationDto.setReleaseStatus("1");
        if ("1".equals(sysApplicationDto.getAppType())) {
            this.initDevelopRole(sysApplicationDto);
        }
        if (HussarUtils.isNotEmpty((Object)sysApplicationDto.getDevelopRoleId())) {
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            Map extendUserMap = userDetails.getExtendUserMap();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            Object rolesList = extendUserMap.get("rolesList");
            if (HussarUtils.isNotEmpty(rolesList)) {
                roleIds.addAll((List)rolesList);
            }
            roleIds.add(sysApplicationDto.getDevelopRoleId());
            userDetails.addExtendUserMap("rolesList", roleIds);
            SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, userDetails.getTokenValue());
            HussarCacheUtil.evict((String)"login_user_info", (Object)userDetails.getAccessToken());
        }
    }

    private void initDevelopRole(SysApplicationDto sysApplicationDto) {
        ApiResponse result = this.rolesExternalService.addAppDevRole(sysApplicationDto.getAppName(), null);
        if (!result.isSuccess()) {
            throw new BaseException("\u521b\u5efa\u5e94\u7528\u5f00\u53d1\u8005\u89d2\u8272\u5931\u8d25");
        }
        Long developRoleId = (Long)result.getData();
        sysApplicationDto.setDevelopRoleId(developRoleId);
        RoleUserDto userDto = new RoleUserDto();
        userDto.setRoleId(developRoleId);
        ArrayList userVos = Lists.newArrayListWithCapacity((int)1);
        RoleOrgUserVo u = new RoleOrgUserVo();
        u.setId(BaseSecurityUtil.getUser().getId());
        userVos.add(u);
        userDto.setAdds((List)userVos);
        this.rolesExternalService.addOrDelAppDevRoleUser(userDto);
        SysAppAuthorize authorize = new SysAppAuthorize();
        authorize.setId(Long.valueOf(IdWorker.getId((Object)new SysAppAuthorize())));
        authorize.setAppId(sysApplicationDto.getId());
        authorize.setRoleId(developRoleId);
        this.appAuthorizeMapper.insert(authorize);
        this.iSysApplicationBoService.updateApp(sysApplicationDto);
    }

    public void deleteRecycleApp(SysAppRecycle appRecycle) {
        Long developRoleId;
        List roles;
        Long appId = appRecycle.getId();
        this.formMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        this.formGroupMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appRecycle) && HussarUtils.isNotEmpty((Object)(roles = this.rolesExternalService.getRoleInfoByIds(HussarUtils.toLongList((String)String.valueOf(developRoleId = appRecycle.getDevelopRoleId())))))) {
            this.rolesExternalService.delRole(developRoleId);
        }
        this.appAuthorizeMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppAuthorize::getAppId, (Object)appId));
        this.formAuthorizeRolesMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId));
        this.roleButtonMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId));
        this.roleFieldMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)appId));
        this.roleOrganDataAuthorityMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getAppId, (Object)appId));
        List sysAppVisitDataLogics = this.dataLogicMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogics)) {
            List logicIds = sysAppVisitDataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicMapper.deleteBatchIds(logicIds);
            this.dataLogicFilterMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, logicIds));
        }
    }

    public void revertRecycleApp(SysAppRecycle appRecycle) {
    }
}

