/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.properties.FormDesignAppProperties;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.migration.enums.EncryptionType;
import com.jxdinfo.hussar.migration.utils.MigrationCryptoUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AppFileExtendServiceImpl
implements AppFileExtendService {
    private static Logger logger = LoggerFactory.getLogger(AppFileExtendServiceImpl.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Autowired
    private FormDesignAppProperties properties;
    @Autowired
    private OssFileProperties ossFileProperties;
    private static final EncryptionType encryptionType = EncryptionType.AES;

    public void fileDownload(Long id, HttpServletResponse response) {
        byte[] data = (byte[])this.ossService.backgroundDownload(id).getData();
        AttachmentManagerModelVo managerModelVo = this.attachmentManagerService.getByFileId(id);
        try (ServletOutputStream os = response.getOutputStream();){
            String newFileName = URLEncoder.encode(managerModelVo.getFileName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("multipart/form-data");
            IOUtils.write((byte[])data, (OutputStream)os);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public Long fileEncrypt(String appName, String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                String oldFormat = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss");
                String fileName = appName + "_" + oldFormat + ".hussar";
                File parentDir = new File(path).getParentFile();
                String zipPath = parentDir.getAbsolutePath() + File.separator + fileName;
                ZipUtil.zip((String)path, (String)zipPath);
                byte[] bytes = FileUtils.readFileToByteArray((File)new File(zipPath));
                byte[] encrypt = MigrationCryptoUtils.encrypt((EncryptionType)encryptionType, (String)this.properties.getEncryptionKey(), (byte[])bytes);
                this.saveEncryptedDataToFile(encrypt, zipPath);
                Long id = this.fileUpload(zipPath);
                File zipFile = new File(zipPath);
                zipFile.delete();
                return id;
            }
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public String fileDecrypt(MultipartFile multipartFile) throws Exception {
        String filePath = FileUtil.posixPath((String[])new String[]{this.ossFileProperties.getFileUploadPath(), multipartFile.getOriginalFilename()});
        AppMigrateUtil.deleteFolder(filePath.substring(0, filePath.lastIndexOf(".")));
        byte[] bytes = multipartFile.getBytes();
        byte[] decrypt = MigrationCryptoUtils.decrypt((EncryptionType)encryptionType, (String)this.properties.getEncryptionKey(), (byte[])bytes);
        this.saveEncryptedDataToFile(decrypt, filePath);
        com.jxdinfo.hussar.platform.core.utils.file.ZipUtil.unzip((File)new File(filePath));
        return filePath;
    }

    public void fileDelete(Long id) {
        Object data = this.ossService.deleteFile(id).getData();
    }

    private void saveEncryptedDataToFile(byte[] encryptedData, String exportPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(exportPath);){
            fos.write(encryptedData);
            fos.flush();
        }
    }
}

