/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppExportRecordMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.SysAppRecordDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppExportRecord;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppExportRecordService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppExportRecordVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.SysAppExportRecordServiceImpl")
public class SysAppExportRecordServiceImpl
extends HussarServiceImpl<SysAppExportRecordMapper, SysAppExportRecord>
implements ISysAppExportRecordService {
    @Resource
    private SysAppExportRecordMapper sysAppExportRecordMapper;
    @Resource
    private ISysDicRefService dicRefService;
    @Resource
    private AppFileExtendService appFileExtendService;

    public IPage<SysAppExportRecordVo> selectRecordList(SysAppRecordDto sysAppRecordDto) {
        Page page = new Page(sysAppRecordDto.getCurrent(), sysAppRecordDto.getSize());
        IPage<SysAppExportRecordVo> pageVo = this.sysAppExportRecordMapper.selectRecordList((Page<SysAppExportRecordVo>)page, sysAppRecordDto.getAppName());
        List appType = this.dicRefService.getDicListByType("app_type");
        List records = pageVo.getRecords();
        if (ToolUtil.isNotEmpty((Object)records)) {
            block0: for (SysAppExportRecordVo record : records) {
                for (DicVo dic : appType) {
                    if (!record.getAppType().equals(dic.getValue())) continue;
                    record.setAppType(dic.getLabel());
                    continue block0;
                }
            }
        }
        return pageVo;
    }

    public void deleteExportRecord(Long recordId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppExportRecord::getRecordId, (Object)recordId);
        Long exportFileId = ((SysAppExportRecord)((SysAppExportRecordMapper)this.baseMapper).selectOne((Wrapper)wrapper)).getExportFileId();
        this.appFileExtendService.fileDelete(exportFileId);
        ((SysAppExportRecordMapper)this.baseMapper).deleteById(recordId);
    }
}

