/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportThreadService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.tool.aspect.ProgressCacheAspect;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportServiceImpl")
public class AppImportServiceImpl
implements IAppImportService {
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IAppImportThreadService appImportThreadService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    private static final Logger logger = LoggerFactory.getLogger(AppImportServiceImpl.class);

    public ApiResponse<AppAttachmentParseVo> parseAttachment(MultipartFile file) {
        String path;
        try {
            path = this.appFileExtendService.fileDecrypt(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = path.substring(0, path.length() - 7);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        AppExportMetaDto appExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, AppExportMetaDto.class);
        if (appExportMetaDto == null) {
            return ApiResponse.fail((String)"\u5bfc\u5165\u7684\u5e94\u7528\u9644\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        String exportVersion = appExportMetaDto.getVersion();
        String importVersion = AppMigrateUtil.getMigrateVersion();
        if (ToolUtil.isNotEmpty((Object)exportVersion) && ToolUtil.isNotEmpty((Object)importVersion) && exportVersion.compareTo(importVersion) > 0) {
            return ApiResponse.fail((String)"\u7248\u672c\u8fc7\u9ad8\uff0c\u65e0\u6cd5\u663e\u793a");
        }
        AppAttachmentParseVo appAttachmentParseVo = new AppAttachmentParseVo();
        appAttachmentParseVo.setPath(unZipPath);
        appAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)appExportMetaDto.getPassword()));
        BeanUtils.copyProperties((Object)appExportMetaDto, (Object)appAttachmentParseVo);
        return ApiResponse.success((Object)appAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(AppImportDto appImportDto) {
        String inputPwd = DigestUtil.sha1Hex((String)appImportDto.getPassword());
        String metaFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "hussar.meta"});
        AppExportMetaDto appExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, AppExportMetaDto.class);
        assert (appExportMetaDto != null);
        String password = appExportMetaDto.getPassword();
        return ApiResponse.success((Object)inputPwd.equals(password));
    }

    public Boolean verifyAppName(String appName) {
        List existAppName = this.applicationService.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)appName));
        List recycleAppNames = this.sysAppRecycleService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppName, (Object)appName));
        return ToolUtil.isEmpty((Object)existAppName) && ToolUtil.isEmpty((Object)recycleAppNames);
    }

    @Async
    public void importApp(AppImportDto appImportDto) throws Exception {
        this.appImportThreadService.startImportThread(appImportDto);
        TransmittableThreadLocalHolder.clear((String)"loginUser");
    }

    public ApiResponse<Void> resetImportProgress() {
        HussarCacheUtil.put((String)"app_import_progress", (Object)"app_import_progress", (Object)ImportStatusVo.put((int)1, (String)"\u6b63\u5728\u5bfc\u5165\u516c\u5171\u6570\u636e", (boolean)false, (boolean)false));
        ProgressCacheAspect.importStatus = 0;
        return ApiResponse.success();
    }

    public ApiResponse<ImportStatusVo> getImportProgress() {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"app_import_progress", (Object)"app_import_progress", ImportStatusVo.class));
    }

    public void importSuccessCallBack(String appId) {
        SysApplication application = (SysApplication)this.applicationService.getById((Serializable)((Object)appId));
        if (ToolUtil.isNotEmpty((Object)application) && HussarUtils.isNotEmpty((Object)application.getDevelopRoleId())) {
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            Map extendUserMap = userDetails.getExtendUserMap();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            Object rolesList = extendUserMap.get("rolesList");
            if (HussarUtils.isNotEmpty(rolesList)) {
                roleIds.addAll((List)rolesList);
            }
            roleIds.add(application.getDevelopRoleId());
            userDetails.addExtendUserMap("rolesList", roleIds);
            SecurityUtil.getTokenSession().addUserDetailToTokenSession(userDetails, userDetails.getTokenValue());
            HussarCacheUtil.evict((String)"login_user_info", (Object)userDetails.getAccessToken());
        }
    }
}

