/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseSetting;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl")
public class AppImportInfoServiceImpl
implements IAppImportInfoService {
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysFormGroupService formGroupService;
    @Resource
    private ISysAppAuthorizeService appAuthorizeService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService formAuthService;
    @Resource
    private ISysAppVisitRoleButtonService buttonAuthService;
    @Resource
    private ISysUpAppVisitRoleFieldService fieldAuthService;
    @Resource
    private ISysAppVisitDataLogicService dataLogicAuthService;
    @Resource
    private ISysAppVisitDataLogicFilterService dataLogicFilterService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private ISysRoleGroupService roleGroupService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private ISysAppDevelopTeamService appDevelopTeamService;
    @Resource
    private ISysAppDevelopTeamMemberService developTeamMemberService;
    @Resource
    private FormOperateService formOperateService;

    @ImportProgressCache(msg="\u6b63\u5728\u5bfc\u5165\u516c\u5171\u6570\u636e")
    public void importCommonData(AppImportDto appImportDto) {
        if (appImportDto.getExportRoleFlag()) {
            List<SysRoles> roles;
            String roleFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "commonData", "commonData.json"});
            JSONObject roleData = AppMigrateUtil.readFileToObject(roleFilePath, JSONObject.class);
            List<SysRoleGroup> roleGroups = AppMigrateUtil.parseJsonObjectToListByKey(roleData, "roleGroups", SysRoleGroup.class);
            if (ToolUtil.isNotEmpty(roleGroups)) {
                List existRoleGroupIds = this.roleGroupService.list().stream().map(SysRoleGroup::getId).collect(Collectors.toList());
                List newRoleGroups = roleGroups.stream().filter(roleGroup -> !existRoleGroupIds.contains(roleGroup.getId())).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(newRoleGroups)) {
                    this.roleGroupService.saveBatch(newRoleGroups);
                }
            }
            if (ToolUtil.isNotEmpty(roles = AppMigrateUtil.parseJsonObjectToListByKey(roleData, "roles", SysRoles.class))) {
                List existRoleIds = this.sysRolesService.list().stream().map(SysRoles::getId).collect(Collectors.toList());
                List newRoles = roles.stream().filter(role -> !existRoleIds.contains(role.getId())).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(newRoles)) {
                    this.sysRolesService.saveBatch(newRoles);
                }
            }
        }
    }

    @ImportProgressCache(msg="\u6b63\u5728\u5bfc\u5165\u5e94\u7528\u6570\u636e")
    public void importAppData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        SysApplication application;
        String appInfoPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "app.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(appInfoPath, JSONObject.class);
        if (ToolUtil.isNotEmpty((Object)jsonObject) && ToolUtil.isNotEmpty((Object)(application = (SysApplication)jsonObject.getObject("appInfo", SysApplication.class)))) {
            JSONArray jsonArray;
            List<SysAppAuthorize> appAuthorizes;
            importMappingDto.setOldAppId(application.getId());
            application.setId(null);
            application.setAppCode(null);
            application.setAppName(appImportDto.getAppName());
            application.setAppGroupId(appImportDto.getAppGroupId());
            if (ToolUtil.isNotEmpty((Object)appImportDto.getAppIconType())) {
                application.setAppIconType(appImportDto.getAppIconType());
            } else {
                application.setAppIconType("1");
            }
            if (ToolUtil.isNotEmpty((Object)appImportDto.getAppIcon())) {
                application.setAppIcon(appImportDto.getAppIcon());
            } else {
                application.setAppIcon("caidan-1Jmoren");
            }
            if (ToolUtil.isNotEmpty((Object)appImportDto.getAppIconColor())) {
                application.setAppIconColor(appImportDto.getAppIconColor());
            } else {
                application.setAppIconColor("#2794F8");
            }
            SysApplicationDto sysApplicationDto = new SysApplicationDto();
            BeanUtil.copyProperties((Object)application, (Object)sysApplicationDto);
            SysApplicationVo sysApplicationVo = this.applicationService.addApplication(sysApplicationDto);
            importMappingDto.setNewAppId(sysApplicationVo.getId());
            if (appImportDto.getExportRoleFlag() && ToolUtil.isNotEmpty(appAuthorizes = AppMigrateUtil.parseJsonArrayToList(jsonArray = (JSONArray)jsonObject.getObject("appAuth", JSONArray.class), SysAppAuthorize.class))) {
                for (SysAppAuthorize appAuthorize : appAuthorizes) {
                    appAuthorize.setId(null);
                    appAuthorize.setAppId(importMappingDto.getNewAppId());
                }
                this.appAuthorizeService.saveBatch(appAuthorizes);
            }
            Long userId = ((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserId();
            Long newAppId = importMappingDto.getNewAppId();
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)newAppId);
            SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.appDevelopTeamService.getOne((Wrapper)wrapper);
            if (ToolUtil.isNotEmpty((Object)sysAppDevelopTeam)) {
                Long teamId = sysAppDevelopTeam.getId();
                this.developTeamMemberService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId));
                SysAppDevelopTeamMember sysAppDevelopTeamMember = new SysAppDevelopTeamMember();
                sysAppDevelopTeamMember.setTeamId(teamId);
                sysAppDevelopTeamMember.setUserId(userId);
                sysAppDevelopTeamMember.setMemberType(Integer.valueOf(1));
                LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).eq(SysAppDevelopTeamMember::getUserId, (Object)userId);
                if (ToolUtil.isEmpty((Object)this.developTeamMemberService.getOne((Wrapper)wrapper1))) {
                    this.developTeamMemberService.save((Object)sysAppDevelopTeamMember);
                }
            }
        }
    }

    @ImportProgressCache(msg="\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6570\u636e")
    public void importFormData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String formFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "form.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(formFilePath, JSONObject.class);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            JSONArray jSONArray;
            List<SysAppVisitFormAuthorizeRoles> formAuths;
            List<SysForm> forms;
            JSONArray jsonArray = (JSONArray)jsonObject.getObject("formGroups", JSONArray.class);
            List<SysFormGroup> formGroups = AppMigrateUtil.parseJsonArrayToList(jsonArray, SysFormGroup.class);
            if (ToolUtil.isNotEmpty(formGroups)) {
                for (SysFormGroup sysFormGroup : formGroups) {
                    Long oldFormGroupId = sysFormGroup.getId();
                    sysFormGroup.setId(null);
                    sysFormGroup.setAppId(importMappingDto.getNewAppId());
                    this.formGroupService.save((Object)sysFormGroup);
                    Long newFormGroupId = sysFormGroup.getId();
                    importMappingDto.getFormGroupMap().put(oldFormGroupId, newFormGroupId);
                }
            }
            if (ToolUtil.isNotEmpty(forms = AppMigrateUtil.parseJsonObjectToListByKey(jsonObject, "forms", SysForm.class))) {
                for (SysForm form : forms) {
                    Long oldFormId = form.getId();
                    String oldTableName = form.getTableName();
                    form.setId(null);
                    form.setAppId(importMappingDto.getNewAppId());
                    String newTableName = oldTableName.substring(0, oldTableName.length() - 16) + RandomUtil.randomString((String)"0123456789", (int)16);
                    form.setTableName(newTableName);
                    form.setFormGroupId((Long)importMappingDto.getFormGroupMap().get(form.getFormGroupId()));
                    this.formService.save((Object)form);
                    SysFormDto sysFormDto = new SysFormDto();
                    BeanUtils.copyProperties((Object)form, (Object)sysFormDto);
                    this.formService.initFormDevelopRole(sysFormDto);
                    Long newFormId = form.getId();
                    importMappingDto.getFormIdMap().put(oldFormId, newFormId);
                    importMappingDto.getTableNameMap().put(oldTableName, newTableName);
                }
            }
            if (appImportDto.getExportRoleFlag() && ToolUtil.isNotEmpty(formAuths = AppMigrateUtil.parseJsonArrayToList(jSONArray = (JSONArray)jsonObject.getObject("formAuth", JSONArray.class), SysAppVisitFormAuthorizeRoles.class))) {
                for (SysAppVisitFormAuthorizeRoles formAuth : formAuths) {
                    formAuth.setId(null);
                    formAuth.setAppId(importMappingDto.getNewAppId());
                    formAuth.setFormId((Long)importMappingDto.getFormIdMap().get(formAuth.getFormId()));
                    this.formAuthService.save((Object)formAuth);
                }
            }
        }
    }

    @ImportProgressCache(msg="\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6743\u9650\u6570\u636e")
    public void importFormAuthData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        String formAuthPath;
        JSONObject jsonObject;
        if (appImportDto.getExportRoleFlag() && ToolUtil.isNotEmpty((Object)(jsonObject = AppMigrateUtil.readFileToObject(formAuthPath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "formAuth.json"}), JSONObject.class)))) {
            JSONArray fieldAuthJsonArray;
            List<SysUpAppVisitRoleField> fieldAuths;
            JSONArray buttonAuthJsonArray = (JSONArray)jsonObject.getObject("buttonAuth", JSONArray.class);
            List<SysAppVisitRoleButton> buttonAuths = AppMigrateUtil.parseJsonArrayToList(buttonAuthJsonArray, SysAppVisitRoleButton.class);
            if (ToolUtil.isNotEmpty(buttonAuths)) {
                for (SysAppVisitRoleButton buttonAuth : buttonAuths) {
                    buttonAuth.setId(null);
                    buttonAuth.setAppId(importMappingDto.getNewAppId());
                    buttonAuth.setFormId((Long)importMappingDto.getFormIdMap().get(buttonAuth.getFormId()));
                }
                this.buttonAuthService.saveBatch(buttonAuths);
            }
            if (ToolUtil.isNotEmpty(fieldAuths = AppMigrateUtil.parseJsonArrayToList(fieldAuthJsonArray = (JSONArray)jsonObject.getObject("filedAuth", JSONArray.class), SysUpAppVisitRoleField.class))) {
                for (SysUpAppVisitRoleField fieldAuth : fieldAuths) {
                    fieldAuth.setId(null);
                    fieldAuth.setAppId(importMappingDto.getNewAppId());
                    fieldAuth.setFormId((Long)importMappingDto.getFormIdMap().get(fieldAuth.getFormId()));
                }
                this.fieldAuthService.saveBatch(fieldAuths);
            }
            JSONArray dataLogicAuthJsonArray = (JSONArray)jsonObject.getObject("dataLogicAuth", JSONArray.class);
            List<SysAppVisitDataLogic> dataLogicAuths = AppMigrateUtil.parseJsonArrayToList(dataLogicAuthJsonArray, SysAppVisitDataLogic.class);
            JSONArray dataLogicFilterJsonArray = (JSONArray)jsonObject.getObject("dataLogicFilter", JSONArray.class);
            List<SysAppVisitDataLogicFilter> dataLogicFilters = AppMigrateUtil.parseJsonArrayToList(dataLogicFilterJsonArray, SysAppVisitDataLogicFilter.class);
            if (ToolUtil.isNotEmpty(dataLogicAuths)) {
                Long oldId;
                HashMap<Long, Long> mapping = new HashMap<Long, Long>();
                for (SysAppVisitDataLogic dataLogicAuth : dataLogicAuths) {
                    oldId = dataLogicAuth.getId();
                    long newId = LrEngineUtil.nextId();
                    mapping.put(oldId, newId);
                    dataLogicAuth.setId(Long.valueOf(newId));
                    dataLogicAuth.setAppId(importMappingDto.getNewAppId());
                    dataLogicAuth.setFormId((Long)importMappingDto.getFormIdMap().get(dataLogicAuth.getFormId()));
                }
                this.dataLogicAuthService.saveBatch(dataLogicAuths);
                if (ToolUtil.isNotEmpty(dataLogicFilters)) {
                    for (SysAppVisitDataLogicFilter dataLogicFilter : dataLogicFilters) {
                        oldId = dataLogicFilter.getRoleDataLogicId();
                        dataLogicFilter.setId(null);
                        dataLogicFilter.setRoleDataLogicId((Long)mapping.get(oldId));
                    }
                }
                this.dataLogicFilterService.saveBatch(dataLogicFilters);
            }
        }
    }

    @ImportProgressCache(msg="\u6b63\u5728\u5bfc\u5165\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void importMidFile(AppImportDto appImportDto, ImportMappingDto importMappingDto) throws Exception {
        File[] files;
        this.recordReplaceMapping(appImportDto, importMappingDto);
        String oldAppId = String.valueOf(importMappingDto.getOldAppId());
        String midFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", oldAppId});
        File midFileFolder = new File(midFilePath);
        if (midFileFolder.exists() && midFileFolder.isDirectory() && ToolUtil.isNotEmpty((Object)(files = midFileFolder.listFiles()))) {
            for (File file : files) {
                HashMap<Object, Object> staffReplaceMap;
                String viewPath;
                FormViewSchema formViewSchema;
                HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
                replaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
                replaceMap.putAll(importMappingDto.getFormIdMap());
                replaceMap.putAll(importMappingDto.getTableNameMap());
                replaceMap.putAll(importMappingDto.getSubTableNameMap());
                replaceMap.putAll(importMappingDto.getProcessKeyMap());
                String canvasPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "canvas", file.getName() + ".fd"});
                FormCanvasSchema formCanvasSchema = AppMigrateUtil.readFileToObjectWithReplace(canvasPath, FormCanvasSchema.class, replaceMap);
                if (ToolUtil.isNotEmpty((Object)formCanvasSchema)) {
                    this.clearSerialNumberId(formCanvasSchema);
                    this.canvasService.saveCanvasForImport(formCanvasSchema, importMappingDto);
                }
                String settingPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "setting", file.getName() + ".setting"});
                HashMap<Object, Object> settingReplaceMap = new HashMap<Object, Object>();
                settingReplaceMap.put(importMappingDto.getOldAppId(), importMappingDto.getNewAppId());
                settingReplaceMap.putAll(importMappingDto.getSubTableNameMap());
                settingReplaceMap.putAll(importMappingDto.getFormIdMap());
                FormSettingSchema formSettingSchema = AppMigrateUtil.readFileToObjectWithReplace(settingPath, FormSettingSchema.class, settingReplaceMap);
                if (ToolUtil.isNotEmpty((Object)formSettingSchema)) {
                    SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
                    bean.saveOrUpdate((BaseSetting)formSettingSchema, formSettingSchema.getFormId());
                }
                if (ToolUtil.isNotEmpty((Object)(formViewSchema = AppMigrateUtil.readFileToObject(viewPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "view", file.getName() + ".vd"}), FormViewSchema.class)))) {
                    formViewSchema.setAppId(String.valueOf(importMappingDto.getNewAppId()));
                    Long oldFormId = Long.valueOf(formViewSchema.getFormId());
                    String newFormId = String.valueOf(importMappingDto.getFormIdMap().get(oldFormId));
                    formViewSchema.setFormId(newFormId);
                    formViewSchema.setFormName((String)importMappingDto.getTableNameMap().get(formViewSchema.getFormName()));
                    this.viewService.save(formViewSchema);
                }
                String fileName = file.getName() + "history" + ".stf";
                String staffPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "staff", fileName});
                JSONArray jsonArray = AppMigrateUtil.readFileToObjectWithReplace(staffPath, JSONArray.class, staffReplaceMap = new HashMap<Object, Object>(importMappingDto.getFormIdMap()));
                List<StaffScope> staffScopes = AppMigrateUtil.parseJsonArrayToList(jsonArray, StaffScope.class);
                if (!ToolUtil.isNotEmpty(staffScopes)) continue;
                this.staffScopeScemaService.saveOrUpdateBatch(staffScopes);
            }
        }
    }

    @ImportProgressCache(msg="\u6b63\u5728\u5bfc\u5165\u6d41\u7a0b\u914d\u7f6e\u6570\u636e")
    public void importFlowData(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        this.recordReplaceMappingOfFlow(importMappingDto);
        String flowFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", "flow.json"});
        JSONObject flowData = AppMigrateUtil.readFileToObject(flowFilePath, JSONObject.class);
        HashMap<String, List<WorkflowDumpVo>> workflowDumpVoListMap = new HashMap<String, List<WorkflowDumpVo>>();
        if (ToolUtil.isNotEmpty((Object)flowData)) {
            for (String key : flowData.keySet()) {
                JSONArray data = (JSONArray)flowData.getObject(key, JSONArray.class);
                List<WorkflowDumpVo> workflowDumpVos = AppMigrateUtil.parseJsonArrayToList(data, WorkflowDumpVo.class);
                workflowDumpVoListMap.put(key, workflowDumpVos);
            }
        }
        com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto flowImportMappingDto = new com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto();
        BeanUtils.copyProperties((Object)importMappingDto, (Object)flowImportMappingDto);
        if (ToolUtil.isNotEmpty((Object)importMappingDto.getTableNameMap())) {
            Map<String, String> mainTableNameMap = importMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setMainTableNameMap(mainTableNameMap);
        }
        if (ToolUtil.isNotEmpty((Object)importMappingDto.getTaskTableNameMap())) {
            Map<String, String> taskTableNameMap = importMappingDto.getTaskTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setTaskTableNameMap(taskTableNameMap);
        }
        flowImportMappingDto.setMainTableBusinessKeyMap(importMappingDto.getTableNameMap());
        this.flowMigrateService.importWorkflow(workflowDumpVoListMap, flowImportMappingDto);
    }

    @ImportProgressCache(msg="\u6b63\u5728\u5bfc\u5165\u4e1a\u52a1\u6570\u636e")
    public void importBusinessData(AppImportDto appImportDto, ImportMappingDto importMappingDto) throws Exception {
        this.updateTableInfo(importMappingDto);
        String filePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "businessData", "businessData.json"});
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.putAll(importMappingDto.getTableNameMap());
        replaceMap.putAll(importMappingDto.getSubTableNameMap());
        JSONObject jsonObject = AppMigrateUtil.readFileToObjectWithReplace(filePath, JSONObject.class, replaceMap);
        if (ToolUtil.isNotEmpty((Object)jsonObject)) {
            String appId = String.valueOf(importMappingDto.getNewAppId());
            Set tableNames = jsonObject.keySet();
            EngineUserUtil.setUser((UserDetails)((UserDetails)TransmittableThreadLocalHolder.get((String)"loginUser")));
            for (String tableName : tableNames) {
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysForm::getTableName, (Object)tableName);
                String formId = String.valueOf(((SysForm)this.formService.getOne((Wrapper)wrapper)).getId());
                JSONArray jsonArray = (JSONArray)jsonObject.getObject(tableName, JSONArray.class);
                List<Object> importList = AppMigrateUtil.parseJsonArrayToList(jsonArray, Object.class);
                HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
                params.put("importList", importList);
                this.formOperateExposedService.tableSave(appId, formId, params);
                this.reSync(formId);
            }
            EngineUserUtil.remove();
        }
    }

    private void clearSerialNumberId(FormCanvasSchema formCanvasSchema) {
        List widgets = formCanvasSchema.getWidgets();
        if (ToolUtil.isNotEmpty((Object)widgets)) {
            for (Widget widget : widgets) {
                List serialNumRuleDTOS;
                if (!WidgetType.JXDNSerialNumber.getType().equals(widget.getType()) || !ToolUtil.isNotEmpty((Object)(serialNumRuleDTOS = (List)JsonParser.array((Object)widget, (String)"$.props.rules", SerialNumRuleDTO.class).orElse(null)))) continue;
                for (SerialNumRuleDTO serialNumRuleDTO : serialNumRuleDTOS) {
                    serialNumRuleDTO.getConfig().setId(null);
                }
                JSONPath.set((Object)widget, (String)"$.props.rules", (Object)serialNumRuleDTOS);
            }
        }
    }

    private void recordReplaceMappingOfFlow(ImportMappingDto importMappingDto) {
        Map<String, String> taskTableNameMap = importMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> "PROCESS_TASK_INFO_" + (String)entry.getKey(), entry -> "PROCESS_TASK_INFO_" + (String)entry.getValue()));
        importMappingDto.setTaskTableNameMap(taskTableNameMap);
        importMappingDto.getMainTableBusinessKeyMap().putAll(importMappingDto.getTableNameMap());
    }

    private void recordReplaceMapping(AppImportDto appImportDto, ImportMappingDto importMappingDto) {
        File[] files;
        String oldAppId = String.valueOf(importMappingDto.getOldAppId());
        String midFilePath = FileUtil.posixPath((String[])new String[]{appImportDto.getPath(), "appConfig", oldAppId});
        File midFileFolder = new File(midFilePath);
        if (midFileFolder.exists() && midFileFolder.isDirectory() && ToolUtil.isNotEmpty((Object)(files = midFileFolder.listFiles()))) {
            for (File file : files) {
                String canvasPath = FileUtil.posixPath((String[])new String[]{file.getAbsolutePath(), "canvas", file.getName() + ".fd"});
                FormCanvasSchema formCanvasSchema = AppMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
                if (!ToolUtil.isNotEmpty((Object)formCanvasSchema)) continue;
                for (Widget widget : formCanvasSchema.childTables()) {
                    String oleSubTableName = widget.getName();
                    String randomSubTableName = RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz0123456789", (int)16);
                    String newSubTableName = "field_jxdnchildrentable_" + randomSubTableName;
                    importMappingDto.getSubTableNameMap().put(oleSubTableName, newSubTableName);
                }
                if (!formCanvasSchema.getFormType().equals("1")) continue;
                String oldFlowIdentity = formCanvasSchema.getIdentity();
                String newFlowIdentity = oldFlowIdentity.substring(0, oldFlowIdentity.length() - 18) + RandomUtil.randomString((String)"0123456789", (int)18);
                importMappingDto.getProcessKeyMap().put(oldFlowIdentity, newFlowIdentity);
            }
        }
    }

    private void updateTableInfo(ImportMappingDto importMappingDto) throws Exception {
        Collection fromIds = importMappingDto.getFormIdMap().values();
        for (Long formId : fromIds) {
            FormCanvasSchema formCanvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            if (ToolUtil.isEmpty((Object)formCanvasSchema)) continue;
            FormSchema formSchema = new FormSchema.Builder().formPage(formCanvasSchema).build();
            DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)formSchema);
            NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
            DataModelBase dataModelBase = builder.direct();
            noCodeModelHandler.updateTable(dataModelBase, builder.createContrast());
            builder.clearFieldForImport(dataModelBase);
            noCodeModelHandler.sync(dataModelBase);
        }
    }

    private void reSync(String formId) throws Exception {
        FormDesignResponse form = this.formOperateService.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)((FormSchema)form.getData()));
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.sync(dataModelBase);
    }
}

