/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppAuthRoleServiceImpl;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppExportInfoServiceImpl")
public class AppExportInfoServiceImpl
implements IAppExportInfoService {
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private SysFormGroupMapper sysFormGroupMapper;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFiledMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private SysAppAuthorizeMapper sysAppAuthorizeMapper;
    @Resource
    SysAppVisitFormAuthorizeRolesMapper sysAppVisitFormAuthorizeRolesMapper;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private AppAuthRoleServiceImpl appAuthRoleService;
    @Resource
    private ISysRoleGroupService roleGroupService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    private String basePath;

    public void init(AppExportDto appExportDto) {
        String exportFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), ".export-store"});
        AppMigrateUtil.deleteFolder(exportFolderPath);
        this.basePath = FileUtil.posixPath((String[])new String[]{exportFolderPath, appExportDto.getAppId().toString()});
    }

    @ProgressCache(msg="\u6b63\u5728\u5bfc\u51fa\u5e94\u7528\u4fe1\u606f")
    public void exportAppInfo(AppExportDto appExportDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysApplication application = (SysApplication)this.sysApplicationMapper.selectById(appExportDto.getAppId());
        map.put("appInfo", application);
        if (ToolUtil.isNotEmpty((Object)appExportDto.getAppAuthRoleIds())) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppAuthorize::getAppId, (Object)appExportDto.getAppId())).in(SysAppAuthorize::getRoleId, (Collection)appExportDto.getAppAuthRoleIds());
            List appAuthInfo = this.sysAppAuthorizeMapper.selectList((Wrapper)wrapper);
            map.put("appAuth", appAuthInfo);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{this.basePath, "appConfig", "app.json"}));
    }

    @ProgressCache(msg="\u6b63\u5728\u5bfc\u51fa\u8868\u5355\u4fe1\u606f")
    public void exportFormInfo(AppExportDto appExportDto) {
        HashMap<String, List> map = new HashMap<String, List>();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        map.put("forms", forms);
        if (ToolUtil.isNotEmpty((Object)forms)) {
            List formGroupIds = forms.stream().map(SysForm::getFormGroupId).collect(Collectors.toList());
            List formGroups = this.sysFormGroupMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFormGroup::getId, formGroupIds));
            map.put("formGroups", formGroups);
        }
        if (ToolUtil.isNotEmpty((Object)appExportDto.getFormAuthRoleIds())) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appExportDto.getAppId())).in(SysAppVisitFormAuthorizeRoles::getRoleId, (Collection)appExportDto.getFormAuthRoleIds());
            List formAuthInfo = this.sysAppVisitFormAuthorizeRolesMapper.selectList((Wrapper)wrapper);
            map.put("formAuth", formAuthInfo);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{this.basePath, "appConfig", "form.json"}));
    }

    @ProgressCache(msg="\u6b63\u5728\u5bfc\u51fa\u8868\u5355\u6743\u9650\u4fe1\u606f")
    public void exportFormAuthorityInfo(AppExportDto appExportDto) {
        if (ToolUtil.isNotEmpty((Object)appExportDto.getFormAuthRoleIds())) {
            HashMap<String, List> map = new HashMap<String, List>();
            LambdaQueryWrapper buttonWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)buttonWrapper.eq(SysAppVisitRoleButton::getAppId, (Object)appExportDto.getAppId())).in(SysAppVisitRoleButton::getRoleId, (Collection)appExportDto.getFormAuthRoleIds());
            List buttonAuth = this.roleButtonMapper.selectList((Wrapper)buttonWrapper);
            map.put("buttonAuth", buttonAuth);
            LambdaQueryWrapper filedWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)filedWrapper.eq(SysUpAppVisitRoleField::getAppId, (Object)appExportDto.getAppId())).in(SysUpAppVisitRoleField::getRoleId, (Collection)appExportDto.getFormAuthRoleIds());
            List filedAuth = this.roleFiledMapper.selectList((Wrapper)filedWrapper);
            map.put("filedAuth", filedAuth);
            LambdaQueryWrapper dataLogicWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)dataLogicWrapper.eq(SysAppVisitDataLogic::getAppId, (Object)appExportDto.getAppId())).in(SysAppVisitDataLogic::getRoleId, (Collection)appExportDto.getFormAuthRoleIds());
            List dataLogicAuth = this.dataLogicMapper.selectList((Wrapper)dataLogicWrapper);
            map.put("dataLogicAuth", dataLogicAuth);
            if (ToolUtil.isNotEmpty((Object)dataLogicAuth)) {
                List dataLogicFilterIds = dataLogicAuth.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
                List dataLogicFilters = this.dataLogicFilterMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, dataLogicFilterIds));
                map.put("dataLogicFilter", dataLogicFilters);
            }
            this.writeToFile(map, FileUtil.posixPath((String[])new String[]{this.basePath, "appConfig", "formAuth.json"}));
        }
    }

    @ProgressCache(msg="\u6b63\u5728\u5bfc\u51fa\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void exportDesignerMidFile(AppExportDto appExportDto) throws JsonProcessingException {
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        List formIds = forms.stream().map(SysForm::getId).collect(Collectors.toList());
        this.formOperateExposedService.exportMid(appExportDto.getAppId(), FileUtil.posixPath((String[])new String[]{this.basePath, "appConfig"}), formIds);
    }

    @ProgressCache(msg="\u6b63\u5728\u5bfc\u51fa\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f")
    public void exportFlowConfigInfo(AppExportDto appExportDto) {
        Map flowDataMap = this.flowMigrateService.exportWorkflow(appExportDto.getAppId());
        String flowFilePath = FileUtil.posixPath((String[])new String[]{this.basePath, "appConfig", "flow.json"});
        this.writeToFile(flowDataMap, flowFilePath);
    }

    @ProgressCache(msg="\u6b63\u5728\u5bfc\u51fa\u516c\u5171\u6570\u636e")
    public void exportCommData(AppExportDto appExportDto) {
        HashSet roleIds = new HashSet();
        roleIds.addAll(appExportDto.getAppAuthRoleIds());
        roleIds.addAll(appExportDto.getFormAuthRoleIds());
        roleIds.addAll(appExportDto.getFlowAuthRoleIds());
        if (ToolUtil.isNotEmpty(roleIds)) {
            HashMap<String, List> roleDataMap = new HashMap<String, List>();
            List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
            roleDataMap.put("roles", roles);
            List roleGroupIds = roles.stream().map(SysRoles::getGroupId).filter(Objects::nonNull).collect(Collectors.toList());
            List roleGroups = this.roleGroupService.selectRoleGroupByIds(roleGroupIds);
            roleDataMap.put("roleGroups", roleGroups);
            this.writeToFile(roleDataMap, FileUtil.posixPath((String[])new String[]{this.basePath, "commonData", "commonData.json"}));
        }
    }

    @ProgressCache(msg="\u6b63\u5728\u5bfc\u51fa\u4e1a\u52a1\u6570\u636e")
    public void exportBusinessData(AppExportDto appExportDto) {
        HashMap<String, List> map = new HashMap<String, List>();
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appExportDto.getAppId()));
        for (SysForm sysForm : forms) {
            ResponseEntity result = this.formOperateExposedService.tableQueryAll(String.valueOf(appExportDto.getAppId()), String.valueOf(sysForm.getId()));
            List data = ((PageVo)((ApiResponse)Objects.requireNonNull(result.getBody())).getData()).getData();
            map.put(sysForm.getTableName(), data);
        }
        this.writeToFile(map, FileUtil.posixPath((String[])new String[]{this.basePath, "businessData", "businessData.json"}));
    }

    @ProgressCache(msg="\u6b63\u5728\u751f\u6210\u5bfc\u51fa\u5e94\u7528\u5143\u4fe1\u606f")
    public void generateMetaInfo(AppExportDto appExportDto) {
        AppExportMetaDto appExportMeta = new AppExportMetaDto();
        SysApplication sysApplication = (SysApplication)this.sysApplicationMapper.selectById(appExportDto.getAppId());
        BeanUtils.copyProperties((Object)sysApplication, (Object)appExportMeta);
        appExportMeta.setAppAuthRoleVo(this.appAuthRoleService.getAppAuthRoleTree(appExportDto.getAppAuthRoleIds(), appExportDto.getFormAuthRoleIds(), appExportDto.getFlowAuthRoleIds()));
        appExportMeta.setVersion(AppMigrateUtil.getMigrateVersion());
        if (ToolUtil.isNotEmpty((Object)appExportDto.getExportPwd())) {
            appExportMeta.setPassword(DigestUtil.sha1Hex((String)appExportDto.getExportPwd()));
        }
        this.writeToFile(appExportMeta, FileUtil.posixPath((String[])new String[]{this.basePath, "hussar.meta"}));
    }

    @ProgressCache(msg="\u5e94\u7528\u5bfc\u51fa\u6210\u529f", finish=true)
    public Long uploadExportFile(AppExportDto appExportDto) {
        String appName = ((SysApplication)this.sysApplicationMapper.selectById(appExportDto.getAppId())).getAppName();
        return this.appFileExtendService.fileEncrypt(appName, this.basePath);
    }

    public void clear() {
        String exportFilePath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), ".export-store"});
        AppMigrateUtil.deleteFolder(exportFilePath);
    }

    private void writeToFile(Object object, String path) {
        String json = JSONObject.toJSONStringWithDateFormat((Object)object, (String)"yyyy-MM-dd hh:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        this.filePublishService.writeStringToFile(json, path);
    }
}

