/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.controller;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppAuthRoleService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAuthRoleVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5e94\u7528\u5bfc\u51fa\u5bfc\u5165\u7c7b"})
@RequestMapping(value={"/hussarBase/application/migrate"})
@RestController(value="com.jxdinfo.hussar.formdesign.application.application.controller.AppExportImportController")
public class AppExportImportController {
    @Resource
    private IAppAuthRoleService appAuthRoleService;
    @Resource
    private IAppExportService appExportService;
    @Resource
    private IAppImportService appImportService;

    @GetMapping(value={"/app_auth_roles"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u6388\u6743\u89d2\u8272\u6811", notes="\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u6388\u6743\u89d2\u8272\u6811")
    public ApiResponse<AppAuthRoleVo> getAppAuthRoles(@ApiParam(value="\u5e94\u7528 id") @RequestParam Long appId) {
        return this.appAuthRoleService.getAppAuthRoles(appId);
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528", notes="\u5bfc\u51fa\u5e94\u7528")
    public ApiResponse<Void> export(@RequestBody AppExportDto appExportDto) {
        return this.appExportService.export(appExportDto);
    }

    @GetMapping(value={"/export_progress"})
    public ApiResponse<ExportStatusVo> getExportProgress() {
        return this.appExportService.getExportProgress();
    }

    @GetMapping(value={"/export_progress_reset"})
    public ApiResponse<Void> resetExportProgress() {
        return this.appExportService.resetExportProgress();
    }

    @PostMapping(value={"/export_file_download/{fileId}"})
    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528\u9644\u4ef6\u4e0b\u8f7d", notes="\u5bfc\u51fa\u5e94\u7528\u9644\u4ef6\u4e0b\u8f7d")
    public void downloadExportFile(@PathVariable(value="fileId") Long fileId, HttpServletResponse response) {
        this.appExportService.downloadExportFile(fileId, response);
    }

    @PostMapping(value={"/import_attachment_parse"})
    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528\u9644\u4ef6\u89e3\u6790", notes="\u5bfc\u5165\u5e94\u7528\u9644\u4ef6\u89e3\u6790")
    public ApiResponse<AppAttachmentParseVo> parseAttachment(@RequestBody MultipartFile file) {
        return this.appImportService.parseAttachment(file);
    }

    @PostMapping(value={"/import_password_verify"})
    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528\u5bc6\u7801\u9a8c\u8bc1", notes="\u5bfc\u5165\u5e94\u7528\u5bc6\u7801\u9a8c\u8bc1")
    public ApiResponse<Boolean> verifyPassword(@RequestBody AppImportDto appImportDto) {
        return this.appImportService.verifyPassword(appImportDto);
    }

    @GetMapping(value={"/import/verify_appName"})
    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528\u540d\u79f0\u91cd\u590d\u9a8c\u8bc1")
    public ApiResponse<Boolean> verifyAppName(@RequestParam(value="appName") String appName) {
        return ApiResponse.success((Object)this.appImportService.verifyAppName(appName));
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528", notes="\u5bfc\u5165\u5e94\u7528")
    public ApiResponse<Void> importApp(@RequestBody AppImportDto appImportDto) throws Exception {
        SecurityUser user = BaseSecurityUtil.getUser();
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
        this.appImportService.importApp(appImportDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/import_after/{appId}"})
    @ApiOperation(value="\u5bfc\u5165\u5e94\u7528\u6210\u529f\u7684\u56de\u8c03")
    public ApiResponse<Void> importSuccessCallBack(@PathVariable(value="appId") String appId) {
        this.appImportService.importSuccessCallBack(appId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/import_progress_reset"})
    @ApiOperation(value="\u91cd\u7f6e\u5bfc\u5165\u5e94\u7528\u8fdb\u5ea6", notes="\u91cd\u7f6e\u5bfc\u5165\u5e94\u7528\u8fdb\u5ea6")
    public ApiResponse<Void> resetImportProgress() {
        return this.appImportService.resetImportProgress();
    }

    @GetMapping(value={"/import_progress"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u5165\u5e94\u7528\u8fdb\u5ea6", notes="\u83b7\u53d6\u5bfc\u5165\u5e94\u7528\u8fdb\u5ea6")
    public ApiResponse<ImportStatusVo> getImportProgress() {
        return this.appImportService.getImportProgress();
    }
}

