/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.FieldAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.FormRoleFieldAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.AppFieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysUpAppVisitRoleFieldServiceImpl")
public class SysUpAppVisitRoleFieldServiceImpl
extends HussarServiceImpl<SysUpAppVisitRoleFieldMapper, SysUpAppVisitRoleField>
implements ISysUpAppVisitRoleFieldService {
    @Resource
    private SysUpAppVisitRoleFieldMapper sysUpAppVisitRoleFieldMapper;
    @Autowired
    private FormOperateExposedService formOperateExposedService;

    @HussarTransactional
    public ApiResponse<Boolean> saveFieldAuthority(FormRoleFieldAuthoritiesDto formRoleFieldAuthoritiesDto) {
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)formRoleFieldAuthoritiesDto.getAppId())).eq(SysUpAppVisitRoleField::getFormId, (Object)formRoleFieldAuthoritiesDto.getFormId())).eq(SysUpAppVisitRoleField::getRoleId, (Object)formRoleFieldAuthoritiesDto.getRoleId()));
        ArrayList<SysUpAppVisitRoleField> sysUpAppVisitRoleFields = new ArrayList<SysUpAppVisitRoleField>();
        List fieldDtos = formRoleFieldAuthoritiesDto.getFieldDtos();
        for (FieldAuthorityDto fieldAuthorityDto : fieldDtos) {
            SysUpAppVisitRoleField sysUpAppVisitRoleField = new SysUpAppVisitRoleField();
            sysUpAppVisitRoleField.setAppId(formRoleFieldAuthoritiesDto.getAppId());
            sysUpAppVisitRoleField.setFormId(formRoleFieldAuthoritiesDto.getFormId());
            sysUpAppVisitRoleField.setRoleId(formRoleFieldAuthoritiesDto.getRoleId());
            sysUpAppVisitRoleField.setFieldId(fieldAuthorityDto.getFieldId());
            sysUpAppVisitRoleField.setFieldName(fieldAuthorityDto.getFieldName());
            sysUpAppVisitRoleField.setCanRead(fieldAuthorityDto.getCanRead());
            sysUpAppVisitRoleField.setCanWrite(fieldAuthorityDto.getCanWrite());
            sysUpAppVisitRoleField.setParentId(fieldAuthorityDto.getParentId());
            sysUpAppVisitRoleFields.add(sysUpAppVisitRoleField);
            List children = fieldAuthorityDto.getChildren();
            if (HussarUtils.isEmpty((Object)children)) continue;
            for (FieldAuthorityDto authorityDto : children) {
                SysUpAppVisitRoleField appVisitRoleField = new SysUpAppVisitRoleField();
                appVisitRoleField.setAppId(formRoleFieldAuthoritiesDto.getAppId());
                appVisitRoleField.setFormId(formRoleFieldAuthoritiesDto.getFormId());
                appVisitRoleField.setRoleId(formRoleFieldAuthoritiesDto.getRoleId());
                appVisitRoleField.setFieldId(authorityDto.getFieldId());
                appVisitRoleField.setFieldName(authorityDto.getFieldName());
                appVisitRoleField.setCanRead(authorityDto.getCanRead());
                appVisitRoleField.setCanWrite(authorityDto.getCanWrite());
                appVisitRoleField.setParentId(authorityDto.getParentId());
                sysUpAppVisitRoleFields.add(appVisitRoleField);
            }
        }
        return ApiResponse.success((Object)this.saveBatch(sysUpAppVisitRoleFields, sysUpAppVisitRoleFields.size()));
    }

    public ApiResponse<List<AppFieldAuthorityVo>> getFieldAuthorityList(Long formId, Long roleId, String appId) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysUpAppVisitRoleField::getFormId, (Object)formId);
        ew.eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId);
        List roleFieldList = this.list((Wrapper)ew);
        ArrayList<AppFieldAuthorityVo> fieldAuthorityVos = new ArrayList<AppFieldAuthorityVo>();
        Map<String, SysUpAppVisitRoleField> fieldVoMap = roleFieldList.stream().collect(Collectors.toMap(SysUpAppVisitRoleField::getFieldId, item -> item));
        List widgetFields = (List)this.formOperateExposedService.widgets(formId.toString(), appId).getData();
        if (HussarUtils.isEmpty((Object)widgetFields)) {
            return ApiResponse.success(fieldAuthorityVos);
        }
        for (WidgetField widgetField : widgetFields) {
            AppFieldAuthorityVo fieldVo = new AppFieldAuthorityVo();
            String fieldId = widgetField.getName();
            fieldVo.setFieldId(fieldId);
            fieldVo.setFieldName(widgetField.getTitle());
            fieldVo.setType(widgetField.getType());
            fieldVo.setUsage(widgetField.getUsage());
            fieldVo.setDataType(widgetField.getDataType());
            fieldVo.setRealField(widgetField.getIsRealField());
            fieldVo.setReadOnly(widgetField.isReadOnly());
            SysUpAppVisitRoleField appVisitRolefield = fieldVoMap.get(fieldId);
            if (HussarUtils.isNotEmpty((Object)appVisitRolefield)) {
                fieldVo.setCanRead(appVisitRolefield.getCanRead());
                fieldVo.setCanWrite(appVisitRolefield.getCanWrite());
            } else {
                fieldVo.setCanRead("1");
                fieldVo.setCanWrite("1");
            }
            if (HussarUtils.isNotEmpty((Object)widgetField.getChildren())) {
                ArrayList fieldVosChildren = Lists.newArrayListWithCapacity((int)10);
                widgetField.getChildren().forEach(c -> {
                    AppFieldAuthorityVo cT = new AppFieldAuthorityVo();
                    String childFieldId = c.getName();
                    cT.setFieldId(c.getName());
                    cT.setFieldName(widgetField.getTitle() + "." + c.getTitle());
                    cT.setType(c.getType());
                    cT.setUsage(c.getUsage());
                    cT.setDataType(c.getDataType());
                    cT.setRealField(c.getIsRealField());
                    cT.setReadOnly(c.isReadOnly());
                    SysUpAppVisitRoleField visitRolefield = (SysUpAppVisitRoleField)fieldVoMap.get(childFieldId);
                    if (HussarUtils.isNotEmpty((Object)visitRolefield)) {
                        cT.setCanRead(visitRolefield.getCanRead());
                        cT.setCanWrite(visitRolefield.getCanWrite());
                    } else {
                        cT.setCanRead("1");
                        cT.setCanWrite("1");
                    }
                    fieldVosChildren.add(cT);
                });
                fieldVo.setChildren((List)fieldVosChildren);
            }
            fieldAuthorityVos.add(fieldVo);
        }
        return ApiResponse.success(fieldAuthorityVos);
    }

    public ApiResponse<List<FieldAuthorityVo>> formAuthorityField(Long formId) {
        if (HussarUtils.isEmpty((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)shiroUser) && HussarUtils.isEmpty((Object)(shiroUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")))) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        List rolesList = shiroUser.getRolesList();
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            ArrayList fieldNoAuthority = Lists.newArrayListWithCapacity((int)10);
            List<FieldAuthorityVo> allField = this.sysUpAppVisitRoleFieldMapper.selectByFormId(formId, rolesList);
            if (HussarUtils.isEmpty(allField)) {
                return ApiResponse.success();
            }
            Map<String, List<FieldAuthorityVo>> nameFieldMap = allField.stream().filter(e -> HussarUtils.isNotEmpty((Object)e.getFieldId())).collect(Collectors.groupingBy(FieldAuthorityVo::getFieldId));
            if (HussarUtils.isEmpty(nameFieldMap)) {
                return ApiResponse.success();
            }
            nameFieldMap.forEach((k, v) -> {
                FieldAuthorityVo fT = (FieldAuthorityVo)v.get(0);
                Set canRead = v.stream().map(FieldAuthorityVo::getCanRead).collect(Collectors.toSet());
                if (!canRead.contains("1")) {
                    fT.setCanRead("0");
                } else {
                    fT.setCanRead("1");
                }
                Set canWrite = v.stream().map(FieldAuthorityVo::getCanWrite).collect(Collectors.toSet());
                if (canWrite.contains("")) {
                    fT.setCanWrite("");
                } else if (!canWrite.contains("1")) {
                    fT.setCanWrite("0");
                } else {
                    fT.setCanWrite("1");
                }
                if ("0".equals(fT.getCanRead()) || "0".equals(fT.getCanWrite())) {
                    fieldNoAuthority.add(fT);
                }
            });
            return ApiResponse.success((Object)fieldNoAuthority);
        }
        return ApiResponse.success();
    }
}

