/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppCommonMapper;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppCommon;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppCommonVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.SysAppCommonServiceImpl")
public class SysAppCommonServiceImpl
extends HussarServiceImpl<SysAppCommonMapper, SysAppCommon>
implements ISysAppCommonService {
    @Resource
    private SysAppCommonMapper sysAppCommonMapper;
    @Resource
    private ISysAppAuthorizeService sysAppAuthorizeService;

    @HussarTransactional
    public ApiResponse<Boolean> addCommonApp(List<SysAppCommon> appCommonList, String platform) {
        if (appCommonList.size() > 12) {
            return ApiResponse.fail((String)"\u5e38\u7528\u5e94\u7528\u4e0d\u53ef\u8d85\u8fc712\u4e2a");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        Long userId = BaseSecurityUtil.getUser().getUserId();
        wrapper.eq(SysAppCommon::getUserId, (Object)userId);
        wrapper.eq(SysAppCommon::getPlatform, (Object)platform);
        this.remove((Wrapper)wrapper);
        for (int i = 0; i < appCommonList.size(); ++i) {
            appCommonList.get(i).setUserId(userId);
            appCommonList.get(i).setSEQ(i);
        }
        this.saveBatch(appCommonList);
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public List<SysAppCommonVo> getCommonAppList(String platform) {
        List currentUserAuthorityApp = this.sysAppAuthorizeService.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty((Object)currentUserAuthorityApp)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<SysAppCommonVo> allAppCommon = this.sysAppCommonMapper.getCommonAppList(platform, BaseSecurityUtil.getUser().getUserId());
        if (HussarUtils.isEmpty(allAppCommon)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList appCommonAuthority = Lists.newArrayListWithCapacity((int)allAppCommon.size());
        for (SysAppCommonVo c : allAppCommon) {
            if (!currentUserAuthorityApp.contains(c.getAppId())) continue;
            appCommonAuthority.add(c);
        }
        return appCommonAuthority;
    }
}

