/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppAuthRoleService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAuthRoleVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AuthRoleVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.RoleGroupTreeVo;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppAuthRoleServiceImpl")
public class AppAuthRoleServiceImpl
implements IAppAuthRoleService {
    @Resource
    private SysAppAuthorizeMapper sysAppAuthorizeMapper;
    @Resource
    private ISysRolesExternalService roleService;
    @Resource
    private ISysRolesExternalService roleGroupService;
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper formAuthMapper;
    @Resource
    private GodAxeMigrationService flowService;

    public ApiResponse<AppAuthRoleVo> getAppAuthRoles(Long appId) {
        AppAuthRoleVo appAuthRoleVo = new AppAuthRoleVo();
        appAuthRoleVo.setAppAuthRoles(this.getAppRoles(appId));
        appAuthRoleVo.setFormAuthRoles(this.getFormRoles(appId));
        appAuthRoleVo.setFlowAuthRoles(this.getFlowRoleTree(appId));
        return ApiResponse.success((Object)appAuthRoleVo);
    }

    public AppAuthRoleVo getAppAuthRoleTree(List<Long> appAuthRoleIds, List<Long> formAuthRoleIds, List<Long> flowAuthRoleIds) {
        AppAuthRoleVo appAuthRoleVo = new AppAuthRoleVo();
        appAuthRoleVo.setAppAuthRoles(this.getAuthRoleVo(appAuthRoleIds));
        appAuthRoleVo.setFormAuthRoles(this.getAuthRoleVo(formAuthRoleIds));
        appAuthRoleVo.setFlowAuthRoles(this.getAuthRoleVo(flowAuthRoleIds));
        return appAuthRoleVo;
    }

    private AuthRoleVo getAppRoles(Long appId) {
        List sysAppAuthorizes = this.sysAppAuthorizeMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysAppAuthorize::getAppId, (Object)appId));
        List<Long> roleIds = sysAppAuthorizes.stream().map(SysAppAuthorize::getRoleId).collect(Collectors.toList());
        return this.getAuthRoleVo(roleIds);
    }

    private AuthRoleVo getFormRoles(Long appId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppVisitFormAuthorizeRoles::getAppId, new Object[]{appId});
        List formAuthRoles = this.formAuthMapper.selectList((Wrapper)wrapper);
        List<Long> roleIds = formAuthRoles.stream().map(SysAppVisitFormAuthorizeRoles::getRoleId).collect(Collectors.toList());
        return this.getAuthRoleVo(roleIds);
    }

    private AuthRoleVo getFlowRoleTree(Long appId) {
        List flowRoleIds = this.flowService.queryRoleIdList(appId);
        return this.getAuthRoleVo(flowRoleIds);
    }

    private AuthRoleVo getAuthRoleVo(List<Long> roleIds) {
        if (ToolUtil.isEmpty(roleIds)) {
            return null;
        }
        AuthRoleVo authRoleVo = new AuthRoleVo();
        List roles = this.roleService.getRolesByIds(roleIds);
        List roleGroupIds = roles.stream().map(SysRoles::getGroupId).collect(Collectors.toList());
        List roleGroups = this.roleGroupService.selectRoleGroupByIds(roleGroupIds);
        ArrayList<RoleVo> roleVos = new ArrayList<RoleVo>();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            SysRoles sysRole = (SysRoles)iterator.next();
            if (!ToolUtil.isEmpty((Object)sysRole.getGroupId())) continue;
            RoleVo roleVo = new RoleVo();
            BeanUtils.copyProperties((Object)sysRole, (Object)roleVo);
            roleVos.add(roleVo);
            iterator.remove();
        }
        ArrayList<RoleGroupTreeVo> roleGroupTreeVos = new ArrayList<RoleGroupTreeVo>();
        for (SysRoleGroup sysRoleGroup : roleGroups) {
            RoleGroupTreeVo roleGroupTreeVo = new RoleGroupTreeVo();
            BeanUtils.copyProperties((Object)sysRoleGroup, (Object)roleGroupTreeVo);
            ArrayList<RoleVo> roleVos1 = new ArrayList<RoleVo>();
            Iterator iterator1 = roles.iterator();
            while (iterator1.hasNext()) {
                SysRoles sysRole = (SysRoles)iterator1.next();
                if (!ToolUtil.equals((Object)sysRole.getGroupId(), (Object)sysRoleGroup.getId())) continue;
                RoleVo roleVo1 = new RoleVo();
                BeanUtils.copyProperties((Object)sysRole, (Object)roleVo1);
                roleVos1.add(roleVo1);
                iterator1.remove();
            }
            roleGroupTreeVo.setRoles(roleVos1);
            roleGroupTreeVos.add(roleGroupTreeVo);
        }
        authRoleVo.setRoleVos(roleVos);
        authRoleVo.setRoleGroupVos(roleGroupTreeVos);
        return authRoleVo;
    }
}

