/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncMenuHandler {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysFormGroupService formGroupService;
    @Resource
    private ISysFormService formService;
    @Resource
    private AppSyncService appSyncService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncMenuHandler.class);

    public void syncMenuForAppImport(Long appId) {
        try {
            this.syncFormGroups("add", appId);
            this.syncForms("add", appId);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83dc\u5355\u5931\u8d25 => ", (Throwable)e);
        }
    }

    public void syncMenuForAppImportFail(Long appId) {
        try {
            this.syncApp("del", appId);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83dc\u5355\u5931\u8d25 => ", (Throwable)e);
        }
    }

    public void syncMenuForFormImport(Long formId) {
        try {
            this.syncForm("add", formId);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83dc\u5355\u5931\u8d25 => ", (Throwable)e);
        }
    }

    public void syncMenuForFormCopy(Long formId) {
        try {
            this.syncForm("add", formId);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83dc\u5355\u5931\u8d25 => ", (Throwable)e);
        }
    }

    public void syncMenuForRecycleApp(Long appId) {
        try {
            this.syncApp("add", appId);
            this.syncFormGroups("add", appId);
            this.syncForms("add", appId);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u83dc\u5355\u5931\u8d25 => ", (Throwable)e);
        }
    }

    public void syncApp(String syncType, Long appId) {
        SysApplication sysApplication = (SysApplication)this.applicationService.getById((Serializable)appId);
        if (HussarUtils.isNotEmpty((Object)sysApplication)) {
            this.appSyncService.syncApp(syncType, sysApplication);
        }
    }

    public void syncFormGroups(String syncType, Long appId) {
        List sysFormGroups = this.formGroupService.list((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysFormGroups)) {
            for (SysFormGroup sysFormGroup : sysFormGroups) {
                this.appSyncService.syncFormGroup(syncType, sysFormGroup);
            }
        }
    }

    public void syncForm(String syncType, Long formId) {
        SysForm sysForm = (SysForm)this.formService.getById((Serializable)formId);
        if (HussarUtils.isNotEmpty((Object)sysForm)) {
            this.appSyncService.syncForm(syncType, sysForm);
        }
    }

    public void syncForms(String syncType, Long appId) {
        List sysForms = this.formService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysForms)) {
            for (SysForm sysForm : sysForms) {
                this.appSyncService.syncForm(syncType, sysForm);
            }
        }
    }
}

