/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.plugin.metadata.service.MetadataTableService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.constant.SysUserTableNameConstant;
import com.jxdinfo.hussar.formdesign.application.tableinfo.dao.SysUserTableNameMapper;
import com.jxdinfo.hussar.formdesign.application.tableinfo.model.SysUserTableName;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.service.DatasourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.tableinfo.service.impl.SysUserTableNameServiceImpl")
public class SysUserTableNameServiceImpl
extends HussarServiceImpl<SysUserTableNameMapper, SysUserTableName>
implements ISysUserTableNameService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysUserTableNameServiceImpl.class);
    @Autowired
    private DatasourceDataService dataSourceDataService;
    @Autowired
    private ISysFormService formService;
    @Autowired
    private SysUserTableNameMapper userTableNameMapper;
    @Autowired
    private ModelRelationshipService modelRelationshipService;
    @Autowired
    private MetadataTableService metadataTableService;

    @Override
    public Page<SysUserTableName> selectByPage(Page<SysUserTableName> page, String tableNameLike) {
        return (Page)this.userTableNameMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserTableName::getState, (Object)"0")).eq(SysUserTableName::getDbId, (Object)this.getDataSourceId())).like(SysUserTableName::getTableName, (Object)tableNameLike)).or()).eq(SysUserTableName::getState, (Object)"0")).eq(SysUserTableName::getDbId, (Object)this.getDataSourceId())).like(SysUserTableName::getComment, (Object)tableNameLike));
    }

    @Override
    public void flushed() throws IOException, LcdpException {
        List slaveList;
        this.clearCreated();
        Long dataSourceId = this.getDataSourceId();
        List tableInfoList = this.dataSourceDataService.getTableById(dataSourceId, "BASE TABLE");
        List oldUserTableNames = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUserTableName::getState, SysUserTableNameConstant.STATE)).eq(SysUserTableName::getDbId, (Object)dataSourceId));
        HashMap<String, SysUserTableName> oldUserTableNameMap = new HashMap<String, SysUserTableName>();
        if (CollectionUtil.isNotEmpty((Collection)oldUserTableNames)) {
            for (SysUserTableName oldUserTableName : oldUserTableNames) {
                oldUserTableNameMap.put(oldUserTableName.getTableName().toUpperCase(), oldUserTableName);
            }
        }
        HashSet<String> createdTableNameSet = new HashSet<String>();
        List tableNameList = this.formService.getTableNameList();
        if (CollectionUtil.isNotEmpty((Collection)tableNameList)) {
            for (String createdTableName : tableNameList) {
                if (createdTableName == null) continue;
                createdTableNameSet.add(createdTableName.toUpperCase());
            }
        }
        ArrayList<Long> tableNameId = new ArrayList<Long>();
        HashSet<String> tfModeIds = new HashSet<String>();
        List taskList = this.modelRelationshipService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ModelRelationship::getParentPath, (Object)"0")).eq(ModelRelationship::getType, (Object)"masterflow"));
        if (CollectionUtil.isNotEmpty((Collection)taskList)) {
            for (Object modelRelationship : taskList) {
                tableNameId.add(modelRelationship.getTableId());
                String tfmodelId = modelRelationship.getTfmodelId();
                if (!tfmodelId.startsWith("process_task_info_") || !this.isLong(tfmodelId.substring("process_task_info_".length()))) continue;
                tfModeIds.add(tfmodelId.substring("process_task_info_".length()));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(slaveList = this.modelRelationshipService.list((Wrapper)new LambdaQueryWrapper().ne(ModelRelationship::getParentPath, (Object)"0"))))) {
            for (ModelRelationship modelRelationship : slaveList) {
                if (tfModeIds.contains(modelRelationship.getTfmodelId())) continue;
                tableNameId.add(modelRelationship.getTableId());
            }
        }
        HashSet<String> delTableName = new HashSet<String>();
        if (CollectionUtil.isNotEmpty(tableNameId)) {
            List tableList = this.metadataTableService.list((Wrapper)new LambdaQueryWrapper().in(MetadataTable::getTableId, tableNameId));
            for (Object metadataTable : tableList) {
                delTableName.add(metadataTable.getTableName().toUpperCase());
            }
        }
        HashSet<String> creatingTableNameSet = new HashSet<String>();
        List creatingTableNames = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserTableName::getState, (Object)"1")).eq(SysUserTableName::getDbId, (Object)dataSourceId));
        if (CollectionUtil.isNotEmpty((Collection)creatingTableNames)) {
            for (SysUserTableName creatingTableName : creatingTableNames) {
                creatingTableNameSet.add(creatingTableName.getTableName().toUpperCase());
            }
        }
        ArrayList<SysUserTableName> addUserTableNames = new ArrayList<SysUserTableName>();
        ArrayList<SysUserTableName> editUserTableNames = new ArrayList<SysUserTableName>();
        ArrayList<Long> removeIds = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)tableInfoList)) {
            for (TableInfo tableInfo : tableInfoList) {
                if (HussarUtils.isNotEmpty(delTableName) && delTableName.contains(tableInfo.getName().toUpperCase())) continue;
                if (HussarUtils.isNotEmpty(creatingTableNameSet) && creatingTableNameSet.contains(tableInfo.getName().toUpperCase())) {
                    oldUserTableNameMap.remove(tableInfo.getName());
                    continue;
                }
                SysUserTableName sysUserTableName = (SysUserTableName)((Object)oldUserTableNameMap.get(tableInfo.getName().toUpperCase()));
                if (HussarUtils.isEmpty((Object)((Object)sysUserTableName))) {
                    sysUserTableName = new SysUserTableName();
                    sysUserTableName.setTableName(tableInfo.getName());
                    sysUserTableName.setComment(tableInfo.getComment());
                    sysUserTableName.setState("0");
                    sysUserTableName.setDbId(dataSourceId);
                    sysUserTableName.setActivation("0");
                    if (HussarUtils.isNotEmpty(createdTableNameSet) && createdTableNameSet.contains(tableInfo.getName().toUpperCase())) {
                        sysUserTableName.setState("2");
                    }
                    addUserTableNames.add(sysUserTableName);
                    continue;
                }
                boolean edit = false;
                if (!HussarUtils.equals((Object)sysUserTableName.getComment(), (Object)tableInfo.getComment())) {
                    sysUserTableName.setComment(tableInfo.getComment());
                    edit = true;
                }
                if (!HussarUtils.equals((Object)sysUserTableName.getTableName(), (Object)tableInfo.getName())) {
                    sysUserTableName.setTableName(tableInfo.getName());
                    edit = true;
                }
                if (HussarUtils.isNotEmpty(createdTableNameSet) && createdTableNameSet.contains(tableInfo.getName().toUpperCase())) {
                    if (!HussarUtils.equals((Object)"2", (Object)sysUserTableName.getState())) {
                        sysUserTableName.setState("2");
                        edit = true;
                    }
                } else if (!HussarUtils.equals((Object)"0", (Object)sysUserTableName.getState())) {
                    sysUserTableName.setState("0");
                    edit = true;
                }
                if (edit) {
                    editUserTableNames.add(sysUserTableName);
                }
                oldUserTableNameMap.remove(sysUserTableName.getTableName().toUpperCase());
            }
        }
        if (CollectionUtil.isNotEmpty(oldUserTableNameMap)) {
            for (SysUserTableName value : oldUserTableNameMap.values()) {
                removeIds.add(value.getId());
            }
        }
        if (CollectionUtil.isNotEmpty(addUserTableNames)) {
            this.saveBatch(addUserTableNames);
        }
        if (CollectionUtil.isNotEmpty(editUserTableNames)) {
            this.updateBatchById(editUserTableNames);
        }
        if (CollectionUtil.isNotEmpty(removeIds)) {
            this.removeByIds(removeIds);
        }
    }

    private boolean isLong(String str) {
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private Long getDataSourceId() {
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasource = sysDataSourceService.getByConnName(NoCodeBusinessDB.getNocodeBusinessDB());
        return datasource.getId();
    }

    @Override
    public void clearCreating() {
        this.userTableNameMapper.update(null, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"STATE", (Object)"1")).eq((Object)"DB_ID", (Object)this.getDataSourceId())).set((Object)"STATE", (Object)"0"));
    }

    @Override
    public ApiResponse<Boolean> check(List<String> tableNames) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUserTableName::getTableName, tableNames)).eq(SysUserTableName::getState, (Object)"0")).eq(SysUserTableName::getDbId, (Object)this.getDataSourceId()));
        Map tableMap = list.stream().collect(Collectors.toMap(SysUserTableName::getTableName, Function.identity()));
        for (String tableName : tableNames) {
            SysUserTableName userTableName = (SysUserTableName)((Object)tableMap.get(tableName));
            if (HussarUtils.isEmpty((Object)((Object)userTableName))) {
                return ApiResponse.fail((String)("\u8868" + tableName + "\u4e0d\u5b58\u5728!"));
            }
            if ("0".equals(userTableName.getState())) continue;
            return ApiResponse.fail((String)("\u6570\u636e\u5e93\u8868" + tableName + "\u5df2\u88ab" + userTableName.getComment() + "\u8868\u5355\u7ed1\u5b9a\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa"));
        }
        return ApiResponse.success((Object)true);
    }

    @Override
    public String put(List<String> tableNames) {
        String key = "" + UUID.randomUUID();
        this.userTableNameMapper.put(tableNames, key, this.getDataSourceId());
        return key;
    }

    @Override
    public void clearCreated() {
        LocalDateTime time = LocalDateTime.now().minusMinutes(30L);
        this.userTableNameMapper.clearCreated(time);
    }

    @Override
    @HussarDs(value="#dataSourceKey")
    public void createdFail(String key, String dataSourceKey) {
        this.userTableNameMapper.update(null, (Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"TABLE_KEY", (Object)key)).eq((Object)"STATE", (Object)"1")).eq((Object)"DB_ID", (Object)this.getDataSourceId())).set((Object)"STATE", (Object)"0"));
    }

    @Override
    public void createdFailOne(String tableName) {
        this.userTableNameMapper.update(null, (Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"TABLE_NAME", (Object)tableName)).eq((Object)"STATE", (Object)"1")).eq((Object)"DB_ID", (Object)this.getDataSourceId())).set((Object)"STATE", (Object)"0"));
    }

    @Override
    public void created(String tableName) {
        this.userTableNameMapper.update(null, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"TABLE_NAME", (Object)tableName)).eq((Object)"DB_ID", (Object)this.getDataSourceId())).set((Object)"STATE", (Object)"2"));
    }

    @Override
    public void activation(String key) {
        this.userTableNameMapper.update(null, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"TABLE_KEY", (Object)key)).eq((Object)"DB_ID", (Object)this.getDataSourceId())).set((Object)"ACTIVATION", (Object)"1"));
    }

    @Override
    public void removeForm(String tableName) throws IOException, LcdpException {
        Long dataSourceId = this.getDataSourceId();
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserTableName::getTableName, (Object)tableName)).eq(SysUserTableName::getDbId, (Object)dataSourceId));
        if (HussarUtils.isEmpty((Object)list)) {
            Optional tableInfoOption = this.dataSourceDataService.filterTable(dataSourceId, "BASE TABLE", tableName);
            if (!tableInfoOption.isPresent()) {
                return;
            }
            TableInfo tableInfo = (TableInfo)tableInfoOption.get();
            SysUserTableName userTableName = new SysUserTableName();
            userTableName.setTableName(tableInfo.getName());
            userTableName.setComment(tableInfo.getComment());
            userTableName.setState("0");
            userTableName.setDbId(dataSourceId);
            userTableName.setActivation("0");
            this.save((BaseEntity)userTableName);
        } else {
            this.userTableNameMapper.update(null, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"TABLE_NAME", (Object)tableName)).eq((Object)"DB_ID", (Object)dataSourceId)).set((Object)"STATE", (Object)"0"));
        }
    }
}

